/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.view.builder.ml.harvest;

import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.OpenMapTable;
import ai.platon.pulsar.dom.FeaturedDocument;
import ai.platon.pulsar.dom.model.Image;
import ai.platon.pulsar.dom.model.ModelsKt;
import ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt;
import ai.platon.scent.entities.PageTableGroup;
import ai.platon.scent.entities.PageTableKt;
import ai.platon.scent.entities.TableData;
import ai.platon.scent.view.builder.HTMLBuilder;
import ai.platon.scent.view.builder.ml.harvest.TableViewBuilder;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\fH\u0002J\u0018\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\fH\u0002J\u0010\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u0018H\u0002J\u001e\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u00182\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002J\u001e\u0010\u001b\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u00182\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00180\"H\u0002J\u001a\u0010#\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u00182\b\b\u0002\u0010$\u001a\u00020%H\u0002J\u0018\u0010&\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\fH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lai/platon/scent/view/builder/ml/harvest/PageTableViewBuilder;", "Lai/platon/scent/view/builder/HTMLBuilder;", "tableGroup", "Lai/platon/scent/entities/PageTableGroup;", "htmlTemplateResource", "", "devMode", "", "(Lai/platon/scent/entities/PageTableGroup;Ljava/lang/String;Z)V", "logger", "Lorg/slf4j/Logger;", "sampleTable", "Lai/platon/pulsar/common/OpenMapTable;", "getTableGroup", "()Lai/platon/scent/entities/PageTableGroup;", "tableViewBuilder", "Lai/platon/scent/view/builder/ml/harvest/TableViewBuilder;", "tables", "", "build", "Lai/platon/pulsar/dom/FeaturedDocument;", "buildGeneratedHyperPaths", "", "rootElement", "Lorg/jsoup/nodes/Element;", "table", "buildGeneratedXSQL", "buildLinkSnapshot", "contentView", "rows", "", "Lai/platon/pulsar/common/OpenMapTable$Row;", "root", "elements", "", "buildLinkTable", "n", "", "buildMLStatistics", "scent-build"})
@SourceDebugExtension(value={"SMAP\nPageTableViewBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PageTableViewBuilder.kt\nai/platon/scent/view/builder/ml/harvest/PageTableViewBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,231:1\n1045#2:232\n1864#2,3:233\n1549#2:241\n1620#2,3:242\n1864#2,3:245\n1864#2,3:248\n1864#2,3:251\n13309#3,2:236\n13309#3:238\n13310#3:240\n1#4:239\n*S KotlinDebug\n*F\n+ 1 PageTableViewBuilder.kt\nai/platon/scent/view/builder/ml/harvest/PageTableViewBuilder\n*L\n48#1:232\n48#1:233,3\n153#1:241\n153#1:242,3\n162#1:245,3\n177#1:248,3\n209#1:251,3\n87#1:236,2\n97#1:238\n97#1:240\n*E\n"})
public final class PageTableViewBuilder
extends HTMLBuilder {
    @NotNull
    private final PageTableGroup tableGroup;
    @NotNull
    private final String htmlTemplateResource;
    private final boolean devMode;
    @NotNull
    private final Logger logger;
    @NotNull
    private final List<OpenMapTable> tables;
    private OpenMapTable sampleTable;
    @NotNull
    private final TableViewBuilder tableViewBuilder;

    public PageTableViewBuilder(@NotNull PageTableGroup tableGroup, @NotNull String htmlTemplateResource, boolean devMode) {
        Intrinsics.checkNotNullParameter((Object)tableGroup, (String)"tableGroup");
        Intrinsics.checkNotNullParameter((Object)htmlTemplateResource, (String)"htmlTemplateResource");
        super(htmlTemplateResource, null, 2, null);
        this.tableGroup = tableGroup;
        this.htmlTemplateResource = htmlTemplateResource;
        this.devMode = devMode;
        this.logger = LogsKt.getLogger((Object)this);
        this.tables = this.tableGroup.getTables();
        this.tableViewBuilder = new TableViewBuilder(this.devMode);
    }

    public /* synthetic */ PageTableViewBuilder(PageTableGroup pageTableGroup, String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(pageTableGroup, string, bl);
    }

    @NotNull
    public final PageTableGroup getTableGroup() {
        return this.tableGroup;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public FeaturedDocument build() {
        void $this$forEachIndexed$iv;
        FeaturedDocument output = super.build();
        output.getDocument().outputSettings().prettyPrint(false);
        Element element = output.getBody().selectFirst("div#page-message");
        Intrinsics.checkNotNull((Object)element);
        Element messageView = element;
        OpenMapTable openMapTable = (OpenMapTable)CollectionsKt.lastOrNull(this.tables);
        if (openMapTable == null) {
            openMapTable = new OpenMapTable(0, 0, 2, null);
        }
        this.sampleTable = openMapTable;
        String host = this.tableGroup.getPortalUrl().getUrl().getHost();
        OpenMapTable openMapTable2 = this.sampleTable;
        if (openMapTable2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sampleTable");
            openMapTable2 = null;
        }
        int documentSize = PageTableKt.getData((OpenMapTable)openMapTable2).getDocumentSize();
        output.getDocument().title("PLATON AI - Auto Web Mining - " + host);
        String string = "Total %d pages, generated %d tables";
        Object[] objectArray = new Object[]{documentSize, this.tables.size()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String caption = string2;
        messageView.appendElement("div").text(caption);
        messageView.appendElement("div").text(OffsetDateTime.now().toString());
        messageView.appendElement("hr");
        messageView.appendElement("div").text(this.tableGroup.getCommand());
        Element element2 = output.getBody().selectFirst("div#tables");
        Intrinsics.checkNotNull((Object)element2);
        Element tableListView = element2;
        Iterable $this$sortedBy$iv = this.tables;
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                OpenMapTable it = (OpenMapTable)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(PageTableKt.getData((OpenMapTable)it).getAlignedTop());
                it = (OpenMapTable)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(PageTableKt.getData((OpenMapTable)it).getAlignedTop()));
            }
        });
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void table;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            OpenMapTable openMapTable3 = (OpenMapTable)item$iv;
            int i = n;
            boolean bl = false;
            TableData tableData = PageTableKt.getData((OpenMapTable)table);
            String message = "<div class='message'><i class='no'>" + (1 + i) + ".</i>e<b>X</b>tracted <em>" + (table.getNumColumns() - 2) + "</em> fields from page area <b>" + PageTableKt.getData((OpenMapTable)table).getName() + "</b></div>";
            tableListView.appendElement("div").html(message);
            String pageTable = TableViewBuilder.buildPageTable$default(this.tableViewBuilder, (OpenMapTable)table, null, 2, null);
            tableListView.append(pageTable);
            if (this.devMode && !tableData.isCombined()) {
                this.buildGeneratedHyperPaths(tableListView, (OpenMapTable)table);
                tableListView.appendElement("br");
                this.buildGeneratedXSQL(tableListView, (OpenMapTable)table);
                tableListView.appendElement("br");
                this.buildMLStatistics(tableListView, (OpenMapTable)table);
            }
            tableListView.appendElement("br");
        }
        return output;
    }

    /*
     * WARNING - void declaration
     */
    private final void buildMLStatistics(Element rootElement, OpenMapTable table) {
        void $this$forEach$iv;
        Element element = rootElement.appendElement("div").addClass("hidden").addClass("statistics");
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"addClass(...)");
        Element div = element;
        div.appendElement("h2").text("Machine Learning Statistics");
        Element element2 = div.appendElement("dl");
        Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"appendElement(...)");
        Element dl = element2;
        TableData d = PageTableKt.getData((OpenMapTable)table);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"score", (Object)d.getScore()), TuplesKt.to((Object)"distortion", (Object)d.getDistortion()), TuplesKt.to((Object)"macroP", (Object)d.getMacroP()), TuplesKt.to((Object)"macroR", (Object)d.getMacroR()), TuplesKt.to((Object)"macroF1", (Object)d.getMacroF1()), TuplesKt.to((Object)"microP", (Object)d.getMicroP()), TuplesKt.to((Object)"microR", (Object)d.getMicroR()), TuplesKt.to((Object)"microF1", (Object)d.getMicroF1()), TuplesKt.to((Object)"ff", (Object)d.getFf()), TuplesKt.to((Object)"ffr", (Object)d.getFfr())};
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv;
            void var11_11 = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            String name = (String)var11_11.component1();
            Object value = var11_11.component2();
            dl.append("<dt>" + name + "</dt><dd>" + value + "</dd>");
        }
    }

    private final void buildGeneratedHyperPaths(Element rootElement, OpenMapTable table) {
        Element element = rootElement.appendElement("div").addClass("hidden").addClass("css-paths");
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"addClass(...)");
        Element div = element;
        div.appendElement("h2").text("Generated CSS Paths");
        Element element2 = div.appendElement("dl");
        Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"appendElement(...)");
        Element dl = element2;
        OpenMapTable.Column[] $this$forEach$iv = table.getColumns();
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            String string;
            OpenMapTable.Column element$iv;
            OpenMapTable.Column column2 = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            String it = string = PageTableKt.getData((OpenMapTable.Column)column2).getHyperPath();
            boolean bl2 = false;
            String string2 = !StringsKt.isBlank((CharSequence)it) ? string : null;
            if (string2 == null) continue;
            it = string2;
            boolean bl3 = false;
            dl.append("<dt>" + column2.getName() + "</dt><dd>" + it + "</dd>");
        }
    }

    private final void buildGeneratedXSQL(Element rootElement, OpenMapTable table) {
        Element element = rootElement.appendElement("div").addClass("hidden").addClass("x-sql");
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"addClass(...)");
        Element div = element;
        div.appendElement("h2").text("Generated X-SQL");
        div.append("<pre>\n" + PageTableKt.getData((OpenMapTable)table).getXsql() + "\n</pre>");
    }

    /*
     * WARNING - void declaration
     */
    private final void buildLinkSnapshot(Element contentView) {
        void $this$mapTo$iv$iv;
        if (this.tables.isEmpty()) {
            return;
        }
        int sampleSize = 10;
        OpenMapTable table = (OpenMapTable)CollectionsKt.first(this.tables);
        List samples = CollectionsKt.take((Iterable)table.getRows(), (int)sampleSize);
        Iterable $this$map$iv = samples;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            OpenMapTable.Row row = (OpenMapTable.Row)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(PageTableKt.getData((OpenMapTable.Row)it).getLocation());
        }
        List sampleUrls = (List)destination$iv$iv;
        contentView.appendElement("div").text("Show " + samples.size() + "/" + table.getNumRows() + " pages: ");
        this.buildLinkSnapshot(contentView, samples);
    }

    /*
     * WARNING - void declaration
     */
    private final void buildLinkSnapshot(Element contentView, Collection<OpenMapTable.Row> rows) {
        Element element = contentView.appendElement("ul");
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"appendElement(...)");
        Element ul = element;
        Iterable $this$forEachIndexed$iv = rows;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            Element li;
            void row;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            OpenMapTable.Row row2 = (OpenMapTable.Row)item$iv;
            int i = n;
            boolean bl = false;
            String uri = PageTableKt.getData((OpenMapTable.Row)row).getLocation();
            String title = PageTableKt.getData((OpenMapTable.Row)row).getTitle();
            Intrinsics.checkNotNullExpressionValue((Object)ul.appendElement("li"), (String)"appendElement(...)");
            li.appendElement("span").html(1 + i + ".&nbsp;");
            li.appendElement("a").attr("href", uri).attr("target", "_blank").text(title);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void buildLinkSnapshot(Element root, Iterable<? extends Element> elements) {
        Element element = root.appendElement("ul");
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"appendElement(...)");
        Element ul = element;
        Iterable<? extends Element> $this$forEachIndexed$iv = elements;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Element element2 : $this$forEachIndexed$iv) {
            void it;
            Element li;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Element element22 = element2;
            int i = n;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)ul.appendElement("li"), (String)"appendElement(...)");
            li.appendElement("span").html(1 + i + ".&nbsp;");
            Element element3 = li.appendElement("a").attr("href", NodeExtKt.getLocation((Node)((Node)it))).attr("target", "_blank");
            Document document = it.ownerDocument();
            Intrinsics.checkNotNull((Object)document);
            element3.text(document.title());
            if (!NodeExtKt.isImage((Node)((Node)it))) continue;
            Image image = ModelsKt.createImage$default((Element)it, (boolean)false, (boolean)false, (int)6, null);
            ((Map)image.getAttributes()).put("width", "200");
            ((Map)image.getAttributes()).put("height", "200");
            li.appendElement(image.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void buildLinkTable(Element root, int n) {
        if (this.tables.isEmpty()) {
            return;
        }
        OpenMapTable table = (OpenMapTable)CollectionsKt.first(this.tables);
        List rows = CollectionsKt.take((Iterable)table.getRows(), (int)n);
        root.appendElement("hr");
        root.appendElement("div").text("Show " + rows.size() + "/" + table.getRows().size() + " pages: ");
        Element element = root.appendElement("table");
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"appendElement(...)");
        Element tableElement = element;
        Element tr = null;
        Element element2 = tableElement.appendElement("tr");
        Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"appendElement(...)");
        tr = element2;
        tr.append("<th>&nbsp;</th><th>Title</th><th>Url</th>");
        Iterable $this$forEachIndexed$iv = rows;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void row;
            int n2;
            if ((n2 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            OpenMapTable.Row row2 = (OpenMapTable.Row)item$iv;
            int i = n2;
            boolean bl = false;
            String uri = PageTableKt.getData((OpenMapTable.Row)row).getLocation();
            String displayUri = StringUtils.abbreviateMiddle((String)PageTableKt.getData((OpenMapTable.Row)row).getLocation(), (String)"..", (int)200);
            String exportPath = PageTableKt.getData((OpenMapTable.Row)row).getExportPath();
            String title = PageTableKt.getData((OpenMapTable.Row)row).getTitle();
            Intrinsics.checkNotNullExpressionValue((Object)tableElement.appendElement("tr"), (String)"appendElement(...)");
            tr.appendElement("td").text(String.valueOf(1 + i));
            tr.appendElement("td").appendElement("a").attr("href", exportPath.toString()).attr("target", "_blank").text(title);
            tr.appendElement("td").appendElement("a").attr("href", uri).attr("target", "_blank").text(displayUri);
        }
    }

    static /* synthetic */ void buildLinkTable$default(PageTableViewBuilder pageTableViewBuilder, Element element, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 50;
        }
        pageTableViewBuilder.buildLinkTable(element, n);
    }
}

