/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.view.builder.ml.harvest;

import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.OpenMapTable;
import ai.platon.scent.entities.PageTableKt;
import ai.platon.scent.view.builder.ml.MLResultXLSXBuilder;
import ai.platon.scent.view.builder.ml.XLSXBuilder;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J#\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u00162\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002\u00a2\u0006\u0002\u0010\"J#\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u00162\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002\u00a2\u0006\u0002\u0010\"R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006%"}, d2={"Lai/platon/scent/view/builder/ml/harvest/XLSXTableViewBuilder;", "Lai/platon/scent/view/builder/ml/XLSXBuilder;", "sheet", "Lorg/apache/poi/ss/usermodel/Sheet;", "devMode", "", "(Lorg/apache/poi/ss/usermodel/Sheet;Z)V", "getDevMode", "()Z", "logger", "Lorg/slf4j/Logger;", "nextRowId", "", "getSheet", "()Lorg/apache/poi/ss/usermodel/Sheet;", "appendRow", "", "i", "row", "Lai/platon/pulsar/common/OpenMapTable$Row;", "appendStringRow", "sheetRow", "Lorg/apache/poi/ss/usermodel/Row;", "build", "table", "Lai/platon/pulsar/common/OpenMapTable;", "buildTableBody", "buildTableHead", "buildTableHead0", "fillLabelHeader", "labelRow", "columns", "", "Lai/platon/pulsar/common/OpenMapTable$Column;", "(Lorg/apache/poi/ss/usermodel/Row;[Lai/platon/pulsar/common/OpenMapTable$Column;)V", "fillPredictionHeader", "predictionRow", "scent-build"})
@SourceDebugExtension(value={"SMAP\nXLSXTableViewBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XLSXTableViewBuilder.kt\nai/platon/scent/view/builder/ml/harvest/XLSXTableViewBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,151:1\n1855#2,2:152\n1855#2,2:154\n1864#2,3:156\n288#2,2:159\n13374#3,3:161\n429#4:164\n502#4,5:165\n*S KotlinDebug\n*F\n+ 1 XLSXTableViewBuilder.kt\nai/platon/scent/view/builder/ml/harvest/XLSXTableViewBuilder\n*L\n40#1:152,2\n45#1:154,2\n57#1:156,3\n64#1:159,2\n78#1:161,3\n127#1:164\n127#1:165,5\n*E\n"})
public class XLSXTableViewBuilder
extends XLSXBuilder {
    @NotNull
    private final Sheet sheet;
    private final boolean devMode;
    @NotNull
    private final Logger logger;
    private int nextRowId;

    public XLSXTableViewBuilder(@NotNull Sheet sheet, boolean devMode) {
        Intrinsics.checkNotNullParameter((Object)sheet, (String)"sheet");
        this.sheet = sheet;
        this.devMode = devMode;
        this.logger = LogsKt.getLogger((Object)this);
    }

    public /* synthetic */ XLSXTableViewBuilder(Sheet sheet, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(sheet, bl);
    }

    @NotNull
    public final Sheet getSheet() {
        return this.sheet;
    }

    public final boolean getDevMode() {
        return this.devMode;
    }

    public final void build(@NotNull OpenMapTable table) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        this.buildTableHead(table);
        this.buildTableBody(table);
    }

    private final void buildTableHead(OpenMapTable table) {
        this.buildTableHead0(table, this.sheet);
    }

    private final void buildTableHead0(OpenMapTable table, Sheet sheet) {
        Iterable $this$forEach$iv = MLResultXLSXBuilder.Companion.getHEADERS();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String label = (String)element$iv;
            boolean bl = false;
            int n = this.nextRowId;
            this.nextRowId = n + 1;
            this.writeHeader(n, label, table.getColumns().length, sheet);
        }
        $this$forEach$iv = (Iterable)new IntRange(0, MLResultXLSXBuilder.Companion.getHEADER_NAMES().size() - 1);
        $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int j = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            sheet.getRow(j).getCell(0).setCellValue(MLResultXLSXBuilder.Companion.getHEADER_NAMES().get(j));
        }
        Row row = sheet.getRow(1);
        Intrinsics.checkNotNullExpressionValue((Object)row, (String)"getRow(...)");
        this.fillPredictionHeader(row, table.getColumns());
        Row row2 = sheet.getRow(2);
        Intrinsics.checkNotNullExpressionValue((Object)row2, (String)"getRow(...)");
        this.fillLabelHeader(row2, table.getColumns());
    }

    /*
     * WARNING - void declaration
     */
    private final void buildTableBody(OpenMapTable table) {
        Iterable $this$forEachIndexed$iv = table.getRows();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void row;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            OpenMapTable.Row row2 = (OpenMapTable.Row)item$iv;
            int i = n;
            boolean bl = false;
            this.appendRow(i, (OpenMapTable.Row)row);
        }
    }

    private final void appendRow(int i, OpenMapTable.Row row) {
        Object v0;
        Row sheetRow;
        block2: {
            int n = this.nextRowId;
            this.nextRowId = n + 1;
            sheetRow = this.sheet.createRow(n);
            List values = row.getValues();
            Iterable $this$firstOrNull$iv = values;
            boolean $i$f$firstOrNull = false;
            Iterator iterator = $this$firstOrNull$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator.next();
                boolean bl = false;
                if (!(it != null)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        if (v0 == null) {
            return;
        }
        Object sample = v0;
        String url = PageTableKt.getData((OpenMapTable.Row)row).getNormalizedUrl();
        sheetRow.createCell(0).setCellValue(String.valueOf(i));
        sheetRow.createCell(1).setCellValue(url);
        Intrinsics.checkNotNull((Object)sheetRow);
        this.appendStringRow(row, sheetRow);
    }

    /*
     * WARNING - void declaration
     */
    private final void appendStringRow(OpenMapTable.Row row, Row sheetRow) {
        OpenMapTable.Cell[] $this$forEachIndexed$iv = row.getCells();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (OpenMapTable.Cell item$iv : $this$forEachIndexed$iv) {
            Object object;
            Object value;
            void cell;
            int n = index$iv++;
            OpenMapTable.Cell cell2 = item$iv;
            int j = n;
            boolean bl = false;
            int column2 = 2 + j;
            void v1 = cell;
            Object object2 = value = v1 != null ? v1.getValue() : null;
            if (value == null) {
                sheetRow.createCell(column2).setCellValue("");
                continue;
            }
            Object s = ((Object)StringsKt.trim((CharSequence)value.toString())).toString();
            if (value instanceof Double || value instanceof Float) {
                String string = "%.2f";
                Object[] objectArray = new Object[]{value};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                s = string2;
            } else {
                CharSequence charSequence = (CharSequence)s;
                if (new Regex("<a.+>.+</a>").matches(charSequence)) {
                    s = "";
                }
            }
            if (j == 1) {
                s = PageTableKt.getData((OpenMapTable.Row)row).getTitle();
            }
            if (j == row.getCells().length - 1 && (object = PageTableKt.getData((OpenMapTable.Row)row).getNormalizedUrl()) == null) {
                object = s = "";
            }
            if (this.devMode) {
                Object object3 = cell.getAttributes().get("tv");
                if (object3 == null) {
                    object3 = "";
                }
                Object vi = object3;
                s = (String)s + " [" + vi + "]";
            }
            sheetRow.createCell(column2).setCellValue((String)s);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void fillPredictionHeader(Row predictionRow, OpenMapTable.Column[] columns) {
        if (predictionRow.getLastCellNum() != columns.length) {
            this.logger.info("The cluster ID row does not match the columns.");
        }
        int n = predictionRow.getLastCellNum();
        for (int j = 2; j < n; ++j) {
            String prediction;
            void $this$filterTo$iv$iv;
            String placeholder = predictionRow.getCell(j).getStringCellValue();
            Intrinsics.checkNotNull((Object)placeholder);
            CharSequence charSequence = placeholder;
            if (!new Regex("C\\d+").matches(charSequence)) continue;
            String $this$filter$iv = PageTableKt.getData((OpenMapTable.Column)columns[j - 2]).getPrediction();
            boolean $i$f$filter = false;
            CharSequence charSequence2 = $this$filter$iv;
            Appendable destination$iv$iv = new StringBuilder();
            boolean $i$f$filterTo = false;
            int n2 = $this$filterTo$iv$iv.length();
            for (int index$iv$iv = 0; index$iv$iv < n2; ++index$iv$iv) {
                char element$iv$iv;
                char it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = !Character.isDigit(it);
                if (!bl2) continue;
                destination$iv$iv.append(element$iv$iv);
            }
            Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)destination$iv$iv).toString(), (String)"toString(...)");
            predictionRow.getCell(j).setCellValue("C" + prediction);
        }
    }

    private final void fillLabelHeader(Row labelRow, OpenMapTable.Column[] columns) {
        if (labelRow.getLastCellNum() != columns.length) {
            this.logger.info("The label row does not match the columns.");
        }
        int n = labelRow.getLastCellNum();
        for (int j = 2; j < n; ++j) {
            String label;
            String value = labelRow.getCell(j).getStringCellValue();
            Intrinsics.checkNotNull((Object)value);
            CharSequence charSequence = value;
            if (!new Regex("L\\d+").matches(charSequence) || !(!StringsKt.isBlank((CharSequence)(label = PageTableKt.getData((OpenMapTable.Column)columns[j - 2]).getLabel())))) continue;
            labelRow.getCell(j).setCellValue(label);
        }
    }
}

