/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.ml;

import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.Strings;
import ai.platon.pulsar.common.urls.URLUtils;
import ai.platon.scent.ml.ML;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.perf4j.slf4j.Slf4JStopWatch;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B3\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0003J\b\u0010\u001f\u001a\u00020 H\u0002J\u0018\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u0006H\u0002J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0003H\u0002J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0003H\u0002J8\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u00042\u000e\u0010(\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u00032\u0006\u0010\u0007\u001a\u00020\u00062\u000e\u0010)\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u0014H\u0002J\"\u0010&\u001a\u0004\u0018\u00010\u001e2\u0006\u0010*\u001a\u00020\u00062\u0006\u0010'\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J0\u0010+\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010'\u001a\u00020\u00042\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00150\u00032\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u0010\u0010-\u001a\u00020 2\u0006\u0010.\u001a\u00020/H\u0002R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR&\u0010\r\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0019\u00a8\u00060"}, d2={"Lai/platon/scent/ml/ContextualColumnsBuilder;", "", "columns", "", "Lai/platon/scent/ml/ML$Column;", "rowLimit", "", "windowSize", "revisedXlsxViewPath", "Ljava/nio/file/Path;", "(Ljava/util/List;IILjava/nio/file/Path;)V", "getColumns", "()Ljava/util/List;", "contextTexts", "", "Lkotlin/Pair;", "", "logger", "Lorg/slf4j/Logger;", "revisedRecords", "", "Lai/platon/scent/ml/ML$Record;", "getRevisedXlsxViewPath", "()Ljava/nio/file/Path;", "getRowLimit", "()I", "stopWatch", "Lorg/perf4j/slf4j/Slf4JStopWatch;", "getWindowSize", "build", "Lai/platon/scent/ml/ML$ContextualColumnDescription;", "buildAllContextTexts", "", "buildContextText", "columnNum", "rowNum", "buildWithRevision", "buildWithoutRevision", "createContextualColumn", "column", "cellTexts", "cellContexts", "colNum", "createContextualColumnWithRevision", "revisedColumn", "loadRevisedRecords", "xlsxFile", "Ljava/io/File;", "scent-build"})
@SourceDebugExtension(value={"SMAP\nContextualColumnsBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContextualColumnsBuilder.kt\nai/platon/scent/ml/ContextualColumnsBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,207:1\n1864#2,2:208\n1866#2:211\n1477#2:212\n1502#2,3:213\n1505#2,3:223\n1864#2,3:226\n1549#2:229\n1620#2,3:230\n1864#2,3:239\n1194#2,2:242\n1222#2,4:244\n1864#2,3:248\n1864#2,2:251\n1864#2,3:253\n1866#2:256\n1855#2,2:257\n1#3:210\n372#4,7:216\n1324#5,2:233\n1324#5,3:235\n1326#5:238\n*S KotlinDebug\n*F\n+ 1 ContextualColumnsBuilder.kt\nai/platon/scent/ml/ContextualColumnsBuilder\n*L\n50#1:208,2\n50#1:211\n65#1:212\n65#1:213,3\n65#1:223,3\n67#1:226,3\n89#1:229\n89#1:230,3\n117#1:239,3\n143#1:242,2\n143#1:244,4\n147#1:248,3\n186#1:251,2\n187#1:253,3\n186#1:256\n197#1:257,2\n65#1:216,7\n91#1:233,2\n98#1:235,3\n91#1:238\n*E\n"})
public final class ContextualColumnsBuilder {
    @NotNull
    private final List<ML.Column> columns;
    private final int rowLimit;
    private final int windowSize;
    @Nullable
    private final Path revisedXlsxViewPath;
    @NotNull
    private final Logger logger;
    @Nullable
    private final Slf4JStopWatch stopWatch;
    @NotNull
    private final List<ML.Record> revisedRecords;
    @NotNull
    private final Map<Pair<Integer, Integer>, String> contextTexts;

    public ContextualColumnsBuilder(@NotNull List<ML.Column> columns, int rowLimit, int windowSize, @Nullable Path revisedXlsxViewPath) {
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        this.columns = columns;
        this.rowLimit = rowLimit;
        this.windowSize = windowSize;
        this.revisedXlsxViewPath = revisedXlsxViewPath;
        this.logger = LogsKt.getLogger((Object)this);
        this.revisedRecords = new ArrayList();
        this.contextTexts = new LinkedHashMap();
    }

    public /* synthetic */ ContextualColumnsBuilder(List list, int n, int n2, Path path, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n = Integer.MAX_VALUE;
        }
        if ((n3 & 4) != 0) {
            n2 = 5;
        }
        if ((n3 & 8) != 0) {
            path = null;
        }
        this(list, n, n2, path);
    }

    @NotNull
    public final List<ML.Column> getColumns() {
        return this.columns;
    }

    public final int getRowLimit() {
        return this.rowLimit;
    }

    public final int getWindowSize() {
        return this.windowSize;
    }

    @Nullable
    public final Path getRevisedXlsxViewPath() {
        return this.revisedXlsxViewPath;
    }

    @NotNull
    public final List<ML.ContextualColumnDescription> build() {
        this.buildAllContextTexts();
        if (this.revisedXlsxViewPath == null) {
            return this.buildWithoutRevision();
        }
        File file = this.revisedXlsxViewPath.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        this.loadRevisedRecords(file);
        return this.buildWithRevision();
    }

    /*
     * WARNING - void declaration
     */
    private final List<ML.ContextualColumnDescription> buildWithoutRevision() {
        this.logger.info("Building without revision ...");
        List descriptions = new ArrayList();
        Slf4JStopWatch slf4JStopWatch = this.stopWatch;
        if (slf4JStopWatch != null) {
            slf4JStopWatch.lap("Begin createContextualColumns");
        }
        Iterable $this$forEachIndexed$iv = this.columns;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            ML.ContextualColumnDescription it;
            void column2;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ML.Column column3 = (ML.Column)item$iv;
            int colNum = n;
            boolean bl = false;
            if (this.createContextualColumn(colNum, (ML.Column)column2, this.windowSize) == null) continue;
            boolean bl2 = false;
            descriptions.add(it);
        }
        Slf4JStopWatch slf4JStopWatch2 = this.stopWatch;
        if (slf4JStopWatch2 != null) {
            slf4JStopWatch2.lap("End createContextualColumns");
        }
        this.logger.info("Total {} column descriptions", (Object)descriptions.size());
        return descriptions;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ML.ContextualColumnDescription> buildWithRevision() {
        void $this$groupByTo$iv$iv;
        this.logger.info("Building with revision ...");
        List descriptions = new ArrayList();
        Iterable $this$groupBy$iv = this.revisedRecords;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            ML.Record it = (ML.Record)element$iv$iv;
            boolean bl = false;
            Integer key$iv$iv = it.getPrediction();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map predictionToRevisedRecords = destination$iv$iv;
        Slf4JStopWatch slf4JStopWatch = this.stopWatch;
        if (slf4JStopWatch != null) {
            slf4JStopWatch.lap("Begin createContextualColumns");
        }
        Iterable $this$forEachIndexed$iv = this.columns;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            List revisedColumn;
            ML.ContextualColumnDescription cc;
            void column2;
            int n;
            Object element$iv$iv;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            element$iv$iv = (ML.Column)item$iv;
            int j = n;
            boolean bl = false;
            int prediction = column2.getPrediction();
            if ((List)predictionToRevisedRecords.get(prediction) == null || (cc = this.createContextualColumnWithRevision(j, (ML.Column)column2, revisedColumn, this.windowSize)) == null) continue;
            descriptions.add(cc);
        }
        Slf4JStopWatch slf4JStopWatch2 = this.stopWatch;
        if (slf4JStopWatch2 != null) {
            slf4JStopWatch2.lap("End createContextualColumns");
        }
        this.logger.info("Total {} column descriptions", (Object)descriptions.size());
        return descriptions;
    }

    /*
     * WARNING - void declaration
     */
    private final void loadRevisedRecords(File xlsxFile) {
        void $this$mapTo$iv$iv;
        XSSFWorkbook workbook = new XSSFWorkbook(xlsxFile);
        XSSFSheet xSSFSheet = workbook.getSheetAt(0);
        if (xSSFSheet == null) {
            throw new IllegalArgumentException("No sheet found in XLSX file | " + xlsxFile);
        }
        XSSFSheet sheet = xSSFSheet;
        XSSFRow xSSFRow = sheet.getRow(1);
        if (xSSFRow == null) {
            throw new IllegalArgumentException("No prediction row found in XLSX file | " + xlsxFile);
        }
        XSSFRow predictionRow = xSSFRow;
        Iterable $this$map$iv = (Iterable)predictionRow;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Cell cell = (Cell)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v2 = it;
            collection.add(Strings.findFirstInteger((String)(v2 != null ? v2.getStringCellValue() : null), (int)-1));
        }
        List chosenPredictions = (List)destination$iv$iv;
        Iterator iterator = sheet.rowIterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"rowIterator(...)");
        Sequence $this$forEachIndexed$iv = SequencesKt.asSequence((Iterator)iterator);
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void row;
            int n;
            Object item$iv$iv;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            item$iv$iv = (Row)item$iv;
            int i = n;
            boolean bl = false;
            String url = row.getCell(1).getStringCellValue();
            if (!URLUtils.isStandard((String)url)) continue;
            Iterator iterator2 = row.cellIterator();
            Intrinsics.checkNotNullExpressionValue((Object)iterator2, (String)"cellIterator(...)");
            Sequence $this$forEachIndexed$iv2 = SequencesKt.asSequence((Iterator)iterator2);
            boolean $i$f$forEachIndexed2 = false;
            int index$iv2 = 0;
            for (Object item$iv2 : $this$forEachIndexed$iv2) {
                CharSequence charSequence;
                void cell;
                int n2;
                if ((n2 = index$iv2++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Cell cell2 = (Cell)item$iv2;
                int j = n2;
                boolean bl2 = false;
                int prediction = ((Number)chosenPredictions.get(j)).intValue();
                String text = cell.getStringCellValue();
                if (prediction < 0 || (charSequence = (CharSequence)text) == null || StringsKt.isBlank((CharSequence)charSequence)) continue;
                Intrinsics.checkNotNull((Object)url);
                ML.Record record = new ML.Record(null, prediction, 0.0f, 0.0f, 0.0f, 0.0f, 0, 0, text, url, 0, 1277, null);
                this.revisedRecords.add(record);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final ML.ContextualColumnDescription createContextualColumn(int colNum, ML.Column column2, int windowSize) {
        List cellTexts = new ArrayList();
        List cellContexts = new ArrayList();
        Iterable $this$forEachIndexed$iv = CollectionsKt.take((Iterable)column2.getCells(), (int)this.rowLimit);
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            String string;
            CharSequence charSequence;
            Regex regex;
            void cell;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ML.Record record = (ML.Record)item$iv;
            int rowNum = n;
            boolean bl = false;
            String string2 = cell.getText();
            String text = string2 != null && (string2 = (regex = new Regex("[\\x00-\\x1F]")).replace(charSequence = (CharSequence)string2, string = " ")) != null ? ((Object)StringsKt.trim((CharSequence)string2)).toString() : null;
            CharSequence charSequence2 = text;
            if (charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) continue;
            cellTexts.add(text);
            String context = this.contextTexts.get(new Pair((Object)rowNum, (Object)colNum));
            cellContexts.add(context);
        }
        if (!((Collection)cellTexts).isEmpty()) {
            return this.createContextualColumn(column2, cellTexts, windowSize, cellContexts);
        }
        this.logger.info("Cell texts is empty");
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final ML.ContextualColumnDescription createContextualColumnWithRevision(int columnNum, ML.Column column2, List<ML.Record> revisedColumn, int windowSize) {
        ML.Record it;
        void $this$associateByTo$iv$iv;
        Iterable $this$associateBy$iv = revisedColumn;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            ML.Record record = (ML.Record)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getUrl(), element$iv$iv);
        }
        Map urlToRevisedRecords = destination$iv$iv;
        List cellTexts = new ArrayList();
        List cellContexts = new ArrayList();
        Iterable $this$forEachIndexed$iv = CollectionsKt.take((Iterable)column2.getCells(), (int)this.rowLimit);
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void cell;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            it = (ML.Record)item$iv;
            int rowNum = n;
            boolean bl = false;
            String url = cell.getUrl();
            ML.Record record = (ML.Record)urlToRevisedRecords.get(url);
            String text = record != null ? record.getText() : null;
            CharSequence charSequence = text;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) continue;
            cellTexts.add(text);
            String context = this.contextTexts.get(new Pair((Object)rowNum, (Object)columnNum));
            cellContexts.add(context);
        }
        if (!((Collection)cellTexts).isEmpty()) {
            return this.createContextualColumn(column2, cellTexts, windowSize, cellContexts);
        }
        return null;
    }

    private final ML.ContextualColumnDescription createContextualColumn(ML.Column column2, List<String> cellTexts, int windowSize, List<String> cellContexts) {
        return new ML.ContextualColumnDescription(column2.getPrediction(), column2.getLabel(), column2.getScreen(), column2.getAverageLeft(), column2.getAverageTop(), column2.getAverageWidth(), column2.getAverageHeight(), cellTexts, windowSize, cellContexts, null, 1024, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void buildAllContextTexts() {
        Iterable $this$forEachIndexed$iv = this.columns;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void column2;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ML.Column column3 = (ML.Column)item$iv;
            int columnNum = n;
            boolean bl = false;
            Iterable $this$forEachIndexed$iv2 = CollectionsKt.take((Iterable)column2.getCells(), (int)this.rowLimit);
            boolean $i$f$forEachIndexed2 = false;
            int index$iv2 = 0;
            for (Object item$iv2 : $this$forEachIndexed$iv2) {
                int n2;
                if ((n2 = index$iv2++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                ML.Record cfr_ignored_0 = (ML.Record)item$iv2;
                int rowNum = n2;
                boolean bl2 = false;
                String context = this.buildContextText(columnNum, rowNum);
                this.contextTexts.put((Pair<Integer, Integer>)new Pair((Object)rowNum, (Object)columnNum), context);
            }
        }
    }

    private final String buildContextText(int columnNum, int rowNum) {
        StringBuilder sb = new StringBuilder();
        Iterable $this$forEach$iv = (Iterable)new IntRange(columnNum - this.windowSize, columnNum + this.windowSize);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int j1 = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            Object object = (ML.Column)CollectionsKt.getOrNull(this.columns, (int)j1);
            if (object == null || (object = ((ML.Column)object).getCells()) == null || (object = (ML.Record)CollectionsKt.getOrNull((List)object, (int)rowNum)) == null || (object = ((ML.Record)object).getText()) == null) {
                object = "";
            }
            Object context = object;
            CharSequence charSequence = (CharSequence)context;
            Regex regex = new Regex("[\\x00-\\x1F]");
            String string = " ";
            context = ((Object)StringsKt.trim((CharSequence)regex.replace(charSequence, string))).toString();
            sb.append((String)context);
            sb.append("\t");
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

