/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.ml;

import ai.platon.scent.common.MLPaths;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0003\b&\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0007\u001a\u00020\u00032\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\tJ\b\u0010\n\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lai/platon/scent/ml/MLProject;", "", "id", "", "(Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "buildInfo", "params", "", "toString", "Companion", "scent-build"})
@SourceDebugExtension(value={"SMAP\nMLProject.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MLProject.kt\nai/platon/scent/ml/MLProject\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,56:1\n125#2:57\n152#2,3:58\n*S KotlinDebug\n*F\n+ 1 MLProject.kt\nai/platon/scent/ml/MLProject\n*L\n44#1:57\n44#1:58,3\n*E\n"})
public abstract class MLProject {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    private static final DateTimeFormatter FORMATTER_PER_DAY = DateTimeFormatter.ofPattern("yyyyMMdd");
    private static final DateTimeFormatter FORMATTER_PER_HOUR = DateTimeFormatter.ofPattern("yyyyMMddHH");
    private static final DateTimeFormatter FORMATTER_PER_MINUTE = DateTimeFormatter.ofPattern("yyyyMMddHHmm");
    private static final DateTimeFormatter FORMATTER_PER_SECOND;
    private static final DateTimeFormatter FORMATTER;

    public MLProject(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.id = id;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String buildInfo(@NotNull Map<String, ? extends Object> params) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(params, (String)"params");
        Map<String, ? extends Object> $this$map$iv = params;
        boolean $i$f$map = false;
        Map<String, ? extends Object> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String k = (String)entry.getKey();
            Object v = entry.getValue();
            collection.add(k + ": " + v);
        }
        Object info2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        info2 = (String)info2 + StringsKt.trimIndent((String)("\n            projectId: " + this.id + "\n            buildTime: " + OffsetDateTime.now() + "\n        "));
        return info2;
    }

    @NotNull
    public String toString() {
        return this.id;
    }

    static {
        FORMATTER = FORMATTER_PER_SECOND = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0016\u001a\u00020\u0011J\u000e\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0004J\u0006\u0010\u0018\u001a\u00020\u0011J\u0006\u0010\u0019\u001a\u00020\u0011J\u0006\u0010\u001a\u001a\u00020\u0011J\u0006\u0010\u001b\u001a\u00020\u0011R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0019\u0010\b\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0019\u0010\n\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0019\u0010\f\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0019\u0010\u000e\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007\u00a8\u0006\u001c"}, d2={"Lai/platon/scent/ml/MLProject$Companion;", "", "()V", "FORMATTER", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "getFORMATTER", "()Ljava/time/format/DateTimeFormatter;", "FORMATTER_PER_DAY", "getFORMATTER_PER_DAY", "FORMATTER_PER_HOUR", "getFORMATTER_PER_HOUR", "FORMATTER_PER_MINUTE", "getFORMATTER_PER_MINUTE", "FORMATTER_PER_SECOND", "getFORMATTER_PER_SECOND", "findProjectId", "", "path", "Ljava/nio/file/Path;", "isProjectBaseDir", "", "newProjectId", "formatter", "perDayProjectId", "perHourProjectId", "perMinuteProjectId", "perSecondProjectId", "scent-build"})
    public static final class Companion {
        private Companion() {
        }

        public final DateTimeFormatter getFORMATTER_PER_DAY() {
            return FORMATTER_PER_DAY;
        }

        public final DateTimeFormatter getFORMATTER_PER_HOUR() {
            return FORMATTER_PER_HOUR;
        }

        public final DateTimeFormatter getFORMATTER_PER_MINUTE() {
            return FORMATTER_PER_MINUTE;
        }

        public final DateTimeFormatter getFORMATTER_PER_SECOND() {
            return FORMATTER_PER_SECOND;
        }

        public final DateTimeFormatter getFORMATTER() {
            return FORMATTER;
        }

        @NotNull
        public final String newProjectId() {
            DateTimeFormatter dateTimeFormatter = this.getFORMATTER();
            Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"<get-FORMATTER>(...)");
            return this.newProjectId(dateTimeFormatter);
        }

        @NotNull
        public final String newProjectId(@NotNull DateTimeFormatter formatter) {
            Intrinsics.checkNotNullParameter((Object)formatter, (String)"formatter");
            return "p" + LocalDateTime.now().format(formatter);
        }

        @NotNull
        public final String perDayProjectId() {
            DateTimeFormatter dateTimeFormatter = this.getFORMATTER_PER_DAY();
            Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"<get-FORMATTER_PER_DAY>(...)");
            return this.newProjectId(dateTimeFormatter);
        }

        @NotNull
        public final String perHourProjectId() {
            DateTimeFormatter dateTimeFormatter = this.getFORMATTER_PER_HOUR();
            Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"<get-FORMATTER_PER_HOUR>(...)");
            return this.newProjectId(dateTimeFormatter);
        }

        @NotNull
        public final String perMinuteProjectId() {
            DateTimeFormatter dateTimeFormatter = this.getFORMATTER_PER_MINUTE();
            Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"<get-FORMATTER_PER_MINUTE>(...)");
            return this.newProjectId(dateTimeFormatter);
        }

        @NotNull
        public final String perSecondProjectId() {
            DateTimeFormatter dateTimeFormatter = this.getFORMATTER_PER_SECOND();
            Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"<get-FORMATTER_PER_SECOND>(...)");
            return this.newProjectId(dateTimeFormatter);
        }

        @Nullable
        public final String findProjectId(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            MatchResult matchResult = Regex.find$default((Regex)MLPaths.INSTANCE.getProjectIdPattern(), (CharSequence)((Object)path).toString(), (int)0, (int)2, null);
            if (matchResult == null) {
                return null;
            }
            MatchResult result = matchResult;
            return result.getValue();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isProjectBaseDir(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.isDirectory(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) return false;
            CharSequence charSequence = PathsKt.getName((Path)path);
            if (!MLPaths.INSTANCE.getProjectBaseDirPattern().matches(charSequence)) return false;
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

