/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.ml.clustering.io;

import ai.platon.pulsar.common.urls.URLUtils;
import ai.platon.scent.ml.ML;
import ai.platon.scent.ml.MLResultLoader;
import ai.platon.scent.ml.MLResultTable;
import ai.platon.scent.ml.clustering.io.ClusteringResultPageListLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0014\u001a\u00020\u0007H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u001a\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\f2\b\u0010!\u001a\u0004\u0018\u00010\fH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\"\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0011\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lai/platon/scent/ml/clustering/io/ClusteringResultPageListLoader;", "Lai/platon/scent/ml/MLResultLoader;", "csvPaths", "", "Ljava/nio/file/Path;", "(Ljava/util/List;)V", "format", "Lorg/apache/commons/csv/CSVFormat;", "getFormat", "()Lorg/apache/commons/csv/CSVFormat;", "headerNames", "", "", "getHeaderNames", "()[Ljava/lang/String;", "setHeaderNames", "([Ljava/lang/String;)V", "[Ljava/lang/String;", "urlHeaderIndex", "", "buildCSVFormat", "buildRows", "", "csvParser", "Lorg/apache/commons/csv/CSVParser;", "load", "Lai/platon/scent/ml/MLResultTable;", "parseHeaderNames", "csvRecord", "Lorg/apache/commons/csv/CSVRecord;", "recordAsCell", "Lai/platon/scent/ml/ML$Record;", "url", "text", "Companion", "scent-build"})
@SourceDebugExtension(value={"SMAP\nClusteringResultPageListLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClusteringResultPageListLoader.kt\nai/platon/scent/ml/clustering/io/ClusteringResultPageListLoader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,73:1\n1864#2,2:74\n1866#2:79\n13374#3,3:76\n11065#3:80\n11400#3,3:81\n37#4,2:84\n*S KotlinDebug\n*F\n+ 1 ClusteringResultPageListLoader.kt\nai/platon/scent/ml/clustering/io/ClusteringResultPageListLoader\n*L\n31#1:74,2\n31#1:79\n42#1:76,3\n51#1:80\n51#1:81,3\n51#1:84,2\n*E\n"})
public final class ClusteringResultPageListLoader
extends MLResultLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Path> csvPaths;
    @NotNull
    private String[] headerNames;
    private int urlHeaderIndex;
    @NotNull
    private final CSVFormat format;
    @NotNull
    private static final String EXAMPLE_RESOURCE = "data/hua/dataset.nodes.unsupervised.result.20000.page.list.csv";

    public ClusteringResultPageListLoader(@NotNull List<? extends Path> csvPaths2) {
        Intrinsics.checkNotNullParameter(csvPaths2, (String)"csvPaths");
        this.csvPaths = csvPaths2;
        this.headerNames = new String[0];
        this.format = this.buildCSVFormat();
    }

    @Override
    @NotNull
    public String[] getHeaderNames() {
        return this.headerNames;
    }

    public void setHeaderNames(@NotNull String[] stringArray) {
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"<set-?>");
        this.headerNames = stringArray;
    }

    @Override
    @NotNull
    public CSVFormat getFormat() {
        return this.format;
    }

    @Override
    @NotNull
    public MLResultTable load() {
        super.loadAllCSV(this.csvPaths);
        return new MLResultTable(this.getUrlToRecords(), this.getPredictionToColumns());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void buildRows(@NotNull CSVParser csvParser) {
        Intrinsics.checkNotNullParameter((Object)csvParser, (String)"csvParser");
        Iterable $this$forEachIndexed$iv = (Iterable)csvParser;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            String url;
            void csvRecord;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            CSVRecord cSVRecord = (CSVRecord)item$iv;
            int i = n;
            boolean bl = false;
            if (i == 0) {
                Intrinsics.checkNotNull((Object)csvRecord);
                this.parseHeaderNames((CSVRecord)csvRecord);
            }
            if (!URLUtils.isStandard((String)(url = csvRecord.get(this.urlHeaderIndex)))) continue;
            Intrinsics.checkNotNullExpressionValue((Object)this.getUrlToRecords().computeIfAbsent(url, arg_0 -> ClusteringResultPageListLoader.buildRows$lambda$2$lambda$0(buildRows.1.cells.1.INSTANCE, arg_0)), (String)"computeIfAbsent(...)");
            String[] $this$forEachIndexed$iv2 = this.getHeaderNames();
            boolean $i$f$forEachIndexed2 = false;
            int index$iv2 = 0;
            for (String item$iv2 : $this$forEachIndexed$iv2) {
                Map cells2;
                int n2 = index$iv2++;
                String string = item$iv2;
                int j = n2;
                boolean bl2 = false;
                String[] stringArray = csvRecord.values();
                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"values(...)");
                String text = (String)ArraysKt.getOrNull((Object[])stringArray, (int)j);
                Intrinsics.checkNotNull((Object)url);
                ML.Record cell = this.recordAsCell(url, text);
                cells2.put(cell.getPrediction(), cell);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void parseHeaderNames(CSVRecord csvRecord) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String[] stringArray = csvRecord.values();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"values(...)");
        Object[] objectArray = stringArray;
        ClusteringResultPageListLoader clusteringResultPageListLoader = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        clusteringResultPageListLoader.setHeaderNames(thisCollection$iv.toArray(new String[0]));
        this.urlHeaderIndex = ArraysKt.indexOf((Object[])this.getHeaderNames(), (Object)"URL");
        if (this.urlHeaderIndex < 0) {
            this.urlHeaderIndex = ArraysKt.indexOf((Object[])this.getHeaderNames(), (Object)"url");
        }
    }

    private final ML.Record recordAsCell(String url, String text) {
        return new ML.Record("", 0, 0.0f, 0.0f, 0.0f, 0.0f, 0, 0, text, url, 0, 1216, null);
    }

    private final CSVFormat buildCSVFormat() {
        CSVFormat cSVFormat = CSVFormat.ORACLE.builder().setSkipHeaderRecord(false).build();
        Intrinsics.checkNotNullExpressionValue((Object)cSVFormat, (String)"build(...)");
        return cSVFormat;
    }

    private static final Map buildRows$lambda$2$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Map)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lai/platon/scent/ml/clustering/io/ClusteringResultPageListLoader$Companion;", "", "()V", "EXAMPLE_RESOURCE", "", "getEXAMPLE_RESOURCE", "()Ljava/lang/String;", "scent-build"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getEXAMPLE_RESOURCE() {
            return EXAMPLE_RESOURCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

