/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.ml.encoding;

import ai.platon.pulsar.common.AppPaths;
import ai.platon.pulsar.common.RequiredDirectory;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.scent.common.MLPaths;
import ai.platon.scent.ml.MLProject;
import ai.platon.scent.ml.encoding.EncodeProject;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 .2\u00020\u0001:\u0002./B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010 \u001a\u00020!J\u001a\u0010\"\u001a\u00020!2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020%0$J\u0006\u0010&\u001a\u00020!J\u001a\u0010'\u001a\u00020!2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020%0$J\u001a\u0010)\u001a\u00020!2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030$J\u000e\u0010*\u001a\u00020\b2\u0006\u0010+\u001a\u00020,J\u000e\u0010*\u001a\u00020\b2\u0006\u0010-\u001a\u00020\u0003R\u0019\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\f\u001a\n \t*\u0004\u0018\u00010\b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0019\u0010\u000e\u001a\n \t*\u0004\u0018\u00010\b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0019\u0010\u0010\u001a\n \t*\u0004\u0018\u00010\b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000bR\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0016\u001a\n \t*\u0004\u0018\u00010\b0\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000bR\u0019\u0010\u0018\u001a\n \t*\u0004\u0018\u00010\b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000bR\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u00060"}, d2={"Lai/platon/scent/ml/encoding/EncodeProject;", "Lai/platon/scent/ml/MLProject;", "id", "", "type", "Lai/platon/scent/ml/encoding/EncodeProject$Type;", "(Ljava/lang/String;Lai/platon/scent/ml/encoding/EncodeProject$Type;)V", "baseDir", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "getBaseDir", "()Ljava/nio/file/Path;", "configFile", "getConfigFile", "datasetPath", "getDatasetPath", "encodeInfoFile", "getEncodeInfoFile", "hasHTMLFile", "", "getHasHTMLFile", "()Z", "htmlBaseDir", "getHtmlBaseDir", "htmlExportInfoFile", "getHtmlExportInfoFile", "htmlFileCount", "", "getHtmlFileCount", "()I", "getType", "()Lai/platon/scent/ml/encoding/EncodeProject$Type;", "clearEncodeInfo", "", "createConfigFile", "properties", "", "", "createDirectories", "createEncodeInfoFile", "params", "createExportInfoFile", "exportPath", "page", "Lai/platon/pulsar/persist/WebPage;", "url", "Companion", "Type", "scent-build"})
@SourceDebugExtension(value={"SMAP\nEncodeProject.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EncodeProject.kt\nai/platon/scent/ml/encoding/EncodeProject\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,147:1\n3792#2:148\n4307#2:149\n12474#2,2:150\n4308#2:152\n1603#3,9:153\n1855#3:162\n1856#3:164\n1612#3:165\n1855#3:166\n1856#3:168\n1#4:163\n1#4:167\n*S KotlinDebug\n*F\n+ 1 EncodeProject.kt\nai/platon/scent/ml/encoding/EncodeProject\n*L\n142#1:148\n142#1:149\n142#1:150,2\n142#1:152\n143#1:153,9\n143#1:162\n143#1:164\n143#1:165\n144#1:166\n144#1:168\n143#1:163\n*E\n"})
public final class EncodeProject
extends MLProject {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Type type;
    private final Path baseDir;
    @RequiredDirectory
    private final Path htmlBaseDir;
    private final Path htmlExportInfoFile;
    private final Path datasetPath;
    private final Path encodeInfoFile;
    private final Path configFile;

    public EncodeProject(@NotNull String id, @NotNull Type type) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        super(id);
        this.type = type;
        this.baseDir = switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 1 -> MLPaths.INSTANCE.getTrainingDatasetBaseDir().resolve(id);
            case 2 -> MLPaths.INSTANCE.getPredictionDatasetBaseDir().resolve(id);
            default -> throw new NoWhenBranchMatchedException();
        };
        this.htmlBaseDir = this.baseDir.resolve("html");
        this.htmlExportInfoFile = this.baseDir.resolve("htmlExportInfo.txt");
        this.datasetPath = this.baseDir.resolve("dataset-" + id + ".csv");
        this.encodeInfoFile = this.baseDir.resolve("encodeInfo.txt");
        this.configFile = this.baseDir.resolve("config.properties");
        this.createDirectories();
    }

    @NotNull
    public final Type getType() {
        return this.type;
    }

    public final Path getBaseDir() {
        return this.baseDir;
    }

    public final Path getHtmlBaseDir() {
        return this.htmlBaseDir;
    }

    public final Path getHtmlExportInfoFile() {
        return this.htmlExportInfoFile;
    }

    public final int getHtmlFileCount() {
        Path path = this.htmlBaseDir;
        Intrinsics.checkNotNull((Object)path);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.notExists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return 0;
        }
        path = this.htmlBaseDir;
        Intrinsics.checkNotNull((Object)path);
        return ((Collection)PathsKt.listDirectoryEntries((Path)path, (String)"*.html")).size();
    }

    public final boolean getHasHTMLFile() {
        return this.getHtmlFileCount() > 0;
    }

    public final Path getDatasetPath() {
        return this.datasetPath;
    }

    public final Path getEncodeInfoFile() {
        return this.encodeInfoFile;
    }

    public final Path getConfigFile() {
        return this.configFile;
    }

    @NotNull
    public final Path exportPath(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String fileName = AppPaths.INSTANCE.fromUri(url, "", ".html");
        Path path = this.htmlBaseDir.resolve(fileName);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @NotNull
    public final Path exportPath(@NotNull WebPage page) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        return this.exportPath(page.getUrl());
    }

    public final void createExportInfoFile(@NotNull Map<String, String> params) throws IOException {
        Intrinsics.checkNotNullParameter(params, (String)"params");
        Path path = this.baseDir.resolve("htmlExportInfo.txt");
        Files.writeString(path, (CharSequence)this.buildInfo(params), new OpenOption[0]);
    }

    public final void createEncodeInfoFile(@NotNull Map<String, ? extends Object> params) throws IOException {
        Intrinsics.checkNotNullParameter(params, (String)"params");
        Files.writeString(this.encodeInfoFile, (CharSequence)this.buildInfo(params), new OpenOption[0]);
    }

    public final void createConfigFile(@NotNull Map<String, ? extends Object> properties) {
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        String info2 = CollectionsKt.joinToString$default((Iterable)properties.entrySet(), (CharSequence)"\n", null, null, (int)0, null, (Function1)createConfigFile.info.1.INSTANCE, (int)30, null);
        Files.writeString(this.configFile, (CharSequence)info2, new OpenOption[0]);
    }

    public final void clearEncodeInfo() {
        Files.deleteIfExists(this.encodeInfoFile);
    }

    /*
     * WARNING - void declaration
     */
    public final void createDirectories() {
        void $this$mapNotNullTo$iv$iv;
        Iterator element$iv$iv2;
        Iterable $this$filterTo$iv$iv;
        Field[] fieldArray = EncodeProject.class.getDeclaredFields();
        Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"getDeclaredFields(...)");
        Object[] $this$filter$iv = fieldArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Iterator element$iv$iv2 : $this$filterTo$iv$iv) {
            boolean bl;
            block4: {
                Field it = (Field)((Object)element$iv$iv2);
                boolean bl2 = false;
                Annotation[] annotationArray = it.getAnnotations();
                Intrinsics.checkNotNullExpressionValue((Object)annotationArray, (String)"getAnnotations(...)");
                Object[] $this$any$iv = annotationArray;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    Annotation it2 = (Annotation)element$iv;
                    boolean bl3 = false;
                    if (!(it2 instanceof RequiredDirectory)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        element$iv$iv2 = $this$forEach$iv$iv$iv.iterator();
        while (element$iv$iv2.hasNext()) {
            Path it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv3 = element$iv$iv$iv = element$iv$iv2.next();
            boolean bl = false;
            Field it = (Field)element$iv$iv3;
            boolean bl4 = false;
            Object object = it.get(this);
            if ((object instanceof Path ? (Path)object : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            Path path;
            Path it = (Path)element$iv;
            boolean bl = false;
            Path it3 = path = it;
            boolean bl6 = false;
            Path path2 = !Files.exists(it3, new LinkOption[0]) ? path : null;
            if (path2 == null) continue;
            it3 = path2;
            boolean bl7 = false;
            Files.createDirectories(it3, new FileAttribute[0]);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006J\u0006\u0010\f\u001a\u00020\u0004J\b\u0010\r\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0011"}, d2={"Lai/platon/scent/ml/encoding/EncodeProject$Companion;", "", "()V", "fromPath", "Lai/platon/scent/ml/encoding/EncodeProject;", "path", "Ljava/nio/file/Path;", "fromPathOrNull", "isProjectBaseDir", "", "file", "Ljava/io/File;", "lastTrainingProject", "lastTrainingProjectOrNull", "newProject", "type", "Lai/platon/scent/ml/encoding/EncodeProject$Type;", "scent-build"})
    @SourceDebugExtension(value={"SMAP\nEncodeProject.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EncodeProject.kt\nai/platon/scent/ml/encoding/EncodeProject$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,147:1\n766#2:148\n857#2,2:149\n1963#2,14:151\n*S KotlinDebug\n*F\n+ 1 EncodeProject.kt\nai/platon/scent/ml/encoding/EncodeProject$Companion\n*L\n56#1:148\n56#1:149,2\n57#1:151,14\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EncodeProject fromPath(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            EncodeProject encodeProject = this.fromPathOrNull(path);
            if (encodeProject == null) {
                throw new IllegalArgumentException("Invalid project path: " + path);
            }
            return encodeProject;
        }

        @Nullable
        public final EncodeProject fromPathOrNull(@Nullable Path path) {
            if (path == null) {
                return null;
            }
            String string = MLProject.Companion.findProjectId(path);
            if (string == null) {
                return null;
            }
            String projectId = string;
            String pathString = ((Object)path).toString();
            return StringsKt.contains$default((CharSequence)pathString, (CharSequence)"training", (boolean)false, (int)2, null) ? new EncodeProject(projectId, Type.TRAINING) : (StringsKt.contains$default((CharSequence)pathString, (CharSequence)"predict", (boolean)false, (int)2, null) ? new EncodeProject(projectId, Type.PREDICT) : null);
        }

        @NotNull
        public final EncodeProject lastTrainingProject() {
            EncodeProject encodeProject = this.lastTrainingProjectOrNull();
            if (encodeProject == null) {
                throw new IllegalArgumentException("No encoding project found.");
            }
            return encodeProject;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final EncodeProject lastTrainingProjectOrNull() {
            Object v0;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = PathsKt.listDirectoryEntries$default((Path)MLPaths.INSTANCE.getTrainingDatasetBaseDir(), null, (int)1, null);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Path it = (Path)element$iv$iv;
                boolean bl = false;
                if (!Companion.isProjectBaseDir(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$maxByOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v0 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v0 = maxElem$iv;
                } else {
                    Path it = (Path)maxElem$iv;
                    boolean bl = false;
                    Comparable maxValue$iv = Files.getLastModifiedTime(it, new LinkOption[0]);
                    do {
                        Object e$iv = iterator$iv.next();
                        Path it2 = (Path)e$iv;
                        $i$a$-maxByOrNull-EncodeProject$Companion$lastTrainingProjectOrNull$projectDir$2 = false;
                        Comparable v$iv = Files.getLastModifiedTime(it2, new LinkOption[0]);
                        if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v0 = maxElem$iv;
                }
            }
            Path projectDir = v0;
            return this.fromPathOrNull(projectDir);
        }

        public final boolean isProjectBaseDir(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Path path = file.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
            return this.isProjectBaseDir(path);
        }

        public final boolean isProjectBaseDir(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return MLProject.Companion.isProjectBaseDir(path);
        }

        @NotNull
        public final EncodeProject newProject(@NotNull Type type) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            return new EncodeProject(MLProject.Companion.newProjectId(), type);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lai/platon/scent/ml/encoding/EncodeProject$Type;", "", "(Ljava/lang/String;I)V", "TRAINING", "PREDICT", "scent-build"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type TRAINING = new Type();
        public static final /* enum */ Type PREDICT = new Type();
        private static final /* synthetic */ Type[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value) {
            return Enum.valueOf(Type.class, value);
        }

        @NotNull
        public static EnumEntries<Type> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = typeArray = new Type[]{Type.TRAINING, Type.PREDICT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Type.values().length];
            try {
                nArray[Type.TRAINING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.PREDICT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

