/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.ml.harvest;

import ai.platon.pulsar.common.RequiredDirectory;
import ai.platon.scent.common.MLPaths;
import ai.platon.scent.ml.encoding.EncodeProject;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import smile.data.DataFrame;
import smile.io.CSV;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u001a\u001a\u00020\u00032\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u001cH\u0002J\u001a\u0010\u001d\u001a\u00020\u001e2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u001cJ\u0006\u0010\u001f\u001a\u00020\u001eJ\u001a\u0010 \u001a\u00020\u001e2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u001cJ\u001a\u0010!\u001a\u00020\u001e2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u001cJ\u001c\u0010\"\u001a\u00020\u001e2\u0014\b\u0002\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u001cJ\u0006\u0010#\u001a\u00020\u001eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0013\u001a\n \u0015*\u0004\u0018\u00010\u00140\u00148\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001e\u0010\u0018\u001a\n \u0015*\u0004\u0018\u00010\u00140\u00148\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017\u00a8\u0006$"}, d2={"Lai/platon/scent/ml/harvest/HarvestProject;", "", "id", "", "(Ljava/lang/String;)V", "encodeProject", "Lai/platon/scent/ml/encoding/EncodeProject;", "getEncodeProject", "()Lai/platon/scent/ml/encoding/EncodeProject;", "hasHTMLFile", "", "getHasHTMLFile", "()Z", "htmlFileCount", "", "getHtmlFileCount", "()I", "getId", "()Ljava/lang/String;", "predictionAndMinimalFeaturesBaseDir", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "getPredictionAndMinimalFeaturesBaseDir", "()Ljava/nio/file/Path;", "resultBaseDir", "getResultBaseDir", "buildInfo", "params", "", "createClusteringInfoFile", "", "createDirectories", "createEncodingInfoFile", "createExportInfoFile", "createInfoFiles", "createPredictionAndMinimalDataset", "scent-build"})
@SourceDebugExtension(value={"SMAP\nHarvestProject.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HarvestProject.kt\nai/platon/scent/ml/harvest/HarvestProject\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,73:1\n3792#2:74\n4307#2:75\n12474#2,2:76\n4308#2:78\n1603#3,9:79\n1855#3:88\n1856#3:90\n1612#3:91\n1855#3:92\n1856#3:94\n1#4:89\n1#4:93\n125#5:95\n152#5,3:96\n*S KotlinDebug\n*F\n+ 1 HarvestProject.kt\nai/platon/scent/ml/harvest/HarvestProject\n*L\n59#1:74\n59#1:75\n59#1:76,2\n59#1:78\n60#1:79,9\n60#1:88\n60#1:90\n60#1:91\n61#1:92\n61#1:94\n60#1:89\n65#1:95\n65#1:96,3\n*E\n"})
public final class HarvestProject {
    @NotNull
    private final String id;
    @NotNull
    private final EncodeProject encodeProject;
    @RequiredDirectory
    private final Path resultBaseDir;
    @RequiredDirectory
    private final Path predictionAndMinimalFeaturesBaseDir;

    public HarvestProject(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.id = id;
        this.encodeProject = new EncodeProject(this.id, EncodeProject.Type.TRAINING);
        this.resultBaseDir = MLPaths.INSTANCE.getHarvestResultBaseDir().resolve(this.id);
        this.predictionAndMinimalFeaturesBaseDir = this.resultBaseDir.resolve("predictionAndMinimalFeatures");
        this.createDirectories();
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final EncodeProject getEncodeProject() {
        return this.encodeProject;
    }

    public final Path getResultBaseDir() {
        return this.resultBaseDir;
    }

    public final Path getPredictionAndMinimalFeaturesBaseDir() {
        return this.predictionAndMinimalFeaturesBaseDir;
    }

    public final int getHtmlFileCount() {
        return this.encodeProject.getHtmlFileCount();
    }

    public final boolean getHasHTMLFile() {
        return this.encodeProject.getHasHTMLFile();
    }

    public final void createPredictionAndMinimalDataset() {
        if (!Files.exists(this.encodeProject.getDatasetPath(), new LinkOption[0])) {
            return;
        }
        Path baseDir = this.resultBaseDir.resolve("predictionAndMinimalFeatures");
        Files.createDirectories(baseDir, new FileAttribute[0]);
        DataFrame df = new CSV().read(this.encodeProject.getDatasetPath());
    }

    public final void createEncodingInfoFile(@NotNull Map<String, String> params) {
        Intrinsics.checkNotNullParameter(params, (String)"params");
        this.encodeProject.createEncodeInfoFile(params);
    }

    public final void createExportInfoFile(@NotNull Map<String, String> params) {
        Intrinsics.checkNotNullParameter(params, (String)"params");
        this.encodeProject.createExportInfoFile(params);
    }

    public final void createClusteringInfoFile(@NotNull Map<String, String> params) {
        Intrinsics.checkNotNullParameter(params, (String)"params");
        Path path = this.resultBaseDir.resolve("clusteringInfo.txt");
        Files.writeString(path, (CharSequence)this.buildInfo(params), new OpenOption[0]);
    }

    public final void createInfoFiles(@NotNull Map<String, String> params) {
        Intrinsics.checkNotNullParameter(params, (String)"params");
        this.createDirectories();
        this.encodeProject.createDirectories();
        this.createEncodingInfoFile(params);
        this.createExportInfoFile(params);
        this.createClusteringInfoFile(params);
    }

    public static /* synthetic */ void createInfoFiles$default(HarvestProject harvestProject, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            map = MapsKt.emptyMap();
        }
        harvestProject.createInfoFiles(map);
    }

    /*
     * WARNING - void declaration
     */
    public final void createDirectories() {
        void $this$mapNotNullTo$iv$iv;
        Iterator element$iv$iv2;
        Iterable $this$filterTo$iv$iv;
        Field[] fieldArray = HarvestProject.class.getDeclaredFields();
        Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"getDeclaredFields(...)");
        Object[] $this$filter$iv = fieldArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Iterator element$iv$iv2 : $this$filterTo$iv$iv) {
            boolean bl;
            block4: {
                Field it = (Field)((Object)element$iv$iv2);
                boolean bl2 = false;
                Annotation[] annotationArray = it.getAnnotations();
                Intrinsics.checkNotNullExpressionValue((Object)annotationArray, (String)"getAnnotations(...)");
                Object[] $this$any$iv = annotationArray;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    Annotation it2 = (Annotation)element$iv;
                    boolean bl3 = false;
                    if (!(it2 instanceof RequiredDirectory)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        element$iv$iv2 = $this$forEach$iv$iv$iv.iterator();
        while (element$iv$iv2.hasNext()) {
            Path it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv3 = element$iv$iv$iv = element$iv$iv2.next();
            boolean bl = false;
            Field it = (Field)element$iv$iv3;
            boolean bl4 = false;
            Object object = it.get(this);
            if ((object instanceof Path ? (Path)object : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            Path path;
            Path it = (Path)element$iv;
            boolean bl = false;
            Path it3 = path = it;
            boolean bl6 = false;
            Path path2 = !Files.exists(it3, new LinkOption[0]) ? path : null;
            if (path2 == null) continue;
            it3 = path2;
            boolean bl7 = false;
            Files.createDirectories(it3, new FileAttribute[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String buildInfo(Map<String, String> params) {
        void $this$mapTo$iv$iv;
        Map<String, String> $this$map$iv = params;
        boolean $i$f$map = false;
        Map<String, String> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String k = (String)entry.getKey();
            String v = (String)entry.getValue();
            collection.add(k + ": " + v);
        }
        Object info2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        info2 = (String)info2 + StringsKt.trimIndent((String)("\n            projectId: " + this.id + "\n            buildTime: " + OffsetDateTime.now() + "\n        "));
        return info2;
    }
}

