/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.view.builder;

import ai.platon.pulsar.common.AppFiles;
import ai.platon.pulsar.common.AppPaths;
import ai.platon.pulsar.common.Strings;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.dom.FeaturedDocument;
import ai.platon.pulsar.dom.model.PageAttribute;
import ai.platon.pulsar.dom.model.PageEntity;
import ai.platon.scent.view.builder.HtmlViewBuilder;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.nodes.Element;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00192\u00020\u0001:\u0002\u0019\u001aB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\b\u0010\f\u001a\u00020\rH\u0016J\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u001e\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u001e\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u0006\u0010\u0016\u001a\u00020\u0017J\b\u0010\u0018\u001a\u00020\u0017H\u0004R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lai/platon/scent/view/builder/ProductHtmlBuilder;", "Lai/platon/scent/view/builder/HtmlViewBuilder;", "pageEntity", "Lai/platon/pulsar/dom/model/PageEntity;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/dom/model/PageEntity;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "format", "Lai/platon/scent/view/builder/ProductHtmlBuilder$Format;", "(Lai/platon/pulsar/dom/model/PageEntity;Lai/platon/scent/view/builder/ProductHtmlBuilder$Format;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "getFormat", "()Lai/platon/scent/view/builder/ProductHtmlBuilder$Format;", "build", "", "buildCommonBlock", "Lorg/jsoup/nodes/Element;", "root", "attributes", "", "Lai/platon/pulsar/dom/model/PageAttribute;", "buildGallery", "buildProductDetailText", "buildSimplified", "Lai/platon/pulsar/dom/FeaturedDocument;", "buildWaterfall", "Companion", "Format", "scent-build"})
@SourceDebugExtension(value={"SMAP\nProductHtmlBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProductHtmlBuilder.kt\nai/platon/scent/view/builder/ProductHtmlBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,176:1\n766#2:177\n857#2,2:178\n*S KotlinDebug\n*F\n+ 1 ProductHtmlBuilder.kt\nai/platon/scent/view/builder/ProductHtmlBuilder\n*L\n38#1:177\n38#1:178,2\n*E\n"})
public final class ProductHtmlBuilder
extends HtmlViewBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Format format;
    @NotNull
    private static final String[] predefinedProductLabels;

    public ProductHtmlBuilder(@NotNull PageEntity pageEntity, @NotNull Format format, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)pageEntity, (String)"pageEntity");
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        super(pageEntity, conf);
        this.format = format;
    }

    @NotNull
    public final Format getFormat() {
        return this.format;
    }

    public ProductHtmlBuilder(@NotNull PageEntity pageEntity, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)pageEntity, (String)"pageEntity");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this(pageEntity, Format.Simplified, conf);
    }

    @Override
    public void build() {
        if (this.format == Format.Waterfall) {
            this.buildWaterfall();
        } else if (this.format == Format.All) {
            HtmlViewBuilder.buildDocument$default(this, null, 1, null);
        } else {
            this.buildSimplified();
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final FeaturedDocument buildSimplified() {
        Validate.notNull((Object)this.getDoc());
        Element body = this.getDoc().getBody();
        Object[] objectArray = new String[]{"TitleContainer", "ProductSpec", "Metadata", "PreDefined"};
        List tableLabels = CollectionsKt.listOf((Object[])objectArray);
        for (String label : predefinedProductLabels) {
            Element div;
            void $this$filterTo$iv$iv;
            String section = Strings.humanize((String)label);
            Collection collection = this.getPageEntity().getAttributes().values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable $this$filter$iv = collection;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PageAttribute it = (PageAttribute)element$iv$iv;
                boolean bl = false;
                if (!it.hasCategory(label)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List attributes = (List)destination$iv$iv;
            if (attributes.isEmpty()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)body.appendElement("div"), (String)"appendElement(...)");
            div.attr("class", section);
            if (!Intrinsics.areEqual((Object)label, (Object)"Title")) {
                div.appendElement("h2").text(section);
            }
            if (Intrinsics.areEqual((Object)label, (Object)"Title")) {
                String title = ((PageAttribute)CollectionsKt.first((List)attributes)).getValue();
                div.appendElement("h1").text(title);
                this.getDoc().getDocument().title(title);
            } else if (tableLabels.contains(label)) {
                this.buildTable(div, attributes);
            } else if (Intrinsics.areEqual((Object)label, (Object)"ProductDetail")) {
                this.buildProductDetailText(div, attributes);
                this.buildPureImages(div, attributes);
            } else if (Intrinsics.areEqual((Object)label, (Object)"SimilarEntity")) {
                this.buildLinks(div, attributes);
            } else if (Intrinsics.areEqual((Object)label, (Object)"Gallery")) {
                this.buildGallery(div, attributes);
            } else if (Intrinsics.areEqual((Object)label, (Object)"Categories")) {
                div.appendElement("div").html(((PageAttribute)CollectionsKt.first((List)attributes)).getValue());
            }
            body.appendElement("hr");
        }
        this.adjustAllImageSize(body);
        this.adjustAttributes(body);
        return this.getDoc();
    }

    @NotNull
    protected final FeaturedDocument buildWaterfall() {
        return this.getDoc();
    }

    private final Element buildGallery(Element root, Collection<PageAttribute> attributes) {
        for (PageAttribute attr : attributes) {
            root.append(attr.getValue());
        }
        for (Element img : root.getElementsByTag("img")) {
            img.removeAttr("alt");
        }
        return root;
    }

    private final Element buildProductDetailText(Element root, Collection<PageAttribute> attributes) {
        for (PageAttribute attr : attributes) {
            String text;
            Element div;
            Intrinsics.checkNotNullExpressionValue((Object)this.getDoc().getDocument().createElement("div"), (String)"createElement(...)");
            div.append(attr.getValue());
            Intrinsics.checkNotNullExpressionValue((Object)div.text(), (String)"text(...)");
            root.text(text);
        }
        return root;
    }

    private final Element buildCommonBlock(Element root, Collection<PageAttribute> attributes) {
        for (PageAttribute attr : attributes) {
            root.append(attr.getValue());
        }
        return root;
    }

    static {
        String[] stringArray = new String[]{"Title", "Categories", "Metadata", "Gallery", "TitleContainer", "ProductSpec", "PreDefined", "ProductDetail", "SimilarEntity", "Links"};
        predefinedProductLabels = stringArray;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\t\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lai/platon/scent/view/builder/ProductHtmlBuilder$Companion;", "", "()V", "predefinedProductLabels", "", "", "getPredefinedProductLabels", "()[Ljava/lang/String;", "[Ljava/lang/String;", "build", "Lorg/apache/commons/lang3/tuple/Pair;", "Ljava/nio/file/Path;", "doc", "Lai/platon/pulsar/dom/FeaturedDocument;", "pageEntity", "Lai/platon/pulsar/dom/model/PageEntity;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "scent-build"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String[] getPredefinedProductLabels() {
            return predefinedProductLabels;
        }

        @NotNull
        public final Path build(@NotNull PageEntity pageEntity, @NotNull ImmutableConfig conf) {
            Intrinsics.checkNotNullParameter((Object)pageEntity, (String)"pageEntity");
            Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
            String format = conf.get("BUILDER", "all");
            ProductHtmlBuilder builder = new ProductHtmlBuilder(pageEntity, Format.Companion.of(format), conf);
            builder.build();
            String baseURI = pageEntity.getBaseURI();
            Path path = AppPaths.INSTANCE.getREPORT_DIR().resolve("build").resolve(AppPaths.INSTANCE.fromUri(baseURI, "", ".htm"));
            String string = builder.toString();
            Intrinsics.checkNotNull((Object)path);
            return AppFiles.saveTo$default((AppFiles)AppFiles.INSTANCE, (String)string, (Path)path, (boolean)false, (int)4, null);
        }

        @NotNull
        public final Pair<Path, Path> build(@NotNull FeaturedDocument doc, @NotNull PageEntity pageEntity, @NotNull ImmutableConfig conf) {
            Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
            Intrinsics.checkNotNullParameter((Object)pageEntity, (String)"pageEntity");
            Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
            String format = conf.get("BUILDER", "all");
            ProductHtmlBuilder builder = new ProductHtmlBuilder(pageEntity, Format.Companion.of(format), conf);
            builder.build();
            CharSequence charSequence = doc.toString();
            Regex regex = new Regex("script");
            Object object = "script-rm";
            String content = regex.replace(charSequence, (String)object);
            Path path = AppPaths.INSTANCE.getREPORT_DIR().resolve("build").resolve(AppPaths.INSTANCE.fromUri(doc.getLocation(), "", ".original.htm"));
            object = path;
            Intrinsics.checkNotNull((Object)object);
            Path file = AppFiles.saveTo$default((AppFiles)AppFiles.INSTANCE, (String)content, (Path)object, (boolean)false, (int)4, null);
            path = AppPaths.INSTANCE.getREPORT_DIR().resolve("build").resolve(AppPaths.INSTANCE.fromUri(doc.getLocation(), "", ".htm"));
            String string = builder.toString();
            Path path2 = path;
            Intrinsics.checkNotNull((Object)path2);
            Path file2 = AppFiles.saveTo$default((AppFiles)AppFiles.INSTANCE, (String)string, (Path)path2, (boolean)false, (int)4, null);
            Pair pair = Pair.of((Object)file, (Object)file2);
            Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"of(...)");
            return pair;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u0000 \u000b2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u000bB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\f"}, d2={"Lai/platon/scent/view/builder/ProductHtmlBuilder$Format;", "", "_value", "", "(Ljava/lang/String;ILjava/lang/String;)V", "value", "getValue", "()Ljava/lang/String;", "Simplified", "Waterfall", "All", "Companion", "scent-build"})
    public static final class Format
    extends Enum<Format> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String value;
        public static final /* enum */ Format Simplified;
        public static final /* enum */ Format Waterfall;
        public static final /* enum */ Format All;
        private static final /* synthetic */ Format[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Format(String _value) {
            String string = _value;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            this.value = string2;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        public static Format[] values() {
            return (Format[])$VALUES.clone();
        }

        public static Format valueOf(String value) {
            return Enum.valueOf(Format.class, value);
        }

        @NotNull
        public static EnumEntries<Format> getEntries() {
            return $ENTRIES;
        }

        static {
            Simplified = new Format("simplified");
            Waterfall = new Format("waterfall");
            All = new Format("all");
            $VALUES = formatArray = new Format[]{Format.Simplified, Format.Waterfall, Format.All};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a8\u0006\u0007"}, d2={"Lai/platon/scent/view/builder/ProductHtmlBuilder$Format$Companion;", "", "()V", "of", "Lai/platon/scent/view/builder/ProductHtmlBuilder$Format;", "value", "", "scent-build"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Format of(@Nullable String value) {
                if (value == null) {
                    return All;
                }
                return StringsKt.equals((String)value, (String)"all", (boolean)true) ? All : (StringsKt.equals((String)value, (String)"waterfall", (boolean)true) ? Waterfall : Simplified);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

