/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.view.builder.ml;

import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.ResourceLoader;
import ai.platon.pulsar.dom.Documents;
import ai.platon.pulsar.dom.FeaturedDocument;
import ai.platon.scent.ml.ML;
import ai.platon.scent.ml.MLResultTable;
import ai.platon.scent.view.builder.ml.MLResultHTMLBuilder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Element;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u0014\u0010\u000e\u001a\u00020\u00142\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J\u0006\u0010\u0015\u001a\u00020\u000fJ\u0014\u0010\u0015\u001a\u00020\u000f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0012J\u0018\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\bH\u0002J\"\u0010\u001b\u001a\u00020\u000f2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\n\u0010\u001d\u001a\u00060\u001ej\u0002`\u001fH\u0002J\"\u0010 \u001a\u00020\u000f2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\n\u0010\u001d\u001a\u00060\u001ej\u0002`\u001fH\u0002J*\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\n2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\n\u0010\u0019\u001a\u00060\u001ej\u0002`\u001fH\u0002J \u0010#\u001a\u00020\u000f2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\n\u0010\u0019\u001a\u00060\u001ej\u0002`\u001fJD\u0010$\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020\u00032\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\n\u0010\u0019\u001a\u00060\u001ej\u0002`\u001f2\u0018\u0010&\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00010'H\u0002J\"\u0010$\u001a\u00020\u000f2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\n\u0010\u001d\u001a\u00060\u001ej\u0002`\u001fH\u0002J\"\u0010(\u001a\u00020\u000f2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\n\u0010\u001d\u001a\u00060\u001ej\u0002`\u001fH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lai/platon/scent/view/builder/ml/MLResultHTMLBuilder;", "", "type", "", "projectId", "mlResultTable", "Lai/platon/scent/ml/MLResultTable;", "outputBaseDir", "Ljava/nio/file/Path;", "columnsPerURL", "", "(Ljava/lang/String;Ljava/lang/String;Lai/platon/scent/ml/MLResultTable;Ljava/nio/file/Path;I)V", "logger", "Lorg/slf4j/Logger;", "build", "", "outputFile", "orderedColumns", "", "Lai/platon/scent/ml/ML$Column;", "Lai/platon/pulsar/dom/FeaturedDocument;", "buildAll", "strategies", "Lai/platon/scent/ml/ML$BuilderStrategy;", "exportTo", "htmlContent", "outputPath", "writeClassifierTableHeader", "columns", "htmlBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "writeClusteringTableHeader", "writeTable", "block", "writeTableBody", "writeTableHeader", "headerName", "attributesMapping", "Lkotlin/Function2;", "writeTableHeaderColumnID", "scent-build"})
@SourceDebugExtension(value={"SMAP\nMLResultHTMLBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MLResultHTMLBuilder.kt\nai/platon/scent/view/builder/ml/MLResultHTMLBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,234:1\n1549#2:235\n1620#2,3:236\n1855#2,2:239\n1864#2,3:241\n1477#2:244\n1502#2,3:245\n1505#2,3:255\n1549#2:258\n1620#2,3:259\n1855#2,2:262\n1864#2,3:264\n1864#2,2:267\n1866#2:270\n1549#2:271\n1620#2,3:272\n1054#2:275\n1855#2:276\n1549#2:277\n1620#2,2:278\n288#2,2:280\n1622#2:282\n1864#2,3:283\n1856#2:286\n372#3,7:248\n1#4:269\n*S KotlinDebug\n*F\n+ 1 MLResultHTMLBuilder.kt\nai/platon/scent/view/builder/ml/MLResultHTMLBuilder\n*L\n38#1:235\n38#1:236,3\n44#1:239,2\n72#1:241,3\n75#1:244\n75#1:245,3\n75#1:255,3\n77#1:258\n77#1:259,3\n77#1:262,2\n147#1:264,3\n170#1:267,2\n170#1:270\n192#1:271\n192#1:272,3\n193#1:275\n198#1:276\n207#1:277\n207#1:278,2\n207#1:280,2\n207#1:282\n208#1:283,3\n198#1:286\n75#1:248,7\n*E\n"})
public final class MLResultHTMLBuilder {
    @NotNull
    private final String type;
    @NotNull
    private final String projectId;
    @NotNull
    private final MLResultTable mlResultTable;
    @NotNull
    private final Path outputBaseDir;
    private final int columnsPerURL;
    @NotNull
    private final Logger logger;

    public MLResultHTMLBuilder(@NotNull String type, @NotNull String projectId, @NotNull MLResultTable mlResultTable, @NotNull Path outputBaseDir, int columnsPerURL) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        Intrinsics.checkNotNullParameter((Object)mlResultTable, (String)"mlResultTable");
        Intrinsics.checkNotNullParameter((Object)outputBaseDir, (String)"outputBaseDir");
        this.type = type;
        this.projectId = projectId;
        this.mlResultTable = mlResultTable;
        this.outputBaseDir = outputBaseDir;
        this.columnsPerURL = columnsPerURL;
        this.logger = LogsKt.getLogger((Object)this);
    }

    public /* synthetic */ MLResultHTMLBuilder(String string, String string2, MLResultTable mLResultTable, Path path, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x10) != 0) {
            n = 20;
        }
        this(string, string2, mLResultTable, path, n);
    }

    /*
     * WARNING - void declaration
     */
    public final void buildAll() {
        void $this$mapTo$iv$iv;
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)((Object)MLResultTable.Filter.PERFECT), (Object)"perfect"), TuplesKt.to((Object)((Object)MLResultTable.Filter.QUALIFIED), (Object)"qualified"), TuplesKt.to((Object)((Object)MLResultTable.Filter.QUALIFIED), (Object)""), TuplesKt.to((Object)((Object)MLResultTable.Filter.TOP2_SCREEN_QUALIFIED), (Object)"top2ScreenQualified"), TuplesKt.to((Object)((Object)MLResultTable.Filter.ALL), (Object)"all")};
        Iterable $this$map$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ML.BuilderStrategy((MLResultTable.Filter)((Object)it.getFirst()), (String)it.getSecond()));
        }
        List strategies = (List)destination$iv$iv;
        this.buildAll(strategies);
    }

    public final void buildAll(@NotNull List<ML.BuilderStrategy> strategies) {
        Intrinsics.checkNotNullParameter(strategies, (String)"strategies");
        Iterable $this$forEach$iv = strategies;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ML.BuilderStrategy builderStrategy = (ML.BuilderStrategy)element$iv;
            boolean bl = false;
            MLResultTable.Filter strategy = builderStrategy.component1();
            String ident = builderStrategy.component2();
            String fileName = StringsKt.replace$default((String)(this.projectId + "." + ident + ".html"), (String)"..", (String)".", (boolean)false, (int)4, null);
            Path outputFile = this.outputBaseDir.resolve(fileName);
            Files.deleteIfExists(outputFile);
            try {
                List columns = MLResultTable.filterColumnList$default(this.mlResultTable, strategy, 0, 2, null);
                Intrinsics.checkNotNull((Object)outputFile);
                this.build(outputFile, columns);
            }
            catch (Exception e) {
                this.logger.warn("Failed to build view with strategy " + strategy + " | {}", (Object)e.getMessage());
            }
        }
    }

    public final void build() {
        List columns = MLResultTable.filterColumnList$default(this.mlResultTable, MLResultTable.Filter.QUALIFIED, 0, 2, null);
        Path path = this.outputBaseDir.resolve(this.projectId + ".html");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        this.build(path, columns);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final FeaturedDocument build(@NotNull List<ML.Column> orderedColumns) {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        int n;
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter(orderedColumns, (String)"orderedColumns");
        StringBuilder htmlContent = new StringBuilder();
        String resource = "wwwroot/template/page.predicate.result.template.htm";
        FeaturedDocument document = Documents.INSTANCE.parse(ResourceLoader.INSTANCE.readString(resource));
        String title = this.type + " - predict result";
        document.getDocument().title(title);
        Element element = document.selectFirstOrNull(".container .title");
        if (element != null) {
            element.text(title);
        }
        int chunkSize = 100;
        Iterable $this$forEachIndexed$iv = orderedColumns;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            Iterator column2;
            int n2;
            if ((n2 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ML.Column column3 = (ML.Column)item$iv;
            int i = n2;
            boolean bl = false;
            ((ML.Column)((Object)column2)).setBlock(i / chunkSize);
        }
        Iterable $this$groupBy$iv = orderedColumns;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            ML.Column it = (ML.Column)element$iv$iv;
            n = 0;
            Integer key$iv$iv = it.getBlock();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map columnChunks = destination$iv$iv;
        List blocks = CollectionsKt.sorted((Iterable)columnChunks.keySet());
        Iterable $this$map$iv = blocks;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            n = ((Number)item$iv$iv).intValue();
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            Integer n3 = (int)it;
            Object v = columnChunks.get((int)it);
            Intrinsics.checkNotNull(v);
            collection.add(TuplesKt.to((Object)n3, v));
        }
        $this$map$iv = (List)destination$iv$iv2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            int block = ((Number)pair.component1()).intValue();
            List chunk = (List)pair.component2();
            this.writeTable(block, chunk, htmlContent);
        }
        String string = htmlContent.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String table = string;
        document.selectFirst(".container").append(table);
        return document;
    }

    private final void build(Path outputFile, List<ML.Column> orderedColumns) {
        FeaturedDocument document = this.build(orderedColumns);
        this.exportTo(document.getOuterHtml(), outputFile);
    }

    private final void writeTable(int block, List<ML.Column> columns, StringBuilder htmlContent) {
        StringBuilder stringBuilder = htmlContent.append("<div>" + OffsetDateTime.now() + "</div>");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder2 = htmlContent.append("<div>Fields on block " + block + "</div>");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder3 = htmlContent.append("<table class='table block-" + block + "'>");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder4 = htmlContent.append("<thead>");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
        this.writeTableHeader(columns, htmlContent);
        StringBuilder stringBuilder5 = htmlContent.append("</thead>");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder6 = htmlContent.append("<tbody>");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6.append('\n'), (String)"append(...)");
        this.writeTableBody(columns, htmlContent);
        StringBuilder stringBuilder7 = htmlContent.append("</tbody>");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder8 = htmlContent.append("</table>");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8.append('\n'), (String)"append(...)");
    }

    private final void writeTableHeader(List<ML.Column> columns, StringBuilder htmlBuilder) {
        String string = this.type;
        if (Intrinsics.areEqual((Object)string, (Object)"classifier")) {
            this.writeClassifierTableHeader(columns, htmlBuilder);
        } else if (Intrinsics.areEqual((Object)string, (Object)"clustering")) {
            this.writeClusteringTableHeader(columns, htmlBuilder);
        } else {
            this.writeClusteringTableHeader(columns, htmlBuilder);
        }
    }

    private final void writeClassifierTableHeader(List<ML.Column> columns, StringBuilder htmlBuilder) {
        this.writeTableHeader("Order", columns, htmlBuilder, (Function2<? super Integer, ? super ML.Column, ? extends Object>)((Function2)writeClassifierTableHeader.1.INSTANCE));
        this.writeTableHeader("Label", columns, htmlBuilder, (Function2<? super Integer, ? super ML.Column, ? extends Object>)((Function2)writeClassifierTableHeader.2.INSTANCE));
    }

    private final void writeClusteringTableHeader(List<ML.Column> columns, StringBuilder htmlBuilder) {
        this.writeTableHeaderColumnID(columns, htmlBuilder);
        this.writeTableHeader("Prediction", columns, htmlBuilder, (Function2<? super Integer, ? super ML.Column, ? extends Object>)((Function2)writeClusteringTableHeader.1.INSTANCE));
        this.writeTableHeader("TOP", columns, htmlBuilder, (Function2<? super Integer, ? super ML.Column, ? extends Object>)((Function2)writeClusteringTableHeader.2.INSTANCE));
        this.writeTableHeader("LEFT", columns, htmlBuilder, (Function2<? super Integer, ? super ML.Column, ? extends Object>)((Function2)writeClusteringTableHeader.3.INSTANCE));
    }

    private final void writeTableHeaderColumnID(List<ML.Column> columns, StringBuilder htmlBuilder) {
        StringBuilder stringBuilder = htmlBuilder.append("<tr>");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder2 = htmlBuilder.append("<th></th>");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
        Iterable $this$forEachIndexed$iv = columns;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ML.Column column2 = (ML.Column)item$iv;
            int j = n;
            boolean bl = false;
            if (j % this.columnsPerURL == 0) {
                StringBuilder stringBuilder3 = htmlBuilder.append("<th></th>");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
            }
            StringBuilder stringBuilder4 = htmlBuilder.append("<th>" + j + "</th>");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
        }
        StringBuilder stringBuilder5 = htmlBuilder.append("</tr>");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append(...)");
    }

    /*
     * WARNING - void declaration
     */
    private final void writeTableHeader(String headerName, List<ML.Column> columns, StringBuilder htmlContent, Function2<? super Integer, ? super ML.Column, ? extends Object> attributesMapping) {
        StringBuilder stringBuilder = htmlContent.append("<tr>");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder2 = htmlContent.append("<th>" + headerName + "</th>");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
        Iterable $this$forEachIndexed$iv = columns;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void column2;
            Object attributes;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ML.Column column3 = (ML.Column)item$iv;
            int j = n;
            boolean bl = false;
            if (j % this.columnsPerURL == 0) {
                StringBuilder stringBuilder3 = htmlContent.append("<th></th>");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
            }
            if ((attributes = attributesMapping.invoke((Object)j, (Object)column2)) instanceof Map) {
                String string;
                if (((Map)attributes).get("title") != null) {
                    Object it;
                    boolean bl2 = false;
                    string = "title='" + it + "'";
                } else {
                    string = null;
                }
                String title = string;
                Object textContent = ((Map)attributes).get("textContent");
                StringBuilder stringBuilder4 = htmlContent.append("<th " + title + ">" + textContent + "</th>");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
                continue;
            }
            StringBuilder stringBuilder5 = htmlContent.append("<th>" + attributes + "</th>");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append(...)");
        }
        StringBuilder stringBuilder6 = htmlContent.append("</tr>");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6.append('\n'), (String)"append(...)");
    }

    /*
     * WARNING - void declaration
     */
    public final void writeTableBody(@NotNull List<ML.Column> columns, @NotNull StringBuilder htmlContent) {
        void $this$sortedByDescending$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        Intrinsics.checkNotNullParameter((Object)htmlContent, (String)"htmlContent");
        int i = 0;
        Iterable iterable = this.mlResultTable.getUrlToRecords().entrySet();
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)((Map)it.getValue()).values().size(), it.getKey()));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$sortedByDescending = false;
        List orderedURLs = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)b;
                boolean bl = false;
                Comparable comparable = (Integer)it.getFirst();
                it = (Pair)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)it.getFirst()));
            }
        });
        Iterable $this$forEach$iv = orderedURLs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$mapTo$iv$iv2;
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            String url = (String)pair.component2();
            StringBuilder stringBuilder = htmlContent.append("<tr class='tr" + ++i + "'>");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
            String link = "<a href='" + url + "'>" + url + "</a>";
            StringBuilder stringBuilder2 = htmlContent.append("<td>" + i + "</td>");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
            Iterable $this$map$iv2 = columns;
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                Object v2;
                Collection collection;
                block9: {
                    void it;
                    ML.Column column2 = (ML.Column)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl2 = false;
                    Iterable $this$firstOrNull$iv = it.getCells();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv2 : $this$firstOrNull$iv) {
                        ML.Record it2 = (ML.Record)element$iv2;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it2.getUrl(), (Object)url)) continue;
                        v2 = element$iv2;
                        break block9;
                    }
                    v2 = null;
                }
                collection.add(v2);
            }
            List cells2 = (List)destination$iv$iv2;
            Iterable $this$forEachIndexed$iv = cells2;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                String string;
                String rectangle;
                void record;
                String string2;
                int n;
                Object item$iv$iv;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                item$iv$iv = (ML.Record)item$iv;
                int j = n;
                boolean bl4 = false;
                if (j % this.columnsPerURL == 0) {
                    StringBuilder stringBuilder3 = htmlContent.append("<td>" + link + "</td>");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
                }
                if ((string2 = record) == null || (string2 = ((ML.Record)((Object)string2)).getRectString()) == null) {
                    string2 = rectangle = "";
                }
                if ((string = record) == null || (string = ((ML.Record)((Object)string)).getText()) == null) {
                    string = "";
                }
                String text = string;
                CharSequence charSequence = text;
                Regex regex = new Regex("[\\x00-\\x1F]");
                String string3 = "";
                text = regex.replace(charSequence, string3);
                text = StringsKt.replace$default((String)StringsKt.replace$default((String)text, (String)"<", (String)"&lt;", (boolean)false, (int)4, null), (String)">", (String)"&gt;", (boolean)false, (int)4, null);
                StringBuilder stringBuilder4 = htmlContent.append("<td><span title='" + rectangle + "'>" + text + "</span></td>");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
            }
            StringBuilder stringBuilder5 = htmlContent.append("</tr>");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append(...)");
        }
    }

    private final void exportTo(String htmlContent, Path outputPath) {
        Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(outputPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            Files.createFile(outputPath, new FileAttribute[0]);
        }
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.APPEND};
        Files.writeString(outputPath, (CharSequence)htmlContent, Charsets.UTF_8, openOptionArray);
    }
}

