/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.view.builder.ml.base;

import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.serialize.json.JacksonKt;
import ai.platon.scent.common.Workbook2JSONConverter;
import ai.platon.scent.ml.MLResultTable;
import ai.platon.scent.view.builder.ml.MLResultHTMLBuilder;
import ai.platon.scent.view.builder.ml.MLResultXLSXBuilder;
import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\u001f\u001a\u00020\u00052\b\b\u0002\u0010 \u001a\u00020!H&J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0005H\u0016J\u0010\u0010%\u001a\u00020#2\u0006\u0010&\u001a\u00020\u0003H\u0016J\u0018\u0010'\u001a\u00020#2\u0006\u0010(\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u0005H\u0016J\u0018\u0010'\u001a\u00020#2\u0006\u0010)\u001a\u00020*2\u0006\u0010$\u001a\u00020\u0005H\u0016J\u0018\u0010+\u001a\u00020\u00052\u0006\u0010,\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\u0005H\u0016J\b\u0010-\u001a\u00020\u0005H\u0016J\b\u0010.\u001a\u00020\u0005H\u0002J\b\u0010/\u001a\u00020\u0005H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0017\"\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u00060"}, d2={"Lai/platon/scent/view/builder/ml/base/MLResultViewsBuilder;", "", "projectId", "", "inputBaseDir", "Ljava/nio/file/Path;", "outputBaseDir", "columnsPerURL", "", "(Ljava/lang/String;Ljava/nio/file/Path;Ljava/nio/file/Path;I)V", "getColumnsPerURL", "()I", "fieldListTable", "Lai/platon/scent/ml/MLResultTable;", "getFieldListTable", "()Lai/platon/scent/ml/MLResultTable;", "filterStrategy", "Lai/platon/scent/ml/MLResultTable$Filter;", "getFilterStrategy", "()Lai/platon/scent/ml/MLResultTable$Filter;", "setFilterStrategy", "(Lai/platon/scent/ml/MLResultTable$Filter;)V", "getInputBaseDir", "()Ljava/nio/file/Path;", "logger", "Lorg/slf4j/Logger;", "getOutputBaseDir", "setOutputBaseDir", "(Ljava/nio/file/Path;)V", "getProjectId", "()Ljava/lang/String;", "build", "rebuild", "", "buildFieldListJSONView", "", "outputFile", "buildHTMLViews", "type", "buildJSONView", "workbookFile", "workbook", "Lorg/apache/poi/xssf/usermodel/XSSFWorkbook;", "buildXLSXView", "filter", "buildXLSXViews", "createViewBaseDir", "getViewBaseDir", "scent-build"})
public abstract class MLResultViewsBuilder {
    @NotNull
    private final String projectId;
    @NotNull
    private final Path inputBaseDir;
    @Nullable
    private Path outputBaseDir;
    private final int columnsPerURL;
    @NotNull
    private final Logger logger;
    @NotNull
    private MLResultTable.Filter filterStrategy;

    public MLResultViewsBuilder(@NotNull String projectId, @NotNull Path inputBaseDir, @Nullable Path outputBaseDir, int columnsPerURL) {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        Intrinsics.checkNotNullParameter((Object)inputBaseDir, (String)"inputBaseDir");
        this.projectId = projectId;
        this.inputBaseDir = inputBaseDir;
        this.outputBaseDir = outputBaseDir;
        this.columnsPerURL = columnsPerURL;
        this.logger = LogsKt.getLogger((Object)this);
        this.filterStrategy = MLResultTable.Filter.QUALIFIED;
    }

    public /* synthetic */ MLResultViewsBuilder(String string, Path path, Path path2, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            path2 = null;
        }
        if ((n2 & 8) != 0) {
            n = 20;
        }
        this(string, path, path2, n);
    }

    @NotNull
    public final String getProjectId() {
        return this.projectId;
    }

    @NotNull
    public final Path getInputBaseDir() {
        return this.inputBaseDir;
    }

    @Nullable
    public final Path getOutputBaseDir() {
        return this.outputBaseDir;
    }

    public final void setOutputBaseDir(@Nullable Path path) {
        this.outputBaseDir = path;
    }

    public final int getColumnsPerURL() {
        return this.columnsPerURL;
    }

    @NotNull
    public abstract MLResultTable getFieldListTable();

    @NotNull
    public final MLResultTable.Filter getFilterStrategy() {
        return this.filterStrategy;
    }

    public final void setFilterStrategy(@NotNull MLResultTable.Filter filter) {
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"<set-?>");
        this.filterStrategy = filter;
    }

    private final Path createViewBaseDir() throws FileNotFoundException {
        if (!Files.exists(this.inputBaseDir, new LinkOption[0])) {
            throw new FileNotFoundException("Input base directory does not exist");
        }
        Path path = this.inputBaseDir.resolveSibling(this.inputBaseDir.getFileName() + ".views");
        Intrinsics.checkNotNull((Object)path);
        return path;
    }

    @NotNull
    public abstract Path build(boolean var1);

    public static /* synthetic */ Path build$default(MLResultViewsBuilder mLResultViewsBuilder, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: build");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        return mLResultViewsBuilder.build(bl);
    }

    @NotNull
    public Path getViewBaseDir() throws IllegalArgumentException {
        Path realOutputPath;
        if (this.outputBaseDir != null) {
            Path path = this.outputBaseDir;
            Intrinsics.checkNotNull((Object)path);
            return path;
        }
        this.outputBaseDir = realOutputPath = this.createViewBaseDir();
        return realOutputPath;
    }

    public void buildHTMLViews(@NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Path outputBaseDir = this.getViewBaseDir();
        MLResultHTMLBuilder builder = new MLResultHTMLBuilder(type, this.projectId, this.getFieldListTable(), outputBaseDir, this.columnsPerURL);
        builder.buildAll();
    }

    public void buildFieldListJSONView(@NotNull Path outputFile) {
        Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
        List columns = MLResultTable.filterColumnList$default(this.getFieldListTable(), this.filterStrategy, 0, 2, null);
        String json = JacksonKt.prettyPulsarObjectMapper().writeValueAsString((Object)columns);
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE};
        Files.writeString(outputFile, (CharSequence)json, Charsets.UTF_8, openOptionArray);
    }

    public void buildJSONView(@NotNull Path workbookFile, @NotNull Path outputFile) {
        Intrinsics.checkNotNullParameter((Object)workbookFile, (String)"workbookFile");
        Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
        new Workbook2JSONConverter().convert(workbookFile, outputFile);
    }

    public void buildJSONView(@NotNull XSSFWorkbook workbook, @NotNull Path outputFile) {
        Intrinsics.checkNotNullParameter((Object)workbook, (String)"workbook");
        Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
        String json = new Workbook2JSONConverter().convert(workbook);
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE};
        Files.writeString(outputFile, (CharSequence)json, Charsets.UTF_8, openOptionArray);
    }

    @NotNull
    public Path buildXLSXViews() {
        Path baseDir = this.getViewBaseDir();
        MLResultXLSXBuilder builder = new MLResultXLSXBuilder("", this.projectId, this.getFieldListTable(), baseDir, this.columnsPerURL);
        builder.buildAll();
        return baseDir;
    }

    @NotNull
    public Path buildXLSXView(@NotNull MLResultTable.Filter filter, @NotNull Path outputFile) {
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
        MLResultTable mLResultTable = this.getFieldListTable();
        Path path = outputFile.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getParent(...)");
        MLResultXLSXBuilder builder = new MLResultXLSXBuilder("clustering", this.projectId, mLResultTable, path, this.columnsPerURL);
        builder.build(outputFile, MLResultTable.filterColumnList$default(this.getFieldListTable(), filter, 0, 2, null));
        return outputFile;
    }
}

