/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.view.builder.ml.classifier;

import ai.platon.pulsar.common.HtmlUtils;
import ai.platon.pulsar.common.LogsKt;
import ai.platon.scent.ml.MLResultFieldListTable;
import ai.platon.scent.ml.classifier.ClassifierProject;
import ai.platon.scent.ml.classifier.ClassifierResultFieldListLoader;
import ai.platon.scent.view.builder.ml.base.MLResultViewsBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\"H\u0002J\u0016\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020 J\u0010\u0010%\u001a\u00020\u00052\b\b\u0002\u0010\u001f\u001a\u00020 R!\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\r\u001a\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0013\u001a\u00020\u00148VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\r\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006&"}, d2={"Lai/platon/scent/view/builder/ml/classifier/ClassifierResultViewsBuilder;", "Lai/platon/scent/view/builder/ml/base/MLResultViewsBuilder;", "projectId", "", "inputBaseDir", "Ljava/nio/file/Path;", "outputBaseDir", "(Ljava/lang/String;Ljava/nio/file/Path;Ljava/nio/file/Path;)V", "csvPaths", "", "getCsvPaths", "()Ljava/util/List;", "csvPaths$delegate", "Lkotlin/Lazy;", "fieldListLoader", "Lai/platon/scent/ml/classifier/ClassifierResultFieldListLoader;", "getFieldListLoader", "()Lai/platon/scent/ml/classifier/ClassifierResultFieldListLoader;", "fieldListLoader$delegate", "fieldListTable", "Lai/platon/scent/ml/MLResultFieldListTable;", "getFieldListTable", "()Lai/platon/scent/ml/MLResultFieldListTable;", "fieldListTable$delegate", "logger", "Lorg/slf4j/Logger;", "project", "Lai/platon/scent/ml/classifier/ClassifierProject;", "getProject", "()Lai/platon/scent/ml/classifier/ClassifierProject;", "build", "rebuild", "", "createBuildInfo", "", "shouldBuild", "viewBaseDir", "tryBuild", "scent-build"})
public final class ClassifierResultViewsBuilder
extends MLResultViewsBuilder {
    @NotNull
    private final Logger logger;
    @NotNull
    private final Lazy csvPaths$delegate;
    @NotNull
    private final Lazy fieldListLoader$delegate;
    @NotNull
    private final Lazy fieldListTable$delegate;
    @NotNull
    private final ClassifierProject project;

    public ClassifierResultViewsBuilder(@NotNull String projectId, @NotNull Path inputBaseDir, @Nullable Path outputBaseDir) {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        Intrinsics.checkNotNullParameter((Object)inputBaseDir, (String)"inputBaseDir");
        super(projectId, inputBaseDir, outputBaseDir, 0, 8, null);
        this.logger = LogsKt.getLogger((Object)this);
        this.csvPaths$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends Path>>(inputBaseDir){
            final /* synthetic */ Path $inputBaseDir;
            {
                this.$inputBaseDir = $inputBaseDir;
                super(0);
            }

            @NotNull
            public final List<Path> invoke() {
                return CollectionsKt.toList((Iterable)PathsKt.listDirectoryEntries((Path)this.$inputBaseDir, (String)"*.csv"));
            }
        }));
        this.fieldListLoader$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ClassifierResultFieldListLoader>(this){
            final /* synthetic */ ClassifierResultViewsBuilder this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ClassifierResultFieldListLoader invoke() {
                return new ClassifierResultFieldListLoader(ClassifierResultViewsBuilder.access$getCsvPaths(this.this$0));
            }
        }));
        this.fieldListTable$delegate = LazyKt.lazy((Function0)((Function0)new Function0<MLResultFieldListTable>(this){
            final /* synthetic */ ClassifierResultViewsBuilder this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final MLResultFieldListTable invoke() {
                return ClassifierResultViewsBuilder.access$getFieldListLoader(this.this$0).load();
            }
        }));
        this.project = new ClassifierProject(projectId);
    }

    public /* synthetic */ ClassifierResultViewsBuilder(String string, Path path, Path path2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            path2 = null;
        }
        this(string, path, path2);
    }

    private final List<Path> getCsvPaths() {
        Lazy lazy = this.csvPaths$delegate;
        return (List)lazy.getValue();
    }

    private final ClassifierResultFieldListLoader getFieldListLoader() {
        Lazy lazy = this.fieldListLoader$delegate;
        return (ClassifierResultFieldListLoader)lazy.getValue();
    }

    @Override
    @NotNull
    public MLResultFieldListTable getFieldListTable() {
        Lazy lazy = this.fieldListTable$delegate;
        return (MLResultFieldListTable)lazy.getValue();
    }

    @NotNull
    public final ClassifierProject getProject() {
        return this.project;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean shouldBuild(@NotNull Path viewBaseDir, boolean rebuild) {
        Intrinsics.checkNotNullParameter((Object)viewBaseDir, (String)"viewBaseDir");
        if (!Files.exists(this.project.getPredictInfoFile(), new LinkOption[0])) {
            return false;
        }
        if (!rebuild) {
            Path path = this.project.getViewBuilderInfoFile();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"<get-viewBuilderInfoFile>(...)");
            Path path2 = path;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.notExists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                if (!Files.notExists(viewBaseDir, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                    if (!this.project.hasNewerClassifierResult()) return false;
                }
            }
        }
        boolean bl = true;
        boolean build2 = bl;
        if (!build2) return build2;
        Files.deleteIfExists(this.project.getViewBuilderInfoFile());
        FileUtils.deleteDirectory((File)viewBaseDir.toFile());
        return build2;
    }

    @NotNull
    public final Path tryBuild(boolean rebuild) throws IOException {
        Path viewBaseDir = this.getViewBaseDir();
        if (this.shouldBuild(viewBaseDir, rebuild)) {
            this.build(rebuild);
        }
        return viewBaseDir;
    }

    public static /* synthetic */ Path tryBuild$default(ClassifierResultViewsBuilder classifierResultViewsBuilder, boolean bl, int n, Object object) throws IOException {
        if ((n & 1) != 0) {
            bl = false;
        }
        return classifierResultViewsBuilder.tryBuild(bl);
    }

    @Override
    @NotNull
    public Path build(boolean rebuild) throws IOException {
        Path viewBaseDir = this.getViewBaseDir();
        this.logger.info("Building views for classifier result | {} | {}", (Object)this.getProjectId(), (Object)viewBaseDir);
        this.createBuildInfo();
        Files.createDirectories(viewBaseDir, new FileAttribute[0]);
        Object[] objectArray = new String[]{"Price RMB", "Price USD", "Seller Rating", "Product Name"};
        CollectionsKt.toCollection((Iterable)SetsKt.setOf((Object[])objectArray), (Collection)this.getFieldListTable().getImportantFields());
        this.buildHTMLViews("classifier");
        Path path = viewBaseDir.resolve(this.getProjectId() + ".fields.json");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        this.buildFieldListJSONView(path);
        this.buildXLSXViews();
        Path xlsxPath = viewBaseDir.resolve(this.getProjectId() + ".xlsx");
        Intrinsics.checkNotNull((Object)xlsxPath);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(xlsxPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            Path path2 = xlsxPath.resolveSibling(this.getProjectId() + ".json");
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolveSibling(...)");
            this.buildJSONView(xlsxPath, path2);
        }
        HtmlUtils.INSTANCE.createIndexFile(viewBaseDir);
        return viewBaseDir;
    }

    private final void createBuildInfo() {
        OffsetDateTime now = OffsetDateTime.now();
        String info2 = StringsKt.trimIndent((String)("\n            Build time: " + now + "\n            \n        "));
        Files.writeString(this.project.getViewBuilderInfoFile(), (CharSequence)info2, new OpenOption[0]);
    }

    public static final /* synthetic */ List access$getCsvPaths(ClassifierResultViewsBuilder $this) {
        return $this.getCsvPaths();
    }

    public static final /* synthetic */ ClassifierResultFieldListLoader access$getFieldListLoader(ClassifierResultViewsBuilder $this) {
        return $this.getFieldListLoader();
    }
}

