/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.view.builder.ml.clustering;

import ai.platon.pulsar.common.HtmlUtils;
import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.ResourceLoader;
import ai.platon.pulsar.common.serialize.json.JacksonKt;
import ai.platon.scent.ml.ContextualColumnsBuilder;
import ai.platon.scent.ml.ML;
import ai.platon.scent.ml.MLResultTable;
import ai.platon.scent.ml.clustering.ClusteringProject;
import ai.platon.scent.ml.clustering.PromptFile;
import ai.platon.scent.ml.clustering.io.ClusteringResultFieldListLoader;
import ai.platon.scent.view.builder.ml.MLResultHTMLBuilder;
import ai.platon.scent.view.builder.ml.base.MLResultViewsBuilder;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 82\u00020\u0001:\u00018B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\"H\u0016J\u000e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0005J \u0010&\u001a\u00020$2\u0006\u0010'\u001a\u00020\b2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0005H\u0002J\u0016\u0010+\u001a\u00020$2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010*\u001a\u00020\u0005J\u0006\u0010,\u001a\u00020$J\u000e\u0010-\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0005J\u000e\u0010.\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0005J\u0016\u0010/\u001a\u00020$2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010*\u001a\u00020\u0005J\b\u00100\u001a\u00020$H\u0002J\u0006\u00101\u001a\u00020\u0005J\u0010\u00102\u001a\u00020\u00132\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J \u00103\u001a\u00020\"2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u00104\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\"H\u0002J \u00105\u001a\u00020$2\u0006\u00106\u001a\u0002072\u0006\u0010'\u001a\u00020\b2\u0006\u0010(\u001a\u00020)H\u0002R\u001b\u0010\n\u001a\u00020\u00038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\u000f\u001a\u00020\u00038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u000e\u001a\u0004\b\u0010\u0010\fR\u001b\u0010\u0012\u001a\u00020\u00138VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u000e\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u00069"}, d2={"Lai/platon/scent/view/builder/ml/clustering/ClusteringResultViewsBuilder;", "Lai/platon/scent/view/builder/ml/base/MLResultViewsBuilder;", "projectId", "", "inputBaseDir", "Ljava/nio/file/Path;", "outputBaseDir", "columnsPerURL", "", "(Ljava/lang/String;Ljava/nio/file/Path;Ljava/nio/file/Path;I)V", "additionalGuide", "getAdditionalGuide", "()Ljava/lang/String;", "additionalGuide$delegate", "Lkotlin/Lazy;", "dataExpertPrompt", "getDataExpertPrompt", "dataExpertPrompt$delegate", "fieldListTable", "Lai/platon/scent/ml/MLResultTable;", "getFieldListTable", "()Lai/platon/scent/ml/MLResultTable;", "fieldListTable$delegate", "logger", "Lorg/slf4j/Logger;", "project", "Lai/platon/scent/ml/clustering/ClusteringProject;", "promptMaxSamples", "getPromptMaxSamples", "()I", "setPromptMaxSamples", "(I)V", "build", "rebuild", "", "buildColumnDescriptions", "", "outputFile", "buildColumnPromptView", "j", "column", "Lai/platon/scent/ml/ML$ContextualColumnDescription;", "baseDir", "buildEachColumnPromptView", "buildHTMLViews", "buildJSONView", "buildPromptView", "buildRevisedEachColumnPromptView", "createBuildInfo", "createOutputBaseDir", "loadFieldListTable", "shouldBuild", "viewBaseDir", "writePromptForColumn", "printer", "Ljava/io/BufferedWriter;", "Companion", "scent-build"})
@SourceDebugExtension(value={"SMAP\nClusteringResultViewsBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClusteringResultViewsBuilder.kt\nai/platon/scent/view/builder/ml/clustering/ClusteringResultViewsBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Lang.kt\nai/platon/scent/common/LangKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,376:1\n1864#2,3:377\n1864#2,3:380\n1864#2,2:383\n1866#2:390\n1855#2,2:396\n1549#2:398\n1620#2,3:399\n13#3,4:385\n13#3,4:391\n1#4:389\n1#4:395\n*S KotlinDebug\n*F\n+ 1 ClusteringResultViewsBuilder.kt\nai/platon/scent/view/builder/ml/clustering/ClusteringResultViewsBuilder\n*L\n239#1:377,3\n261#1:380,3\n282#1:383,2\n282#1:390\n341#1:396,2\n357#1:398\n357#1:399,3\n283#1:385,4\n301#1:391,4\n283#1:389\n301#1:395\n*E\n"})
public final class ClusteringResultViewsBuilder
extends MLResultViewsBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    @NotNull
    private final ClusteringProject project;
    @NotNull
    private final Lazy dataExpertPrompt$delegate;
    @NotNull
    private final Lazy additionalGuide$delegate;
    @NotNull
    private final Lazy fieldListTable$delegate;
    private int promptMaxSamples;
    public static final int PROMPT_MAX_SAMPLES = 30;
    @NotNull
    public static final String META_DATA_PLACEHOLDER = "{\"screen\":0,\"left\":0,\"top\":0,\"width\":0,\"height\":0,\"projectID\":\"p0\",\"prediction\":0}";
    @NotNull
    public static final String PROMPT_SYSTEM_MESSAGE_FILE = "prompts/data-expert/system.message.md";
    @NotNull
    public static final String ADDITIONAL_GUIDE_FILE = "prompts/data-expert/additional.guide.txt";

    public ClusteringResultViewsBuilder(@NotNull String projectId, @NotNull Path inputBaseDir, @Nullable Path outputBaseDir, int columnsPerURL) {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        Intrinsics.checkNotNullParameter((Object)inputBaseDir, (String)"inputBaseDir");
        super(projectId, inputBaseDir, outputBaseDir, columnsPerURL);
        this.logger = LogsKt.getLogger((Object)this);
        this.project = new ClusteringProject(projectId);
        this.dataExpertPrompt$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ ClusteringResultViewsBuilder this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                Path path;
                Path it = path = ClusteringResultViewsBuilder.access$getProject$p(this.this$0).getPromptTemplateFile();
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                Object object = Files.isReadable(it) ? path : null;
                if (object == null || (object = PathsKt.readText$default((Path)object, null, (int)1, null)) == null) {
                    object = ResourceLoader.INSTANCE.readString("prompts/data-expert/system.message.md");
                }
                return object;
            }
        }));
        this.additionalGuide$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ ClusteringResultViewsBuilder this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                Path path;
                Path it = path = ClusteringResultViewsBuilder.access$getProject$p(this.this$0).getPromptAdditionalGuideFile();
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                Object object = Files.isReadable(it) ? path : null;
                if (object == null || (object = PathsKt.readText$default((Path)object, null, (int)1, null)) == null) {
                    object = ResourceLoader.INSTANCE.readString("prompts/data-expert/additional.guide.txt");
                }
                return object;
            }
        }));
        this.fieldListTable$delegate = LazyKt.lazy((Function0)((Function0)new Function0<MLResultTable>(this, inputBaseDir){
            final /* synthetic */ ClusteringResultViewsBuilder this$0;
            final /* synthetic */ Path $inputBaseDir;
            {
                this.this$0 = $receiver;
                this.$inputBaseDir = $inputBaseDir;
                super(0);
            }

            @NotNull
            public final MLResultTable invoke() {
                return ClusteringResultViewsBuilder.access$loadFieldListTable(this.this$0, this.$inputBaseDir);
            }
        }));
        this.promptMaxSamples = 30;
    }

    public /* synthetic */ ClusteringResultViewsBuilder(String string, Path path, Path path2, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            path2 = null;
        }
        if ((n2 & 8) != 0) {
            n = 20;
        }
        this(string, path, path2, n);
    }

    private final String getDataExpertPrompt() {
        Lazy lazy = this.dataExpertPrompt$delegate;
        return (String)lazy.getValue();
    }

    private final String getAdditionalGuide() {
        Lazy lazy = this.additionalGuide$delegate;
        return (String)lazy.getValue();
    }

    @Override
    @NotNull
    public MLResultTable getFieldListTable() {
        Lazy lazy = this.fieldListTable$delegate;
        return (MLResultTable)lazy.getValue();
    }

    public final int getPromptMaxSamples() {
        return this.promptMaxSamples;
    }

    public final void setPromptMaxSamples(int n) {
        this.promptMaxSamples = n;
    }

    @NotNull
    public final Path createOutputBaseDir() throws FileNotFoundException {
        if (!Files.exists(this.getInputBaseDir(), new LinkOption[0])) {
            throw new FileNotFoundException("Input base directory does not exist");
        }
        Path path = this.getInputBaseDir().resolve("predictionAndOriginalFeatures.views");
        Files.createDirectories(path, new FileAttribute[0]);
        Intrinsics.checkNotNull((Object)path);
        return path;
    }

    @Override
    @NotNull
    public Path build(boolean rebuild) {
        Path viewBaseDir = this.getViewBaseDir();
        if (!this.shouldBuild(this.getInputBaseDir(), viewBaseDir, rebuild)) {
            return viewBaseDir;
        }
        this.createBuildInfo();
        Files.createDirectories(viewBaseDir, new FileAttribute[0]);
        try {
            this.buildHTMLViews();
            Path path = viewBaseDir.resolve(this.getProjectId() + ".json");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            this.buildJSONView(path);
            Path path2 = viewBaseDir.resolve(this.getProjectId() + ".columns.json");
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
            this.buildColumnDescriptions(path2);
            this.buildXLSXViews();
            Path path3 = viewBaseDir.resolve(this.getProjectId() + ".txt");
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
            this.buildPromptView(path3);
            String string = this.getProjectId();
            Path path4 = this.project.getPromptViewBaseDir();
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"<get-promptViewBaseDir>(...)");
            this.buildEachColumnPromptView(string, path4);
        }
        catch (Exception e) {
            this.logger.error("Failed to build views for " + this.getProjectId(), (Throwable)e);
        }
        HtmlUtils.INSTANCE.createIndexFile(viewBaseDir);
        return viewBaseDir;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldBuild(Path inputBaseDir, Path viewBaseDir, boolean rebuild) {
        if (!Files.exists(this.project.getClusteringInfoFile(), new LinkOption[0])) {
            return false;
        }
        if (!rebuild) {
            Path path = this.project.getViewBuilderInfoFile();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"<get-viewBuilderInfoFile>(...)");
            Path path2 = path;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.notExists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                if (!Files.notExists(viewBaseDir, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) return false;
            }
        }
        boolean bl = true;
        boolean build2 = bl;
        if (!build2) return build2;
        Files.deleteIfExists(this.project.getViewBuilderInfoFile());
        FileUtils.deleteDirectory((File)viewBaseDir.toFile());
        return build2;
    }

    private final void createBuildInfo() {
        OffsetDateTime now = OffsetDateTime.now();
        String info2 = StringsKt.trimIndent((String)("\n            Build time: " + now + "\n            \n        "));
        Files.writeString(this.project.getViewBuilderInfoFile(), (CharSequence)info2, new OpenOption[0]);
    }

    public final void buildHTMLViews() {
        MLResultHTMLBuilder builder = new MLResultHTMLBuilder("clustering", this.getProjectId(), this.getFieldListTable(), this.getViewBaseDir(), this.getColumnsPerURL());
        builder.buildAll();
    }

    public final void buildJSONView(@NotNull Path outputFile) {
        Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
        List columns = MLResultTable.filterColumnList$default(this.getFieldListTable(), this.getFilterStrategy(), 0, 2, null);
        String json = JacksonKt.prettyPulsarObjectMapper().writeValueAsString((Object)columns);
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE};
        Files.writeString(outputFile, (CharSequence)json, Charsets.UTF_8, openOptionArray);
    }

    /*
     * WARNING - void declaration
     */
    public final void buildPromptView(@NotNull Path outputFile) {
        Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
        BufferedWriter printer = Files.newBufferedWriter(outputFile, Charsets.UTF_8, new OpenOption[0]);
        MLResultTable.Filter filter = MLResultTable.Filter.QUALIFIED;
        List columns = SequencesKt.toList(this.getFieldListTable().filterColumnSequence(filter));
        List contextualColumns = MLResultTable.Companion.createContextualColumns$default(MLResultTable.Companion, columns, this.promptMaxSamples, 0, 4, null);
        Iterable $this$forEachIndexed$iv = contextualColumns;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void column2;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ML.ContextualColumnDescription contextualColumnDescription = (ML.ContextualColumnDescription)item$iv;
            int j = n;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)printer);
            this.writePromptForColumn(printer, j, (ML.ContextualColumnDescription)column2);
            printer.newLine();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void buildEachColumnPromptView(@NotNull String projectId, @NotNull Path baseDir) {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
        if (((CharSequence)this.getDataExpertPrompt()).length() == 0) {
            this.logger.warn("No data expert prompt found");
        }
        List columns = SequencesKt.toList(this.getFieldListTable().filterColumnSequence(this.getFilterStrategy()));
        List contextualColumns = MLResultTable.Companion.createContextualColumns$default(MLResultTable.Companion, columns, this.promptMaxSamples, 0, 4, null);
        Iterable $this$forEachIndexed$iv = contextualColumns;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void column2;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ML.ContextualColumnDescription contextualColumnDescription = (ML.ContextualColumnDescription)item$iv;
            int j = n;
            boolean bl = false;
            this.buildColumnPromptView(j, (ML.ContextualColumnDescription)column2, baseDir);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void buildRevisedEachColumnPromptView(@NotNull String projectId, @NotNull Path baseDir) {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
        Path xlsxFile = this.project.getRevisedXlsxViewPath();
        Intrinsics.checkNotNull((Object)xlsxFile);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(xlsxFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            this.logger.warn("Revised XLSX file not found: {}", (Object)xlsxFile);
            return;
        }
        if (Files.exists(baseDir, new LinkOption[0])) {
            this.logger.warn("Revised prompt directory already exists: {}", (Object)baseDir);
            return;
        }
        List<ML.Column> columns = this.getFieldListTable().filterColumnList(this.getFilterStrategy(), this.promptMaxSamples);
        ContextualColumnsBuilder builder = new ContextualColumnsBuilder(columns, 0, 0, xlsxFile, 6, null);
        Iterable $this$forEachIndexed$iv = builder.build();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            Throwable it$iv;
            Object object;
            void column2;
            boolean bl;
            ClusteringResultViewsBuilder $this$buildRevisedEachColumnPromptView_u24lambda_u243_u24lambda_u242;
            Object object2;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ML.ContextualColumnDescription contextualColumnDescription = (ML.ContextualColumnDescription)item$iv;
            int j = n;
            boolean bl2 = false;
            ClusteringResultViewsBuilder $this$runCatchingWarnUnexpected$iv = this;
            boolean $i$f$runCatchingWarnUnexpected = false;
            if ($this$runCatchingWarnUnexpected$iv == null) {
                object2 = $this$runCatchingWarnUnexpected$iv;
                try {
                    $this$buildRevisedEachColumnPromptView_u24lambda_u243_u24lambda_u242 = object2;
                    bl = false;
                    $this$buildRevisedEachColumnPromptView_u24lambda_u243_u24lambda_u242.buildColumnPromptView(j, (ML.ContextualColumnDescription)column2, baseDir);
                    object = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                continue;
            }
            object2 = $this$runCatchingWarnUnexpected$iv;
            try {
                $this$buildRevisedEachColumnPromptView_u24lambda_u243_u24lambda_u242 = object2;
                bl = false;
                $this$buildRevisedEachColumnPromptView_u24lambda_u243_u24lambda_u242.buildColumnPromptView(j, (ML.ContextualColumnDescription)column2, baseDir);
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            object2 = object;
            if (Result.exceptionOrNull-impl((Object)object2) == null) continue;
            boolean bl3 = false;
            LogsKt.warnUnexpected((Object)$this$runCatchingWarnUnexpected$iv, (Throwable)it$iv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void buildColumnPromptView(int j, ML.ContextualColumnDescription column2, Path baseDir) {
        String label = column2.isPriceLike() ? "remarkable" : "";
        PromptFile promptFile = new PromptFile(this.getProjectId(), column2.getPrediction(), label, null, 8, null);
        String fileName = promptFile.getFileName();
        if (column2.isPriceLike()) {
            // empty if block
        }
        Path path = baseDir.resolve(fileName);
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        Files.deleteIfExists(path);
        Object object = new OpenOption[]{StandardOpenOption.CREATE};
        object = Files.newBufferedWriter(path, Charsets.UTF_8, object);
        Throwable throwable = null;
        try {
            Object object2;
            BufferedWriter printer = (BufferedWriter)object;
            boolean bl = false;
            ClusteringResultViewsBuilder $this$runCatchingWarnUnexpected$iv = this;
            boolean $i$f$runCatchingWarnUnexpected = false;
            if ($this$runCatchingWarnUnexpected$iv == null) {
                Object object3;
                ClusteringResultViewsBuilder clusteringResultViewsBuilder = $this$runCatchingWarnUnexpected$iv;
                try {
                    ClusteringResultViewsBuilder $this$buildColumnPromptView_u24lambda_u245_u24lambda_u244 = clusteringResultViewsBuilder;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)printer);
                    $this$buildColumnPromptView_u24lambda_u245_u24lambda_u244.writePromptForColumn(printer, j, column2);
                    object3 = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable throwable2) {
                    object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
                }
                object2 = object3;
            } else {
                Object object4;
                Object object5 = $this$runCatchingWarnUnexpected$iv;
                try {
                    ClusteringResultViewsBuilder $this$buildColumnPromptView_u24lambda_u245_u24lambda_u244 = object5;
                    boolean bl3 = false;
                    Intrinsics.checkNotNull((Object)printer);
                    $this$buildColumnPromptView_u24lambda_u245_u24lambda_u244.writePromptForColumn(printer, j, column2);
                    object4 = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable throwable3) {
                    object4 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable3));
                }
                object5 = object4;
                Throwable throwable4 = Result.exceptionOrNull-impl((Object)object5);
                if (throwable4 != null) {
                    Throwable it$iv = throwable4;
                    boolean bl4 = false;
                    LogsKt.warnUnexpected((Object)$this$runCatchingWarnUnexpected$iv, (Throwable)it$iv);
                }
                object2 = object5;
            }
            Object object6 = object2;
        }
        catch (Throwable throwable5) {
            throwable = throwable5;
            throw throwable5;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    private final void writePromptForColumn(BufferedWriter printer, int j, ML.ContextualColumnDescription column2) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"screen", (Object)column2.getScreen()), TuplesKt.to((Object)"left", (Object)column2.getLeft()), TuplesKt.to((Object)"top", (Object)column2.getTop()), TuplesKt.to((Object)"width", (Object)column2.getWidth()), TuplesKt.to((Object)"height", (Object)column2.getHeight()), TuplesKt.to((Object)"projectID", (Object)this.getProjectId()), TuplesKt.to((Object)"prediction", (Object)column2.getPrediction())};
        Map metadata = MapsKt.mapOf((Pair[])pairArray);
        String metadataString = JacksonKt.pulsarObjectMapper().writeValueAsString((Object)metadata);
        String systemMessage = this.getDataExpertPrompt();
        printer.write(systemMessage);
        if (!StringsKt.isBlank((CharSequence)this.getAdditionalGuide())) {
            printer.write("\n\nADDITIONAL GUIDE BEGIN\n");
            printer.write(this.getAdditionalGuide());
            printer.write("\nADDITIONAL GUIDE END\n");
        }
        printer.write("\n\nMETADATA BEGIN\n");
        printer.write(metadataString);
        printer.write("\nMETADATA END\n");
        printer.write("\nDATA BEGIN\n");
        int maxSamples = RangesKt.coerceAtMost((int)column2.getCells().size(), (int)30);
        String SPACE = " ";
        Iterable $this$forEach$iv = (Iterable)new IntRange(0, maxSamples - 1);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            CharSequence charSequence;
            CharSequence charSequence2;
            int element$iv;
            int k = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            String string = column2.getCells().get(k);
            String text = string != null && (string = new Regex("\\s+").replace(charSequence2 = (CharSequence)string, SPACE)) != null ? ((Object)StringsKt.trim((CharSequence)string)).toString() : null;
            String string2 = column2.getCellContexts().get(k);
            String context = string2 != null && (string2 = new Regex("\\s+").replace(charSequence = (CharSequence)string2, SPACE)) != null ? ((Object)StringsKt.trim((CharSequence)string2)).toString() : null;
            printer.write(k + "\t" + text + "\t" + context + "\n");
        }
        printer.write("\nDATA END\n");
    }

    /*
     * WARNING - void declaration
     */
    public final void buildColumnDescriptions(@NotNull Path outputFile) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
        Iterable $this$map$iv = MLResultTable.filterColumnList$default(this.getFieldListTable(), this.getFilterStrategy(), 0, 2, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ML.Column column2 = (ML.Column)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toColumnDescription());
        }
        List columns = (List)destination$iv$iv;
        String descriptions = JacksonKt.prettyPulsarObjectMapper().writeValueAsString((Object)columns);
        Files.deleteIfExists(outputFile);
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE};
        Files.writeString(outputFile, (CharSequence)descriptions, Charsets.UTF_8, openOptionArray);
    }

    private final MLResultTable loadFieldListTable(Path inputBaseDir) {
        List csvPaths2 = CollectionsKt.toList((Iterable)PathsKt.listDirectoryEntries((Path)inputBaseDir, (String)"*.csv"));
        ClusteringResultFieldListLoader loader = new ClusteringResultFieldListLoader(csvPaths2);
        return loader.load();
    }

    public static final /* synthetic */ ClusteringProject access$getProject$p(ClusteringResultViewsBuilder $this) {
        return $this.project;
    }

    public static final /* synthetic */ MLResultTable access$loadFieldListTable(ClusteringResultViewsBuilder $this, Path inputBaseDir) {
        return $this.loadFieldListTable(inputBaseDir);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lai/platon/scent/view/builder/ml/clustering/ClusteringResultViewsBuilder$Companion;", "", "()V", "ADDITIONAL_GUIDE_FILE", "", "META_DATA_PLACEHOLDER", "PROMPT_MAX_SAMPLES", "", "PROMPT_SYSTEM_MESSAGE_FILE", "scent-build"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

