/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.common;

import ai.platon.pulsar.common.AppPaths;
import ai.platon.pulsar.common.RequiredDirectory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b/\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020\bJ\u000e\u0010D\u001a\u00020B2\u0006\u0010E\u001a\u00020\bJ\u000e\u0010F\u001a\u00020B2\u0006\u0010G\u001a\u00020\bJ\u0006\u0010H\u001a\u00020BR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0016\u0010\r\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0016\u0010\u000f\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\nR\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0015\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\n\"\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0006R\u0011\u0010\u001b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0006R\u0011\u0010\u001d\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0006R\u001e\u0010\u001f\u001a\n  *\u0004\u0018\u00010\b0\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\nR\u001e\u0010\"\u001a\n  *\u0004\u0018\u00010\b0\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\nR\u001e\u0010$\u001a\n  *\u0004\u0018\u00010\b0\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\nR\u001e\u0010&\u001a\n  *\u0004\u0018\u00010\b0\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\nR\u001e\u0010(\u001a\n  *\u0004\u0018\u00010\b0\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\nR\u001e\u0010*\u001a\n  *\u0004\u0018\u00010\b0\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\nR\u0011\u0010,\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u0006R\u001e\u0010.\u001a\n  *\u0004\u0018\u00010\b0\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\nR\u001e\u00100\u001a\n  *\u0004\u0018\u00010\b0\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010\nR\u001e\u00102\u001a\n  *\u0004\u0018\u00010\b0\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010\nR\u0016\u00104\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010\nR\u001e\u00106\u001a\n  *\u0004\u0018\u00010\b0\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010\nR\u0016\u00108\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010\nR\u001e\u0010:\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010\n\"\u0004\b<\u0010\u0018R\u0016\u0010=\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010\nR\u001e\u0010?\u001a\n  *\u0004\u0018\u00010\b0\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010\n\u00a8\u0006I"}, d2={"Lai/platon/scent/common/MLPaths;", "", "()V", "answerFileNamePattern", "Lkotlin/text/Regex;", "getAnswerFileNamePattern", "()Lkotlin/text/Regex;", "baseDir", "Ljava/nio/file/Path;", "getBaseDir", "()Ljava/nio/file/Path;", "datasetBaseDir", "getDatasetBaseDir", "harvestResultBaseDir", "getHarvestResultBaseDir", "harvestTaskDir", "getHarvestTaskDir", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "predictionDatasetBaseDir", "getPredictionDatasetBaseDir", "setPredictionDatasetBaseDir", "(Ljava/nio/file/Path;)V", "projectBaseDirPattern", "getProjectBaseDirPattern", "projectIdPattern", "getProjectIdPattern", "promptFileNamePattern", "getPromptFileNamePattern", "promptTaskBaseDir", "kotlin.jvm.PlatformType", "getPromptTaskBaseDir", "promptTaskProcessedDir", "getPromptTaskProcessedDir", "promptTaskProcessingDir", "getPromptTaskProcessingDir", "promptTaskResultBaseDir", "getPromptTaskResultBaseDir", "promptTaskResultCacheDir", "getPromptTaskResultCacheDir", "reportBaseDir", "getReportBaseDir", "reportFileNamePattern", "getReportFileNamePattern", "reportProcessedDir", "getReportProcessedDir", "reportProcessingDir", "getReportProcessingDir", "reportResultDir", "getReportResultDir", "supervisedTaskDir", "getSupervisedTaskDir", "supervisedTaskResultBaseDir", "getSupervisedTaskResultBaseDir", "taskBaseDir", "getTaskBaseDir", "trainingDatasetBaseDir", "getTrainingDatasetBaseDir", "setTrainingDatasetBaseDir", "unsupervisedTaskDir", "getUnsupervisedTaskDir", "unsupervisedTaskResultBaseDir", "getUnsupervisedTaskResultBaseDir", "copyToLearnUnsupervised", "", "taskFile", "copyToPrompt", "promptFile", "copyToReport", "reportFile", "createDirectories", "scent-common"})
@SourceDebugExtension(value={"SMAP\nMLPaths.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MLPaths.kt\nai/platon/scent/common/MLPaths\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,219:1\n3792#2:220\n4307#2:221\n12474#2,2:222\n4308#2:224\n1603#3,9:225\n1855#3:234\n1856#3:236\n1612#3:237\n1855#3:238\n1856#3:240\n1#4:235\n1#4:239\n*S KotlinDebug\n*F\n+ 1 MLPaths.kt\nai/platon/scent/common/MLPaths\n*L\n199#1:220\n199#1:221\n199#1:222,2\n199#1:224\n200#1:225,9\n200#1:234\n200#1:236\n200#1:237\n201#1:238\n201#1:240\n200#1:235\n*E\n"})
public final class MLPaths {
    @NotNull
    public static final MLPaths INSTANCE = new MLPaths();
    @NotNull
    private static final Logger logger;
    @RequiredDirectory
    @NotNull
    private static final Path baseDir;
    @RequiredDirectory
    @NotNull
    private static final Path datasetBaseDir;
    @RequiredDirectory
    @NotNull
    private static Path trainingDatasetBaseDir;
    @RequiredDirectory
    @NotNull
    private static Path predictionDatasetBaseDir;
    @RequiredDirectory
    @NotNull
    private static final Path taskBaseDir;
    @NotNull
    private static final Regex projectIdPattern;
    @NotNull
    private static final Regex projectBaseDirPattern;
    @RequiredDirectory
    @NotNull
    private static final Path harvestTaskDir;
    @RequiredDirectory
    @NotNull
    private static final Path harvestResultBaseDir;
    @RequiredDirectory
    @NotNull
    private static final Path supervisedTaskDir;
    @RequiredDirectory
    private static final Path supervisedTaskResultBaseDir;
    @RequiredDirectory
    @NotNull
    private static final Path unsupervisedTaskDir;
    @RequiredDirectory
    private static final Path unsupervisedTaskResultBaseDir;
    @RequiredDirectory
    private static final Path promptTaskBaseDir;
    @RequiredDirectory
    private static final Path promptTaskProcessingDir;
    @RequiredDirectory
    private static final Path promptTaskProcessedDir;
    @RequiredDirectory
    private static final Path promptTaskResultBaseDir;
    @RequiredDirectory
    private static final Path promptTaskResultCacheDir;
    @NotNull
    private static final Regex promptFileNamePattern;
    @NotNull
    private static final Regex answerFileNamePattern;
    @RequiredDirectory
    private static final Path reportBaseDir;
    @RequiredDirectory
    private static final Path reportProcessingDir;
    @RequiredDirectory
    private static final Path reportProcessedDir;
    @RequiredDirectory
    private static final Path reportResultDir;
    @NotNull
    private static final Regex reportFileNamePattern;

    private MLPaths() {
    }

    @NotNull
    public final Logger getLogger() {
        return logger;
    }

    @NotNull
    public final Path getBaseDir() {
        return baseDir;
    }

    @NotNull
    public final Path getDatasetBaseDir() {
        return datasetBaseDir;
    }

    @NotNull
    public final Path getTrainingDatasetBaseDir() {
        return trainingDatasetBaseDir;
    }

    public final void setTrainingDatasetBaseDir(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"<set-?>");
        trainingDatasetBaseDir = path;
    }

    @NotNull
    public final Path getPredictionDatasetBaseDir() {
        return predictionDatasetBaseDir;
    }

    public final void setPredictionDatasetBaseDir(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"<set-?>");
        predictionDatasetBaseDir = path;
    }

    @NotNull
    public final Path getTaskBaseDir() {
        return taskBaseDir;
    }

    @NotNull
    public final Regex getProjectIdPattern() {
        return projectIdPattern;
    }

    @NotNull
    public final Regex getProjectBaseDirPattern() {
        return projectBaseDirPattern;
    }

    @NotNull
    public final Path getHarvestTaskDir() {
        return harvestTaskDir;
    }

    @NotNull
    public final Path getHarvestResultBaseDir() {
        return harvestResultBaseDir;
    }

    @NotNull
    public final Path getSupervisedTaskDir() {
        return supervisedTaskDir;
    }

    public final Path getSupervisedTaskResultBaseDir() {
        return supervisedTaskResultBaseDir;
    }

    @NotNull
    public final Path getUnsupervisedTaskDir() {
        return unsupervisedTaskDir;
    }

    public final Path getUnsupervisedTaskResultBaseDir() {
        return unsupervisedTaskResultBaseDir;
    }

    public final Path getPromptTaskBaseDir() {
        return promptTaskBaseDir;
    }

    public final Path getPromptTaskProcessingDir() {
        return promptTaskProcessingDir;
    }

    public final Path getPromptTaskProcessedDir() {
        return promptTaskProcessedDir;
    }

    public final Path getPromptTaskResultBaseDir() {
        return promptTaskResultBaseDir;
    }

    public final Path getPromptTaskResultCacheDir() {
        return promptTaskResultCacheDir;
    }

    @NotNull
    public final Regex getPromptFileNamePattern() {
        return promptFileNamePattern;
    }

    @NotNull
    public final Regex getAnswerFileNamePattern() {
        return answerFileNamePattern;
    }

    public final Path getReportBaseDir() {
        return reportBaseDir;
    }

    public final Path getReportProcessingDir() {
        return reportProcessingDir;
    }

    public final Path getReportProcessedDir() {
        return reportProcessedDir;
    }

    public final Path getReportResultDir() {
        return reportResultDir;
    }

    @NotNull
    public final Regex getReportFileNamePattern() {
        return reportFileNamePattern;
    }

    /*
     * WARNING - void declaration
     */
    public final void createDirectories() {
        void $this$mapNotNullTo$iv$iv;
        Iterator element$iv$iv2;
        Iterable $this$filterTo$iv$iv;
        Field[] fieldArray = MLPaths.class.getDeclaredFields();
        Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"getDeclaredFields(...)");
        Object[] $this$filter$iv = fieldArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Iterator element$iv$iv2 : $this$filterTo$iv$iv) {
            boolean bl;
            block4: {
                Field it = (Field)((Object)element$iv$iv2);
                boolean bl2 = false;
                Annotation[] annotationArray = it.getAnnotations();
                Intrinsics.checkNotNullExpressionValue((Object)annotationArray, (String)"getAnnotations(...)");
                Object[] $this$any$iv = annotationArray;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    Annotation it2 = (Annotation)element$iv;
                    boolean bl3 = false;
                    if (!(it2 instanceof RequiredDirectory)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        element$iv$iv2 = $this$forEach$iv$iv$iv.iterator();
        while (element$iv$iv2.hasNext()) {
            Path it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv3 = element$iv$iv$iv = element$iv$iv2.next();
            boolean bl = false;
            Field it = (Field)element$iv$iv3;
            boolean bl4 = false;
            Object object = it.get(INSTANCE);
            if ((object instanceof Path ? (Path)object : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            Path path;
            Path it = (Path)element$iv;
            boolean bl = false;
            Path it3 = path = it;
            boolean bl6 = false;
            Path path2 = !Files.exists(it3, new LinkOption[0]) ? path : null;
            if (path2 == null) continue;
            it3 = path2;
            boolean bl7 = false;
            Files.createDirectories(it3, new FileAttribute[0]);
        }
    }

    public final void copyToLearnUnsupervised(@NotNull Path taskFile) {
        Intrinsics.checkNotNullParameter((Object)taskFile, (String)"taskFile");
        Path path = unsupervisedTaskDir.resolve(taskFile.getFileName());
        CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
        Files.copy(taskFile, path, copyOptionArray);
    }

    public final void copyToPrompt(@NotNull Path promptFile) {
        Intrinsics.checkNotNullParameter((Object)promptFile, (String)"promptFile");
        Path path = promptTaskBaseDir.resolve(promptFile.getFileName());
        CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
        Files.copy(promptFile, path, copyOptionArray);
    }

    public final void copyToReport(@NotNull Path reportFile) {
        Intrinsics.checkNotNullParameter((Object)reportFile, (String)"reportFile");
        Path path = reportBaseDir.resolve(reportFile.getFileName());
        CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
        Files.copy(reportFile, path, copyOptionArray);
    }

    static {
        Logger logger = LoggerFactory.getLogger(MLPaths.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        MLPaths.logger = logger;
        baseDir = AppPaths.INSTANCE.getProcTmp("ml", new String[0]);
        Path path = baseDir.resolve("dataset");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        datasetBaseDir = path;
        Path path2 = datasetBaseDir.resolve("train");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        trainingDatasetBaseDir = path2;
        Path path3 = datasetBaseDir.resolve("predict");
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
        predictionDatasetBaseDir = path3;
        Path path4 = baseDir.resolve("tasks");
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
        taskBaseDir = path4;
        projectIdPattern = new Regex("p\\d+");
        projectBaseDirPattern = projectIdPattern;
        Path path5 = taskBaseDir.resolve("harvest");
        Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"resolve(...)");
        harvestTaskDir = path5;
        Path path6 = harvestTaskDir.resolve("result");
        Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"resolve(...)");
        harvestResultBaseDir = path6;
        Path path7 = taskBaseDir.resolve("supervised");
        Intrinsics.checkNotNullExpressionValue((Object)path7, (String)"resolve(...)");
        supervisedTaskDir = path7;
        supervisedTaskResultBaseDir = supervisedTaskDir.resolve("result");
        Path path8 = taskBaseDir.resolve("unsupervised");
        Intrinsics.checkNotNullExpressionValue((Object)path8, (String)"resolve(...)");
        unsupervisedTaskDir = path8;
        unsupervisedTaskResultBaseDir = unsupervisedTaskDir.resolve("result");
        promptTaskBaseDir = taskBaseDir.resolve("prompts");
        promptTaskProcessingDir = promptTaskBaseDir.resolve("processing");
        promptTaskProcessedDir = promptTaskBaseDir.resolve("processed");
        promptTaskResultBaseDir = promptTaskBaseDir.resolve("result");
        promptTaskResultCacheDir = AppPaths.INSTANCE.getPROMPT_CACHE_DIR();
        promptFileNamePattern = new Regex("prompt.(p\\d+)\\.(\\d+)\\.?(\\w+)?\\.([a-zA-Z]+)");
        answerFileNamePattern = new Regex("prompt.(p\\d+)\\.(\\d+)\\.?(\\w+)?\\.answer\\.([a-zA-Z]+)");
        reportBaseDir = taskBaseDir.resolve("report");
        reportProcessingDir = reportBaseDir.resolve("processing");
        reportProcessedDir = reportBaseDir.resolve("processed");
        reportResultDir = reportBaseDir.resolve("result");
        reportFileNamePattern = new Regex(".+\\..+");
        INSTANCE.createDirectories();
    }
}

