/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.common;

import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lai/platon/scent/common/Workbook2CSVConverter;", "", "workbookFilePath", "Ljava/nio/file/Path;", "csvFilePath", "(Ljava/nio/file/Path;Ljava/nio/file/Path;)V", "format", "Lorg/apache/commons/csv/CSVFormat;", "kotlin.jvm.PlatformType", "convert", "", "workbook", "Lorg/apache/poi/xssf/usermodel/XSSFWorkbook;", "setFormat", "Companion", "scent-common"})
public final class Workbook2CSVConverter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path workbookFilePath;
    @NotNull
    private final Path csvFilePath;
    private CSVFormat format;
    @NotNull
    private static final Logger logger;

    public Workbook2CSVConverter(@NotNull Path workbookFilePath, @NotNull Path csvFilePath) {
        Intrinsics.checkNotNullParameter((Object)workbookFilePath, (String)"workbookFilePath");
        Intrinsics.checkNotNullParameter((Object)csvFilePath, (String)"csvFilePath");
        this.workbookFilePath = workbookFilePath;
        this.csvFilePath = csvFilePath;
        this.format = CSVFormat.DEFAULT;
    }

    @NotNull
    public final Workbook2CSVConverter setFormat(@NotNull CSVFormat format) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        this.format = format;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void convert() {
        try {
            Closeable closeable = new FileInputStream(this.workbookFilePath.toFile());
            Throwable throwable = null;
            try {
                FileInputStream fis = (FileInputStream)closeable;
                boolean bl = false;
                Closeable closeable2 = (Closeable)new XSSFWorkbook((InputStream)fis);
                Throwable throwable2 = null;
                try {
                    XSSFWorkbook workbook = (XSSFWorkbook)closeable2;
                    boolean bl2 = false;
                    this.convert(workbook);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            logger.warn(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void convert(XSSFWorkbook workbook) throws IOException {
        XSSFSheet xSSFSheet = workbook.getSheetAt(0);
        Intrinsics.checkNotNullExpressionValue((Object)xSSFSheet, (String)"getSheetAt(...)");
        Sheet sheet = (Sheet)xSSFSheet;
        Closeable closeable = new FileWriter(this.csvFilePath.toFile(), Charset.defaultCharset());
        Throwable throwable = null;
        try {
            FileWriter out = (FileWriter)closeable;
            boolean bl = false;
            Closeable closeable2 = (Closeable)new CSVPrinter((Appendable)out, this.format);
            Throwable throwable2 = null;
            try {
                CSVPrinter csvPrinter = (CSVPrinter)closeable2;
                boolean bl2 = false;
                for (Row row : sheet) {
                    String[] rowData = new String[row.getLastCellNum()];
                    for (Cell cell : row) {
                        int cellIndex = cell.getColumnIndex();
                        Intrinsics.checkNotNull((Object)cell);
                        rowData[cellIndex] = Companion.getCellValueAsString(cell);
                    }
                    csvPrinter.printRecord((Object[])Arrays.copyOf(rowData, rowData.length));
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    static {
        Logger logger = LoggerFactory.getLogger(Workbook2CSVConverter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        Workbook2CSVConverter.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lai/platon/scent/common/Workbook2CSVConverter$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "getCellValueAsString", "", "cell", "Lorg/apache/poi/ss/usermodel/Cell;", "scent-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getCellValueAsString(@NotNull Cell cell) {
            String string;
            Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
            CellType cellType = cell.getCellType();
            switch (cellType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[cellType.ordinal()]) {
                case 1: {
                    String string2 = cell.getStringCellValue();
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getStringCellValue(...)");
                    break;
                }
                case 2: {
                    String string3 = DateUtil.isCellDateFormatted((Cell)cell) ? cell.getDateCellValue().toString() : String.valueOf(cell.getNumericCellValue());
                    Intrinsics.checkNotNull((Object)string3);
                    string = string3;
                    break;
                }
                case 3: {
                    string = String.valueOf(cell.getBooleanCellValue());
                    break;
                }
                case 4: {
                    String string4 = cell.getCellFormula();
                    string = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getCellFormula(...)");
                    break;
                }
                default: {
                    string = "";
                }
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[CellType.values().length];
                try {
                    nArray[CellType.STRING.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CellType.NUMERIC.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CellType.BOOLEAN.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CellType.FORMULA.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

