/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.common;

import ai.platon.pulsar.common.serialize.json.JacksonKt;
import ai.platon.scent.common.RowData;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\u000e\u0010\u0006\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lai/platon/scent/common/Workbook2JSONConverter;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "convert", "", "workbookPath", "Ljava/nio/file/Path;", "jsonPath", "", "workbook", "Lorg/apache/poi/xssf/usermodel/XSSFWorkbook;", "scent-common"})
public final class Workbook2JSONConverter {
    private final Logger logger = LoggerFactory.getLogger(Workbook2JSONConverter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void convert(@NotNull Path workbookPath, @NotNull Path jsonPath) {
        Intrinsics.checkNotNullParameter((Object)workbookPath, (String)"workbookPath");
        Intrinsics.checkNotNullParameter((Object)jsonPath, (String)"jsonPath");
        try {
            Closeable closeable = new FileInputStream(workbookPath.toFile());
            Throwable throwable = null;
            try {
                Path path;
                FileInputStream fis = (FileInputStream)closeable;
                boolean bl = false;
                Closeable closeable2 = (Closeable)new XSSFWorkbook((InputStream)fis);
                Throwable throwable2 = null;
                try {
                    XSSFWorkbook workbook = (XSSFWorkbook)closeable2;
                    boolean bl2 = false;
                    path = Files.writeString(jsonPath, (CharSequence)this.convert(workbook), new OpenOption[0]);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                Path path2 = path;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            this.logger.warn(e.toString());
        }
    }

    @NotNull
    public final String convert(@NotNull XSSFWorkbook workbook) {
        Intrinsics.checkNotNullParameter((Object)workbook, (String)"workbook");
        XSSFSheet sheet = workbook.getSheetAt(0);
        List rows = new ArrayList();
        for (Row row : sheet) {
            List cellData = new ArrayList();
            for (Cell cell : row) {
                cellData.add(cell.toString());
            }
            rows.add(new RowData(cellData));
        }
        String string = JacksonKt.prettyPulsarObjectMapper().writeValueAsString((Object)rows);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
        return string;
    }
}

