/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.dom;

import ai.platon.pulsar.common.math.vectors.VectorsKt;
import ai.platon.scent.dom.features.defined.DefinedFeaturesKt;
import ai.platon.scent.dom.nodes.node.ext.NodeExtKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.stat.descriptive.MultivariateSummaryStatistics;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lai/platon/scent/dom/CalculatorUtils;", "", "()V", "summary", "Lorg/apache/commons/math3/stat/descriptive/MultivariateSummaryStatistics;", "nodes", "", "Lorg/jsoup/nodes/Element;", "updateRegionalFeatures", "", "node", "Lorg/jsoup/nodes/Node;", "scent-dom"})
@SourceDebugExtension(value={"SMAP\nCalculatorUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CalculatorUtils.kt\nai/platon/scent/dom/CalculatorUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,44:1\n1855#2,2:45\n*S KotlinDebug\n*F\n+ 1 CalculatorUtils.kt\nai/platon/scent/dom/CalculatorUtils\n*L\n27#1:45,2\n*E\n"})
public final class CalculatorUtils {
    @NotNull
    public static final CalculatorUtils INSTANCE = new CalculatorUtils();

    private CalculatorUtils() {
    }

    @NotNull
    public final MultivariateSummaryStatistics summary(@NotNull List<? extends Element> nodes) {
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        if (nodes.isEmpty()) {
            return new MultivariateSummaryStatistics(0, false);
        }
        MultivariateSummaryStatistics ds = new MultivariateSummaryStatistics(DefinedFeaturesKt.getN2(), false);
        Iterable $this$forEach$iv = nodes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Element it = (Element)element$iv;
            boolean bl = false;
            ds.addValue(it.getExtension().getFeatures().toArray());
        }
        return ds;
    }

    public final void updateRegionalFeatures(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Element element = NodeExtKt.getOwnerComponent(node);
        if (element == null) {
            return;
        }
        Element component = element;
        RealVector realVector = component.getExtension().getFeatures();
        Intrinsics.checkNotNullExpressionValue((Object)realVector, (String)"getFeatures(...)");
        double top = VectorsKt.get((RealVector)realVector, (int)ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.TOP);
        RealVector realVector2 = component.getExtension().getFeatures();
        Intrinsics.checkNotNullExpressionValue((Object)realVector2, (String)"getFeatures(...)");
        double left = VectorsKt.get((RealVector)realVector2, (int)ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.LEFT);
        RealVector realVector3 = component.getExtension().getFeatures();
        Intrinsics.checkNotNullExpressionValue((Object)realVector3, (String)"getFeatures(...)");
        double sequence = VectorsKt.get((RealVector)realVector3, (int)ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.SEQ);
        RealVector realVector4 = node.getExtension().getFeatures();
        Intrinsics.checkNotNullExpressionValue((Object)realVector4, (String)"getFeatures(...)");
        RealVector f = realVector4;
        RealVector realVector5 = node.getExtension().getFeatures();
        Intrinsics.checkNotNullExpressionValue((Object)realVector5, (String)"getFeatures(...)");
        VectorsKt.set((RealVector)realVector5, (int)DefinedFeaturesKt.getRTOP(), (double)(VectorsKt.get((RealVector)f, (int)ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.TOP) - top));
        RealVector realVector6 = node.getExtension().getFeatures();
        Intrinsics.checkNotNullExpressionValue((Object)realVector6, (String)"getFeatures(...)");
        VectorsKt.set((RealVector)realVector6, (int)DefinedFeaturesKt.getRLEFT(), (double)(VectorsKt.get((RealVector)f, (int)ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.LEFT) - left));
        RealVector realVector7 = node.getExtension().getFeatures();
        Intrinsics.checkNotNullExpressionValue((Object)realVector7, (String)"getFeatures(...)");
        VectorsKt.set((RealVector)realVector7, (int)DefinedFeaturesKt.getRSEQ(), (double)(VectorsKt.get((RealVector)f, (int)ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.SEQ) - sequence));
    }
}

