/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.dom;

import ai.platon.pulsar.common.math.vectors.VectorsKt;
import ai.platon.pulsar.dom.features.defined.F;
import ai.platon.pulsar.dom.nodes.NodesKt;
import ai.platon.scent.dom.FeatureValidator;
import ai.platon.scent.dom.features.defined.DefinedFeaturesKt;
import ai.platon.scent.dom.features.defined.FF;
import ai.platon.scent.dom.nodes.NodePath;
import ai.platon.scent.dom.nodes.node.ext.NodeExtKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.util.Precision;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000bJ\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u000bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lai/platon/scent/dom/FeatureValidator;", "", "document", "Lorg/jsoup/nodes/Document;", "(Lorg/jsoup/nodes/Document;)V", "getDocument", "()Lorg/jsoup/nodes/Document;", "validate", "", "elements", "", "Lorg/jsoup/nodes/Element;", "element", "validateAverageLineHeight", "node", "Lorg/jsoup/nodes/Node;", "validateNodeStatFeature", "e", "Companion", "scent-dom"})
@SourceDebugExtension(value={"SMAP\nFeatureValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FeatureValidator.kt\nai/platon/scent/dom/FeatureValidator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,139:1\n1855#2,2:140\n2976#2,5:142\n766#2:147\n857#2,2:148\n*S KotlinDebug\n*F\n+ 1 FeatureValidator.kt\nai/platon/scent/dom/FeatureValidator\n*L\n49#1:140,2\n57#1:142,5\n61#1:147\n61#1:148,2\n*E\n"})
public final class FeatureValidator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Document document;
    @NotNull
    private static final Logger log;

    public FeatureValidator(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        this.document = document;
        Element element = this.document.body();
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"body(...)");
        Element body = element;
        ai.platon.scent.dom.FeatureValidator$Companion.ensure$default(Companion, ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getWidth((Node)((Node)body)) >= 900, "body width", null, 4, null);
        ai.platon.scent.dom.FeatureValidator$Companion.ensure$default(Companion, ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getHeight((Node)((Node)body)) >= 1000, "body height", null, 4, null);
        ai.platon.scent.dom.FeatureValidator$Companion.ensure$default(Companion, ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getUnitArea((Document)this.document) > 1, "unit area", null, 4, null);
        ai.platon.scent.dom.FeatureValidator$Companion.ensure$default(Companion, ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getGrid((Document)this.document).width > 1, "grid", null, 4, null);
        ai.platon.scent.dom.FeatureValidator$Companion.ensure$default(Companion, ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getGrid((Document)this.document).height > 1, "grid", null, 4, null);
    }

    @NotNull
    public final Document getDocument() {
        return this.document;
    }

    public final void validate(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.validate(CollectionsKt.listOf((Object)element));
    }

    public final void validate(@NotNull Iterable<? extends Element> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Element element = this.document.body();
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"body(...)");
        this.validateAverageLineHeight((Node)element);
        Element element2 = this.document.body();
        Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"body(...)");
        NodesKt.forEach$default((Node)((Node)element2), (boolean)false, (Function1)validate.1.INSTANCE, (int)1, null);
        Iterable<? extends Element> $this$forEach$iv = elements;
        boolean $i$f$forEach = false;
        Iterator<? extends Element> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Element element$iv;
            Element it = element$iv = iterator2.next();
            boolean bl = false;
            this.validateNodeStatFeature(it);
        }
        this.document.body().attr("a-feature-validated", "1");
    }

    /*
     * WARNING - void declaration
     */
    private final void validateNodeStatFeature(Element e) {
        void $this$filterTo$iv$iv;
        int n2;
        void $this$sumBy$iv;
        RealVector realVector = e.getExtension().getFeatures();
        Intrinsics.checkNotNullExpressionValue((Object)realVector, (String)"getFeatures(...)");
        RealVector f = realVector;
        double d = VectorsKt.get((RealVector)f, (int)DefinedFeaturesKt.getG());
        Elements elements = e.children();
        Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"children(...)");
        Iterable iterable = (Iterable)elements;
        double d2 = d;
        Companion companion = Companion;
        boolean $i$f$sumBy = false;
        int sum$iv = 0;
        for (Object element$iv : $this$sumBy$iv) {
            void it;
            Element element = (Element)element$iv;
            n2 = sum$iv;
            boolean bl = false;
            int n3 = it.children().size();
            sum$iv = n2 + n3;
        }
        n2 = sum$iv;
        companion.ensureEquals(d2, (double)n2, FF.G, (Node)e);
        Companion.ensureEquals(VectorsKt.get((RealVector)f, (int)DefinedFeaturesKt.getD()), (double)NodesKt.count((Node)((Node)e), (Function1)validateNodeStatFeature.2.INSTANCE), FF.D, (Node)e);
        Companion.ensureEquals(VectorsKt.get((RealVector)f, (int)ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.SIB), (double)ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getParentElement((Node)((Node)e)).children().size(), F.SIB, (Node)e);
        List list = e.childNodes();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"childNodes(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Node it = (Node)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (!ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.isRegularText((Node)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List ownTextNodes = (List)destination$iv$iv;
        Companion.ensureEquals((double)ownTextNodes.size(), VectorsKt.get((RealVector)f, (int)DefinedFeaturesKt.getOTN()), FF.OTN, (Node)e);
        Companion.ensureEquals(VectorsKt.get((RealVector)f, (int)DefinedFeaturesKt.getATW()), NodesKt.accumulate$default((Node)((Node)e), (int)ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.WIDTH, (boolean)false, (Function1)validateNodeStatFeature.3.INSTANCE, (int)2, null), FF.ATW, (Node)e);
        Companion.ensureEquals(VectorsKt.get((RealVector)f, (int)DefinedFeaturesKt.getATH()), NodesKt.accumulate$default((Node)((Node)e), (int)ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.HEIGHT, (boolean)false, (Function1)validateNodeStatFeature.4.INSTANCE, (int)2, null), FF.ATH, (Node)e);
        Companion.ensureEquals(VectorsKt.get((RealVector)f, (int)DefinedFeaturesKt.getITW()), NodesKt.accumulate$default((Node)((Node)e), (int)ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.WIDTH, (boolean)false, (Function1)validateNodeStatFeature.5.INSTANCE, (int)2, null), FF.ITW, (Node)e);
        Companion.ensureEquals(VectorsKt.get((RealVector)f, (int)DefinedFeaturesKt.getITH()), NodesKt.accumulate$default((Node)((Node)e), (int)ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.HEIGHT, (boolean)false, (Function1)validateNodeStatFeature.6.INSTANCE, (int)2, null), FF.ITH, (Node)e);
        Companion.ensureEquals(VectorsKt.get((RealVector)f, (int)ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.TN), (double)NodesKt.count((Node)((Node)e), (Function1)validateNodeStatFeature.7.INSTANCE), F.TN.getAlias(), (Node)e);
        if (VectorsKt.get((RealVector)f, (int)ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.TN) > 0.0) {
            Companion.ensureEquals(VectorsKt.get((RealVector)f, (int)DefinedFeaturesKt.getTAW()), NodesKt.accumulate$default((Node)((Node)e), (int)ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.WIDTH, (boolean)false, (Function1)validateNodeStatFeature.8.INSTANCE, (int)2, null) / VectorsKt.get((RealVector)f, (int)ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.TN), FF.TAW, (Node)e);
            Companion.ensureEquals(VectorsKt.get((RealVector)f, (int)DefinedFeaturesKt.getTAH()), NodesKt.accumulate$default((Node)((Node)e), (int)ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.HEIGHT, (boolean)false, (Function1)validateNodeStatFeature.9.INSTANCE, (int)2, null) / VectorsKt.get((RealVector)f, (int)ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.TN), FF.TAH, (Node)e);
        }
        if (VectorsKt.get((RealVector)f, (int)ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.A) > 0.0) {
            Companion.ensureEquals(VectorsKt.get((RealVector)f, (int)DefinedFeaturesKt.getAAW()), NodesKt.accumulate$default((Node)((Node)e), (int)ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.WIDTH, (boolean)false, (Function1)validateNodeStatFeature.10.INSTANCE, (int)2, null) / VectorsKt.get((RealVector)f, (int)ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.A), FF.AAW, (Node)e);
            Companion.ensureEquals(VectorsKt.get((RealVector)f, (int)DefinedFeaturesKt.getAAH()), NodesKt.accumulate$default((Node)((Node)e), (int)ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.HEIGHT, (boolean)false, (Function1)validateNodeStatFeature.11.INSTANCE, (int)2, null) / VectorsKt.get((RealVector)f, (int)ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.A), FF.AAH, (Node)e);
        }
        if (VectorsKt.get((RealVector)f, (int)ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.IMG) > 0.0) {
            Companion.ensureEquals(VectorsKt.get((RealVector)f, (int)DefinedFeaturesKt.getIAW()), NodesKt.accumulate$default((Node)((Node)e), (int)ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.WIDTH, (boolean)false, (Function1)validateNodeStatFeature.12.INSTANCE, (int)2, null) / VectorsKt.get((RealVector)f, (int)ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.IMG), FF.IAW, (Node)e);
            Companion.ensureEquals(VectorsKt.get((RealVector)f, (int)DefinedFeaturesKt.getIAH()), NodesKt.accumulate$default((Node)((Node)e), (int)ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.HEIGHT, (boolean)false, (Function1)validateNodeStatFeature.13.INSTANCE, (int)2, null) / VectorsKt.get((RealVector)f, (int)ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.IMG), FF.IAH, (Node)e);
        }
    }

    private final void validateAverageLineHeight(Node node) {
    }

    static {
        Logger logger = LoggerFactory.getLogger(FeatureValidator.class);
        Intrinsics.checkNotNull((Object)logger);
        log = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eJ*\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eJ*\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00152\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eJ,\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\b\b\u0002\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eJ\"\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\n0\u001aR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001b"}, d2={"Lai/platon/scent/dom/FeatureValidator$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "ensure", "", "b", "", "name", "", "node", "Lorg/jsoup/nodes/Node;", "ensureEquals", "expected", "", "actual", "f", "Lai/platon/pulsar/dom/features/defined/F;", "Lai/platon/scent/dom/features/defined/FF;", "validateRegionalFeature", "component", "Lorg/jsoup/nodes/Element;", "predicate", "Lkotlin/Function1;", "scent-dom"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        public final void validateRegionalFeature(@NotNull Element component, @NotNull Function1<? super Node, Boolean> predicate2) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            Intrinsics.checkNotNullParameter(predicate2, (String)"predicate");
            RealVector realVector = component.getExtension().getFeatures();
            Intrinsics.checkNotNullExpressionValue((Object)realVector, (String)"getFeatures(...)");
            double top = VectorsKt.get((RealVector)realVector, (int)ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.TOP);
            RealVector realVector2 = component.getExtension().getFeatures();
            Intrinsics.checkNotNullExpressionValue((Object)realVector2, (String)"getFeatures(...)");
            double left = VectorsKt.get((RealVector)realVector2, (int)ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.LEFT);
            RealVector realVector3 = component.getExtension().getFeatures();
            Intrinsics.checkNotNullExpressionValue((Object)realVector3, (String)"getFeatures(...)");
            double sequence = VectorsKt.get((RealVector)realVector3, (int)ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.SEQ);
            NodesKt.forEachMatching((Node)((Node)component), predicate2, (Function1)((Function1)new Function1<Node, Unit>(component, top, left, sequence){
                final /* synthetic */ Element $component;
                final /* synthetic */ double $top;
                final /* synthetic */ double $left;
                final /* synthetic */ double $sequence;
                {
                    this.$component = $component;
                    this.$top = $top;
                    this.$left = $left;
                    this.$sequence = $sequence;
                    super(1);
                }

                public final void invoke(@NotNull Node it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    FeatureValidator.Companion.ensure(Intrinsics.areEqual((Object)NodeExtKt.getOwnerComponent(it), (Object)this.$component), "ownerComponent", (Node)this.$component);
                    if (Intrinsics.areEqual((Object)NodeExtKt.getOwnerComponent(it), (Object)this.$component)) {
                        RealVector realVector = it.getExtension().getFeatures();
                        Intrinsics.checkNotNullExpressionValue((Object)realVector, (String)"getFeatures(...)");
                        RealVector f = realVector;
                        FeatureValidator.Companion.ensureEquals(VectorsKt.get((RealVector)f, (int)DefinedFeaturesKt.getRTOP()), VectorsKt.get((RealVector)f, (int)ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.TOP) - this.$top, FF.RTOP, it);
                        FeatureValidator.Companion.ensureEquals(VectorsKt.get((RealVector)f, (int)DefinedFeaturesKt.getRLEFT()), VectorsKt.get((RealVector)f, (int)ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.LEFT) - this.$left, FF.RLEFT, it);
                        FeatureValidator.Companion.ensureEquals(VectorsKt.get((RealVector)f, (int)DefinedFeaturesKt.getRSEQ()), VectorsKt.get((RealVector)f, (int)ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.SEQ) - this.$sequence, FF.RSEQ, it);
                    }
                }
            }));
        }

        public final void ensure(boolean b, @NotNull String name, @Nullable Node node) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            if (!b) {
                Object object = node;
                if (object == null || (object = ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getBestElement((Node)object)) == null || (object = NodeExtKt.getPath((Node)object)) == null || (object = ((NodePath)object).getSelector3()) == null) {
                    object = "";
                }
                Object message = object;
                this.getLog().warn("Assertion violated\t[" + name + "]\t" + (String)message);
            }
        }

        public static /* synthetic */ void ensure$default(Companion companion, boolean bl, String string, Node node, int n2, Object object) {
            if ((n2 & 2) != 0) {
                string = "";
            }
            if ((n2 & 4) != 0) {
                node = null;
            }
            companion.ensure(bl, string, node);
        }

        public final void ensureEquals(double expected, double actual, @NotNull F f, @Nullable Node node) {
            Intrinsics.checkNotNullParameter((Object)f, (String)"f");
            this.ensureEquals(expected, actual, f.getAlias(), node);
        }

        public static /* synthetic */ void ensureEquals$default(Companion companion, double d, double d2, F f, Node node, int n2, Object object) {
            if ((n2 & 8) != 0) {
                node = null;
            }
            companion.ensureEquals(d, d2, f, node);
        }

        public final void ensureEquals(double expected, double actual, @NotNull FF f, @Nullable Node node) {
            Intrinsics.checkNotNullParameter((Object)((Object)f), (String)"f");
            this.ensureEquals(expected, actual, f.getAlias(), node);
        }

        public static /* synthetic */ void ensureEquals$default(Companion companion, double d, double d2, FF fF, Node node, int n2, Object object) {
            if ((n2 & 8) != 0) {
                node = null;
            }
            companion.ensureEquals(d, d2, fF, node);
        }

        public final void ensureEquals(double expected, double actual, @NotNull String name, @Nullable Node node) {
            Object message;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Object object = node;
            if (object == null || (object = ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getBestElement((Node)object)) == null || (object = NodeExtKt.getPath((Node)object)) == null || (object = ((NodePath)object).getSelector3()) == null) {
                object = message = "";
            }
            if (!Precision.equals((double)expected, (double)actual, (double)0.01)) {
                this.getLog().warn("Expected: " + expected + " actual: " + actual + "\t[" + name + "]\t" + (String)message);
            }
        }

        public static /* synthetic */ void ensureEquals$default(Companion companion, double d, double d2, String string, Node node, int n2, Object object) {
            if ((n2 & 4) != 0) {
                string = "";
            }
            if ((n2 & 8) != 0) {
                node = null;
            }
            companion.ensureEquals(d, d2, string, node);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

