/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.dom.detail;

import ai.platon.pulsar.common.math.vectors.VectorsKt;
import ai.platon.pulsar.dom.features.FeatureEntry;
import ai.platon.pulsar.dom.features.FeatureRegistry;
import ai.platon.pulsar.dom.features.NodeFeature;
import ai.platon.pulsar.dom.nodes.DOMRect;
import ai.platon.pulsar.dom.nodes.NodesKt;
import ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt;
import ai.platon.scent.dom.features.defined.DefinedFeaturesKt;
import ai.platon.scent.dom.nodes.node.ext.NodeCharactersKt;
import ai.platon.scent.dom.utils.DOMUtils;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.NodeVisitor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\t\b\u0000\u0018\u0000  2\u00020\u0001:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0002J)\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r\"\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u000bH\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u000bH\u0002J(\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0018H\u0002J\u0018\u0010\u001d\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u0004H\u0016J\u0018\u0010\u001f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u0004H\u0016R\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006!"}, d2={"Lai/platon/scent/dom/detail/Level2NodeFeatureCalculatorVisitor;", "Lorg/jsoup/select/NodeVisitor;", "()V", "<set-?>", "", "sequence", "getSequence", "()I", "accumulateFeatures", "", "node", "Lorg/jsoup/nodes/Node;", "features", "", "Lai/platon/pulsar/dom/features/FeatureEntry;", "(Lorg/jsoup/nodes/Node;[Lai/platon/pulsar/dom/features/FeatureEntry;)V", "calcSelfIndicator", "calculateAverageFeatures", "Lorg/jsoup/nodes/Element;", "calculateBodyFeatures", "body", "calculateBodyRect", "Lai/platon/pulsar/dom/nodes/DOMRect;", "divide", "", "ele", "numerator", "denominator", "divideByZeroValue", "head", "depth", "tail", "Companion", "scent-dom"})
@SourceDebugExtension(value={"SMAP\nLevel2FeatureCalculatorVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Level2FeatureCalculatorVisitor.kt\nai/platon/scent/dom/detail/Level2NodeFeatureCalculatorVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,297:1\n1855#2,2:298\n*S KotlinDebug\n*F\n+ 1 Level2FeatureCalculatorVisitor.kt\nai/platon/scent/dom/detail/Level2NodeFeatureCalculatorVisitor\n*L\n210#1:298,2\n*E\n"})
public final class Level2NodeFeatureCalculatorVisitor
implements NodeVisitor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int sequence;
    @NotNull
    private static final AtomicInteger globalNumNodes = new AtomicInteger();

    public final int getSequence() {
        return this.sequence;
    }

    public void head(@NotNull Node node, int depth) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        globalNumNodes.incrementAndGet();
        node.getExtension().setFeatures((RealVector)new ArrayRealVector(FeatureRegistry.INSTANCE.getDimension()));
        RealVector realVector = node.getExtension().getFeatures();
        Intrinsics.checkNotNullExpressionValue((Object)realVector, (String)"getFeatures(...)");
        VectorsKt.set((RealVector)realVector, (int)ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.DEP, (double)depth);
        RealVector realVector2 = node.getExtension().getFeatures();
        Intrinsics.checkNotNullExpressionValue((Object)realVector2, (String)"getFeatures(...)");
        VectorsKt.set((RealVector)realVector2, (int)ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.SEQ, (double)this.sequence);
        this.calcSelfIndicator(node);
        ++this.sequence;
    }

    private final void calcSelfIndicator(Node node) {
        if (!(node instanceof Element) && !(node instanceof TextNode)) {
            return;
        }
        DOMRect rect = DOMUtils.INSTANCE.parseDOMRect(node);
        if (!rect.isEmpty()) {
            RealVector realVector = node.getExtension().getFeatures();
            Intrinsics.checkNotNullExpressionValue((Object)realVector, (String)"getFeatures(...)");
            VectorsKt.set((RealVector)realVector, (int)ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.TOP, (double)rect.getTop());
            RealVector realVector2 = node.getExtension().getFeatures();
            Intrinsics.checkNotNullExpressionValue((Object)realVector2, (String)"getFeatures(...)");
            VectorsKt.set((RealVector)realVector2, (int)ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.LEFT, (double)rect.getLeft());
            RealVector realVector3 = node.getExtension().getFeatures();
            Intrinsics.checkNotNullExpressionValue((Object)realVector3, (String)"getFeatures(...)");
            VectorsKt.set((RealVector)realVector3, (int)ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.WIDTH, (double)rect.getWidth());
            RealVector realVector4 = node.getExtension().getFeatures();
            Intrinsics.checkNotNullExpressionValue((Object)realVector4, (String)"getFeatures(...)");
            VectorsKt.set((RealVector)realVector4, (int)ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.HEIGHT, (double)rect.getHeight());
        }
        if (node instanceof TextNode && NodeExtKt.isRegularText((Node)node)) {
            ((TextNode)node).getExtension().setImmutableText(((TextNode)node).text());
            String string = ((TextNode)node).getExtension().getImmutableText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getImmutableText(...)");
            String text = string;
            double ch = text.length();
            double sep = 0.0;
            for (String separator : NodeFeature.Companion.getSEPARATORS()) {
                sep += (double)StringUtils.countMatches((CharSequence)text, (CharSequence)separator);
            }
            if (ch > 0.0) {
                RealVector realVector = ((TextNode)node).getExtension().getFeatures();
                Intrinsics.checkNotNullExpressionValue((Object)realVector, (String)"getFeatures(...)");
                double w = VectorsKt.get((RealVector)realVector, (int)ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.WIDTH);
                RealVector realVector5 = ((TextNode)node).getExtension().getFeatures();
                Intrinsics.checkNotNullExpressionValue((Object)realVector5, (String)"getFeatures(...)");
                double h = VectorsKt.get((RealVector)realVector5, (int)ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.HEIGHT);
                FeatureEntry[] featureEntryArray = new FeatureEntry[]{new FeatureEntry(ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.CH, ch), new FeatureEntry(DefinedFeaturesKt.getCHM(), ch), new FeatureEntry(DefinedFeaturesKt.getCHA(), ch), new FeatureEntry(DefinedFeaturesKt.getOCH(), ch), new FeatureEntry(DefinedFeaturesKt.getSEP(), sep), new FeatureEntry(DefinedFeaturesKt.getTTW(), w), new FeatureEntry(DefinedFeaturesKt.getTTH(), h)};
                this.accumulateFeatures(node, featureEntryArray);
            }
        }
        if (node instanceof Element) {
            double a = 0.0;
            double aW = 0.0;
            double aH = 0.0;
            double img = 0.0;
            double imgW = 0.0;
            double imgH = 0.0;
            if (NodeExtKt.isRegularAnchor((Node)node)) {
                a += 1.0;
                aW = rect.getWidth();
                aH = rect.getHeight();
            }
            if (NodeExtKt.isRegularImage((Node)node)) {
                img += 1.0;
                imgW = rect.getWidth();
                imgH = rect.getHeight();
            }
            FeatureEntry[] featureEntryArray = new FeatureEntry[]{new FeatureEntry(ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.A, a), new FeatureEntry(ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.IMG, img), new FeatureEntry(DefinedFeaturesKt.getSIMG(), NodeCharactersKt.isSmallImage(node)), new FeatureEntry(DefinedFeaturesKt.getMIMG(), NodeCharactersKt.isMediumImage(node)), new FeatureEntry(DefinedFeaturesKt.getLIMG(), NodeCharactersKt.isLargeImage(node)), new FeatureEntry(DefinedFeaturesKt.getAIMG(), NodeExtKt.isAnchorImage((Node)node)), new FeatureEntry(DefinedFeaturesKt.getSAIMG(), NodeCharactersKt.isSmallAnchorImage(node)), new FeatureEntry(DefinedFeaturesKt.getMAIMG(), NodeCharactersKt.isMediumAnchorImage(node)), new FeatureEntry(DefinedFeaturesKt.getLAIMG(), NodeCharactersKt.isLargeAnchorImage(node)), new FeatureEntry(DefinedFeaturesKt.getATW(), aW), new FeatureEntry(DefinedFeaturesKt.getATH(), aH), new FeatureEntry(DefinedFeaturesKt.getITW(), imgW), new FeatureEntry(DefinedFeaturesKt.getITH(), imgH)};
            this.accumulateFeatures(node, featureEntryArray);
        }
    }

    public void tail(@NotNull Node node, int depth) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (!(node instanceof Element) && !(node instanceof TextNode)) {
            return;
        }
        if (node instanceof TextNode) {
            Node parent = node.parent();
            double otn = NodeExtKt.isRegularText((Node)node) ? 1.0 : 0.0;
            Node node2 = parent;
            Intrinsics.checkNotNull((Object)node2);
            FeatureEntry[] featureEntryArray = new FeatureEntry[]{new FeatureEntry(DefinedFeaturesKt.getOTN(), otn), new FeatureEntry(ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.TN, otn), NodeExtKt.getFeatureEntry((Node)node, (int)DefinedFeaturesKt.getOCH()), NodeExtKt.getFeatureEntry((Node)node, (int)ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.CH), NodeExtKt.getFeatureEntry((Node)node, (int)DefinedFeaturesKt.getCHM()), NodeExtKt.getFeatureEntry((Node)node, (int)DefinedFeaturesKt.getSEP()), NodeExtKt.getFeatureEntry((Node)node, (int)DefinedFeaturesKt.getTTH()), NodeExtKt.getFeatureEntry((Node)node, (int)DefinedFeaturesKt.getTTW())};
            this.accumulateFeatures(node2, featureEntryArray);
            return;
        }
        if (node instanceof Element) {
            this.calculateAverageFeatures((Element)node);
            Element element = ((Element)node).parent();
            if (element == null) {
                return;
            }
            Element pe = element;
            FeatureEntry[] otn = new FeatureEntry[]{NodeExtKt.getFeatureEntry((Node)node, (int)ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.CH), NodeExtKt.getFeatureEntry((Node)node, (int)DefinedFeaturesKt.getSEP()), NodeExtKt.getFeatureEntry((Node)node, (int)ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.TN), NodeExtKt.getFeatureEntry((Node)node, (int)ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.A), NodeExtKt.getFeatureEntry((Node)node, (int)ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.IMG), NodeExtKt.getFeatureEntry((Node)node, (int)DefinedFeaturesKt.getSIMG()), NodeExtKt.getFeatureEntry((Node)node, (int)DefinedFeaturesKt.getMIMG()), NodeExtKt.getFeatureEntry((Node)node, (int)DefinedFeaturesKt.getLIMG()), NodeExtKt.getFeatureEntry((Node)node, (int)DefinedFeaturesKt.getAIMG()), NodeExtKt.getFeatureEntry((Node)node, (int)DefinedFeaturesKt.getSAIMG()), NodeExtKt.getFeatureEntry((Node)node, (int)DefinedFeaturesKt.getMAIMG()), NodeExtKt.getFeatureEntry((Node)node, (int)DefinedFeaturesKt.getLAIMG()), new FeatureEntry(ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.C, NodeExtKt.isVisible((Node)node)), new FeatureEntry(DefinedFeaturesKt.getD(), NodeExtKt.isVisible((Node)node) ? 1.0 : 0.0 + NodeExtKt.getFeature((Node)node, (int)DefinedFeaturesKt.getD())), NodeExtKt.getFeatureEntry((Node)node, (int)DefinedFeaturesKt.getATW()), NodeExtKt.getFeatureEntry((Node)node, (int)DefinedFeaturesKt.getATH()), NodeExtKt.getFeatureEntry((Node)node, (int)DefinedFeaturesKt.getITW()), NodeExtKt.getFeatureEntry((Node)node, (int)DefinedFeaturesKt.getITH()), NodeExtKt.getFeatureEntry((Node)node, (int)DefinedFeaturesKt.getTTH()), NodeExtKt.getFeatureEntry((Node)node, (int)DefinedFeaturesKt.getTTW())};
            this.accumulateFeatures((Node)pe, otn);
            int[] nArray = new int[]{DefinedFeaturesKt.getCHM(), DefinedFeaturesKt.getTMH(), DefinedFeaturesKt.getTMW(), DefinedFeaturesKt.getAMH(), DefinedFeaturesKt.getAMW(), DefinedFeaturesKt.getIMH(), DefinedFeaturesKt.getIMW()};
            for (int feature : nArray) {
                double value = NodeExtKt.getFeature((Node)node, (int)feature);
                if (!(value > NodeExtKt.getFeature((Node)((Node)pe), (int)feature))) continue;
                NodeExtKt.setFeature((Node)((Node)pe), (int)feature, (double)value);
            }
            Element ppe = pe.parent();
            if (ppe != null) {
                FeatureEntry[] featureEntryArray = new FeatureEntry[]{new FeatureEntry(DefinedFeaturesKt.getG(), 1.0)};
                this.accumulateFeatures((Node)ppe, featureEntryArray);
            }
            List list = node.childNodes();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"childNodes(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Node it = (Node)element$iv;
                boolean bl = false;
                if (!(it instanceof Element)) continue;
                RealVector realVector = ((Element)it).getExtension().getFeatures();
                Intrinsics.checkNotNullExpressionValue((Object)realVector, (String)"getFeatures(...)");
                RealVector realVector2 = ((Element)node).getExtension().getFeatures();
                Intrinsics.checkNotNullExpressionValue((Object)realVector2, (String)"getFeatures(...)");
                VectorsKt.set((RealVector)realVector, (int)ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.SIB, (double)VectorsKt.get((RealVector)realVector2, (int)ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.C));
            }
        }
        RealVector realVector = node.getExtension().getFeatures();
        Intrinsics.checkNotNullExpressionValue((Object)realVector, (String)"getFeatures(...)");
        int n2 = DefinedFeaturesKt.getRTOP();
        RealVector realVector3 = node.getExtension().getFeatures();
        Intrinsics.checkNotNullExpressionValue((Object)realVector3, (String)"getFeatures(...)");
        VectorsKt.set((RealVector)realVector, (int)n2, (double)VectorsKt.get((RealVector)realVector3, (int)ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.TOP));
        RealVector realVector4 = node.getExtension().getFeatures();
        Intrinsics.checkNotNullExpressionValue((Object)realVector4, (String)"getFeatures(...)");
        int n3 = DefinedFeaturesKt.getRLEFT();
        RealVector realVector5 = node.getExtension().getFeatures();
        Intrinsics.checkNotNullExpressionValue((Object)realVector5, (String)"getFeatures(...)");
        VectorsKt.set((RealVector)realVector4, (int)n3, (double)VectorsKt.get((RealVector)realVector5, (int)ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.LEFT));
        RealVector realVector6 = node.getExtension().getFeatures();
        Intrinsics.checkNotNullExpressionValue((Object)realVector6, (String)"getFeatures(...)");
        int n4 = DefinedFeaturesKt.getRSEQ();
        RealVector realVector7 = node.getExtension().getFeatures();
        Intrinsics.checkNotNullExpressionValue((Object)realVector7, (String)"getFeatures(...)");
        VectorsKt.set((RealVector)realVector6, (int)n4, (double)VectorsKt.get((RealVector)realVector7, (int)ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.SEQ));
        if (node == node.getExtension().getOwnerBody()) {
            // empty if block
        }
    }

    private final void calculateBodyFeatures(Node body) {
        DOMRect rect = this.calculateBodyRect(body);
        NodeExtKt.setWidth((Node)body, (int)((int)rect.getWidth()));
        NodeExtKt.setHeight((Node)body, (int)((int)rect.getHeight()));
    }

    private final void calculateAverageFeatures(Element node) {
        NodeExtKt.setFeature((Node)((Node)node), (int)DefinedFeaturesKt.getCHA(), (double)this.divide(node, ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.CH, ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.TN, 0.0));
        NodeExtKt.setFeature((Node)((Node)node), (int)DefinedFeaturesKt.getTAW(), (double)this.divide(node, DefinedFeaturesKt.getTTW(), ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.TN, 0.0));
        NodeExtKt.setFeature((Node)((Node)node), (int)DefinedFeaturesKt.getTAH(), (double)this.divide(node, DefinedFeaturesKt.getTTH(), ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.TN, 0.0));
        NodeExtKt.setFeature((Node)((Node)node), (int)DefinedFeaturesKt.getIAW(), (double)this.divide(node, DefinedFeaturesKt.getITW(), ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.IMG, 0.0));
        NodeExtKt.setFeature((Node)((Node)node), (int)DefinedFeaturesKt.getIAH(), (double)this.divide(node, DefinedFeaturesKt.getITH(), ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.IMG, 0.0));
        NodeExtKt.setFeature((Node)((Node)node), (int)DefinedFeaturesKt.getAAW(), (double)this.divide(node, DefinedFeaturesKt.getATW(), ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.A, 0.0));
        NodeExtKt.setFeature((Node)((Node)node), (int)DefinedFeaturesKt.getAAH(), (double)this.divide(node, DefinedFeaturesKt.getATH(), ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.A, 0.0));
    }

    private final void accumulateFeatures(Node node, FeatureEntry ... features) {
        for (FeatureEntry feature : features) {
            double old = NodeExtKt.getFeature((Node)node, (int)feature.getKey());
            NodeExtKt.setFeature((Node)node, (int)feature.getKey(), (double)(feature.getValue() + old));
        }
    }

    private final DOMRect calculateBodyRect(Node body) {
        double minW = 900.0;
        double maxW = 1500.0;
        DescriptiveStatistics widths = new DescriptiveStatistics();
        widths.addValue(minW);
        Ref.IntRef height = new Ref.IntRef();
        height.element = NodeExtKt.getHeight((Node)body);
        NodesKt.forEachElement$default((Node)body, (boolean)false, (Function1)((Function1)new Function1<Element, Unit>(minW, maxW, widths, height){
            final /* synthetic */ double $minW;
            final /* synthetic */ double $maxW;
            final /* synthetic */ DescriptiveStatistics $widths;
            final /* synthetic */ Ref.IntRef $height;
            {
                this.$minW = $minW;
                this.$maxW = $maxW;
                this.$widths = $widths;
                this.$height = $height;
                super(1);
            }

            public final void invoke(@NotNull Element it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if ((double)NodeExtKt.getWidth((Node)((Node)it)) > this.$minW && (double)NodeExtKt.getWidth((Node)((Node)it)) < this.$maxW) {
                    this.$widths.addValue((double)NodeExtKt.getWidth((Node)((Node)it)));
                }
                if (NodeExtKt.getY2((Node)((Node)it)) > this.$height.element) {
                    this.$height.element = NodeExtKt.getY2((Node)((Node)it));
                }
            }
        }), (int)1, null);
        return new DOMRect(0.0, 0.0, widths.getPercentile(90.0), (double)20 + (double)height.element);
    }

    private final double divide(Element ele, int numerator, int denominator, double divideByZeroValue) {
        double n2 = NodeExtKt.getFeature((Node)((Node)ele), (int)numerator);
        double d = NodeExtKt.getFeature((Node)((Node)ele), (int)denominator);
        return d == 0.0 ? divideByZeroValue : n2 / d;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lai/platon/scent/dom/detail/Level2NodeFeatureCalculatorVisitor$Companion;", "", "()V", "globalNumNodes", "Ljava/util/concurrent/atomic/AtomicInteger;", "getGlobalNumNodes", "()Ljava/util/concurrent/atomic/AtomicInteger;", "scent-dom"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AtomicInteger getGlobalNumNodes() {
            return globalNumNodes;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

