/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.dom.nodes;

import ai.platon.pulsar.common.Frequency;
import ai.platon.pulsar.common.LangKt;
import ai.platon.pulsar.common.ScoreVector;
import ai.platon.pulsar.common.sql.ResultSetFormatter;
import ai.platon.pulsar.ql.common.ResultSets;
import ai.platon.scent.dom.nodes.AnchorGroup;
import ai.platon.scent.dom.nodes.AnchorPartitioner;
import ai.platon.scent.dom.nodes.AnchorSpec;
import ai.platon.scent.dom.nodes.NavigateAnchor;
import ai.platon.scent.dom.nodes.NavigateComponent;
import ai.platon.scent.dom.nodes.node.ext.NodeExtKt;
import java.net.URL;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.similarity.EditDistance;
import org.apache.commons.text.similarity.LevenshteinDistance;
import org.h2.tools.SimpleResultSet;
import org.h2.value.DataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;
import org.nield.kotlinstatistics.NumberStatisticsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 j2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001jB3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0000\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010X\u001a\u00020Y2\f\u0010Z\u001a\b\u0012\u0004\u0012\u00020\u00000\u0013H\u0002J\u0011\u0010[\u001a\u00020\u001c2\u0006\u0010\\\u001a\u00020\u0000H\u0096\u0002J\f\u0010]\u001a\b\u0012\u0004\u0012\u00020\u00000\u0005J\f\u0010^\u001a\b\u0012\u0004\u0012\u00020\u00000\u0005J\u000e\u0010_\u001a\u00020Y2\u0006\u0010`\u001a\u00020aJ\b\u0010b\u001a\u00020\u0003H\u0002J\b\u0010c\u001a\u00020\u0018H\u0002J\u001a\u0010d\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00050*H\u0002J\u001a\u0010e\u001a\u00020\u00032\b\b\u0002\u0010f\u001a\u00020\u00032\b\b\u0002\u0010g\u001a\u00020\u0003J\b\u0010h\u001a\u00020%H\u0002J\b\u0010i\u001a\u00020\u0018H\u0002R!\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00000\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000eR\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR!\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00030 8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010\u0010\u001a\u0004\b!\u0010\"R\u001b\u0010$\u001a\u00020%8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b(\u0010\u0010\u001a\u0004\b&\u0010'R-\u0010)\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00050*8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b-\u0010\u0010\u001a\u0004\b+\u0010,R\u0011\u0010.\u001a\u00020/8F\u00a2\u0006\u0006\u001a\u0004\b0\u00101R#\u00102\u001a\n 3*\u0004\u0018\u00010\u00030\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b6\u0010\u0010\u001a\u0004\b4\u00105R\u0011\u00107\u001a\u00020/8F\u00a2\u0006\u0006\u001a\u0004\b7\u00101R\u0011\u00108\u001a\u00020/8F\u00a2\u0006\u0006\u001a\u0004\b8\u00101R\u0011\u00109\u001a\u00020/8F\u00a2\u0006\u0006\u001a\u0004\b9\u00101R\u0011\u0010:\u001a\u00020/8F\u00a2\u0006\u0006\u001a\u0004\b:\u00101R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u00105R \u0010<\u001a\b\u0012\u0004\u0012\u00020\u001c0=X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010?\"\u0004\b@\u0010AR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010CR\u001b\u0010D\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bF\u0010\u0010\u001a\u0004\bE\u00105R\u0019\u0010G\u001a\n 3*\u0004\u0018\u00010\u00180\u00188F\u00a2\u0006\u0006\u001a\u0004\bH\u0010\u001aR\u0011\u0010I\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\bJ\u0010\u001eR\u0011\u0010K\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\bL\u0010\u001aR!\u0010M\u001a\b\u0012\u0004\u0012\u00020\u00030N8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bQ\u0010\u0010\u001a\u0004\bO\u0010PR!\u0010R\u001a\b\u0012\u0004\u0012\u00020S0N8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bU\u0010\u0010\u001a\u0004\bT\u0010PR\u0011\u0010V\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\bW\u0010\u001a\u00a8\u0006k"}, d2={"Lai/platon/scent/dom/nodes/AnchorGroup;", "", "label", "", "anchors", "", "Lai/platon/scent/dom/nodes/NavigateAnchor;", "parent", "component", "Lai/platon/scent/dom/nodes/NavigateComponent;", "(Ljava/lang/String;Ljava/util/List;Lai/platon/scent/dom/nodes/AnchorGroup;Lai/platon/scent/dom/nodes/NavigateComponent;)V", "anchorSpecs", "Lai/platon/scent/dom/nodes/AnchorSpec;", "getAnchorSpecs", "()Ljava/util/List;", "anchorSpecs$delegate", "Lkotlin/Lazy;", "getAnchors", "children", "", "getChildren", "getComponent", "()Lai/platon/scent/dom/nodes/NavigateComponent;", "cscore", "Lai/platon/pulsar/common/ScoreVector;", "getCscore", "()Lai/platon/pulsar/common/ScoreVector;", "depth", "", "getDepth", "()I", "dictionary", "Lai/platon/pulsar/common/Frequency;", "getDictionary", "()Lai/platon/pulsar/common/Frequency;", "dictionary$delegate", "distortion", "", "getDistortion", "()D", "distortion$delegate", "folds", "", "getFolds", "()Ljava/util/Map;", "folds$delegate", "hasParent", "", "getHasParent", "()Z", "id", "kotlin.jvm.PlatformType", "getId", "()Ljava/lang/String;", "id$delegate", "isEmpty", "isLeaf", "isNotEmpty", "isRoot", "getLabel", "measure", "Lorg/apache/commons/text/similarity/EditDistance;", "getMeasure", "()Lorg/apache/commons/text/similarity/EditDistance;", "setMeasure", "(Lorg/apache/commons/text/similarity/EditDistance;)V", "getParent", "()Lai/platon/scent/dom/nodes/AnchorGroup;", "path", "getPath", "path$delegate", "score", "getScore", "size", "getSize", "sscore", "getSscore", "urlStrings", "Ljava/util/SortedSet;", "getUrlStrings", "()Ljava/util/SortedSet;", "urlStrings$delegate", "urls", "Ljava/net/URL;", "getUrls", "urls$delegate", "vscore", "getVscore", "collectLeafNodesTo", "", "nodes", "compareTo", "other", "flatten", "leafNodes", "partitionBy", "partitioner", "Lai/platon/scent/dom/nodes/AnchorPartitioner;", "pathOf", "similarity", "splitFolds", "toReport", "prefix", "postfix", "totalDistortion", "visionScore", "Companion", "scent-dom"})
@SourceDebugExtension(value={"SMAP\nNavigateDocument.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NavigateDocument.kt\nai/platon/scent/dom/nodes/AnchorGroup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,715:1\n1446#2,5:716\n1855#2,2:721\n1208#2,2:723\n1238#2,2:725\n766#2:727\n857#2,2:728\n1241#2:730\n1549#2:731\n1620#2,3:732\n1549#2:735\n1620#2,3:736\n1549#2:739\n1620#2,3:740\n1549#2:743\n1620#2,3:744\n1603#2,9:747\n1855#2:756\n1963#2,14:757\n1856#2:772\n1612#2:773\n1549#2:774\n1620#2,3:775\n1549#2:778\n1620#2,3:779\n1864#2,2:784\n1866#2:787\n1864#2,2:788\n1864#2,3:790\n1866#2:793\n1855#2,2:794\n1#3:771\n1#3:786\n13309#4,2:782\n*S KotlinDebug\n*F\n+ 1 NavigateDocument.kt\nai/platon/scent/dom/nodes/AnchorGroup\n*L\n156#1:716,5\n168#1:721,2\n174#1:723,2\n174#1:725,2\n175#1:727\n175#1:728,2\n174#1:730\n196#1:731\n196#1:732,3\n197#1:735\n197#1:736,3\n198#1:739\n198#1:740,3\n217#1:743\n217#1:744,3\n219#1:747,9\n219#1:756\n219#1:757,14\n219#1:772\n219#1:773\n220#1:774\n220#1:775,3\n225#1:778\n225#1:779,3\n245#1:784,2\n245#1:787\n258#1:788,2\n259#1:790,3\n258#1:793\n275#1:794,2\n219#1:771\n242#1:782,2\n*E\n"})
public final class AnchorGroup
implements Comparable<AnchorGroup> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String label;
    @NotNull
    private final List<NavigateAnchor> anchors;
    @Nullable
    private final AnchorGroup parent;
    @Nullable
    private final NavigateComponent component;
    @NotNull
    private final Lazy id$delegate;
    @NotNull
    private final Lazy path$delegate;
    @NotNull
    private final List<AnchorGroup> children;
    @NotNull
    private final Lazy urls$delegate;
    @NotNull
    private final Lazy urlStrings$delegate;
    @NotNull
    private EditDistance<Integer> measure;
    @NotNull
    private final Lazy folds$delegate;
    @NotNull
    private final Lazy dictionary$delegate;
    @NotNull
    private final Lazy anchorSpecs$delegate;
    @NotNull
    private final Lazy distortion$delegate;
    @NotNull
    private static final AnchorGroup EMPTY = new AnchorGroup("", CollectionsKt.emptyList(), null, null, 12, null);

    public AnchorGroup(@NotNull String label, @NotNull List<NavigateAnchor> anchors, @Nullable AnchorGroup parent, @Nullable NavigateComponent component) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter(anchors, (String)"anchors");
        this.label = label;
        this.anchors = anchors;
        this.parent = parent;
        this.component = component;
        this.id$delegate = LangKt.usfLazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ AnchorGroup this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final String invoke() {
                return DigestUtils.md5Hex((String)this.this$0.getPath());
            }
        }));
        this.path$delegate = LangKt.usfLazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ AnchorGroup this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return AnchorGroup.access$pathOf(this.this$0);
            }
        }));
        this.children = new ArrayList();
        this.urls$delegate = LangKt.usfLazy((Function0)((Function0)new Function0<TreeSet<URL>>(this){
            final /* synthetic */ AnchorGroup this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final TreeSet<URL> invoke() {
                void var2_2;
                void $this$mapTo$iv;
                Iterable iterable = this.this$0.getAnchors();
                Collection destination$iv = new TreeSet<E>();
                boolean $i$f$mapTo = false;
                for (T item$iv : $this$mapTo$iv) {
                    void it;
                    NavigateAnchor navigateAnchor = (NavigateAnchor)item$iv;
                    Collection collection = destination$iv;
                    boolean bl = false;
                    collection.add(it.getUrl());
                }
                return (TreeSet)var2_2;
            }
        }));
        this.urlStrings$delegate = LangKt.usfLazy((Function0)((Function0)new Function0<TreeSet<String>>(this){
            final /* synthetic */ AnchorGroup this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final TreeSet<String> invoke() {
                void var2_2;
                void $this$mapTo$iv;
                Iterable iterable = this.this$0.getAnchors();
                Collection destination$iv = new TreeSet<E>();
                boolean $i$f$mapTo = false;
                for (T item$iv : $this$mapTo$iv) {
                    void it;
                    NavigateAnchor navigateAnchor = (NavigateAnchor)item$iv;
                    Collection collection = destination$iv;
                    boolean bl = false;
                    collection.add(it.getHref());
                }
                return (TreeSet)var2_2;
            }
        }));
        this.measure = (EditDistance)new LevenshteinDistance();
        this.folds$delegate = LangKt.usfLazy((Function0)((Function0)new Function0<Map<NavigateAnchor, ? extends List<? extends String>>>(this){
            final /* synthetic */ AnchorGroup this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Map<NavigateAnchor, List<String>> invoke() {
                return AnchorGroup.access$splitFolds(this.this$0);
            }
        }));
        this.dictionary$delegate = LangKt.usfLazy((Function0)((Function0)new Function0<Frequency<String>>(this){
            final /* synthetic */ AnchorGroup this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Frequency<String> invoke() {
                void var2_2;
                void $this$flatMapTo$iv;
                Iterable iterable = this.this$0.getFolds().values();
                Collection destination$iv = (Collection)new Frequency(null, 1, null);
                boolean $i$f$flatMapTo = false;
                for (T element$iv : $this$flatMapTo$iv) {
                    List it = (List)element$iv;
                    boolean bl = false;
                    Iterable list$iv = it;
                    CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
                }
                return (Frequency)var2_2;
            }
        }));
        this.anchorSpecs$delegate = LangKt.usfLazy((Function0)((Function0)new Function0<List<? extends AnchorSpec>>(this){
            final /* synthetic */ AnchorGroup this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<AnchorSpec> invoke() {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = this.this$0.getAnchors();
                AnchorGroup anchorGroup = this.this$0;
                boolean $i$f$map = false;
                void var4_4 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    NavigateAnchor navigateAnchor = (NavigateAnchor)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    List list = anchorGroup.getFolds().get(it);
                    if (list == null) {
                        list = CollectionsKt.emptyList();
                    }
                    collection.add(new AnchorSpec((NavigateAnchor)it, list, anchorGroup.getDictionary(), anchorGroup));
                }
                return (List)destination$iv$iv;
            }
        }));
        this.distortion$delegate = LangKt.usfLazy((Function0)((Function0)new Function0<Double>(this){
            final /* synthetic */ AnchorGroup this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Double invoke() {
                return AnchorGroup.access$totalDistortion(this.this$0) / (double)this.this$0.getSize() / (double)this.this$0.getSize();
            }
        }));
    }

    public /* synthetic */ AnchorGroup(String string, List list, AnchorGroup anchorGroup, NavigateComponent navigateComponent, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            anchorGroup = null;
        }
        if ((n2 & 8) != 0) {
            AnchorGroup anchorGroup2 = anchorGroup;
            navigateComponent = anchorGroup2 != null ? anchorGroup2.component : null;
        }
        this(string, list, anchorGroup, navigateComponent);
    }

    @NotNull
    public final String getLabel() {
        return this.label;
    }

    @NotNull
    public final List<NavigateAnchor> getAnchors() {
        return this.anchors;
    }

    @Nullable
    public final AnchorGroup getParent() {
        return this.parent;
    }

    @Nullable
    public final NavigateComponent getComponent() {
        return this.component;
    }

    public final String getId() {
        Lazy lazy = this.id$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final String getPath() {
        Lazy lazy = this.path$delegate;
        return (String)lazy.getValue();
    }

    public final int getSize() {
        return this.anchors.size();
    }

    public final boolean isEmpty() {
        return this.anchors.isEmpty();
    }

    public final boolean isNotEmpty() {
        return !((Collection)this.anchors).isEmpty();
    }

    public final boolean getHasParent() {
        return this.parent != null;
    }

    public final boolean isRoot() {
        return !this.getHasParent();
    }

    public final boolean isLeaf() {
        return this.children.isEmpty();
    }

    public final int getDepth() {
        return this.parent == null ? 1 : 1 + this.parent.getDepth();
    }

    @NotNull
    public final List<AnchorGroup> getChildren() {
        return this.children;
    }

    @NotNull
    public final SortedSet<URL> getUrls() {
        Lazy lazy = this.urls$delegate;
        return (SortedSet)lazy.getValue();
    }

    @NotNull
    public final SortedSet<String> getUrlStrings() {
        Lazy lazy = this.urlStrings$delegate;
        return (SortedSet)lazy.getValue();
    }

    @NotNull
    public final EditDistance<Integer> getMeasure() {
        return this.measure;
    }

    public final void setMeasure(@NotNull EditDistance<Integer> editDistance) {
        Intrinsics.checkNotNullParameter(editDistance, (String)"<set-?>");
        this.measure = editDistance;
    }

    @NotNull
    public final Map<NavigateAnchor, List<String>> getFolds() {
        Lazy lazy = this.folds$delegate;
        return (Map)lazy.getValue();
    }

    @NotNull
    public final Frequency<String> getDictionary() {
        Lazy lazy = this.dictionary$delegate;
        return (Frequency)lazy.getValue();
    }

    @NotNull
    public final List<AnchorSpec> getAnchorSpecs() {
        Lazy lazy = this.anchorSpecs$delegate;
        return (List)lazy.getValue();
    }

    public final double getDistortion() {
        Lazy lazy = this.distortion$delegate;
        return ((Number)lazy.getValue()).doubleValue();
    }

    @NotNull
    public final ScoreVector getCscore() {
        NavigateComponent navigateComponent = this.component;
        if (navigateComponent == null || (navigateComponent = navigateComponent.getScore()) == null) {
            ScoreVector scoreVector = ScoreVector.ZERO;
            navigateComponent = scoreVector;
            Intrinsics.checkNotNullExpressionValue((Object)scoreVector, (String)"ZERO");
        }
        return navigateComponent;
    }

    @NotNull
    public final ScoreVector getSscore() {
        return this.similarity();
    }

    @NotNull
    public final ScoreVector getVscore() {
        return this.visionScore();
    }

    public final ScoreVector getScore() {
        return ScoreVector.combine((ScoreVector)this.getCscore(), (ScoreVector)this.getVscore());
    }

    @NotNull
    public final List<AnchorGroup> flatten() {
        Object[] objectArray = new AnchorGroup[]{this};
        List groups = CollectionsKt.mutableListOf((Object[])objectArray);
        Iterable $this$flatMapTo$iv = this.children;
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            AnchorGroup it = (AnchorGroup)element$iv;
            boolean bl = false;
            Iterable list$iv = it.flatten();
            CollectionsKt.addAll((Collection)groups, (Iterable)list$iv);
        }
        return (List)((Collection)groups);
    }

    @NotNull
    public final List<AnchorGroup> leafNodes() {
        List nodes = new ArrayList();
        this.collectLeafNodesTo(nodes);
        return nodes;
    }

    public final void partitionBy(@NotNull AnchorPartitioner partitioner) {
        Intrinsics.checkNotNullParameter((Object)partitioner, (String)"partitioner");
        partitioner.partitionTo(this, this.children);
        AnchorPartitioner anchorPartitioner = partitioner.getNextPartitioner();
        if (anchorPartitioner == null) {
            return;
        }
        AnchorPartitioner nextPartitioner = anchorPartitioner;
        Iterable $this$forEach$iv = this.children;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AnchorGroup it = (AnchorGroup)element$iv;
            boolean bl = false;
            it.partitionBy(nextPartitioner);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Map<NavigateAnchor, List<String>> splitFolds() {
        void $this$associateByTo$iv$iv;
        Iterable $this$associateBy$iv = this.anchors;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void $this$filterTo$iv$iv;
            NavigateAnchor navigateAnchor = (NavigateAnchor)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            NavigateAnchor it = (NavigateAnchor)element$iv$iv;
            void var22_22 = it;
            boolean bl2 = false;
            String string = it.getUrl().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            String[] stringArray = new String[]{"/"};
            Iterable $this$filter$iv = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                String it2 = (String)element$iv$iv2;
                boolean bl3 = false;
                int n2 = it2.length();
                boolean bl4 = 1 <= n2 ? n2 < 21 : false;
                if (!bl4) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            List list = (List)destination$iv$iv2;
            map.put(var22_22, list);
        }
        return destination$iv$iv;
    }

    private final String pathOf() {
        List labels = new ArrayList();
        labels.add(this.label);
        AnchorGroup p = this.parent;
        while (p != null) {
            labels.add(0, p.label);
            p = p.parent;
        }
        return CollectionsKt.joinToString$default((Iterable)labels, (CharSequence)" > ", null, null, (int)0, null, (Function1)pathOf.1.INSTANCE, (int)30, null);
    }

    /*
     * WARNING - void declaration
     */
    private final ScoreVector similarity() {
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        Collection collection;
        void $this$mapTo$iv$iv3;
        int sz = this.getSize() >= 10 ? 10 : this.getSize();
        Iterable $this$map$iv = this.getUrlStrings();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.length());
        }
        int lengthStd = (int)NumberStatisticsKt.standardDeviation((Iterable)((List)destination$iv$iv));
        Iterable $this$map$iv2 = this.anchors;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            NavigateAnchor bl = (NavigateAnchor)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(NodeExtKt.getSqrtArea((Node)it.getAnchor()));
        }
        int sqrtAreaStd = (int)NumberStatisticsKt.standardDeviation((Iterable)((List)destination$iv$iv2));
        Iterable $this$map$iv3 = this.anchors;
        boolean $i$f$map3 = false;
        destination$iv$iv2 = $this$map$iv3;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            NavigateAnchor bl2 = (NavigateAnchor)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl = false;
            collection.add(ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getWidth((Node)((Node)it.getAnchor())));
        }
        int widthStd = (int)NumberStatisticsKt.standardDeviation((Iterable)((List)destination$iv$iv3));
        int std = lengthStd + sqrtAreaStd + widthStd;
        Object[] objectArray = new Integer[]{sz, -std, 777};
        List factors = CollectionsKt.listOf((Object[])objectArray);
        return new ScoreVector(factors.size(), (Collection)factors);
    }

    /*
     * WARNING - void declaration
     */
    private final ScoreVector visionScore() {
        Iterable $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        if (this.anchors.isEmpty()) {
            ScoreVector scoreVector = ScoreVector.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)scoreVector, (String)"ZERO");
            return scoreVector;
        }
        Iterable $this$map$iv = this.anchors;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            NavigateAnchor navigateAnchor = (NavigateAnchor)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(NodeExtKt.getSqrtArea((Node)it.getAnchor()));
        }
        int sqrtArea2 = (int)CollectionsKt.averageOfDouble((Iterable)((List)destination$iv$iv));
        if (ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.isImageAnchor((Node)((Node)((NavigateAnchor)CollectionsKt.first(this.anchors)).getAnchor()))) {
            Iterable $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = this.anchors;
            boolean $i$f$mapNotNull = false;
            destination$iv$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Element bl = $this$forEach$iv$iv$iv.iterator();
            while (bl.hasNext()) {
                Element it$iv$iv;
                Object v2;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = bl.next();
                boolean bl2 = false;
                NavigateAnchor it = (NavigateAnchor)element$iv$iv;
                boolean bl3 = false;
                Elements elements = it.getAnchor().children();
                Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"children(...)");
                Iterable $this$maxByOrNull$iv = (Iterable)elements;
                boolean $i$f$maxByOrNull = false;
                Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v2 = null;
                } else {
                    Object maxElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        v2 = maxElem$iv;
                    } else {
                        Element it2 = (Element)maxElem$iv;
                        boolean bl4 = false;
                        Intrinsics.checkNotNull((Object)it2);
                        double maxValue$iv = NodeExtKt.getSqrtArea((Node)it2);
                        do {
                            Object e$iv = iterator$iv.next();
                            Element it3 = (Element)e$iv;
                            $i$a$-maxByOrNull-AnchorGroup$visionScore$sqrtArea2$1$1 = false;
                            Intrinsics.checkNotNull((Object)it3);
                            double v$iv = NodeExtKt.getSqrtArea((Node)it3);
                            if (Double.compare(maxValue$iv, v$iv) >= 0) continue;
                            maxElem$iv = e$iv;
                            maxValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        v2 = maxElem$iv;
                    }
                }
                if ((Element)v2 == null) continue;
                boolean bl5 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            Iterable $this$map$iv2 = (List)destination$iv$iv2;
            boolean $i$f$map2 = false;
            $this$mapNotNullTo$iv$iv = $this$map$iv2;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                bl = (Element)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl6 = false;
                collection.add(NodeExtKt.getSqrtArea((Node)it));
            }
            int sqrtArea22 = (int)CollectionsKt.averageOfDouble((Iterable)((List)destination$iv$iv2));
            if (sqrtArea22 > sqrtArea2) {
                sqrtArea2 = sqrtArea22;
            }
        }
        Iterable $this$map$iv3 = this.anchors;
        boolean $i$f$map3 = false;
        $this$mapTo$iv$iv = $this$map$iv3;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            NavigateAnchor it = (NavigateAnchor)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl = false;
            collection.add(NodeExtKt.getEstimatedLeft((Node)it.getAnchor()));
        }
        int left = (int)CollectionsKt.averageOfInt((Iterable)((List)destination$iv$iv3));
        Object[] objectArray = new Integer[]{sqrtArea2 / 10 * 10, -left / 100 * 100, 666};
        List factors = CollectionsKt.listOf((Object[])objectArray);
        return new ScoreVector(factors.size(), (Collection)factors);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String toReport(@NotNull String prefix, @NotNull String postfix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)postfix, (String)"postfix");
        SimpleResultSet rs = new SimpleResultSet();
        String[] stringArray = new String[]{" ", "Display", "Children", "Score", "Distort"};
        String[] $this$forEach$iv = stringArray;
        boolean $i$f$forEach = false;
        int n2 = $this$forEach$iv.length;
        for (int i = 0; i < n2; ++i) {
            String element$iv;
            String it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            rs.addColumn(it, DataType.convertTypeToSQLType((int)13), 0, 0);
        }
        Iterable $this$forEachIndexed$iv = this.children;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void group;
            int n3;
            if ((n3 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            AnchorGroup bl = (AnchorGroup)item$iv;
            int i = n3;
            boolean bl2 = false;
            Comparable[] comparableArray = new Comparable[]{Integer.valueOf(i + 1), group.label, Integer.valueOf(this.children.size()), this.getScore(), Double.valueOf(this.getDistortion())};
            Comparable[] it = comparableArray;
            boolean bl3 = false;
            rs.addRow((Object[])Arrays.copyOf(it, it.length));
        }
        StringBuilder sb = new StringBuilder(prefix);
        String string = sb.append('\n').append(new ResultSetFormatter((ResultSet)rs, false, false, 0, null, 30, null).toString()).append(postfix).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static /* synthetic */ String toReport$default(AnchorGroup anchorGroup, String string, String string2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = "";
        }
        if ((n2 & 2) != 0) {
            string2 = "";
        }
        return anchorGroup.toReport(string, string2);
    }

    /*
     * WARNING - void declaration
     */
    private final double totalDistortion() {
        double distortion2 = 0.0;
        Iterable $this$forEachIndexed$iv = this.getAnchorSpecs();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int n2;
            if ((n2 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            AnchorSpec anchorSpec = (AnchorSpec)item$iv;
            int i = n2;
            boolean bl = false;
            Iterable $this$forEachIndexed$iv2 = this.getAnchorSpecs();
            boolean $i$f$forEachIndexed2 = false;
            int index$iv2 = 0;
            for (Object item$iv2 : $this$forEachIndexed$iv2) {
                void u2;
                void u1;
                int n3;
                if ((n3 = index$iv2++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                AnchorSpec anchorSpec2 = (AnchorSpec)item$iv2;
                int j = n3;
                boolean bl2 = false;
                if (j <= i) continue;
                String s1 = u1.getIdentity();
                String s2 = u2.getIdentity();
                Object object = this.measure.apply((CharSequence)s1, (CharSequence)s2);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"apply(...)");
                distortion2 += ((Number)object).doubleValue();
            }
        }
        return distortion2;
    }

    private final void collectLeafNodesTo(List<AnchorGroup> nodes) {
        if (this.isLeaf()) {
            nodes.add(this);
        } else {
            Iterable $this$forEach$iv = this.children;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AnchorGroup it = (AnchorGroup)element$iv;
                boolean bl = false;
                it.collectLeafNodesTo(nodes);
            }
        }
    }

    @Override
    public int compareTo(@NotNull AnchorGroup other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.getScore().compareTo(other.getScore());
    }

    public static final /* synthetic */ String access$pathOf(AnchorGroup $this) {
        return $this.pathOf();
    }

    public static final /* synthetic */ Map access$splitFolds(AnchorGroup $this) {
        return $this.splitFolds();
    }

    public static final /* synthetic */ double access$totalDistortion(AnchorGroup $this) {
        return $this.totalDistortion();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lai/platon/scent/dom/nodes/AnchorGroup$Companion;", "", "()V", "EMPTY", "Lai/platon/scent/dom/nodes/AnchorGroup;", "getEMPTY", "()Lai/platon/scent/dom/nodes/AnchorGroup;", "toResultSet", "Lorg/h2/tools/SimpleResultSet;", "anchorGroups", "", "scent-dom"})
    @SourceDebugExtension(value={"SMAP\nNavigateDocument.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NavigateDocument.kt\nai/platon/scent/dom/nodes/AnchorGroup$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,715:1\n1#2:716\n1360#3:717\n1446#3,5:718\n1054#3:723\n1864#3,2:724\n1549#3:726\n1620#3,3:727\n1866#3:730\n*S KotlinDebug\n*F\n+ 1 NavigateDocument.kt\nai/platon/scent/dom/nodes/AnchorGroup$Companion\n*L\n290#1:717\n290#1:718,5\n290#1:723\n290#1:724,2\n295#1:726\n295#1:727,3\n290#1:730\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AnchorGroup getEMPTY() {
            return EMPTY;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final SimpleResultSet toResultSet(@NotNull Iterable<AnchorGroup> anchorGroups) {
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter(anchorGroups, (String)"anchorGroups");
            SimpleResultSet rs = ResultSets.newSimpleResultSet();
            String[] stringArray = new String[]{" ", "Id", "Label", "Component", "Dep", "Anchors", "LenStd", "Score", "Distort", "Path"};
            String[] it = stringArray;
            boolean $i$a$-let-AnchorGroup$Companion$toResultSet$22 = false;
            ResultSets.addColumns((SimpleResultSet)rs, (String[])Arrays.copyOf(it, it.length));
            Iterable<AnchorGroup> $this$flatMap$iv = anchorGroups;
            boolean $i$f$flatMap = false;
            Iterable<AnchorGroup> $i$a$-let-AnchorGroup$Companion$toResultSet$22 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                AnchorGroup it2 = (AnchorGroup)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it2.flatten();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable $this$sortedByDescending$iv = (List)destination$iv$iv;
            boolean $i$f$sortedByDescending = false;
            Iterable $this$forEachIndexed$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    AnchorGroup it = (AnchorGroup)b;
                    boolean bl = false;
                    Comparable comparable = (Comparable)it.getScore();
                    it = (AnchorGroup)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)it.getScore()));
                }
            });
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                String distortion2;
                String score2;
                String $this$mapTo$iv$iv;
                void group;
                int n2;
                Object element$iv$iv;
                if ((n2 = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                element$iv$iv = (AnchorGroup)item$iv;
                int i = n2;
                boolean bl = false;
                NavigateComponent component = group.getComponent();
                NavigateComponent navigateComponent = component;
                if (navigateComponent == null || (navigateComponent = navigateComponent.getElement()) == null) continue;
                NavigateComponent e = navigateComponent;
                String name = StringUtils.abbreviateMiddle((String)ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getCanonicalName((Node)((Node)e)), (String)"..", (int)40);
                String label = StringUtils.abbreviateMiddle((String)group.getLabel(), (String)"..", (int)30);
                Iterable $this$map$iv = group.getUrlStrings();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo22 = false;
                Iterator iterator2 = $this$mapTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    void it3;
                    Object item$iv$iv = iterator2.next();
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    collection.add(it3.length());
                }
                int lengthStd = (int)NumberStatisticsKt.standardDeviation((Iterable)((List)destination$iv$iv2));
                $this$mapTo$iv$iv = "%s";
                Object object = new Object[]{group.getScore().toString()};
                Intrinsics.checkNotNullExpressionValue((Object)String.format($this$mapTo$iv$iv, Arrays.copyOf(object, ((Object[])object).length)), (String)"format(...)");
                object = "%.4f";
                Object[] $i$f$mapTo22 = new Object[]{group.getDistortion()};
                Intrinsics.checkNotNullExpressionValue((Object)String.format((String)object, Arrays.copyOf($i$f$mapTo22, $i$f$mapTo22.length)), (String)"format(...)");
                String path6 = group.getPath();
                object = new Object[]{i + 1, group.getId(), label, name, group.getDepth(), group.getSize(), lengthStd, score2, distortion2, path6};
                Object it4 = object;
                boolean bl3 = false;
                rs.addRow(Arrays.copyOf(it4, ((Object[])it4).length));
            }
            Intrinsics.checkNotNull((Object)rs);
            return rs;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

