/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.dom.nodes;

import ai.platon.pulsar.common.math.geometric.AlignType;
import ai.platon.pulsar.dom.nodes.NodesKt;
import ai.platon.scent.dom.nodes.MultiTileCross;
import ai.platon.scent.dom.nodes.MutableTileArray;
import ai.platon.scent.dom.nodes.TileArray;
import ai.platon.scent.dom.nodes.TileArrayKey;
import ai.platon.scent.dom.nodes.TileColumn;
import ai.platon.scent.dom.nodes.TileCross;
import ai.platon.scent.dom.nodes.TileGrid;
import ai.platon.scent.dom.nodes.TileGridBuilder;
import ai.platon.scent.dom.nodes.TileRow;
import ai.platon.scent.dom.nodes.node.ext.NodeCharactersKt;
import ai.platon.scent.dom.nodes.node.ext.NodeExtKt;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u001e\u001a\u00020\u001fJ\b\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020!H\u0002J\u0018\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u00152\u0006\u0010%\u001a\u00020\u0016H\u0002J\u0010\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\n\"\u0004\b\u000f\u0010\fR\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u0006("}, d2={"Lai/platon/scent/dom/nodes/TileGridBuilder;", "", "root", "Lorg/jsoup/nodes/Element;", "ignoreMorbid", "", "(Lorg/jsoup/nodes/Element;Z)V", "minimalHCollinearNodes", "", "getMinimalHCollinearNodes", "()I", "setMinimalHCollinearNodes", "(I)V", "minimalVCollinearNodes", "getMinimalVCollinearNodes", "setMinimalVCollinearNodes", "multiNodeCrossIndexer", "Ljava/util/TreeMap;", "Lorg/jsoup/nodes/Node;", "Lai/platon/scent/dom/nodes/MultiTileCross;", "nodeArrayIndexer", "Lai/platon/scent/dom/nodes/TileArrayKey;", "Lai/platon/scent/dom/nodes/MutableTileArray;", "getRoot", "()Lorg/jsoup/nodes/Element;", "verbose", "getVerbose", "()Z", "setVerbose", "(Z)V", "build", "Lai/platon/scent/dom/nodes/TileGrid;", "buildNodeArrayIndexers", "", "calculateMultiNodeCross", "filterTileArray", "key", "array", "index", "node", "scent-dom"})
@SourceDebugExtension(value={"SMAP\nTileGrid.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TileGrid.kt\nai/platon/scent/dom/nodes/TileGridBuilder\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,306:1\n125#2:307\n152#2,3:308\n215#2:320\n216#2:323\n1855#3,2:311\n1855#3,2:321\n1549#3:324\n1620#3,3:325\n766#3:328\n857#3,2:329\n1194#3,2:331\n1222#3,4:333\n1549#3:337\n1620#3,3:338\n1655#3,8:341\n1549#3:349\n1620#3,3:350\n1655#3,8:353\n526#4:313\n511#4,6:314\n*S KotlinDebug\n*F\n+ 1 TileGrid.kt\nai/platon/scent/dom/nodes/TileGridBuilder\n*L\n244#1:307\n244#1:308,3\n267#1:320\n267#1:323\n246#1:311,2\n272#1:321,2\n293#1:324\n293#1:325,3\n294#1:328\n294#1:329,2\n295#1:331,2\n295#1:333,4\n296#1:337\n296#1:338,3\n296#1:341,8\n297#1:349\n297#1:350,3\n297#1:353,8\n264#1:313\n264#1:314,6\n*E\n"})
public final class TileGridBuilder {
    @NotNull
    private final Element root;
    private final boolean ignoreMorbid;
    private int minimalVCollinearNodes;
    private int minimalHCollinearNodes;
    private boolean verbose;
    @NotNull
    private final TreeMap<TileArrayKey, MutableTileArray> nodeArrayIndexer;
    @NotNull
    private final TreeMap<Node, MultiTileCross> multiNodeCrossIndexer;

    public TileGridBuilder(@NotNull Element root, boolean ignoreMorbid) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.root = root;
        this.ignoreMorbid = ignoreMorbid;
        this.minimalVCollinearNodes = 4;
        this.minimalHCollinearNodes = 2;
        this.nodeArrayIndexer = new TreeMap();
        this.multiNodeCrossIndexer = new TreeMap(NodesKt.getNodePositionComparator());
    }

    public /* synthetic */ TileGridBuilder(Element element, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            bl = true;
        }
        this(element, bl);
    }

    @NotNull
    public final Element getRoot() {
        return this.root;
    }

    public final int getMinimalVCollinearNodes() {
        return this.minimalVCollinearNodes;
    }

    public final void setMinimalVCollinearNodes(int n2) {
        this.minimalVCollinearNodes = n2;
    }

    public final int getMinimalHCollinearNodes() {
        return this.minimalHCollinearNodes;
    }

    public final void setMinimalHCollinearNodes(int n2) {
        this.minimalHCollinearNodes = n2;
    }

    public final boolean getVerbose() {
        return this.verbose;
    }

    public final void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    /*
     * WARNING - void declaration
     */
    private final void index(Node node) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Document doc = ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getOwnerDocument((Node)node);
        Dimension oldGrid = ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getGrid((Document)doc);
        ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.setGrid((Document)doc, (Dimension)ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getSecondaryGrid((Document)doc));
        Object object = new Pair[]{TuplesKt.to((Object)NodeExtKt.getAlignedX(node), (Object)AlignType.LEFT), TuplesKt.to((Object)NodeExtKt.getAlignedCenterX(node), (Object)AlignType.V_CENTER), TuplesKt.to((Object)NodeExtKt.getAlignedX2(node), (Object)AlignType.RIGHT), TuplesKt.to((Object)NodeExtKt.getAlignedY(node), (Object)AlignType.TOP), TuplesKt.to((Object)NodeExtKt.getAlignedCenterY(node), (Object)AlignType.H_CENTER), TuplesKt.to((Object)NodeExtKt.getAlignedY2(node), (Object)AlignType.BOTTOM)};
        object = MapsKt.mapOf((Pair[])object);
        boolean $i$f$map = false;
        Iterator iterator2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator3 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator3.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator3.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new TileArrayKey(((Number)it.getKey()).intValue(), (AlignType)it.getValue()));
        }
        List keys = (List)destination$iv$iv;
        Iterable $this$forEach$iv = keys;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TileArrayKey key = (TileArrayKey)element$iv;
            boolean bl = false;
            this.nodeArrayIndexer.computeIfAbsent(key, arg_0 -> TileGridBuilder.index$lambda$2$lambda$1(index.1.1.INSTANCE, arg_0)).getTiles().add(node);
        }
        ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.setGrid((Document)doc, (Dimension)oldGrid);
    }

    private final void buildNodeArrayIndexers() {
        NodesKt.forEach$default((Node)((Node)this.root), (boolean)false, (Function1)((Function1)new Function1<Node, Unit>(this){
            final /* synthetic */ TileGridBuilder this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Node it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (NodeCharactersKt.isTile(it)) {
                    TileGridBuilder.access$index(this.this$0, it);
                }
            }
        }), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void calculateMultiNodeCross() {
        Map array;
        Map map;
        Object object;
        if (this.ignoreMorbid) {
            void $this$filterTo$iv$iv;
            Map $this$filter$iv = this.nodeArrayIndexer;
            boolean $i$f$filter = false;
            object = $this$filter$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator2.next();
                boolean bl = false;
                if (!this.filterTileArray((TileArrayKey)it.getKey(), (MutableTileArray)it.getValue())) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            map = destination$iv$iv;
        } else {
            map = this.nodeArrayIndexer;
        }
        Map $this$forEach$iv = array = map;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = (Map.Entry)object.next();
            boolean bl = false;
            TileArrayKey key = (TileArrayKey)entry.getKey();
            MutableTileArray nodeArray = (MutableTileArray)entry.getValue();
            if (!this.verbose || key.getAlignType().isVertical()) {
                // empty if block
            }
            Iterable $this$forEach$iv2 = nodeArray.getTiles();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                MultiTileCross cross2;
                Node node = (Node)element$iv2;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)this.multiNodeCrossIndexer.computeIfAbsent(node, arg_0 -> TileGridBuilder.calculateMultiNodeCross$lambda$6$lambda$5$lambda$4(calculateMultiNodeCross.1.1.cross.1.INSTANCE, arg_0)), (String)"computeIfAbsent(...)");
                ((Map)cross2.getNodeArrays()).put(key, nodeArray);
            }
        }
    }

    private final boolean filterTileArray(TileArrayKey key, MutableTileArray array) {
        boolean isVertical = key.getAlignType().isVertical() && array.getSize() >= this.minimalVCollinearNodes;
        boolean isHorizontal = key.getAlignType().isHorizontal() && array.getSize() >= this.minimalHCollinearNodes;
        return isVertical || isHorizontal;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TileGrid build() {
        void $this$distinctBy$iv;
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        Iterable $this$associateByTo$iv$iv;
        void $this$filterTo$iv$iv;
        Comparable<TileCross> it;
        Object object;
        Iterable $this$mapTo$iv$iv3;
        this.buildNodeArrayIndexers();
        this.calculateMultiNodeCross();
        Collection<MultiTileCross> collection = this.multiNodeCrossIndexer.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            MultiTileCross multiTileCross = (MultiTileCross)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(((MultiTileCross)it).findBiggestCross());
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv3 = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (TileCross)element$iv$iv;
            boolean bl = false;
            if (!(!((TileCross)it).isEmpty())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$associateBy$iv = (List)destination$iv$iv;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        Object destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it2;
            TileCross bl = (TileCross)element$iv$iv;
            object = destination$iv$iv2;
            boolean bl2 = false;
            object.put(it2.getTile(), element$iv$iv);
        }
        Map crosses = destination$iv$iv2;
        Iterable $this$map$iv2 = crosses.values();
        boolean $i$f$map2 = false;
        $this$associateByTo$iv$iv = $this$map$iv2;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            TileCross it2 = (TileCross)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            object.add(new TileColumn(it2.getColumn()));
        }
        Iterable $this$distinctBy$iv2 = (List)destination$iv$iv2;
        boolean $i$f$distinctBy = false;
        HashSet<TileArrayKey> set$iv = new HashSet<TileArrayKey>();
        Iterable list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv2) {
            it = (TileColumn)e$iv;
            boolean bl = false;
            TileArrayKey key$iv = ((TileArray)it).getKey();
            if (!set$iv.add(key$iv)) continue;
            ((ArrayList)list$iv).add(e$iv);
        }
        List columns = (List)list$iv;
        Iterable $this$map$iv3 = crosses.values();
        boolean $i$f$map3 = false;
        list$iv = $this$map$iv3;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it3;
            TileCross bl = (TileCross)item$iv$iv;
            object = destination$iv$iv3;
            boolean bl3 = false;
            object.add(new TileRow(it3.getRow()));
        }
        $this$map$iv3 = (List)destination$iv$iv3;
        boolean $i$f$distinctBy2 = false;
        HashSet<TileArrayKey> set$iv2 = new HashSet<TileArrayKey>();
        ArrayList list$iv2 = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            TileRow it4 = (TileRow)e$iv;
            boolean bl = false;
            TileArrayKey key$iv = it4.getKey();
            if (!set$iv2.add(key$iv)) continue;
            list$iv2.add(e$iv);
        }
        List rows = list$iv2;
        if (!((Collection)columns).isEmpty()) {
            // empty if block
        }
        return new TileGrid(columns, rows, crosses);
    }

    private static final MutableTileArray index$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (MutableTileArray)$tmp0.invoke(p0);
    }

    private static final MultiTileCross calculateMultiNodeCross$lambda$6$lambda$5$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (MultiTileCross)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$index(TileGridBuilder $this, Node node) {
        $this.index(node);
    }
}

