/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.dom.nodes;

import ai.platon.pulsar.common.math.geometric.GeoIntPoint;
import ai.platon.scent.dom.nodes.DirectedGeometricGraph;
import ai.platon.scent.dom.nodes.NodeVertex;
import ai.platon.scent.dom.nodes.UnitGrid;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.math3.Field;
import org.apache.commons.math3.FieldElement;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.linear.Array2DRowFieldMatrix;
import org.apache.commons.math3.linear.FieldMatrix;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0003\u00a2\u0006\u0002\u0010\u0005J\u0011\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0004H\u0086\u0002J\u0013\u0010\u001b\u001a\u00020\u00192\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u001a\u0010\u001d\u001a\u00020\u001e2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001e0 J&\u0010!\u001a\u00020\u001e2\u001e\u0010\u001f\u001a\u001a\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001e0\"J\u0011\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020%H\u0086\u0002J\u001c\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010&\u001a\u00020\nH\u0086\u0002\u00a2\u0006\u0002\u0010'J\u0019\u0010#\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\n2\u0006\u0010(\u001a\u00020\nH\u0086\u0002J\u0019\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010*\u001a\u00020\n\u00a2\u0006\u0002\u0010'J\f\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,J\u0010\u0010.\u001a\u0004\u0018\u00010%2\u0006\u0010\u001a\u001a\u00020\u0004J\u0010\u0010/\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u001c\u001a\u00020\u0000J\u0019\u00100\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u00101\u001a\u00020\n\u00a2\u0006\u0002\u0010'J&\u00102\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\n2\u0006\u0010(\u001a\u00020\n2\u0006\u00103\u001a\u00020\n2\u0006\u00104\u001a\u00020\nJ\u0016\u00105\u001a\u0002062\u0006\u0010&\u001a\u00020\n2\u0006\u0010(\u001a\u00020\nJ\b\u00107\u001a\u00020\nH\u0016J\u0006\u00108\u001a\u00020\u0019J\u0006\u00109\u001a\u00020\u0019J\u0006\u0010:\u001a\u00020\u0019J\u0019\u0010;\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020%2\u0006\u0010<\u001a\u00020\u0004H\u0086\u0002J$\u0010;\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\n2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0086\u0002\u00a2\u0006\u0002\u0010=J!\u0010;\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\n2\u0006\u0010(\u001a\u00020\n2\u0006\u0010<\u001a\u00020\u0004H\u0086\u0002J\u0006\u0010>\u001a\u00020?J\u0006\u0010@\u001a\u00020?J\b\u0010A\u001a\u00020BH\u0016J\f\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00040DR\u001f\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0003\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\u0011\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\fR\u0011\u0010\u0016\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0013\u00a8\u0006E"}, d2={"Lai/platon/scent/dom/nodes/DiagonalOrientedGrid;", "", "grid", "", "Lai/platon/scent/dom/nodes/NodeVertex;", "([[Lai/platon/scent/dom/nodes/NodeVertex;)V", "getGrid", "()[[Lai/platon/scent/dom/nodes/NodeVertex;", "[[Lai/platon/scent/dom/nodes/NodeVertex;", "m", "", "getM", "()I", "n", "getN", "order", "getOrder", "sink", "getSink", "()Lai/platon/scent/dom/nodes/NodeVertex;", "size", "getSize", "source", "getSource", "contains", "", "v", "equals", "other", "forEach", "", "action", "Lkotlin/Function1;", "forEachIndexed", "Lkotlin/Function3;", "get", "point", "Lai/platon/pulsar/common/math/geometric/GeoIntPoint;", "row", "(I)[Lai/platon/scent/dom/nodes/NodeVertex;", "col", "getColumn", "j", "getFieldMatrix", "Lorg/apache/commons/math3/linear/FieldMatrix;", "Lorg/apache/commons/math3/complex/Complex;", "getLocation", "getMaximumCommonGrid", "getRow", "i", "getSubGrid", "ms", "ns", "getUnitGrid", "Lai/platon/scent/dom/nodes/UnitGrid;", "hashCode", "isEmpty", "isNull", "isUnitGrid", "set", "data", "(I[Lai/platon/scent/dom/nodes/NodeVertex;)V", "toEmptyGraph", "Lai/platon/scent/dom/nodes/DirectedGeometricGraph;", "toGraph", "toString", "", "vertexSet", "", "scent-dom"})
@SourceDebugExtension(value={"SMAP\nGeometricGraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeometricGraph.kt\nai/platon/scent/dom/nodes/DiagonalOrientedGrid\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,1146:1\n13309#2:1147\n13309#2,2:1148\n13310#2:1150\n*S KotlinDebug\n*F\n+ 1 GeometricGraph.kt\nai/platon/scent/dom/nodes/DiagonalOrientedGrid\n*L\n425#1:1147\n426#1:1148,2\n425#1:1150\n*E\n"})
public final class DiagonalOrientedGrid {
    @NotNull
    private final NodeVertex[][] grid;

    public DiagonalOrientedGrid(@NotNull NodeVertex[][] grid) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        this.grid = grid;
    }

    public /* synthetic */ DiagonalOrientedGrid(NodeVertex[][] nodeVertexArray, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            nodeVertexArray = new NodeVertex[][]{};
        }
        this(nodeVertexArray);
    }

    @NotNull
    public final NodeVertex[][] getGrid() {
        return this.grid;
    }

    public final int getM() {
        return ((Object[])this.grid).length;
    }

    public final int getN() {
        return ((Object[])this.grid).length == 0 ? 0 : this.grid[0].length;
    }

    public final int getOrder() {
        return this.getM() * this.getN();
    }

    public final int getSize() {
        int a = this.getM();
        int b = this.getN();
        return (a - 1) * b + a * (b - 1);
    }

    @NotNull
    public final NodeVertex getSource() {
        return this.grid[0][0];
    }

    @NotNull
    public final NodeVertex getSink() {
        return this.grid[this.getM() - 1][this.getN() - 1];
    }

    @NotNull
    public final NodeVertex[] get(int row) {
        return this.grid[row];
    }

    public final void set(int row, @NotNull NodeVertex[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.grid[row] = data;
    }

    @NotNull
    public final NodeVertex get(int row, int col) {
        return this.grid[row][col];
    }

    public final void set(int row, int col, @NotNull NodeVertex data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.grid[row][col] = data;
    }

    @NotNull
    public final NodeVertex get(@NotNull GeoIntPoint point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        return this.grid[point.getY()][point.getX()];
    }

    public final void set(@NotNull GeoIntPoint point, @NotNull NodeVertex data) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.grid[point.getY()][point.getX()] = data;
    }

    @NotNull
    public final NodeVertex[] getRow(int i) {
        return this.grid[i];
    }

    @NotNull
    public final NodeVertex[] getColumn(int j) {
        int n2 = 0;
        int n3 = this.getM();
        NodeVertex[] nodeVertexArray = new NodeVertex[n3];
        while (n2 < n3) {
            int n4 = n2++;
            nodeVertexArray[n4] = NodeVertex.Companion.getNil();
        }
        NodeVertex[] column = nodeVertexArray;
        n3 = this.getM();
        for (int i = 0; i < n3; ++i) {
            column[i] = this.grid[i][j];
        }
        return column;
    }

    public final boolean isNull() {
        return ((Object[])this.grid).length == 0;
    }

    public final boolean isEmpty() {
        return ((Object[])this.grid).length == 0;
    }

    public final boolean isUnitGrid() {
        return ((Object[])this.grid).length == 2 && this.grid[0].length == 2;
    }

    public final boolean contains(@NotNull NodeVertex v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return this.getLocation(v) != null;
    }

    @Nullable
    public final GeoIntPoint getLocation(@NotNull NodeVertex v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        int n2 = this.getM();
        for (int i = 0; i < n2; ++i) {
            int n3 = this.getN();
            for (int j = 0; j < n3; ++j) {
                if (!Intrinsics.areEqual((Object)this.grid[i][j], (Object)v)) continue;
                return new GeoIntPoint(i, j);
            }
        }
        return null;
    }

    @NotNull
    public final Set<NodeVertex> vertexSet() {
        HashSet<NodeVertex> vertices = new HashSet<NodeVertex>();
        this.forEach((Function1<? super NodeVertex, Unit>)((Function1)new Function1<NodeVertex, Unit>(vertices){
            final /* synthetic */ HashSet<NodeVertex> $vertices;
            {
                this.$vertices = $vertices;
                super(1);
            }

            public final void invoke(@NotNull NodeVertex it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$vertices.add(it);
            }
        }));
        return vertices;
    }

    @NotNull
    public final UnitGrid getUnitGrid(int row, int col) {
        int i = row;
        int j = col;
        return new UnitGrid(this.grid[i][j], this.grid[i][j + 1], this.grid[i + 1][j], this.grid[i + 1][j + 1]);
    }

    @NotNull
    public final DiagonalOrientedGrid getSubGrid(int row, int col, int ms, int ns) {
        int n2 = ms - row;
        NodeVertex[][] nodeVertexArray = new NodeVertex[n2][];
        for (int i = 0; i < n2; ++i) {
            int n3 = i;
            int n4 = 0;
            int n5 = ns - col;
            NodeVertex[] nodeVertexArray2 = new NodeVertex[n5];
            int n6 = n3;
            NodeVertex[][] nodeVertexArray3 = nodeVertexArray;
            while (n4 < n5) {
                int n7 = n4++;
                nodeVertexArray2[n7] = NodeVertex.Companion.getNil();
            }
            nodeVertexArray3[n6] = nodeVertexArray2;
        }
        NodeVertex[][] subGrid = nodeVertexArray;
        for (int i = row; i < ms; ++i) {
            for (int j = col; j < ns; ++j) {
                subGrid[i - row][j - col] = this.grid[i][j];
            }
        }
        return new DiagonalOrientedGrid(subGrid);
    }

    @Nullable
    public final DiagonalOrientedGrid getMaximumCommonGrid(@NotNull DiagonalOrientedGrid other) {
        int n2;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (other.isNull()) {
            return null;
        }
        GeoIntPoint geoIntPoint = this.getLocation(other.getSource());
        if (geoIntPoint == null) {
            return null;
        }
        GeoIntPoint geoIntPoint2 = geoIntPoint;
        int x = geoIntPoint2.component1();
        int y = geoIntPoint2.component2();
        int ms = Math.min(this.getM() - y, other.getM());
        int ns = Math.min(this.getN() - x, other.getN());
        while (--ms > 0 && --ns > 0 && !Intrinsics.areEqual((Object)this.grid[ms][ns], (Object)other.grid[ms][ns])) {
        }
        if (ms <= 0 || ns <= 0) {
            return null;
        }
        int n3 = ms;
        NodeVertex[][] nodeVertexArray = new NodeVertex[n3][];
        for (int i = 0; i < n3; ++i) {
            n2 = i;
            int n4 = 0;
            int n5 = ns;
            NodeVertex[] nodeVertexArray2 = new NodeVertex[n5];
            int n6 = n2;
            NodeVertex[][] nodeVertexArray3 = nodeVertexArray;
            while (n4 < n5) {
                int n7 = n4++;
                nodeVertexArray2[n7] = NodeVertex.Companion.getNil();
            }
            nodeVertexArray3[n6] = nodeVertexArray2;
        }
        NodeVertex[][] commonGrid = nodeVertexArray;
        n3 = ms;
        for (int i = y; i < n3; ++i) {
            n2 = ns;
            for (int j = x; j < n2; ++j) {
                NodeVertex v1 = this.grid[i][j];
                NodeVertex v2 = other.grid[i][j];
                if (!Intrinsics.areEqual((Object)v1, (Object)v2)) {
                    return new DiagonalOrientedGrid(null, 1, null);
                }
                commonGrid[i][j] = v1;
            }
        }
        return new DiagonalOrientedGrid(commonGrid);
    }

    @NotNull
    public final FieldMatrix<Complex> getFieldMatrix() {
        Array2DRowFieldMatrix matrix = new Array2DRowFieldMatrix((Field)Complex.ZERO.getField(), this.getM(), this.getN());
        int n2 = this.getM();
        for (int i = 0; i < n2; ++i) {
            int n3 = this.getN();
            for (int j = 0; j < n3; ++j) {
                Complex data = new Complex((double)this.grid[i][j].getData().x, (double)this.grid[i][j].getData().y);
                matrix.setEntry(i, j, (FieldElement)data);
            }
        }
        return (FieldMatrix)matrix;
    }

    @NotNull
    public final DirectedGeometricGraph toGraph() {
        DirectedGeometricGraph graph = new DirectedGeometricGraph(new Pair[0]);
        int n2 = ((Object[])this.grid).length - 1;
        for (int i = 0; i < n2; ++i) {
            int n3 = this.grid[i].length - 1;
            for (int j = 0; j < n3; ++j) {
                graph.addGrid(this.getUnitGrid(i, j));
            }
        }
        return graph;
    }

    @NotNull
    public final DirectedGeometricGraph toEmptyGraph() {
        DirectedGeometricGraph graph = new DirectedGeometricGraph(new Pair[0]);
        Object[] $this$forEach$iv = (Object[])this.grid;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NodeVertex[] rows = (NodeVertex[])element$iv;
            boolean bl = false;
            NodeVertex[] $this$forEach$iv2 = rows;
            boolean $i$f$forEach2 = false;
            int n2 = $this$forEach$iv2.length;
            for (int i = 0; i < n2; ++i) {
                NodeVertex element$iv2;
                NodeVertex it = element$iv2 = $this$forEach$iv2[i];
                boolean bl2 = false;
                graph.addVertex(it);
            }
        }
        return graph;
    }

    public final void forEach(@NotNull Function1<? super NodeVertex, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        int i = 0;
        int n2 = this.getM();
        if (i <= n2) {
            while (true) {
                int n3;
                int j;
                if ((j = 0) <= (n3 = this.getN())) {
                    while (true) {
                        action.invoke((Object)this.get(i, j));
                        if (j == n3) break;
                        ++j;
                    }
                }
                if (i == n2) break;
                ++i;
            }
        }
    }

    public final void forEachIndexed(@NotNull Function3<? super Integer, ? super Integer, ? super NodeVertex, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        int i = 0;
        int n2 = this.getM();
        if (i <= n2) {
            while (true) {
                int n3;
                int j;
                if ((j = 0) <= (n3 = this.getN())) {
                    while (true) {
                        action.invoke((Object)i, (Object)j, (Object)this.get(i, j));
                        if (j == n3) break;
                        ++j;
                    }
                }
                if (i == n2) break;
                ++i;
            }
        }
    }

    public int hashCode() {
        int hash = 0;
        int n2 = this.getM();
        for (int i = 0; i < n2; ++i) {
            int n3 = this.getN();
            for (int j = 0; j < n3; ++j) {
                hash = hash * 31 + this.grid[i][j].hashCode();
            }
        }
        return hash;
    }

    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof DiagonalOrientedGrid) || this.getM() != ((DiagonalOrientedGrid)other).getM() || this.getN() != ((DiagonalOrientedGrid)other).getN()) {
            return false;
        }
        int i = 0;
        int n2 = this.getM();
        if (i <= n2) {
            while (true) {
                int n3;
                int j;
                if ((j = 0) <= (n3 = this.getN())) {
                    while (true) {
                        if (!Intrinsics.areEqual((Object)this.grid[i][j], (Object)((DiagonalOrientedGrid)other).grid[i][j])) {
                            return false;
                        }
                        if (j == n3) break;
                        ++j;
                    }
                }
                if (i == n2) break;
                ++i;
            }
        }
        return true;
    }

    @NotNull
    public String toString() {
        return "G_" + this.getM() + "x" + this.getN();
    }

    public DiagonalOrientedGrid() {
        this(null, 1, null);
    }
}

