/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.dom.nodes;

import ai.platon.scent.dom.nodes.DiagonalOrientedFrame;
import ai.platon.scent.dom.nodes.DiagonalOrientedGrid;
import ai.platon.scent.dom.nodes.GridPattern;
import ai.platon.scent.dom.nodes.NodeVertex;
import ai.platon.scent.dom.nodes.node.ext.NodeExtKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Node;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u00a8\u0006\u0003"}, d2={"calculateTabularPattern", "Lai/platon/scent/dom/nodes/GridPattern;", "Lai/platon/scent/dom/nodes/DiagonalOrientedFrame;", "scent-dom"})
@SourceDebugExtension(value={"SMAP\nGeometricGraphs.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeometricGraphs.kt\nai/platon/scent/dom/nodes/GeometricGraphsKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,134:1\n12634#2,3:135\n12634#2,3:138\n*S KotlinDebug\n*F\n+ 1 GeometricGraphs.kt\nai/platon/scent/dom/nodes/GeometricGraphsKt\n*L\n119#1:135,3\n120#1:138,3\n*E\n"})
public final class GeometricGraphsKt {
    @NotNull
    public static final GridPattern calculateTabularPattern(@NotNull DiagonalOrientedFrame $this$calculateTabularPattern) {
        Intrinsics.checkNotNullParameter((Object)$this$calculateTabularPattern, (String)"<this>");
        GridPattern tabularType = GridPattern.OTHER;
        DiagonalOrientedGrid grid = $this$calculateTabularPattern.getPrincipalGrid();
        if (grid.isEmpty()) {
            return GridPattern.OTHER;
        }
        Node node = grid.getSource().getData().getNode();
        if (node == null) {
            return GridPattern.OTHER;
        }
        Node root = node;
        int m = grid.getM();
        int n2 = grid.getN();
        if (m < 2 || n2 < 2) {
            return GridPattern.OTHER;
        }
        if (m == 2 && n2 > m) {
            return GridPattern.ROW2;
        }
        int minimumBipartileTableCollinearConsts = 2;
        if (NodeExtKt.getAccumVCConstants(root) >= minimumBipartileTableCollinearConsts) {
            switch (n2) {
                case 2: {
                    tabularType = GridPattern.COL2;
                    break;
                }
                case 4: {
                    tabularType = GridPattern.COL4;
                    break;
                }
                case 6: {
                    tabularType = GridPattern.COL6;
                }
            }
            return tabularType;
        }
        NodeVertex[] row0 = grid.get(0);
        NodeVertex[] col0 = grid.getColumn(0);
        NodeVertex[] $this$count$iv = row0;
        boolean $i$f$count = false;
        int count$iv = 0;
        int n3 = $this$count$iv.length;
        for (int i = 0; i < n3; ++i) {
            NodeVertex element$iv;
            NodeVertex it = element$iv = $this$count$iv[i];
            boolean bl = false;
            Node node2 = it.getData().getNode();
            boolean bl2 = node2 != null ? NodeExtKt.isLocallyConstant(node2) : false;
            if (!bl2) continue;
            ++count$iv;
        }
        int c1 = count$iv;
        NodeVertex[] $this$count$iv2 = col0;
        boolean $i$f$count2 = false;
        int count$iv2 = 0;
        int n4 = $this$count$iv2.length;
        for (n3 = 0; n3 < n4; ++n3) {
            NodeVertex element$iv;
            NodeVertex it = element$iv = $this$count$iv2[n3];
            boolean bl = false;
            Node node3 = it.getData().getNode();
            boolean bl3 = node3 != null ? NodeExtKt.isLocallyConstant(node3) : false;
            if (!bl3) continue;
            ++count$iv2;
        }
        int c2 = count$iv2;
        double rate1 = (double)c1 / (double)m;
        double rate2 = (double)c2 / (double)n2;
        if (rate1 > 0.5 && rate2 > 0.5) {
            tabularType = GridPattern.DUAL_HEAD;
        } else if (rate1 > 0.5) {
            tabularType = GridPattern.COL_HEAD;
        } else if (rate2 > 0.5) {
            tabularType = GridPattern.ROW_HEAD;
        }
        return tabularType;
    }
}

