/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.dom.nodes;

import ai.platon.pulsar.dom.nodes.NodesKt;
import ai.platon.scent.dom.nodes.TileArray;
import ai.platon.scent.dom.nodes.TileArrayKey;
import ai.platon.scent.dom.nodes.TileCross;
import ai.platon.scent.dom.nodes.TileGridKt;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Node;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0000H\u0096\u0002J\u0006\u0010\u0010\u001a\u00020\u0011R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lai/platon/scent/dom/nodes/MultiTileCross;", "", "tile", "Lorg/jsoup/nodes/Node;", "(Lorg/jsoup/nodes/Node;)V", "nodeArrays", "Ljava/util/HashMap;", "Lai/platon/scent/dom/nodes/TileArrayKey;", "Lai/platon/scent/dom/nodes/TileArray;", "getNodeArrays", "()Ljava/util/HashMap;", "getTile", "()Lorg/jsoup/nodes/Node;", "compareTo", "", "other", "findBiggestCross", "Lai/platon/scent/dom/nodes/TileCross;", "scent-dom"})
public final class MultiTileCross
implements Comparable<MultiTileCross> {
    @NotNull
    private final Node tile;
    @NotNull
    private final HashMap<TileArrayKey, TileArray> nodeArrays;

    public MultiTileCross(@NotNull Node tile) {
        Intrinsics.checkNotNullParameter((Object)tile, (String)"tile");
        this.tile = tile;
        this.nodeArrays = new HashMap();
    }

    @NotNull
    public final Node getTile() {
        return this.tile;
    }

    @NotNull
    public final HashMap<TileArrayKey, TileArray> getNodeArrays() {
        return this.nodeArrays;
    }

    @NotNull
    public final TileCross findBiggestCross() {
        if (!(!((Map)this.nodeArrays).isEmpty())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        TileArray column = TileGridKt.getNoneTileArray();
        TileArray row = TileGridKt.getNoneTileArray();
        for (Map.Entry entry : ((Map)this.nodeArrays).entrySet()) {
            TileArrayKey key = (TileArrayKey)entry.getKey();
            TileArray array = (TileArray)entry.getValue();
            if (!array.getTiles().contains(this.tile)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (key.getAlignType().isVertical() && array.getSize() > column.getSize()) {
                column = array;
                continue;
            }
            if (!key.getAlignType().isHorizontal() || array.getSize() <= row.getSize()) continue;
            row = array;
        }
        return new TileCross(this.tile, column, row);
    }

    @Override
    public int compareTo(@NotNull MultiTileCross other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return NodesKt.getNodePositionComparator().compare(this.tile, other.tile);
    }
}

