/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.dom.nodes;

import ai.platon.pulsar.common.LangKt;
import ai.platon.pulsar.common.urls.URLUtils;
import ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt;
import ai.platon.scent.dom.nodes.NavigateComponent;
import java.net.URL;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0011\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010#\u001a\u00020\u00072\b\u0010\"\u001a\u0004\u0018\u00010$H\u0096\u0002J\b\u0010%\u001a\u00020!H\u0016J\u000e\u0010&\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020\u0003J\b\u0010(\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u0014\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\u0015\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010R\u001b\u0010\u0017\u001a\u00020\u00188FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u0019\u0010\u001aR\u001d\u0010\u001d\u001a\u0004\u0018\u00010\u00188FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\u001c\u001a\u0004\b\u001e\u0010\u001a\u00a8\u0006)"}, d2={"Lai/platon/scent/dom/nodes/NavigateAnchor;", "", "anchor", "Lorg/jsoup/nodes/Element;", "component", "Lai/platon/scent/dom/nodes/NavigateComponent;", "ignoreUrlQuery", "", "(Lorg/jsoup/nodes/Element;Lai/platon/scent/dom/nodes/NavigateComponent;Z)V", "getAnchor", "()Lorg/jsoup/nodes/Element;", "getComponent", "()Lai/platon/scent/dom/nodes/NavigateComponent;", "href", "", "getHref", "()Ljava/lang/String;", "getIgnoreUrlQuery", "()Z", "isItemLike", "isValid", "text", "getText", "url", "Ljava/net/URL;", "getUrl", "()Ljava/net/URL;", "url$delegate", "Lkotlin/Lazy;", "urlOrNull", "getUrlOrNull", "urlOrNull$delegate", "compareTo", "", "other", "equals", "", "hashCode", "normalize", "element", "toString", "scent-dom"})
public final class NavigateAnchor
implements Comparable<NavigateAnchor> {
    @NotNull
    private final Element anchor;
    @Nullable
    private final NavigateComponent component;
    private final boolean ignoreUrlQuery;
    @NotNull
    private final String href;
    @NotNull
    private final Lazy urlOrNull$delegate;
    @NotNull
    private final Lazy url$delegate;
    @NotNull
    private final String text;

    public NavigateAnchor(@NotNull Element anchor, @Nullable NavigateComponent component, boolean ignoreUrlQuery) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        this.anchor = anchor;
        this.component = component;
        this.ignoreUrlQuery = ignoreUrlQuery;
        this.href = this.normalize(this.anchor);
        this.urlOrNull$delegate = LangKt.usfLazy((Function0)((Function0)new Function0<URL>(this){
            final /* synthetic */ NavigateAnchor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final URL invoke() {
                return !StringsKt.isBlank((CharSequence)this.this$0.getHref()) ? new URL(this.this$0.getHref()) : null;
            }
        }));
        this.url$delegate = LangKt.usfLazy((Function0)((Function0)new Function0<URL>(this){
            final /* synthetic */ NavigateAnchor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final URL invoke() {
                URL uRL = this.this$0.getUrlOrNull();
                Intrinsics.checkNotNull((Object)uRL, (String)"null cannot be cast to non-null type java.net.URL");
                return uRL;
            }
        }));
        this.text = NodeExtKt.getCleanText((Node)((Node)this.anchor));
    }

    public /* synthetic */ NavigateAnchor(Element element, NavigateComponent navigateComponent, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            navigateComponent = null;
        }
        if ((n2 & 4) != 0) {
            bl = false;
        }
        this(element, navigateComponent, bl);
    }

    @NotNull
    public final Element getAnchor() {
        return this.anchor;
    }

    @Nullable
    public final NavigateComponent getComponent() {
        return this.component;
    }

    public final boolean getIgnoreUrlQuery() {
        return this.ignoreUrlQuery;
    }

    @NotNull
    public final String getHref() {
        return this.href;
    }

    @Nullable
    public final URL getUrlOrNull() {
        Lazy lazy = this.urlOrNull$delegate;
        return (URL)lazy.getValue();
    }

    @NotNull
    public final URL getUrl() {
        Lazy lazy = this.url$delegate;
        return (URL)lazy.getValue();
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    public final boolean isValid() {
        return this.getUrlOrNull() != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isItemLike() {
        if (!this.isValid()) return false;
        String string = this.getUrl().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        if (StringsKt.isBlank((CharSequence)string)) return false;
        boolean bl = true;
        if (!bl) return false;
        if (StringsKt.endsWith$default((String)this.href, (String)"/", (boolean)false, (int)2, null)) return false;
        return true;
    }

    @NotNull
    public final String normalize(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String string = element.attr("abs:href");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"attr(...)");
        return URLUtils.normalizeOrEmpty((String)string, (boolean)this.ignoreUrlQuery);
    }

    public int hashCode() {
        return this.href.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof NavigateAnchor && Intrinsics.areEqual((Object)((NavigateAnchor)other).href, (Object)this.href);
    }

    @Override
    public int compareTo(@NotNull NavigateAnchor other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.href.compareTo(other.href);
    }

    @NotNull
    public String toString() {
        return this.href;
    }
}

