/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.dom.nodes;

import ai.platon.pulsar.common.math.geometric.AlignType;
import ai.platon.scent.dom.nodes.TileArrayKey;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Node;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000e\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001d\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007B\u001d\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\u0002\u0010\tB\u000f\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u000bB#\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0011J\u0011\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\u0000H\u0096\u0002R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0016R\u0011\u0010\u0018\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001cR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006#"}, d2={"Lai/platon/scent/dom/nodes/TileArray;", "", "key", "Lai/platon/scent/dom/nodes/TileArrayKey;", "nodes", "", "Lorg/jsoup/nodes/Node;", "(Lai/platon/scent/dom/nodes/TileArrayKey;Ljava/util/List;)V", "", "(Lai/platon/scent/dom/nodes/TileArrayKey;Ljava/lang/Iterable;)V", "array", "(Lai/platon/scent/dom/nodes/TileArray;)V", "position", "", "alignType", "Lai/platon/pulsar/common/math/geometric/AlignType;", "tiles", "(ILai/platon/pulsar/common/math/geometric/AlignType;Ljava/util/List;)V", "getAlignType", "()Lai/platon/pulsar/common/math/geometric/AlignType;", "isEmpty", "", "()Z", "isHorizontal", "isVertical", "getKey", "()Lai/platon/scent/dom/nodes/TileArrayKey;", "getPosition", "()I", "size", "getSize", "getTiles", "()Ljava/util/List;", "compareTo", "other", "scent-dom"})
public class TileArray
implements Comparable<TileArray> {
    private final int position;
    @NotNull
    private final AlignType alignType;
    @NotNull
    private final List<Node> tiles;

    public TileArray(int position, @NotNull AlignType alignType, @NotNull List<? extends Node> tiles) {
        Intrinsics.checkNotNullParameter((Object)alignType, (String)"alignType");
        Intrinsics.checkNotNullParameter(tiles, (String)"tiles");
        this.position = position;
        this.alignType = alignType;
        this.tiles = tiles;
    }

    public int getPosition() {
        return this.position;
    }

    @NotNull
    public AlignType getAlignType() {
        return this.alignType;
    }

    @NotNull
    public List<Node> getTiles() {
        return this.tiles;
    }

    public TileArray(@NotNull TileArrayKey key, @NotNull List<? extends Node> nodes) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        this(key.getPosition(), key.getAlignType(), nodes);
    }

    public TileArray(@NotNull TileArrayKey key, @NotNull Iterable<? extends Node> nodes) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        this(key.getPosition(), key.getAlignType(), CollectionsKt.toList(nodes));
    }

    public TileArray(@NotNull TileArray array) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        this(array.getPosition(), array.getAlignType(), array.getTiles());
    }

    @NotNull
    public final TileArrayKey getKey() {
        return new TileArrayKey(this.getPosition(), this.getAlignType());
    }

    public final boolean isVertical() {
        return this.getAlignType().isVertical();
    }

    public final boolean isHorizontal() {
        return this.getAlignType().isHorizontal();
    }

    public final boolean isEmpty() {
        return this.getAlignType() == AlignType.NONE;
    }

    public final int getSize() {
        return this.getTiles().size();
    }

    @Override
    public int compareTo(@NotNull TileArray other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int r = this.getAlignType().compareTo((Enum)other.getAlignType());
        return r == 0 ? this.getPosition() - other.getPosition() : r;
    }
}

