/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.dom.utils;

import ai.platon.pulsar.common.Strings;
import ai.platon.scent.dom.features.defined.DefinedFeaturesKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.codec.digest.DigestUtils;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.NodeTraversor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00050\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0012J\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00102\u0006\u0010\n\u001a\u00020\u000bJ\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00102\u0006\u0010\n\u001a\u00020\u000bJ\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00172\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bJ\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00172\u0006\u0010\n\u001a\u00020\u000bJ\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00172\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u000eJ\u000e\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001f"}, d2={"Lai/platon/scent/dom/utils/ElementUtils;", "", "()V", "defaultLikelihoodFeatures", "", "", "getDefaultLikelihoodFeatures", "()[Ljava/lang/Integer;", "calculateKeywordCount", "", "ele", "Lorg/jsoup/nodes/Element;", "keywords", "Ljava/util/SortedMap;", "", "phrases", "", "dictionary", "Ljava/util/SortedSet;", "getAllOwnText", "getAllTextNodes", "Lorg/jsoup/nodes/TextNode;", "getClasses", "Ljava/util/ArrayList;", "getCodeDigest", "getIds", "getMostAppearedClasses", "getRichText", "getStrippedText", "getTextDigest", "text", "scent-dom"})
@SourceDebugExtension(value={"SMAP\nElementUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ElementUtils.kt\nai/platon/scent/dom/utils/ElementUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,158:1\n748#2,10:159\n731#2,9:169\n37#3,2:178\n*S KotlinDebug\n*F\n+ 1 ElementUtils.kt\nai/platon/scent/dom/utils/ElementUtils\n*L\n108#1:159,10\n135#1:169,9\n135#1:178,2\n*E\n"})
public final class ElementUtils {
    @NotNull
    public static final ElementUtils INSTANCE = new ElementUtils();

    private ElementUtils() {
    }

    @NotNull
    public final Integer[] getDefaultLikelihoodFeatures() {
        Integer[] integerArray = new Integer[]{ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.CH, ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.TN, ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.A, ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt.IMG, DefinedFeaturesKt.getD(), DefinedFeaturesKt.getIAH(), DefinedFeaturesKt.getAAH()};
        return integerArray;
    }

    @NotNull
    public final String getStrippedText(@NotNull Element ele) {
        Intrinsics.checkNotNullParameter((Object)ele, (String)"ele");
        String string = Strings.stripNonChar((String)ele.text());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stripNonChar(...)");
        return string;
    }

    @NotNull
    public final String getRichText(@NotNull Element ele) {
        Intrinsics.checkNotNullParameter((Object)ele, (String)"ele");
        StringBuilder accum = new StringBuilder();
        NodeTraversor.traverse((arg_0, arg_1) -> ElementUtils.getRichText$lambda$0(accum, arg_0, arg_1), (Node)((Node)ele));
        String string = accum.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final Set<TextNode> getAllTextNodes(@NotNull Element ele) {
        Intrinsics.checkNotNullParameter((Object)ele, (String)"ele");
        Set nodes = new LinkedHashSet();
        NodeTraversor.traverse((arg_0, arg_1) -> ElementUtils.getAllTextNodes$lambda$1(nodes, arg_0, arg_1), (Node)((Node)ele));
        return nodes;
    }

    @NotNull
    public final Set<String> getAllOwnText(@NotNull Element ele) {
        Intrinsics.checkNotNullParameter((Object)ele, (String)"ele");
        Set texts = new LinkedHashSet();
        NodeTraversor.traverse((arg_0, arg_1) -> ElementUtils.getAllOwnText$lambda$2(texts, arg_0, arg_1), (Node)((Node)ele));
        return texts;
    }

    @NotNull
    public final ArrayList<String> getIds(@NotNull Element ele) {
        Intrinsics.checkNotNullParameter((Object)ele, (String)"ele");
        ArrayList<String> ids = new ArrayList<String>();
        NodeTraversor.traverse((arg_0, arg_1) -> ElementUtils.getIds$lambda$3(ids, arg_0, arg_1), (Node)((Node)ele));
        return ids;
    }

    @NotNull
    public final ArrayList<String> getClasses(@NotNull Element ele) {
        Intrinsics.checkNotNullParameter((Object)ele, (String)"ele");
        ArrayList<String> classes = new ArrayList<String>();
        NodeTraversor.traverse((arg_0, arg_1) -> ElementUtils.getClasses$lambda$5(classes, arg_0, arg_1), (Node)((Node)ele));
        return classes;
    }

    @NotNull
    public final String getCodeDigest(@NotNull Element ele) {
        Intrinsics.checkNotNullParameter((Object)ele, (String)"ele");
        StringBuilder accum = new StringBuilder();
        NodeTraversor.traverse((arg_0, arg_1) -> ElementUtils.getCodeDigest$lambda$6(accum, ele, arg_0, arg_1), (Node)((Node)ele));
        String string = DigestUtils.md5Hex((String)accum.toString());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"md5Hex(...)");
        return string;
    }

    @NotNull
    public final String getTextDigest(@NotNull Element ele) {
        Intrinsics.checkNotNullParameter((Object)ele, (String)"ele");
        String string = DigestUtils.md5Hex((String)ele.text());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"md5Hex(...)");
        return string;
    }

    @NotNull
    public final String getTextDigest(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        String string = DigestUtils.md5Hex((String)text);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"md5Hex(...)");
        return string;
    }

    @NotNull
    public final ArrayList<String> getMostAppearedClasses(@NotNull Element ele) {
        Intrinsics.checkNotNullParameter((Object)ele, (String)"ele");
        ArrayList<String> classes = new ArrayList<String>();
        NodeTraversor.traverse((arg_0, arg_1) -> ElementUtils.getMostAppearedClasses$lambda$8(classes, arg_0, arg_1), (Node)((Node)ele));
        return classes;
    }

    public final void calculateKeywordCount(@NotNull Element ele, @NotNull SortedMap<String, Integer> keywords, @NotNull Set<String> phrases, @NotNull SortedSet<String> dictionary2) {
        Intrinsics.checkNotNullParameter((Object)ele, (String)"ele");
        Intrinsics.checkNotNullParameter(keywords, (String)"keywords");
        Intrinsics.checkNotNullParameter(phrases, (String)"phrases");
        Intrinsics.checkNotNullParameter(dictionary2, (String)"dictionary");
        for (String word : dictionary2) {
            int count2 = 0;
            for (String phrase : phrases) {
                CharSequence charSequence = phrase;
                Intrinsics.checkNotNull((Object)word);
                if (!StringsKt.contains$default((CharSequence)charSequence, (CharSequence)word, (boolean)false, (int)2, null)) continue;
                ++count2;
            }
            if (count2 <= 0) continue;
            Integer n2 = count2;
            ((Map)keywords).put(word, n2);
        }
    }

    private static final void getRichText$lambda$0(StringBuilder $accum, Node node, int n2) {
        Intrinsics.checkNotNullParameter((Object)$accum, (String)"$accum");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (node instanceof TextNode) {
            String string = ((TextNode)node).text();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text(...)");
            CharSequence charSequence = string;
            Regex regex = new Regex("[<>/&]");
            String string2 = "";
            String text = regex.replace(charSequence, string2);
            $accum.append(Strings.stripNonChar((String)text));
        } else if (node instanceof Element) {
            String text = Strings.stripNonChar((String)((Element)node).ownText());
            Intrinsics.checkNotNull((Object)text);
            if (!(((CharSequence)text).length() == 0) && ((Element)node).isBlock()) {
                $accum.append("<br />");
            }
        }
    }

    private static final void getAllTextNodes$lambda$1(Set $nodes, Node node, int n2) {
        Intrinsics.checkNotNullParameter((Object)$nodes, (String)"$nodes");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (node instanceof TextNode) {
            $nodes.add(node);
        }
    }

    private static final void getAllOwnText$lambda$2(Set $texts, Node node, int n2) {
        Intrinsics.checkNotNullParameter((Object)$texts, (String)"$texts");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (node instanceof TextNode) {
            String string = ((TextNode)node).text();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text(...)");
            $texts.add(string);
        }
    }

    private static final void getIds$lambda$3(ArrayList $ids, Node node, int depth) {
        Intrinsics.checkNotNullParameter((Object)$ids, (String)"$ids");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        String string = node.attr("id");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"attr(...)");
        String id2 = string;
        if (!(((CharSequence)id2).length() == 0)) {
            $ids.add(id2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void getClasses$lambda$5(ArrayList $classes, Node node, int depth) {
        Intrinsics.checkNotNullParameter((Object)$classes, (String)"$classes");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        String string = node.attr("class");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"attr(...)");
        String str = string;
        if (!StringsKt.isBlank((CharSequence)str)) {
            void $this$dropWhile$iv;
            Object object = str;
            Regex regex = new Regex("\\s+");
            int n2 = 0;
            object = regex.split((CharSequence)object, n2);
            ArrayList arrayList = $classes;
            boolean $i$f$dropWhile = false;
            boolean yielding$iv = false;
            ArrayList list$iv = new ArrayList();
            for (Object item$iv : $this$dropWhile$iv) {
                if (yielding$iv) {
                    list$iv.add(item$iv);
                    continue;
                }
                String it = (String)item$iv;
                boolean bl = false;
                if (StringsKt.isBlank((CharSequence)it)) continue;
                list$iv.add(item$iv);
                yielding$iv = true;
            }
            arrayList.addAll(list$iv);
        }
    }

    private static final void getCodeDigest$lambda$6(StringBuilder $accum, Element $ele, Node node, int n2) {
        Intrinsics.checkNotNullParameter((Object)$accum, (String)"$accum");
        Intrinsics.checkNotNullParameter((Object)$ele, (String)"$ele");
        Intrinsics.checkNotNullParameter((Object)node, (String)"<anonymous parameter 0>");
        $accum.append($ele.tagName());
    }

    /*
     * WARNING - void declaration
     */
    private static final void getMostAppearedClasses$lambda$8(ArrayList $classes, Node node, int n2) {
        Intrinsics.checkNotNullParameter((Object)$classes, (String)"$classes");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        String string = node.attr("class");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"attr(...)");
        String c = string;
        if (!(((CharSequence)c).length() == 0)) {
            void $this$toTypedArray$iv;
            List list;
            Collection $this$dropLastWhile$iv;
            Object object = c;
            Regex regex = new Regex("\\s+");
            int n3 = 0;
            object = regex.split((CharSequence)object, n3);
            Collection collection = $classes;
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl = false;
                    if (((CharSequence)it).length() == 0) continue;
                    list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            $this$dropLastWhile$iv = list;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            Collections.addAll(collection, Arrays.copyOf(stringArray, stringArray.length));
        }
    }
}

