/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.dom.web;

import ai.platon.pulsar.common.LogsKt;
import ai.platon.scent.common.ScentStringUtils;
import ai.platon.scent.common.web.GeoAnchor;
import ai.platon.scent.dom.web.PlainWebNode;
import ai.platon.scent.dom.web.SlimWebNode;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 22\b\u0012\u0004\u0012\u00020\u00000\u0001:\u00012B\u001b\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\u0005B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0011\u0010*\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010,\u001a\u00020\u00182\b\u0010+\u001a\u0004\u0018\u00010-H\u0096\u0002J\b\u0010.\u001a\u00020\u000eH\u0016J\u0006\u0010/\u001a\u000200J\b\u00101\u001a\u00020\u001bH\u0016R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00000\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u001dR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010&\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u001dR\u0011\u0010(\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u001d\u00a8\u00063"}, d2={"Lai/platon/scent/dom/web/WebNode;", "", "anchor", "Lai/platon/scent/common/web/GeoAnchor;", "parentNode", "(Lai/platon/scent/common/web/GeoAnchor;Lai/platon/scent/dom/web/WebNode;)V", "plainNode", "Lai/platon/scent/dom/web/PlainWebNode;", "(Lai/platon/scent/dom/web/PlainWebNode;)V", "children", "Ljava/util/concurrent/ConcurrentSkipListSet;", "getChildren", "()Ljava/util/concurrent/ConcurrentSkipListSet;", "depth", "", "getDepth", "()I", "id", "", "getId", "()J", "setId", "(J)V", "isRoot", "", "()Z", "name", "", "getName", "()Ljava/lang/String;", "getParentNode", "()Lai/platon/scent/dom/web/WebNode;", "setParentNode", "(Lai/platon/scent/dom/web/WebNode;)V", "path", "getPath", "getPlainNode", "()Lai/platon/scent/dom/web/PlainWebNode;", "symbol", "getSymbol", "url", "getUrl", "compareTo", "other", "equals", "", "hashCode", "toSlimNode", "Lai/platon/scent/dom/web/SlimWebNode;", "toString", "Companion", "scent-dom"})
public final class WebNode
implements Comparable<WebNode> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PlainWebNode plainNode;
    private long id;
    @Nullable
    private WebNode parentNode;
    @NotNull
    private final ConcurrentSkipListSet<WebNode> children;
    @NotNull
    private static final AtomicLong sequencer = new AtomicLong();
    @NotNull
    public static final String PATH_DELIMITER = " > ";
    @NotNull
    public static final String ROOT_NAME = "Root";

    public WebNode(@NotNull PlainWebNode plainNode) {
        Intrinsics.checkNotNullParameter((Object)plainNode, (String)"plainNode");
        this.plainNode = plainNode;
        this.id = sequencer.incrementAndGet();
        this.children = new ConcurrentSkipListSet(new Comparator(){

            public final int compare(T a, T b) {
                WebNode it = (WebNode)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getUrl());
                it = (WebNode)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getUrl())));
            }
        });
    }

    @NotNull
    public final PlainWebNode getPlainNode() {
        return this.plainNode;
    }

    public final long getId() {
        return this.id;
    }

    public final void setId(long l) {
        this.id = l;
    }

    @Nullable
    public final WebNode getParentNode() {
        return this.parentNode;
    }

    public final void setParentNode(@Nullable WebNode webNode) {
        this.parentNode = webNode;
    }

    @NotNull
    public final ConcurrentSkipListSet<WebNode> getChildren() {
        return this.children;
    }

    @NotNull
    public final String getUrl() {
        return this.plainNode.getAnchor().getUrl();
    }

    @NotNull
    public final String getName() {
        return this.plainNode.getAnchor().getText();
    }

    public final boolean isRoot() {
        return this.parentNode == null;
    }

    public final int getDepth() {
        return WebNode.Companion.getDepth(this);
    }

    @NotNull
    public final String getPath() {
        return WebNode.Companion.getPath(this);
    }

    @NotNull
    public final String getSymbol() {
        return this.plainNode.getSymbol();
    }

    public WebNode(@NotNull GeoAnchor anchor, @Nullable WebNode parentNode) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        this(new PlainWebNode(anchor, null, null, null, null, false, 62, null));
        this.parentNode = parentNode;
    }

    public /* synthetic */ WebNode(GeoAnchor geoAnchor, WebNode webNode, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            webNode = null;
        }
        this(geoAnchor, webNode);
    }

    @NotNull
    public final SlimWebNode toSlimNode() {
        WebNode webNode = this.parentNode;
        return new SlimWebNode(this.id, webNode != null ? webNode.id : 0L, this.getDepth(), this.children.size(), this.getPath(), this.getSymbol(), this.getUrl());
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof WebNode && Intrinsics.areEqual((Object)this.getPath(), (Object)((WebNode)other).getPath());
    }

    @Override
    public int compareTo(@NotNull WebNode other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.getPath().compareTo(other.getPath());
    }

    @NotNull
    public String toString() {
        return this.toSlimNode().toString();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000e0\r2\b\b\u0002\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u000eJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000eH\u0002J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0017"}, d2={"Lai/platon/scent/dom/web/WebNode$Companion;", "", "()V", "PATH_DELIMITER", "", "ROOT_NAME", "sequencer", "Ljava/util/concurrent/atomic/AtomicLong;", "getSequencer", "()Ljava/util/concurrent/atomic/AtomicLong;", "buildTree", "", "nodes", "", "Lai/platon/scent/dom/web/WebNode;", "shortenNodeId", "", "createRoot", "getDepth", "", "categoryNode", "getPath", "node", "scent-dom"})
    @SourceDebugExtension(value={"SMAP\nWebTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebTree.kt\nai/platon/scent/dom/web/WebNode$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,332:1\n1#2:333\n215#3,2:334\n215#3:339\n216#3:342\n215#3,2:343\n215#3:345\n216#3:349\n1045#4:336\n1855#4,2:337\n1855#4,2:340\n2624#4,3:346\n*S KotlinDebug\n*F\n+ 1 WebTree.kt\nai/platon/scent/dom/web/WebNode$Companion\n*L\n258#1:334,2\n266#1:339\n266#1:342\n286#1:343,2\n298#1:345\n298#1:349\n261#1:336\n261#1:337,2\n271#1:340,2\n301#1:346,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AtomicLong getSequencer() {
            return sequencer;
        }

        @NotNull
        public final WebNode createRoot() {
            WebNode webNode;
            WebNode $this$createRoot_u24lambda_u240 = webNode = new WebNode(new GeoAnchor("", WebNode.ROOT_NAME, null, 0, 0, 0, 0, 124, null), null, 2, null);
            boolean bl = false;
            $this$createRoot_u24lambda_u240.setId(0L);
            return webNode;
        }

        /*
         * WARNING - void declaration
         */
        public final void buildTree(@NotNull Map<String, WebNode> nodes, boolean shortenNodeId) {
            WebNode node;
            boolean bl;
            Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
            Logger logger = LogsKt.getLogger((KClass)Reflection.getOrCreateKotlinClass(WebNode.class));
            logger.info("Building tree from {} nodes", (Object)nodes.size());
            Map<String, WebNode> $this$forEach$iv = nodes;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, WebNode>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<String, WebNode> entry;
                Map.Entry<String, WebNode> entry2 = entry = iterator2.next();
                boolean bl2 = false;
                Long l = ScentStringUtils.INSTANCE.findTailingLong(entry2.getValue().getUrl());
                entry2.getValue().setId(l != null ? l : -1L);
            }
            if (shortenNodeId) {
                void $this$forEach$iv2;
                long id2 = 0L;
                id2 = 10L;
                Iterable $this$sortedBy$iv = nodes.entrySet();
                boolean $i$f$sortedBy = false;
                $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        Map.Entry it = (Map.Entry)a;
                        boolean bl = false;
                        Comparable comparable = Long.valueOf(((WebNode)it.getValue()).getId());
                        it = (Map.Entry)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(((WebNode)it.getValue()).getId()));
                    }
                });
                boolean $i$f$forEach2 = false;
                for (Object t : $this$forEach$iv2) {
                    Map.Entry it = (Map.Entry)t;
                    bl = false;
                    long l = id2;
                    id2 = l + 1L;
                    ((WebNode)it.getValue()).setId(l);
                }
            }
            int j = 0;
            Map<String, WebNode> $this$forEach$iv3 = nodes;
            boolean $i$f$forEach3 = false;
            Iterator<Map.Entry<String, WebNode>> iterator3 = $this$forEach$iv3.entrySet().iterator();
            while (iterator3.hasNext()) {
                Map.Entry<String, WebNode> entry;
                Map.Entry<String, WebNode> it = entry = iterator3.next();
                bl = false;
                WebNode node2 = it.getValue();
                int n2 = j;
                j = n2 + 1;
                if (n2 % 5000 == 0) {
                    logger.info("Processing the {}th/{} node", (Object)j, (Object)nodes.size());
                }
                Iterable $this$forEach$iv4 = node2.getPlainNode().getChildAnchors();
                boolean $i$f$forEach4 = false;
                for (Object element$iv : $this$forEach$iv4) {
                    GeoAnchor anchor = (GeoAnchor)element$iv;
                    boolean bl2 = false;
                    WebNode child = nodes.get(anchor.getUrl());
                    if (child != null) {
                        child.getPlainNode().setParentUrl(node2.getUrl());
                        child.setParentNode(node2);
                        node2.getChildren().add(child);
                        continue;
                    }
                    logger.info("Child node not fetched | {} <- {}", (Object)anchor.getUrl(), (Object)node2.getUrl());
                }
            }
            WebNode webNode = nodes.get("");
            if (webNode == null) {
                webNode = this.createRoot();
            }
            WebNode root = webNode;
            Map<String, WebNode> $this$forEach$iv5 = nodes;
            boolean bl3 = false;
            Iterator<Map.Entry<String, WebNode>> iterator4 = $this$forEach$iv5.entrySet().iterator();
            while (iterator4.hasNext()) {
                Map.Entry<String, WebNode> element$iv;
                Map.Entry<String, WebNode> entry = element$iv = iterator4.next();
                boolean bl4 = false;
                node = entry.getValue();
                if (node.getPlainNode().getParentUrl() != null || Intrinsics.areEqual((Object)node, (Object)root)) continue;
                node.setParentNode(root);
                root.getChildren().add(node);
            }
            if (!(root.getParentNode() == null)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            Map<String, WebNode> $this$forEach$iv2 = nodes;
            boolean bl5 = false;
            Iterator<Map.Entry<String, WebNode>> iterator5 = $this$forEach$iv2.entrySet().iterator();
            while (iterator5.hasNext()) {
                boolean bl6;
                block14: {
                    Map.Entry<String, WebNode> element$iv;
                    Map.Entry<String, WebNode> entry = element$iv = iterator5.next();
                    boolean bl32 = false;
                    node = entry.getValue();
                    WebNode parentNode = node.getParentNode();
                    if (parentNode == null) continue;
                    Iterable $this$none$iv = parentNode.getPlainNode().getChildAnchors();
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl6 = true;
                    } else {
                        for (Object element$iv3 : $this$none$iv) {
                            GeoAnchor it = (GeoAnchor)element$iv3;
                            boolean bl4 = false;
                            if (!Intrinsics.areEqual((Object)it.getUrl(), (Object)node.getUrl())) continue;
                            bl6 = false;
                            break block14;
                        }
                        bl6 = true;
                    }
                }
                if (!bl6) continue;
                node.getPlainNode().setSymbol("D");
            }
        }

        public static /* synthetic */ void buildTree$default(Companion companion, Map map, boolean bl, int n2, Object object) {
            if ((n2 & 2) != 0) {
                bl = false;
            }
            companion.buildTree(map, bl);
        }

        private final int getDepth(WebNode categoryNode) {
            int d = 0;
            for (WebNode p = categoryNode.getParentNode(); p != null; p = p.getParentNode()) {
                ++d;
            }
            return d;
        }

        private final String getPath(WebNode node) {
            if (Intrinsics.areEqual((Object)node.getName(), (Object)WebNode.ROOT_NAME)) {
                return node.getName();
            }
            StringBuilder sb = new StringBuilder(node.getName());
            for (WebNode p = node.getParentNode(); p != null; p = p.getParentNode()) {
                sb.insert(0, WebNode.PATH_DELIMITER).insert(0, p.getName());
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

