/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.dom.nodes;

import ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt;
import ai.platon.scent.dom.nodes.DiagonalOrientedFrame;
import ai.platon.scent.dom.nodes.DiagonalOrientedGrid;
import ai.platon.scent.dom.nodes.NodeVertex;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bJ\b\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lai/platon/scent/dom/nodes/FrameFormatter;", "", "frame", "Lai/platon/scent/dom/nodes/DiagonalOrientedFrame;", "(Lai/platon/scent/dom/nodes/DiagonalOrientedFrame;)V", "getFrame", "()Lai/platon/scent/dom/nodes/DiagonalOrientedFrame;", "format", "Lorg/jsoup/nodes/Element;", "toString", "", "scent-dom"})
public final class FrameFormatter {
    @NotNull
    private final DiagonalOrientedFrame frame;

    public FrameFormatter(@NotNull DiagonalOrientedFrame frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        this.frame = frame;
    }

    @NotNull
    public final DiagonalOrientedFrame getFrame() {
        return this.frame;
    }

    @NotNull
    public final Element format() {
        Document document = Document.createShell((String)"http://example.com");
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"createShell(...)");
        Document doc = document;
        Element element = doc.appendElement("table");
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"appendElement(...)");
        Element table = element;
        DiagonalOrientedGrid grid = this.frame.getPrincipalGrid();
        int n2 = grid.getM();
        for (int i = 0; i < n2; ++i) {
            Intrinsics.checkNotNullExpressionValue((Object)table.appendElement("tr"), (String)"appendElement(...)");
            int n3 = grid.getN();
            for (int j = 0; j < n3; ++j) {
                Element tr;
                Object object;
                NodeVertex v = grid.get(i)[j];
                Node node = v.getData().getNode();
                if (node instanceof Element) {
                    object = ((Element)node).text();
                } else {
                    object = node;
                    if (object == null || (object = NodeExtKt.getName((Node)object)) == null) {
                        object = "";
                    }
                }
                Object object2 = object;
                Intrinsics.checkNotNull((Object)object2);
                Object text = object2;
                tr.appendElement("td").text((String)text);
            }
        }
        return table;
    }

    @NotNull
    public String toString() {
        String string = this.format().html();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"html(...)");
        return string;
    }
}

