/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.dom.nodes;

import ai.platon.pulsar.common.math.geometric.GeometricsKt;
import ai.platon.pulsar.dom.FeaturedDocument;
import ai.platon.pulsar.dom.nodes.NodesKt;
import ai.platon.pulsar.dom.select.ElementTraversor;
import ai.platon.scent.dom.CalculatorUtils;
import ai.platon.scent.dom.HarvestOptions;
import ai.platon.scent.dom.nodes.AnchorGroup;
import ai.platon.scent.dom.nodes.AnchorPartitioner;
import ai.platon.scent.dom.nodes.FoldPartitioner;
import ai.platon.scent.dom.nodes.HostPartitioner;
import ai.platon.scent.dom.nodes.NavigateAnchor;
import ai.platon.scent.dom.nodes.NavigateComponent;
import ai.platon.scent.dom.nodes.NavigateDocument;
import ai.platon.scent.dom.nodes.NavigateDocumentKt;
import ai.platon.scent.dom.nodes.node.ext.NodeCharactersKt;
import ai.platon.scent.dom.nodes.node.ext.NodeExtKt;
import com.google.common.collect.TreeMultimap;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.math3.stat.descriptive.MultivariateSummaryStatistics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.NodeTraversor;
import org.jsoup.select.NodeVisitor;
import org.perf4j.slf4j.Slf4JStopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u0016H\u0002J\u001e\u00106\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0016\u0012\u0004\u0012\u00020\"072\u0006\u00105\u001a\u00020\u0016H\u0002J<\u00106\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0016\u0012\u0004\u0012\u00020\"072\u0006\u00108\u001a\u00020\r2\b\b\u0002\u00109\u001a\u00020%2\u0012\u0010:\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\"0;H\u0002J:\u0010<\u001a\u0002042\f\u0010=\u001a\b\u0012\u0004\u0012\u00020?0>2\u0006\u0010@\u001a\u00020\f2\u0006\u0010A\u001a\u00020%2\u0012\u0010:\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\"0;H\u0002J\b\u0010B\u001a\u000204H\u0002J\u0006\u0010C\u001a\u00020\"J0\u0010D\u001a\u0004\u0018\u00010\u00162\u0006\u0010E\u001a\u00020\r2\b\b\u0002\u00109\u001a\u00020%2\u0012\u0010:\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\"0;H\u0002J\b\u0010F\u001a\u000204H\u0002J\b\u0010G\u001a\u000204H\u0002J\u001c\u0010H\u001a\u0002042\u0012\u0010:\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\"0;H\u0002J\"\u0010I\u001a\u0004\u0018\u00010\r2\u0006\u0010J\u001a\u00020?2\u0006\u0010K\u001a\u00020?2\u0006\u0010L\u001a\u00020\fH\u0002J\u000e\u0010M\u001a\u0002042\u0006\u0010N\u001a\u00020OJ\u0010\u0010P\u001a\u0002042\u0006\u0010N\u001a\u00020OH\u0002J\b\u0010Q\u001a\u000204H\u0002J\b\u0010R\u001a\u000204H\u0002R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bj\u0002`\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR!\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bj\u0002`\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0010R\u0011\u0010!\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010#R\u0011\u0010$\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0011\u0010(\u001a\u00020)\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0011\u0010,\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0014\u0010/\u001a\u00020\fX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010.R\u0010\u00101\u001a\u0004\u0018\u000102X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006S"}, d2={"Lai/platon/scent/dom/nodes/NavigateDocument;", "", "featuredDocument", "Lai/platon/pulsar/dom/FeaturedDocument;", "(Lai/platon/pulsar/dom/FeaturedDocument;)V", "anchorGroups", "", "Lai/platon/scent/dom/nodes/AnchorGroup;", "getAnchorGroups", "()Ljava/util/List;", "anchorLeftIndexer", "Lcom/google/common/collect/TreeMultimap;", "", "Lorg/jsoup/nodes/Element;", "Lai/platon/scent/dom/nodes/IntElementIndexer;", "getAnchorLeftIndexer", "()Lcom/google/common/collect/TreeMultimap;", "body", "getBody", "()Lorg/jsoup/nodes/Element;", "components", "Ljava/util/TreeSet;", "Lai/platon/scent/dom/nodes/NavigateComponent;", "getComponents", "()Ljava/util/TreeSet;", "document", "Lorg/jsoup/nodes/Document;", "getDocument", "()Lorg/jsoup/nodes/Document;", "getFeaturedDocument", "()Lai/platon/pulsar/dom/FeaturedDocument;", "frameLeftIndexer", "getFrameLeftIndexer", "isNavigatePageLike", "", "()Z", "location", "", "getLocation", "()Ljava/lang/String;", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "maximumNavigateHeight", "getMaximumNavigateHeight", "()I", "minimalNavigateFrames", "getMinimalNavigateFrames", "stopWatch", "Lorg/perf4j/slf4j/Slf4JStopWatch;", "addComponent", "", "component", "addComponentIfAbsent", "Lkotlin/Pair;", "element", "memo", "predicate", "Lkotlin/Function1;", "bidirectionalSearchComponent", "nodes", "", "Lorg/jsoup/nodes/Node;", "minNodes", "type", "calculateNavigateFrameEdges", "checkIsNavigatePageLike", "createComponentIf", "envelop", "findComponents", "findGalleries", "findLeftAlignedComponent", "findMinimumEnvelop", "v1", "v2", "maxHeight", "partition", "options", "Lai/platon/scent/dom/HarvestOptions;", "partitionAnchorGroups", "reportGalleries", "reportNavigates", "scent-dom"})
@SourceDebugExtension(value={"SMAP\nNavigateDocument.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NavigateDocument.kt\nai/platon/scent/dom/nodes/NavigateDocument\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 DomQueries.kt\nai/platon/pulsar/dom/select/DomQueriesKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 7 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,715:1\n1855#2,2:716\n1864#2,2:720\n1611#2:730\n1855#2:731\n1856#2:734\n1612#2:735\n1866#2:737\n1855#2,2:738\n1855#2,2:742\n1855#2,2:746\n1477#2:749\n1502#2,3:750\n1505#2,3:760\n13309#3,2:718\n13374#3,2:722\n13376#3:736\n56#4,6:724\n277#4,2:740\n277#4,2:744\n1#5:732\n1#5:733\n215#6:748\n216#6:763\n215#6,2:764\n215#6,2:766\n372#7,7:753\n*S KotlinDebug\n*F\n+ 1 NavigateDocument.kt\nai/platon/scent/dom/nodes/NavigateDocument\n*L\n484#1:716,2\n524#1:720,2\n527#1:730\n527#1:731\n527#1:734\n527#1:735\n524#1:737\n540#1:738,2\n546#1:742,2\n549#1:746,2\n603#1:749\n603#1:750,3\n603#1:760,3\n507#1:718,2\n526#1:722,2\n526#1:736\n527#1:724,6\n545#1:740,2\n548#1:744,2\n527#1:733\n602#1:748\n602#1:763\n615#1:764,2\n621#1:766,2\n603#1:753,7\n*E\n"})
public final class NavigateDocument {
    @NotNull
    private final FeaturedDocument featuredDocument;
    @NotNull
    private final Logger log;
    @NotNull
    private final Document document;
    @NotNull
    private final String location;
    @NotNull
    private final Element body;
    private final int maximumNavigateHeight;
    private final int minimalNavigateFrames;
    @Nullable
    private final Slf4JStopWatch stopWatch;
    @NotNull
    private final TreeMultimap<Integer, Element> frameLeftIndexer;
    @NotNull
    private final TreeMultimap<Integer, Element> anchorLeftIndexer;
    @NotNull
    private final TreeSet<NavigateComponent> components;
    @NotNull
    private final List<AnchorGroup> anchorGroups;

    public NavigateDocument(@NotNull FeaturedDocument featuredDocument) {
        Intrinsics.checkNotNullParameter((Object)featuredDocument, (String)"featuredDocument");
        this.featuredDocument = featuredDocument;
        NodeExtKt.setNavigateDocument((Node)this.featuredDocument.getDocument(), this);
        Logger logger = LoggerFactory.getLogger(NavigateDocument.class);
        Intrinsics.checkNotNull((Object)logger);
        this.log = logger;
        this.document = this.featuredDocument.getDocument();
        this.location = ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getLocation((Node)((Node)this.document));
        this.body = this.featuredDocument.getBody();
        this.maximumNavigateHeight = ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getHeight((Node)((Node)this.body));
        this.minimalNavigateFrames = 10;
        this.stopWatch = this.log.isDebugEnabled() ? new Slf4JStopWatch() : null;
        TreeMultimap treeMultimap = TreeMultimap.create((Comparator)ComparisonsKt.naturalOrder(), (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Element it = (Element)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getTop((Node)((Node)it)));
                it = (Element)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getTop((Node)((Node)it))));
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)treeMultimap, (String)"create(...)");
        this.frameLeftIndexer = treeMultimap;
        TreeMultimap treeMultimap2 = TreeMultimap.create((Comparator)ComparisonsKt.naturalOrder(), (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Element it = (Element)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getTop((Node)((Node)it)));
                it = (Element)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getTop((Node)((Node)it))));
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)treeMultimap2, (String)"create(...)");
        this.anchorLeftIndexer = treeMultimap2;
        this.components = new TreeSet(new Comparator(){

            public final int compare(T a, T b) {
                NavigateComponent it = (NavigateComponent)b;
                boolean bl = false;
                Comparable comparable = (Comparable)it.getScore();
                it = (NavigateComponent)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)it.getScore()));
            }
        });
        this.anchorGroups = new ArrayList();
    }

    @NotNull
    public final FeaturedDocument getFeaturedDocument() {
        return this.featuredDocument;
    }

    @NotNull
    public final Logger getLog() {
        return this.log;
    }

    @NotNull
    public final Document getDocument() {
        return this.document;
    }

    @NotNull
    public final String getLocation() {
        return this.location;
    }

    @NotNull
    public final Element getBody() {
        return this.body;
    }

    public final int getMaximumNavigateHeight() {
        return this.maximumNavigateHeight;
    }

    public final int getMinimalNavigateFrames() {
        return this.minimalNavigateFrames;
    }

    @NotNull
    public final TreeMultimap<Integer, Element> getFrameLeftIndexer() {
        return this.frameLeftIndexer;
    }

    @NotNull
    public final TreeMultimap<Integer, Element> getAnchorLeftIndexer() {
        return this.anchorLeftIndexer;
    }

    @NotNull
    public final TreeSet<NavigateComponent> getComponents() {
        return this.components;
    }

    @NotNull
    public final List<AnchorGroup> getAnchorGroups() {
        return this.anchorGroups;
    }

    public final boolean isNavigatePageLike() {
        return this.checkIsNavigatePageLike();
    }

    public final void partition(@NotNull HarvestOptions options) {
        block6: {
            Intrinsics.checkNotNullParameter((Object)((Object)options), (String)"options");
            Slf4JStopWatch slf4JStopWatch = this.stopWatch;
            if (slf4JStopWatch != null) {
                slf4JStopWatch.start("partition");
            }
            this.findGalleries();
            Slf4JStopWatch slf4JStopWatch2 = this.stopWatch;
            if (slf4JStopWatch2 != null) {
                slf4JStopWatch2.start("findGalleries");
            }
            this.calculateNavigateFrameEdges();
            Slf4JStopWatch slf4JStopWatch3 = this.stopWatch;
            if (slf4JStopWatch3 != null) {
                slf4JStopWatch3.start("calculateNavigateFrameEdges");
            }
            this.findComponents();
            Slf4JStopWatch slf4JStopWatch4 = this.stopWatch;
            if (slf4JStopWatch4 != null) {
                slf4JStopWatch4.start("findComponents");
            }
            Iterable $this$forEach$iv = this.components;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                NavigateComponent it = (NavigateComponent)element$iv;
                boolean bl = false;
                it.analyze();
            }
            Slf4JStopWatch slf4JStopWatch5 = this.stopWatch;
            if (slf4JStopWatch5 != null) {
                slf4JStopWatch5.start("analyze");
            }
            this.partitionAnchorGroups(options);
            Slf4JStopWatch slf4JStopWatch6 = this.stopWatch;
            if (slf4JStopWatch6 == null) break block6;
            slf4JStopWatch6.start("partitionAnchorGroups");
        }
    }

    public final boolean checkIsNavigatePageLike() {
        NavigateComponent navigateComponent = (NavigateComponent)CollectionsKt.firstOrNull((Iterable)this.components);
        if (navigateComponent == null || (navigateComponent = navigateComponent.getElement()) == null) {
            return false;
        }
        NavigateComponent element = navigateComponent;
        return NodeExtKt.getNthScreen((Node)element) == 1 && ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getArea((Node)((Node)element)) > 600000;
    }

    private final void findComponents() {
        Function1[] predicates;
        Function1 p12 = findComponents.p1.1.INSTANCE;
        Function1 p22 = findComponents.p2.1.INSTANCE;
        Function1 p32 = findComponents.p3.1.INSTANCE;
        Function1 p42 = findComponents.p4.1.INSTANCE;
        Function1 p52 = findComponents.p5.1.INSTANCE;
        Function1[] function1Array = new Function1[]{p12, p22, p32, p42, p52};
        Function1[] $this$forEach$iv = predicates = function1Array;
        boolean $i$f$forEach = false;
        int n2 = $this$forEach$iv.length;
        for (int i = 0; i < n2; ++i) {
            Function1 element$iv;
            Function1 p = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            this.findLeftAlignedComponent((Function1<? super Element, Boolean>)p);
            if (!((Collection)this.components).isEmpty()) continue;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void partitionAnchorGroups(HarvestOptions options) {
        Function1 p12 = partitionAnchorGroups.p1.1.INSTANCE;
        Function1 p22 = partitionAnchorGroups.p2.1.INSTANCE;
        Function1 p32 = partitionAnchorGroups.p3.1.INSTANCE;
        Function1 p42 = partitionAnchorGroups.p4.1.INSTANCE;
        String[] stringArray = new String[]{"a:expr(maimg == 1)", "a:expr(maimg > 1)", "a:expr(aimg > 0)", "a"};
        String[] labels = stringArray;
        Function1[] function1Array = new Function1[]{p12, p22, p32, p42};
        Function1[] predicates = function1Array;
        Iterable $this$forEachIndexed$iv = this.components;
        boolean $i$f$forEachIndexed22 = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int n2;
            if ((n2 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            NavigateComponent navigateComponent = (NavigateComponent)item$iv;
            int i = n2;
            boolean bl = false;
            List lastAnchors = null;
            lastAnchors = CollectionsKt.emptyList();
            Function1[] $this$forEachIndexed$iv2 = predicates;
            boolean $i$f$forEachIndexed = false;
            int index$iv2 = 0;
            for (Function1 item$iv2 : $this$forEachIndexed$iv2) {
                void $this$mapNotNullTo$iv;
                void $this$collectIfTo$iv$iv;
                void predicate2;
                void destination$iv$iv;
                void component;
                int n3 = index$iv2++;
                Function1 function1 = item$iv2;
                int j = n3;
                boolean bl2 = false;
                Object $this$collectIf$iv = (Node)component.getElement();
                boolean $i$f$collectIf = false;
                Node node = $this$collectIf$iv;
                Collection collection = new ArrayList();
                boolean $i$f$collectIfTo = false;
                NodeTraversor.traverse((NodeVisitor)new NodeVisitor((Collection)destination$iv$iv, (Function1)predicate2){
                    final /* synthetic */ Collection $destination;
                    final /* synthetic */ Function1 $predicate$inlined;
                    {
                        this.$destination = $destination;
                        this.$predicate$inlined = function1;
                    }

                    public final void head(@NotNull Node node, int n2) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        Node it = node;
                        boolean bl = false;
                        if (((Boolean)this.$predicate$inlined.invoke((Object)it)).booleanValue()) {
                            this.$destination.add(node);
                        }
                    }
                }, (Node)$this$collectIfTo$iv$iv);
                $this$collectIf$iv = (List)destination$iv$iv;
                Collection destination$iv = new HashSet();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    NavigateAnchor it$iv;
                    NavigateAnchor navigateAnchor;
                    Object element$iv$iv;
                    Object element$iv = element$iv$iv = iterator2.next();
                    boolean bl3 = false;
                    Node it = (Node)element$iv;
                    boolean bl4 = false;
                    Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.jsoup.nodes.Element");
                    NavigateAnchor it2 = navigateAnchor = new NavigateAnchor((Element)it, (NavigateComponent)component, options.getIgnoreUrlQuery());
                    boolean bl5 = false;
                    if ((it2.isValid() ? navigateAnchor : null) == null) continue;
                    it$iv = it$iv;
                    boolean bl6 = false;
                    destination$iv.add(it$iv);
                }
                List anchors = CollectionsKt.toList((Iterable)destination$iv);
                if (anchors.size() <= lastAnchors.size()) continue;
                AnchorGroup anchorGroup = new AnchorGroup(labels[j], anchors, null, (NavigateComponent)component, 4, null);
                this.anchorGroups.add(anchorGroup);
                lastAnchors = anchors;
            }
        }
        AnchorPartitioner[] $i$f$forEachIndexed22 = new AnchorPartitioner[]{new HostPartitioner(), new FoldPartitioner()};
        AnchorPartitioner partitioner = NavigateDocumentKt.makeChainedPartitioner($i$f$forEachIndexed22);
        Iterable $this$forEach$iv = this.anchorGroups;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AnchorGroup it = (AnchorGroup)element$iv;
            boolean bl = false;
            it.partitionBy(partitioner);
        }
    }

    private final void findGalleries() {
        block3: {
            Logger logger;
            Element it;
            Set galleries = new LinkedHashSet();
            Element $this$collectIfTo$iv = this.body;
            boolean $i$f$collectIfTo = false;
            ElementTraversor.INSTANCE.traverse($this$collectIfTo$iv, (Function1)new Function1<Element, Unit>((Collection)galleries){
                final /* synthetic */ Collection $destination;
                {
                    this.$destination = $destination;
                    super(1);
                }

                public final void invoke(@NotNull Element it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    Element it2 = it;
                    boolean bl = false;
                    if (NodeCharactersKt.isGalleryLike((Node)it2)) {
                        this.$destination.add(it);
                    }
                }
            });
            Iterable $this$forEach$iv = galleries;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Element)element$iv;
                boolean bl = false;
                String string = it.attr("a-gallery");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"attr(...)");
                this.addComponentIfAbsent(it, string, (Function1<? super Element, Boolean>)((Function1)findGalleries.2.1.INSTANCE));
            }
            if (galleries.isEmpty()) {
                $this$collectIfTo$iv = this.body;
                $i$f$collectIfTo = false;
                ElementTraversor.INSTANCE.traverse($this$collectIfTo$iv, (Function1)new Function1<Element, Unit>((Collection)galleries){
                    final /* synthetic */ Collection $destination;
                    {
                        this.$destination = $destination;
                        super(1);
                    }

                    public final void invoke(@NotNull Element it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        Element it2 = it;
                        boolean bl = false;
                        if (((Boolean)NodeCharactersKt.checkIsGalleryLikeRelaxed$default((Node)it2, 0, 1, null).getFirst()).booleanValue()) {
                            this.$destination.add(it);
                        }
                    }
                });
                $this$forEach$iv = galleries;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (Element)element$iv;
                    boolean bl = false;
                    String string = it.attr("a-gallery");
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"attr(...)");
                    this.addComponentIfAbsent(it, string, (Function1<? super Element, Boolean>)((Function1)findGalleries.4.1.INSTANCE));
                }
            }
            Logger it2 = logger = this.log;
            boolean bl = false;
            Object object = it2.isDebugEnabled() ? logger : null;
            if (object == null) break block3;
            it2 = object;
            boolean bl2 = false;
            this.reportGalleries();
        }
    }

    private final void reportGalleries() {
        StringBuilder sb = new StringBuilder();
        NodesKt.forEachElement$default((Node)((Node)this.body), (boolean)false, (Function1)((Function1)new Function1<Element, Unit>(sb){
            final /* synthetic */ StringBuilder $sb;
            {
                this.$sb = $sb;
                super(1);
            }

            public final void invoke(@NotNull Element it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Object[] objectArray = new String[]{"ul", "ol", "table", "tbody"};
                String string = it.nodeName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nodeName(...)");
                if (ArraysKt.contains((Object[])objectArray, (Object)string) || ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getNumChildren((Node)((Node)it)) >= 8) {
                    Pair r = NodeCharactersKt.checkIsGalleryLike$default((Node)it, 0, 1, null);
                    String string2 = "%50s%20s%10d%10b%20s";
                    Object[] objectArray2 = new Object[]{ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getCanonicalName((Node)((Node)it)), GeometricsKt.getStr((Rectangle)ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getRectangle((Node)((Node)it))), ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getNumChildren((Node)((Node)it)), r.getFirst(), r.getSecond()};
                    String string3 = String.format(string2, Arrays.copyOf(objectArray2, objectArray2.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
                    String s = string3;
                    StringBuilder stringBuilder = this.$sb.append(s);
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
                }
            }
        }), (int)1, null);
        this.log.debug("Gallery detection report: \n{}", (Object)sb);
    }

    private final void reportNavigates() {
        StringBuilder sb = new StringBuilder();
        NodesKt.forEachElement$default((Node)((Node)this.body), (boolean)false, (Function1)((Function1)new Function1<Element, Unit>(sb){
            final /* synthetic */ StringBuilder $sb;
            {
                this.$sb = $sb;
                super(1);
            }

            public final void invoke(@NotNull Element it) {
                block4: {
                    block3: {
                        block2: {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            if (NodeCharactersKt.isGalleryLike((Node)it)) break block2;
                            Object[] objectArray = new String[]{"ul", "ol", "table", "tbody"};
                            String string = it.nodeName();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nodeName(...)");
                            if (ArraysKt.contains((Object[])objectArray, (Object)string)) break block3;
                        }
                        if (ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getNumChildren((Node)((Node)it)) < 8) break block4;
                    }
                    Pair r = NodeCharactersKt.checkIsNavigateLike$default((Node)it, 0, 1, null);
                    String string = "%50s%20s%10d%10b%20s";
                    Object[] objectArray = new Object[]{ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getCanonicalName((Node)((Node)it)), GeometricsKt.getStr((Rectangle)ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getRectangle((Node)((Node)it))), ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getNumChildren((Node)((Node)it)), r.getFirst(), r.getSecond()};
                    String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                    String s = string2;
                    StringBuilder stringBuilder = this.$sb.append(s);
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
                }
            }
        }), (int)1, null);
        this.log.debug("Navigate detection report: \n{}", (Object)sb);
    }

    private final void calculateNavigateFrameEdges() {
        if (!ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.isInitialized((Document)this.document).get()) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        NodesKt.forEachElement$default((Node)((Node)this.body), (boolean)false, (Function1)((Function1)new Function1<Element, Unit>(this){
            final /* synthetic */ NavigateDocument this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Element it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.isHidden((Node)((Node)it))) {
                    return;
                }
                if (NodeCharactersKt.isNavigateFrameLike((Node)it)) {
                    this.this$0.getFrameLeftIndexer().put((Object)(100000 * ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getWidth((Node)((Node)it)) + ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getLeft((Node)((Node)it)) / 2 * 2), (Object)it);
                } else if (ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.isAnchor((Node)((Node)it))) {
                    this.this$0.getAnchorLeftIndexer().put((Object)NodeExtKt.getAlignedLeft((Node)it), (Object)it);
                }
            }
        }), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void findLeftAlignedComponent(Function1<? super Element, Boolean> predicate2) {
        Collection nodes;
        Map.Entry entry;
        Map.Entry element$iv;
        NavigableMap navigableMap = this.frameLeftIndexer.asMap();
        Intrinsics.checkNotNullExpressionValue((Object)navigableMap, (String)"asMap(...)");
        Map $this$forEach$iv = navigableMap;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void $this$groupByTo$iv$iv;
            entry = element$iv = iterator2.next();
            boolean bl = false;
            nodes = (Collection)entry.getValue();
            Intrinsics.checkNotNull((Object)nodes);
            Iterable $this$groupBy$iv = nodes;
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                Element it = (Element)element$iv$iv;
                boolean bl2 = false;
                Element key$iv$iv = it.parent();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl3 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            destination$iv$iv.forEach((arg_0, arg_1) -> NavigateDocument.findLeftAlignedComponent$lambda$19$lambda$18((Function2)new Function2<Element, List<? extends Element>, Unit>(this, predicate2){
                final /* synthetic */ NavigateDocument this$0;
                final /* synthetic */ Function1<Element, Boolean> $predicate;
                {
                    this.this$0 = $receiver;
                    this.$predicate = $predicate;
                    super(2);
                }

                public final void invoke(@Nullable Element ns, @NotNull List<? extends Element> siblings) {
                    Intrinsics.checkNotNullParameter(siblings, (String)"siblings");
                    if (siblings.size() >= this.this$0.getMinimalNavigateFrames()) {
                        MultivariateSummaryStatistics ds = CalculatorUtils.INSTANCE.summary(siblings);
                        double[] dArray = ds.getStandardDeviation();
                        Intrinsics.checkNotNullExpressionValue((Object)dArray, (String)"getStandardDeviation(...)");
                        double[] $this$count$iv = dArray;
                        boolean $i$f$count = false;
                        int count$iv = 0;
                        int n2 = $this$count$iv.length;
                        for (int i = 0; i < n2; ++i) {
                            double element$iv;
                            double it = element$iv = $this$count$iv[i];
                            boolean bl = false;
                            if (!(it < 1.0)) continue;
                            ++count$iv;
                        }
                        int stds = count$iv;
                        double r = 1.0 * (double)stds / (double)ds.getDimension();
                        if (r > 0.8) {
                            Object object = CollectionsKt.first(siblings);
                            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
                            NavigateDocument.access$addComponentIfAbsent(this.this$0, ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getParentElement((Node)((Node)object)), "std(" + stds + "/" + ds.getDimension() + ")", this.$predicate);
                        }
                    }
                }
            }, arg_0, arg_1));
        }
        NavigableMap navigableMap2 = this.frameLeftIndexer.asMap();
        Intrinsics.checkNotNullExpressionValue((Object)navigableMap2, (String)"asMap(...)");
        $this$forEach$iv = navigableMap2;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            entry = element$iv = iterator2.next();
            boolean bl = false;
            nodes = (Collection)entry.getValue();
            if (nodes.size() < this.minimalNavigateFrames) continue;
            Intrinsics.checkNotNull((Object)nodes);
            this.bidirectionalSearchComponent(CollectionsKt.toList((Iterable)nodes), this.minimalNavigateFrames, "frame", predicate2);
        }
        NavigableMap navigableMap3 = this.anchorLeftIndexer.asMap();
        Intrinsics.checkNotNullExpressionValue((Object)navigableMap3, (String)"asMap(...)");
        $this$forEach$iv = navigableMap3;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            entry = element$iv = iterator2.next();
            boolean bl = false;
            nodes = (Collection)entry.getValue();
            if (nodes.size() < this.minimalNavigateFrames) continue;
            Intrinsics.checkNotNull((Object)nodes);
            this.bidirectionalSearchComponent(CollectionsKt.toList((Iterable)nodes), this.minimalNavigateFrames, "anchor", predicate2);
        }
    }

    private final void bidirectionalSearchComponent(List<? extends Node> nodes, int minNodes, String type, Function1<? super Element, Boolean> predicate2) {
        if (nodes.size() < minNodes) {
            return;
        }
        int size2 = nodes.size();
        Node node = (Node)CollectionsKt.first(nodes);
        int left = ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getLeft((Node)node);
        int last = nodes.size() - 1;
        int maxHeight = this.maximumNavigateHeight;
        int i = 0;
        if (i <= last) {
            while (true) {
                int j;
                int n2;
                if ((n2 = i + minNodes) <= (j = last)) {
                    while (true) {
                        Node v2;
                        Node v1;
                        Element envelop;
                        if ((envelop = this.findMinimumEnvelop(v1 = nodes.get(i), v2 = nodes.get(j), maxHeight)) != null) {
                            this.addComponentIfAbsent(envelop, type + "(" + left + ")[" + i + ", " + j + "]/" + size2, predicate2);
                            if (left - NodeExtKt.getEstimatedLeft((Node)envelop) < 100) {
                                return;
                            }
                        } else {
                            maxHeight = ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getY2((Node)v2) - ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getY((Node)v1);
                        }
                        if (j == n2) break;
                        --j;
                    }
                }
                if (i == last) break;
                ++i;
            }
        }
    }

    private final Element findMinimumEnvelop(Node v1, Node v2, int maxHeight) {
        Node node = v1.getExtension().getOwnerBody();
        if (node == null) {
            return null;
        }
        Node ownerBody = node;
        Function1 stop2 = (Function1)new Function1<Element, Boolean>(ownerBody, maxHeight){
            final /* synthetic */ Node $ownerBody;
            final /* synthetic */ int $maxHeight;
            {
                this.$ownerBody = $ownerBody;
                this.$maxHeight = $maxHeight;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Element it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getDepth((Node)((Node)it)) <= ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getDepth((Node)this.$ownerBody) || ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getHeight((Node)((Node)it)) > this.$maxHeight;
            }
        };
        Function1 predicate2 = (Function1)new Function1<Element, Boolean>(v1, v2){
            final /* synthetic */ Node $v1;
            final /* synthetic */ Node $v2;
            {
                this.$v1 = $v1;
                this.$v2 = $v2;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Element it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getRectangle((Node)((Node)it)).contains(ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getRectangle((Node)this.$v1)) && ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getRectangle((Node)((Node)it)).contains(ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getRectangle((Node)this.$v2));
            }
        };
        return NodesKt.findFirstAncestor((Node)v1, (Function1)((Function1)new Function1<Element, Boolean>((Function1<? super Element, Boolean>)stop2){
            final /* synthetic */ Function1<Element, Boolean> $stop;
            {
                this.$stop = $stop;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Element it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (Boolean)this.$stop.invoke((Object)it);
            }
        }), (Function1)((Function1)new Function1<Element, Boolean>((Function1<? super Element, Boolean>)predicate2){
            final /* synthetic */ Function1<Element, Boolean> $predicate;
            {
                this.$predicate = $predicate;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Element it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (Boolean)this.$predicate.invoke((Object)it);
            }
        }));
    }

    private final NavigateComponent createComponentIf(Element envelop, String memo, Function1<? super Element, Boolean> predicate2) {
        NavigateComponent navigateComponent;
        Element element;
        Element it = element = envelop;
        boolean bl = false;
        Object object = (Boolean)predicate2.invoke((Object)it) != false ? element : null;
        if (object != null) {
            it = object;
            boolean bl2 = false;
            navigateComponent = new NavigateComponent(it, memo);
        } else {
            navigateComponent = null;
        }
        return navigateComponent;
    }

    static /* synthetic */ NavigateComponent createComponentIf$default(NavigateDocument navigateDocument, Element element, String string, Function1 function1, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string = "";
        }
        return navigateDocument.createComponentIf(element, string, (Function1<? super Element, Boolean>)function1);
    }

    private final Pair<NavigateComponent, Boolean> addComponentIfAbsent(Element element, String memo, Function1<? super Element, Boolean> predicate2) {
        NavigateComponent navigateComponent = this.createComponentIf(element, memo, predicate2);
        if (navigateComponent == null) {
            return TuplesKt.to(null, (Object)false);
        }
        NavigateComponent vc = navigateComponent;
        return this.addComponentIfAbsent(vc);
    }

    static /* synthetic */ Pair addComponentIfAbsent$default(NavigateDocument navigateDocument, Element element, String string, Function1 function1, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string = "";
        }
        return navigateDocument.addComponentIfAbsent(element, string, (Function1<? super Element, Boolean>)function1);
    }

    private final Pair<NavigateComponent, Boolean> addComponentIfAbsent(NavigateComponent component) {
        Object v0;
        block2: {
            Iterable iterable = this.components;
            for (Object t : iterable) {
                NavigateComponent it = (NavigateComponent)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it, (Object)component)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        NavigateComponent old = v0;
        if (old == null) {
            this.addComponent(component);
            return TuplesKt.to((Object)component, (Object)true);
        }
        return TuplesKt.to((Object)old, (Object)false);
    }

    private final void addComponent(NavigateComponent component) {
        NodeExtKt.setNavigateComponent((Node)component.getElement(), component);
        this.components.add(component);
    }

    private static final void findLeftAlignedComponent$lambda$19$lambda$18(Function2 $tmp0, Object p0, Object p12) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p12);
    }

    public static final /* synthetic */ Pair access$addComponentIfAbsent(NavigateDocument $this, Element element, String memo, Function1 predicate2) {
        return $this.addComponentIfAbsent(element, memo, (Function1<? super Element, Boolean>)predicate2);
    }
}

