/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.dom.utils;

import ai.platon.pulsar.common.math.vectors.VectorsKt;
import ai.platon.pulsar.dom.FeaturedDocument;
import ai.platon.pulsar.dom.nodes.DOMRect;
import ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt;
import ai.platon.scent.dom.utils.DOMUtils;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import org.apache.commons.math3.linear.RealVector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0016\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010\fJ\u000e\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\b\b\u0002\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0004J\u0016\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u001dJ\u000e\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001e"}, d2={"Lai/platon/scent/dom/utils/DOMUtils;", "", "()V", "ML_LABEL_TIME", "", "getML_LABEL_TIME", "()Ljava/lang/String;", "annotateNodes", "", "document", "Lai/platon/pulsar/dom/FeaturedDocument;", "annotations", "", "clearAnnotations", "equals", "", "rect", "Lai/platon/pulsar/dom/nodes/DOMRect;", "rect2", "e", "", "getDOMRect", "node", "Lorg/jsoup/nodes/Node;", "getRectangle", "Ljava/awt/Rectangle;", "vi", "parseDOMRect", "attrKey", "Lorg/jsoup/nodes/TextNode;", "scent-dom"})
public final class DOMUtils {
    @NotNull
    public static final DOMUtils INSTANCE = new DOMUtils();
    @NotNull
    private static final String ML_LABEL_TIME = "ML_LABEL_TIME";

    private DOMUtils() {
    }

    @NotNull
    public final String getML_LABEL_TIME() {
        return ML_LABEL_TIME;
    }

    @NotNull
    public final Rectangle getRectangle(@NotNull String vi) {
        Intrinsics.checkNotNullParameter((Object)vi, (String)"vi");
        DOMRect r = DOMRect.Companion.parseDOMRect(vi);
        return new Rectangle(MathKt.roundToInt((double)r.getLeft()), MathKt.roundToInt((double)r.getTop()), MathKt.roundToInt((double)r.getWidth()), MathKt.roundToInt((double)r.getHeight()));
    }

    @NotNull
    public final DOMRect getDOMRect(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return new DOMRect((double)NodeExtKt.getX((Node)node), (double)NodeExtKt.getY((Node)node), (double)NodeExtKt.getWidth((Node)node), (double)NodeExtKt.getHeight((Node)node));
    }

    @NotNull
    public final DOMRect parseDOMRect(@NotNull Node node) {
        DOMRect dOMRect;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (node instanceof TextNode) {
            dOMRect = this.parseDOMRect("tv", (TextNode)node);
        } else {
            String string = node.attr("vi");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"attr(...)");
            dOMRect = DOMRect.Companion.parseDOMRect(string);
        }
        return dOMRect;
    }

    @NotNull
    public final DOMRect parseDOMRect(@NotNull String attrKey, @NotNull TextNode node) {
        Intrinsics.checkNotNullParameter((Object)attrKey, (String)"attrKey");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Node parent = node.parent();
        int i = node.siblingIndex();
        Node node2 = parent;
        Intrinsics.checkNotNull((Object)node2);
        String string = node2.attr(attrKey + i);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"attr(...)");
        String tv = string;
        return DOMRect.Companion.parseDOMRect(tv);
    }

    public final boolean equals(@NotNull DOMRect rect, @NotNull DOMRect rect2, double e) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        Intrinsics.checkNotNullParameter((Object)rect2, (String)"rect2");
        DOMRect r = rect;
        DOMRect r2 = rect2;
        return Math.abs(r.getLeft() - r2.getLeft()) < e && Math.abs(r.getTop() - r2.getTop()) < e && Math.abs(r.getWidth() - r2.getWidth()) < e && Math.abs(r.getHeight() - r2.getHeight()) < e;
    }

    public static /* synthetic */ boolean equals$default(DOMUtils dOMUtils, DOMRect dOMRect, DOMRect dOMRect2, double d, int n2, Object object) {
        if ((n2 & 4) != 0) {
            d = 0.99;
        }
        return dOMUtils.equals(dOMRect, dOMRect2, d);
    }

    public final void annotateNodes(@NotNull FeaturedDocument document, @Nullable Map<String, String> annotations) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        if (annotations == null) {
            return;
        }
        if (annotations.isEmpty()) {
            return;
        }
        document.forEach((Function1)new Function1<Node, Unit>(annotations){
            final /* synthetic */ Map<String, String> $annotations;
            {
                this.$annotations = $annotations;
                super(1);
            }

            public final void invoke(@NotNull Node node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                RealVector realVector = node.getExtension().getFeatures();
                Intrinsics.checkNotNullExpressionValue((Object)realVector, (String)"getFeatures(...)");
                if (VectorsKt.isEmpty((RealVector)realVector)) {
                    return;
                }
                node.removeAttr("L");
                Map<String, String> $this$forEach$iv = this.$annotations;
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<String, String>> iterator2 = $this$forEach$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    DOMRect rect2;
                    DOMRect rect;
                    CharSequence charSequence;
                    Map.Entry<String, String> element$iv;
                    Map.Entry<String, String> entry = element$iv = iterator2.next();
                    boolean bl = false;
                    String vi = entry.getKey();
                    String label = entry.getValue();
                    boolean isValidVI = !StringsKt.isBlank((CharSequence)vi) && !Intrinsics.areEqual((Object)vi, (Object)"0 0 0 0");
                    if (!isValidVI || (charSequence = (CharSequence)label) == null || StringsKt.isBlank((CharSequence)charSequence) || !DOMUtils.INSTANCE.equals(rect = DOMRect.Companion.parseDOMRect(vi), rect2 = DOMUtils.INSTANCE.parseDOMRect(node), 1.0)) continue;
                    NodeExtKt.addMlLabel((Node)node, (String)label);
                    node.attr("L", label);
                }
            }
        });
    }

    public final void clearAnnotations(@NotNull FeaturedDocument document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        NodeExtKt.removeVariable((Node)((Node)document.getDocument()), (String)ML_LABEL_TIME);
        document.forEach((Function1)clearAnnotations.1.INSTANCE);
    }
}

