/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.dom.utils;

import ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt;
import ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt;
import ai.platon.pulsar.dom.select.ElementTraversor;
import ai.platon.pulsar.dom.select.ElementVisitor;
import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002 !B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\"\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000b\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\u000eJ?\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010j\u0002`\u00132\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00112\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0016\"\u00020\b\u00a2\u0006\u0002\u0010\u0017J5\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u00192\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00112\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0016\"\u00020\b\u00a2\u0006\u0002\u0010\u001bJ*\u0010\u001c\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u00112\b\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\u000eJ\"\u0010\u001e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000b\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u001f\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\""}, d2={"Lai/platon/scent/dom/utils/DocumentUtils;", "", "()V", "addMeta", "Lorg/jsoup/nodes/Element;", "doc", "Lorg/jsoup/nodes/Document;", "name", "", "content", "findFirstChildHasText", "root", "pattern", "ownText", "", "findMostChildrenElement", "Lcom/google/common/collect/TreeMultimap;", "", "Lorg/jsoup/nodes/Node;", "Lai/platon/scent/dom/nodes/IntNodeIndexer;", "minChildren", "desiredTags", "", "(Lorg/jsoup/nodes/Element;I[Ljava/lang/String;)Lcom/google/common/collect/TreeMultimap;", "findNDepthElements", "", "depth", "(Lorg/jsoup/nodes/Element;I[Ljava/lang/String;)Ljava/util/List;", "findNthChildHasText", "n", "findSecondChildHasText", "getMeta", "MostChildrenElementFounder", "NDepthElementFounder", "scent-dom"})
public final class DocumentUtils {
    @NotNull
    public static final DocumentUtils INSTANCE = new DocumentUtils();

    private DocumentUtils() {
    }

    @NotNull
    public final Element addMeta(@NotNull Document doc, @NotNull String name, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Element element = new Element("meta").attr("name", name).attr("content", content).appendTo(doc.head());
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"appendTo(...)");
        return element;
    }

    @NotNull
    public final String getMeta(@NotNull Document doc, @NotNull String name) {
        String string;
        Element ele;
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Element element = ele = doc.head().selectFirst("meta[name='" + name + "']");
        if (element == null) {
            string = "";
        } else {
            String string2 = element.attr("content");
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"attr(...)");
        }
        return string;
    }

    @NotNull
    public final List<Element> findNDepthElements(@NotNull Element root, int depth, String ... desiredTags) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)desiredTags, (String)"desiredTags");
        NDepthElementFounder header = new NDepthElementFounder(depth, Arrays.copyOf(desiredTags, desiredTags.length));
        ElementTraversor.traverse((ElementVisitor)header, (Element)root);
        return header.getElements();
    }

    @Nullable
    public final Element findFirstChildHasText(@NotNull Element root, @Nullable String pattern, boolean ownText) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        return this.findNthChildHasText(root, 0, pattern, ownText);
    }

    @Nullable
    public final Element findSecondChildHasText(@NotNull Element root, @Nullable String pattern, boolean ownText) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        return this.findNthChildHasText(root, 1, pattern, ownText);
    }

    @Nullable
    public final Element findNthChildHasText(@NotNull Element root, int n2, @Nullable String pattern, boolean ownText) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        int n3 = n2;
        for (Element e : root.children()) {
            if (pattern == null) {
                if (ownText) {
                    if (e.ownText().length() <= 0) continue;
                    if (n3 == 0) {
                        return e;
                    }
                    --n3;
                    continue;
                }
                if (!e.hasText()) continue;
                if (n3 == 0) {
                    return e;
                }
                --n3;
                continue;
            }
            CharSequence charSequence = ownText ? e.ownText() : e.text();
            Intrinsics.checkNotNull((Object)charSequence);
            String s = charSequence;
            if (!(((CharSequence)s).length() > 0) || !new Regex(pattern).matches(charSequence = (CharSequence)s)) continue;
            if (n3 == 0) {
                return e;
            }
            --n3;
        }
        return null;
    }

    @NotNull
    public final TreeMultimap<Integer, Node> findMostChildrenElement(@NotNull Element root, int minChildren, String ... desiredTags) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)desiredTags, (String)"desiredTags");
        MostChildrenElementFounder founder = new MostChildrenElementFounder(minChildren, Arrays.copyOf(desiredTags, desiredTags.length));
        ElementTraversor.traverse((ElementVisitor)founder, (Element)root);
        return founder.getMostChildrenBlocks();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0003H\u0016R \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R!\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00130\u0012j\u0002`\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001c"}, d2={"Lai/platon/scent/dom/utils/DocumentUtils$MostChildrenElementFounder;", "Lai/platon/pulsar/dom/select/ElementVisitor;", "minChildren", "", "desiredTags", "", "", "(I[Ljava/lang/String;)V", "", "getDesiredTags", "()Ljava/util/List;", "setDesiredTags", "(Ljava/util/List;)V", "getMinChildren", "()I", "setMinChildren", "(I)V", "mostChildrenBlocks", "Lcom/google/common/collect/TreeMultimap;", "Lorg/jsoup/nodes/Node;", "Lai/platon/scent/dom/nodes/IntNodeIndexer;", "getMostChildrenBlocks", "()Lcom/google/common/collect/TreeMultimap;", "head", "", "ele", "Lorg/jsoup/nodes/Element;", "depth", "scent-dom"})
    private static final class MostChildrenElementFounder
    extends ElementVisitor {
        private int minChildren;
        @NotNull
        private List<String> desiredTags;
        @NotNull
        private final TreeMultimap<Integer, Node> mostChildrenBlocks;

        public MostChildrenElementFounder(int minChildren, String ... desiredTags) {
            Intrinsics.checkNotNullParameter((Object)desiredTags, (String)"desiredTags");
            this.desiredTags = new ArrayList();
            TreeMultimap treeMultimap = TreeMultimap.create((Comparator)ComparisonsKt.reverseOrder(), (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Node p0 = (Node)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(NodeExtKt.getSequence((Node)p0));
                    p0 = (Node)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(NodeExtKt.getSequence((Node)p0)));
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)treeMultimap, (String)"create(...)");
            this.mostChildrenBlocks = treeMultimap;
            this.minChildren = minChildren;
            if (desiredTags.length > 0) {
                List<String> list = Arrays.asList(Arrays.copyOf(desiredTags, desiredTags.length));
                Intrinsics.checkNotNullExpressionValue(list, (String)"asList(...)");
                this.desiredTags = list;
            }
        }

        public final int getMinChildren() {
            return this.minChildren;
        }

        public final void setMinChildren(int n2) {
            this.minChildren = n2;
        }

        @NotNull
        public final List<String> getDesiredTags() {
            return this.desiredTags;
        }

        public final void setDesiredTags(@NotNull List<String> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.desiredTags = list;
        }

        @NotNull
        public final TreeMultimap<Integer, Node> getMostChildrenBlocks() {
            return this.mostChildrenBlocks;
        }

        public void head(@NotNull Element ele, int depth) {
            Intrinsics.checkNotNullParameter((Object)ele, (String)"ele");
            if (!this.desiredTags.contains(ele.tagName())) {
                return;
            }
            int numChildren = (int)NodeExtKt.getFeature((Node)((Node)ele), (int)DefinedFeaturesKt.C);
            if (numChildren >= this.minChildren) {
                this.mostChildrenBlocks.put((Object)numChildren, (Object)ele);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u0003H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R \u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u000e\"\u0004\b\u0015\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lai/platon/scent/dom/utils/DocumentUtils$NDepthElementFounder;", "Lai/platon/pulsar/dom/select/ElementVisitor;", "depth", "", "desiredTags", "", "", "(I[Ljava/lang/String;)V", "getDepth", "()I", "setDepth", "(I)V", "", "getDesiredTags", "()Ljava/util/List;", "setDesiredTags", "(Ljava/util/List;)V", "elements", "", "Lorg/jsoup/nodes/Element;", "getElements", "setElements", "head", "", "ele", "scent-dom"})
    private static final class NDepthElementFounder
    extends ElementVisitor {
        private int depth;
        @NotNull
        private List<Element> elements;
        @NotNull
        private List<String> desiredTags;

        public NDepthElementFounder(int depth, String ... desiredTags) {
            Intrinsics.checkNotNullParameter((Object)desiredTags, (String)"desiredTags");
            this.elements = new ArrayList();
            this.desiredTags = new ArrayList();
            this.depth = depth;
            List<String> list = Arrays.asList(Arrays.copyOf(desiredTags, desiredTags.length));
            Intrinsics.checkNotNullExpressionValue(list, (String)"asList(...)");
            this.desiredTags = list;
        }

        public final int getDepth() {
            return this.depth;
        }

        public final void setDepth(int n2) {
            this.depth = n2;
        }

        @NotNull
        public final List<Element> getElements() {
            return this.elements;
        }

        public final void setElements(@NotNull List<Element> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.elements = list;
        }

        @NotNull
        public final List<String> getDesiredTags() {
            return this.desiredTags;
        }

        public final void setDesiredTags(@NotNull List<String> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.desiredTags = list;
        }

        public void head(@NotNull Element ele, int depth) {
            Intrinsics.checkNotNullParameter((Object)ele, (String)"ele");
            if (depth == this.depth && this.desiredTags.contains(ele.tagName())) {
                this.elements.add(ele);
            }
        }
    }
}

