/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.driver;

import ai.platon.scent.driver.CompactedScrapeResponse;
import ai.platon.scent.driver.Dashboard;
import ai.platon.scent.driver.ExceptionInfo;
import ai.platon.scent.driver.Page;
import ai.platon.scent.driver.ScrapeException;
import ai.platon.scent.driver.ScrapeRequest;
import ai.platon.scent.driver.ScrapeResponse;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020!J \u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\b\b\u0002\u0010%\u001a\u00020&2\b\b\u0002\u0010'\u001a\u00020&J\u000e\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0003J\u0018\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u00032\u0006\u0010.\u001a\u00020/H\u0002J\u0018\u00100\u001a\u00020\u00032\u0006\u00101\u001a\u00020\u00032\b\b\u0002\u00102\u001a\u000203J\u001a\u00104\u001a\b\u0012\u0004\u0012\u00020\u0003052\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u000307J\u001a\u00108\u001a\u00020\u00032\u0006\u00101\u001a\u00020\u00032\b\b\u0002\u00102\u001a\u000203H\u0002R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0016\u001a\n \f*\u0004\u0018\u00010\u00060\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lai/platon/scent/driver/Driver;", "Ljava/lang/AutoCloseable;", "server", "", "authToken", "httpTimeout", "Ljava/time/Duration;", "(Ljava/lang/String;Ljava/lang/String;Ljava/time/Duration;)V", "dashboardApi", "downloadApi", "httpClient", "Ljava/net/http/HttpClient;", "kotlin.jvm.PlatformType", "priority", "getPriority", "()Ljava/lang/String;", "setPriority", "(Ljava/lang/String;)V", "scrapeApi", "scrapeBaseUri", "statusApi", "statusQueryApi", "timeout", "getTimeout", "()Ljava/time/Duration;", "setTimeout", "(Ljava/time/Duration;)V", "userBaseUri", "close", "", "createGson", "Lcom/google/gson/Gson;", "dashboard", "Lai/platon/scent/driver/Dashboard;", "download", "Lai/platon/scent/driver/Page;", "Lai/platon/scent/driver/CompactedScrapeResponse;", "pageNumber", "", "pageSize", "findById", "Lai/platon/scent/driver/ScrapeResponse;", "id", "post", "Ljava/net/http/HttpRequest;", "url", "requestEntity", "", "submit", "sql", "asap", "", "submitAll", "", "sqls", "", "submitTask", "scent-driver"})
public final class Driver
implements AutoCloseable {
    @NotNull
    private final String server;
    @NotNull
    private final String authToken;
    @NotNull
    private final Duration httpTimeout;
    private Duration timeout;
    @NotNull
    private String priority;
    @NotNull
    private final String scrapeBaseUri;
    @NotNull
    private final String scrapeApi;
    @NotNull
    private final String statusApi;
    @NotNull
    private final String userBaseUri;
    @NotNull
    private final String dashboardApi;
    @NotNull
    private final String downloadApi;
    @NotNull
    private final String statusQueryApi;
    private final HttpClient httpClient;

    public Driver(@NotNull String server, @NotNull String authToken, @NotNull Duration httpTimeout) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)httpTimeout, (String)"httpTimeout");
        this.server = server;
        this.authToken = authToken;
        this.httpTimeout = httpTimeout;
        this.timeout = Duration.ofSeconds(120L);
        this.priority = "HIGHER3";
        this.scrapeBaseUri = "http://" + this.server + ":8182/api/x/a";
        this.scrapeApi = this.scrapeBaseUri + "/q";
        this.statusApi = this.scrapeBaseUri + "/status";
        this.userBaseUri = "http://" + this.server + ":8182/api/users/" + this.authToken;
        this.dashboardApi = this.userBaseUri + "/dashboard";
        this.downloadApi = this.userBaseUri + "/download";
        this.statusQueryApi = this.scrapeBaseUri + "/status/q";
        this.httpClient = HttpClient.newHttpClient();
    }

    public /* synthetic */ Driver(String string, String string2, Duration duration, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            Duration duration2 = Duration.ofMinutes(3L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofMinutes(3)");
            duration = duration2;
        }
        this(string, string2, duration);
    }

    public final Duration getTimeout() {
        return this.timeout;
    }

    public final void setTimeout(Duration duration) {
        this.timeout = duration;
    }

    @NotNull
    public final String getPriority() {
        return this.priority;
    }

    public final void setPriority(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.priority = string;
    }

    @NotNull
    public final String submit(@NotNull String sql, boolean asap) throws ScrapeException {
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        return this.submitTask(sql, asap);
    }

    public static /* synthetic */ String submit$default(Driver driver, String string, boolean bl, int n, Object object) throws ScrapeException {
        if ((n & 2) != 0) {
            bl = false;
        }
        return driver.submit(string, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> submitAll(@NotNull Collection<String> sqls) throws ScrapeException {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(sqls, (String)"sqls");
        Iterable $this$map$iv = sqls;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = Driver.submit$default(this, (String)it, false, 2, null);
            collection.add(string2);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Dashboard dashboard() {
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.dashboardApi)).timeout(this.httpTimeout).GET().build();
        HttpResponse<String> httpResponse = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        Object object = this.createGson().fromJson(httpResponse.body(), Dashboard.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"createGson().fromJson(ht\u2026), Dashboard::class.java)");
        return (Dashboard)object;
    }

    @NotNull
    public final ScrapeResponse findById(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.statusApi + "?id=" + id + "&authToken=" + this.authToken)).timeout(this.httpTimeout).GET().build();
        HttpResponse<String> httpResponse = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        Object object = this.createGson().fromJson(httpResponse.body(), ScrapeResponse.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"createGson().fromJson(ht\u2026rapeResponse::class.java)");
        return (ScrapeResponse)object;
    }

    @NotNull
    public final Page<CompactedScrapeResponse> download(int pageNumber, int pageSize) {
        String uri = this.downloadApi + "?pageNumber=" + pageNumber + "&pageSize=" + pageSize;
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(uri)).timeout(this.httpTimeout).GET().build();
        HttpResponse<String> httpResponse = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        Type listType2 = new TypeToken<Page<CompactedScrapeResponse>>(){}.getType();
        Object object = this.createGson().fromJson(httpResponse.body(), listType2);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"createGson().fromJson(ht\u2026esponse.body(), listType)");
        return (Page)object;
    }

    public static /* synthetic */ Page download$default(Driver driver, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = 500;
        }
        return driver.download(n, n2);
    }

    @NotNull
    public final Gson createGson() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter((Type)((Object)OffsetDateTime.class), (Object)new JsonDeserializer<OffsetDateTime>(){

            @NotNull
            public OffsetDateTime deserialize(@NotNull JsonElement ele, @NotNull Type type, @Nullable JsonDeserializationContext ctx) throws JsonParseException {
                Intrinsics.checkNotNullParameter((Object)ele, (String)"ele");
                Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                OffsetDateTime offsetDateTime = OffsetDateTime.parse(ele.getAsString());
                Intrinsics.checkNotNullExpressionValue((Object)offsetDateTime, (String)"parse(ele.asString)");
                return offsetDateTime;
            }
        });
        builder.registerTypeAdapter((Type)((Object)OffsetDateTime.class), (Object)new JsonSerializer<OffsetDateTime>(){

            @NotNull
            public JsonElement serialize(@NotNull OffsetDateTime time, @NotNull Type type, @Nullable JsonSerializationContext ctx) {
                Intrinsics.checkNotNullParameter((Object)time, (String)"time");
                Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                return (JsonElement)new JsonPrimitive(time.toString());
            }
        });
        Gson gson = builder.create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"builder.create()");
        return gson;
    }

    @Override
    public void close() {
    }

    private final String submitTask(String sql, boolean asap) throws ScrapeException, IOException, InterruptedException {
        ScrapeRequest requestEntity = new ScrapeRequest(this.authToken, sql, this.priority, asap);
        HttpRequest request = this.post(this.scrapeApi, requestEntity);
        HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        String body = response.body();
        if (response.statusCode() != 200) {
            ExceptionInfo info = (ExceptionInfo)this.createGson().fromJson(body, ExceptionInfo.class);
            Intrinsics.checkNotNullExpressionValue((Object)info, (String)"info");
            throw new ScrapeException(info);
        }
        Intrinsics.checkNotNullExpressionValue((Object)body, (String)"body");
        return body;
    }

    static /* synthetic */ String submitTask$default(Driver driver, String string, boolean bl, int n, Object object) throws ScrapeException, IOException, InterruptedException {
        if ((n & 2) != 0) {
            bl = false;
        }
        return driver.submitTask(string, bl);
    }

    private final HttpRequest post(String url, Object requestEntity) {
        String requestBody = new Gson().toJson(requestEntity);
        HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(url)).timeout(Duration.ofMinutes(3L)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(requestBody)).build();
        Intrinsics.checkNotNullExpressionValue((Object)httpRequest, (String)"newBuilder()\n           \u2026dy))\n            .build()");
        return httpRequest;
    }
}

