/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.examples;

import ai.platon.scent.driver.Dashboard;
import ai.platon.scent.driver.Driver;
import ai.platon.scent.driver.Page;
import ai.platon.scent.driver.ScrapeResponse;
import ai.platon.scent.driver.utils.ResourceLoader;
import ai.platon.scent.driver.utils.SQLTemplate;
import com.google.gson.Gson;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000f\u001a\u00020\u0010R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lai/platon/scent/examples/Scrape2;", "", "()V", "authToken", "", "getAuthToken", "()Ljava/lang/String;", "server", "getServer", "sqlTemplate", "getSqlTemplate", "urls", "", "getUrls", "()Ljava/util/List;", "start", "", "scent-driver"})
@SourceDebugExtension(value={"SMAP\nScrape2.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Scrape2.kt\nai/platon/scent/examples/Scrape2\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,64:1\n1855#2,2:65\n*S KotlinDebug\n*F\n+ 1 Scrape2.kt\nai/platon/scent/examples/Scrape2\n*L\n31#1:65,2\n*E\n"})
public final class Scrape2 {
    @NotNull
    private final String server;
    @NotNull
    private final String authToken;
    @NotNull
    private final List<String> urls = CollectionsKt.take((Iterable)CollectionsKt.shuffled((Iterable)ResourceLoader.INSTANCE.readAllLines("asin/asin-urls.txt")), (int)5);
    @NotNull
    private final String sqlTemplate;

    public Scrape2() {
        this.server = "crawl0";
        this.authToken = "b08anchor20e907a5931c2cfef04a4f1723e7bcf47e";
        this.sqlTemplate = "select\n   dom_first_text(dom, '#productTitle') as `title`,\n   dom_first_text(dom, '#price tr td:contains(List Price) ~ td') as `listprice`,\n   dom_first_text(dom, '#price tr td:matches(^Price) ~ td, #price_inside_buybox') as `price`,\n   array_join_to_string(dom_all_texts(dom, '#wayfinding-breadcrumbs_container ul li a'), '|') as `categories`,\n   dom_base_uri(dom) as `baseUri`\nfrom\n   load_and_select('{{url}} -i 1h', ':root')\n";
    }

    @NotNull
    public final String getServer() {
        return this.server;
    }

    @NotNull
    public final String getAuthToken() {
        return this.authToken;
    }

    @NotNull
    public final List<String> getUrls() {
        return this.urls;
    }

    @NotNull
    public final String getSqlTemplate() {
        return this.sqlTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        AutoCloseable autoCloseable = new Driver(this.server, this.authToken, null, 4, null);
        Throwable throwable = null;
        try {
            Driver driver = (Driver)autoCloseable;
            boolean bl = false;
            driver.setPriority("HIGHER2");
            Set ids = new LinkedHashSet();
            Iterable $this$forEach$iv = this.urls;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String url = (String)element$iv;
                boolean bl2 = false;
                String sql = new SQLTemplate(this.sqlTemplate).createSQL(url);
                String id = driver.submit(sql, false);
                ids.add(id);
            }
            Path path = Files.createTempFile("scent-", ".txt", new FileAttribute[0]);
            Files.write(path, (Iterable<? extends CharSequence>)ids, new OpenOption[0]);
            System.out.println((Object)("Ids are written to " + path));
            Gson gson = driver.createGson();
            ScrapeResponse status = driver.findById((String)CollectionsKt.first((Iterable)ids));
            System.out.println((Object)gson.toJson((Object)status));
            Dashboard dashboard = driver.dashboard();
            System.out.println((Object)gson.toJson((Object)dashboard));
            Page results = Driver.download$default(driver, 0, 10, 1, null);
            System.out.println((Object)gson.toJson((Object)results));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }
}

