/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.crawl.urls;

import ai.platon.pulsar.common.AppContext;
import ai.platon.pulsar.common.ExceptionsKt;
import ai.platon.pulsar.common.HtmlIntegrity;
import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.message.PageLoadStatusFormatter;
import ai.platon.pulsar.common.urls.NormUrl;
import ai.platon.pulsar.crawl.PageEvent;
import ai.platon.pulsar.crawl.common.GlobalCache;
import ai.platon.pulsar.crawl.common.GlobalCacheFactory;
import ai.platon.pulsar.crawl.common.url.CompletableListenableHyperlink;
import ai.platon.pulsar.dom.FeaturedDocument;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.ql.ResultSets;
import ai.platon.pulsar.ql.h2.utils.ResultSetUtils;
import ai.platon.scent.ScentSession;
import ai.platon.scent.common.ScrapeResultSet;
import ai.platon.scent.crawl.scrape.ScrapeExceptionHandler;
import ai.platon.scent.crawl.serialize.ScrapeResponseV2;
import ai.platon.scent.crawl.urls.SinkAwareHyperlinkMetrics;
import ai.platon.scent.crawl.urls.SinkAwareLoadEventHandlerV2;
import ai.platon.scent.executors.SinkCommitter;
import ai.platon.scent.executors.SinkResponse;
import ai.platon.scent.jackson.ExtensionsKt;
import ai.platon.scent.mongo.v2.ScrapeTaskStatusV2;
import ai.platon.scent.mongo.v2.XSqlTaskStatus;
import ai.platon.scent.ql.h2.context.support.AbstractScentSQLContext;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.gson.Gson;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.h2.jdbc.JdbcSQLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001BA\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r0\f\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\b\u0010B\u001a\u00020\u0012H\u0002J\u0018\u0010C\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u00105\u001a\u00020\u0002H\u0014J\u0010\u0010D\u001a\u00020\r2\u0006\u0010E\u001a\u00020FH\u0016J2\u0010G\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u00105\u001a\u00020\u00022\u0018\u0010H\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020J\u0012\u0004\u0012\u00020\r0IH\u0004J\u0010\u0010K\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u0012\u0010K\u001a\u0004\u0018\u00010L2\u0006\u0010M\u001a\u00020NH\u0004J\u001a\u0010K\u001a\u0004\u0018\u00010L2\u0006\u0010M\u001a\u00020N2\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u0018\u0010O\u001a\u00020L2\u0006\u0010M\u001a\u00020N2\u0006\u0010P\u001a\u00020\u001cH\u0004J\u0018\u0010Q\u001a\u00020\r2\u0006\u0010E\u001a\u00020F2\u0006\u0010R\u001a\u00020SH\u0016J\u0018\u0010T\u001a\u00020\r2\u0006\u0010E\u001a\u00020F2\u0006\u0010R\u001a\u00020SH\u0002J\u0018\u0010U\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u00105\u001a\u00020JH\u0004J\u0010\u0010V\u001a\u00020\r2\u0006\u0010E\u001a\u00020FH\u0002J\u0010\u0010W\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0012X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016R\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020 X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020&8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010)\u001a\n +*\u0004\u0018\u00010*0*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010,\u001a\u00020-X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0014\u00102\u001a\u00020\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00104R\u000e\u00105\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00108\u001a\u0002098BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010;R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010=R\u001c\u0010>\u001a\n +*\u0004\u0018\u00010?0?X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010AR\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006X"}, d2={"Lai/platon/scent/crawl/urls/ScrapeHyperlinkV2;", "Lai/platon/pulsar/crawl/common/url/CompletableListenableHyperlink;", "Lai/platon/scent/crawl/serialize/ScrapeResponseV2;", "normUrl", "Lai/platon/pulsar/common/urls/NormUrl;", "task", "Lai/platon/scent/mongo/v2/ScrapeTaskStatusV2;", "session", "Lai/platon/scent/ScentSession;", "sinkCommitter", "Lai/platon/scent/executors/SinkCommitter;", "taskUpdater", "Lkotlin/Function1;", "", "globalCacheFactory", "Lai/platon/pulsar/crawl/common/GlobalCacheFactory;", "(Lai/platon/pulsar/common/urls/NormUrl;Lai/platon/scent/mongo/v2/ScrapeTaskStatusV2;Lai/platon/scent/ScentSession;Lai/platon/scent/executors/SinkCommitter;Lkotlin/jvm/functions/Function1;Lai/platon/pulsar/crawl/common/GlobalCacheFactory;)V", "args", "", "getArgs", "()Ljava/lang/String;", "setArgs", "(Ljava/lang/String;)V", "authToken", "getAuthToken", "setAuthToken", "connectionPool", "Ljava/util/concurrent/ArrayBlockingQueue;", "Ljava/sql/Connection;", "getConnectionPool", "()Ljava/util/concurrent/ArrayBlockingQueue;", "event", "Lai/platon/pulsar/crawl/PageEvent;", "getEvent", "()Lai/platon/pulsar/crawl/PageEvent;", "setEvent", "(Lai/platon/pulsar/crawl/PageEvent;)V", "globalCache", "Lai/platon/pulsar/crawl/common/GlobalCache;", "getGlobalCache", "()Lai/platon/pulsar/crawl/common/GlobalCache;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "metrics", "Lai/platon/scent/crawl/urls/SinkAwareHyperlinkMetrics;", "getMetrics", "()Lai/platon/scent/crawl/urls/SinkAwareHyperlinkMetrics;", "getNormUrl", "()Lai/platon/pulsar/common/urls/NormUrl;", "randomConnection", "getRandomConnection", "()Ljava/sql/Connection;", "response", "getSession", "()Lai/platon/scent/ScentSession;", "sqlContext", "Lai/platon/scent/ql/h2/context/support/AbstractScentSQLContext;", "getSqlContext", "()Lai/platon/scent/ql/h2/context/support/AbstractScentSQLContext;", "getTask", "()Lai/platon/scent/mongo/v2/ScrapeTaskStatusV2;", "taskTime", "Ljava/time/Instant;", "getTaskTime", "()Ljava/time/Instant;", "buildArgs", "commit", "complete", "page", "Lai/platon/pulsar/persist/WebPage;", "executeCallback", "thenAction", "Lkotlin/Function2;", "Lai/platon/scent/executors/SinkResponse;", "executeQuery", "Ljava/sql/ResultSet;", "sqlTask", "Lai/platon/scent/mongo/v2/XSqlTaskStatus;", "executeQueryWithConnection", "conn", "extract", "document", "Lai/platon/pulsar/dom/FeaturedDocument;", "extract0", "handleSyncResponse", "statAfterExtract", "update", "scent-engine"})
public class ScrapeHyperlinkV2
extends CompletableListenableHyperlink<ScrapeResponseV2> {
    @NotNull
    private final NormUrl normUrl;
    @NotNull
    private final ScrapeTaskStatusV2 task;
    @NotNull
    private final ScentSession session;
    @NotNull
    private final SinkCommitter sinkCommitter;
    @NotNull
    private final Function1<ScrapeTaskStatusV2, Unit> taskUpdater;
    @NotNull
    private final GlobalCacheFactory globalCacheFactory;
    private final Logger logger;
    @NotNull
    private final SinkAwareHyperlinkMetrics metrics;
    private final Instant taskTime;
    @NotNull
    private final ScrapeResponseV2 response;
    @Nullable
    private String authToken;
    @Nullable
    private String args;
    @NotNull
    private PageEvent event;

    public ScrapeHyperlinkV2(@NotNull NormUrl normUrl, @NotNull ScrapeTaskStatusV2 task, @NotNull ScentSession session, @NotNull SinkCommitter sinkCommitter, @NotNull Function1<? super ScrapeTaskStatusV2, Unit> taskUpdater, @NotNull GlobalCacheFactory globalCacheFactory) {
        Intrinsics.checkNotNullParameter((Object)normUrl, (String)"normUrl");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)sinkCommitter, (String)"sinkCommitter");
        Intrinsics.checkNotNullParameter(taskUpdater, (String)"taskUpdater");
        Intrinsics.checkNotNullParameter((Object)globalCacheFactory, (String)"globalCacheFactory");
        super(normUrl.getSpec(), null, 0, null, null, null, null, 126, null);
        this.normUrl = normUrl;
        this.task = task;
        this.session = session;
        this.sinkCommitter = sinkCommitter;
        this.taskUpdater = taskUpdater;
        this.globalCacheFactory = globalCacheFactory;
        this.logger = LogsKt.getLogger((KClass)Reflection.getOrCreateKotlinClass(ScrapeHyperlinkV2.class));
        this.metrics = new SinkAwareHyperlinkMetrics("v2");
        this.taskTime = this.task.getCreatedAt().truncatedTo(ChronoUnit.SECONDS);
        this.response = new ScrapeResponseV2(this.task.getId(), this.task.getStatusCode(), 0, 0, false, 0L, null, null, 252, null);
        this.authToken = this.task.getAuthToken();
        this.args = this.buildArgs();
        this.event = (PageEvent)new SinkAwareLoadEventHandlerV2(this, this.task, this.metrics);
        this.metrics.getLinks().mark();
    }

    @NotNull
    public final NormUrl getNormUrl() {
        return this.normUrl;
    }

    @NotNull
    public final ScrapeTaskStatusV2 getTask() {
        return this.task;
    }

    @NotNull
    public final ScentSession getSession() {
        return this.session;
    }

    private final AbstractScentSQLContext getSqlContext() {
        return (AbstractScentSQLContext)this.session.getContext();
    }

    private final ArrayBlockingQueue<Connection> getConnectionPool() {
        return this.getSqlContext().getConnectionPool();
    }

    private final Connection getRandomConnection() {
        return this.getSqlContext().getRandomConnection();
    }

    @NotNull
    protected final GlobalCache getGlobalCache() {
        return this.globalCacheFactory.getGlobalCache();
    }

    @NotNull
    protected final SinkAwareHyperlinkMetrics getMetrics() {
        return this.metrics;
    }

    protected final Instant getTaskTime() {
        return this.taskTime;
    }

    @Nullable
    public String getAuthToken() {
        return this.authToken;
    }

    public void setAuthToken(@Nullable String string) {
        this.authToken = string;
    }

    @Nullable
    public String getArgs() {
        return this.args;
    }

    public void setArgs(@Nullable String string) {
        this.args = string;
    }

    @NotNull
    public PageEvent getEvent() {
        return this.event;
    }

    public void setEvent(@NotNull PageEvent pageEvent) {
        Intrinsics.checkNotNullParameter((Object)pageEvent, (String)"<set-?>");
        this.event = pageEvent;
    }

    public void extract(@NotNull WebPage page, @NotNull FeaturedDocument document) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        try {
            int statusCode;
            int n = page.getHtmlIntegrity() == HtmlIntegrity.WRONG_DISTRICT ? 412 : (!page.getProtocolStatus().isSuccess() ? 417 : (statusCode = page.getContentLength() == 0L || page.getContent() == null ? 204 : 102));
            if (statusCode == 102) {
                this.extract0(page, document);
            } else {
                this.task.setStatusCode(statusCode);
            }
        }
        catch (Throwable t) {
            this.logger.warn("Unexpected exception", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete(@NotNull WebPage page) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        if (this.isCancelled()) {
            return;
        }
        try {
            int contentLength = (int)page.getContentLength();
            int pageStatusCode = page.getHtmlIntegrity() == HtmlIntegrity.WRONG_DISTRICT ? 412 : (page.getProtocolStatus().isRetry() && page.getFetchRetries() > page.getMaxRetries() ? 410 : page.getProtocolStatus().getMinorCode());
            this.task.setContentLength(contentLength);
            this.task.setPageStatusCode(pageStatusCode);
            this.task.setDone(true);
            this.response.updateBy(this.task);
            this.statAfterExtract(page);
            this.commit(this.task, this.response);
            this.update(this.task);
        }
        finally {
            this.response.setDone(true);
            this.complete(this.response);
        }
    }

    private final void extract0(WebPage page, FeaturedDocument document) {
        this.getGlobalCache().putPDCache(page, document);
        this.executeQuery(this.task);
        Unit rs = Unit.INSTANCE;
    }

    protected void executeQuery(@NotNull ScrapeTaskStatusV2 task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        int failure = 0;
        task.setStatusCode(102);
        Iterable $this$forEach$iv = task.getSqlTasks();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            XSqlTaskStatus sqlTask = (XSqlTaskStatus)element$iv;
            boolean bl = false;
            ResultSet rs = this.executeQuery(sqlTask, task);
            if (sqlTask.getStatusCode() == 200) {
                List list;
                if (rs == null) continue;
                List entities = ResultSetUtils.INSTANCE.getEntitiesFromResultSet(rs);
                List list2 = task.getResultSets();
                if (list2 == null) {
                    boolean bl2 = false;
                    list = new ArrayList();
                } else {
                    list = list2;
                }
                List resultSets = list;
                resultSets.add(new ScrapeResultSet(sqlTask.getName(), entities));
                task.setResultSets(resultSets);
                continue;
            }
            ++failure;
        }
        int n = failure;
        task.setStatusCode(n == 0 ? 200 : (n == task.getSqlTasks().size() ? 417 : 206));
    }

    protected void commit(@NotNull ScrapeTaskStatusV2 task, @NotNull ScrapeResponseV2 response) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        try {
            if (task.getCallbackUrl() != null) {
                this.executeCallback(task, response, (Function2<? super ScrapeTaskStatusV2, ? super SinkResponse, Unit>)((Function2)new Function2<ScrapeTaskStatusV2, SinkResponse, Unit>(this, task){
                    final /* synthetic */ ScrapeHyperlinkV2 this$0;
                    final /* synthetic */ ScrapeTaskStatusV2 $task;
                    {
                        this.this$0 = $receiver;
                        this.$task = $task;
                        super(2);
                    }

                    public final void invoke(@NotNull ScrapeTaskStatusV2 $noName_0, @NotNull SinkResponse sinkResponse) {
                        Intrinsics.checkNotNullParameter((Object)$noName_0, (String)"$noName_0");
                        Intrinsics.checkNotNullParameter((Object)sinkResponse, (String)"sinkResponse");
                        this.this$0.handleSyncResponse(this.$task, sinkResponse);
                    }
                }));
            }
        }
        catch (JsonProcessingException e) {
            this.logger.warn("Failed serialize scrape response for <" + task.getId() + ">", (Throwable)e);
        }
        catch (Exception e) {
            this.logger.warn("Failed to commit task <" + task.getId() + ">", (Throwable)e);
        }
    }

    @Nullable
    protected ResultSet executeQuery(@NotNull XSqlTaskStatus sqlTask, @NotNull ScrapeTaskStatusV2 task) {
        Intrinsics.checkNotNullParameter((Object)sqlTask, (String)"sqlTask");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        ResultSet rs = null;
        try {
            rs = this.executeQuery(sqlTask);
        }
        catch (Throwable e) {
            sqlTask.setStatusCode(417);
            this.logger.warn("Failed to execute task #" + task.getId() + "\n{}", (Object)ExceptionsKt.stringify$default((Throwable)e, null, null, (int)3, null));
        }
        return rs;
    }

    @Nullable
    protected final ResultSet executeQuery(@NotNull XSqlTaskStatus sqlTask) {
        Object object;
        ScrapeHyperlinkV2 scrapeHyperlinkV2;
        Intrinsics.checkNotNullParameter((Object)sqlTask, (String)"sqlTask");
        Object object2 = this;
        boolean bl = false;
        boolean bl2 = false;
        ScrapeHyperlinkV2 it2 = object2;
        boolean bl3 = false;
        ScrapeHyperlinkV2 scrapeHyperlinkV22 = scrapeHyperlinkV2 = AppContext.INSTANCE.isActive() ? object2 : null;
        if (scrapeHyperlinkV2 == null) {
            return null;
        }
        object2 = this.getConnectionPool().poll();
        Object connection = object2 == null ? this.getRandomConnection() : object2;
        boolean bl4 = false;
        try {
            object = Result.Companion;
            boolean bl5 = false;
            ResultSet resultSet = this.executeQueryWithConnection(sqlTask, (Connection)connection);
            boolean it2 = false;
            object = Result.constructor-impl((Object)resultSet);
        }
        catch (Throwable throwable) {
            it2 = Result.Companion;
            bl3 = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Object object3 = object;
        boolean bl6 = false;
        boolean bl7 = false;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object3);
        if (throwable != null) {
            Throwable it3 = throwable;
            boolean bl8 = false;
            this.getConnectionPool().offer((Connection)connection);
            throw it3;
        }
        return (ResultSet)object3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected final ResultSet executeQueryWithConnection(@NotNull XSqlTaskStatus sqlTask, @NotNull Connection conn) {
        AutoCloseable autoCloseable;
        AutoCloseable autoCloseable2;
        Intrinsics.checkNotNullParameter((Object)sqlTask, (String)"sqlTask");
        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
        String sql2 = sqlTask.getSql();
        ResultSet result2 = null;
        Statement statement = conn.createStatement(1005, 1007);
        if (statement != null) {
            autoCloseable2 = statement;
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                ResultSet resultSet;
                Statement st = (Statement)autoCloseable2;
                boolean bl3 = false;
                try {
                    Unit unit;
                    resultSet = st.executeQuery(sql2);
                    if (resultSet == null) {
                        unit = null;
                    } else {
                        AutoCloseable autoCloseable3 = resultSet;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        Throwable throwable2 = null;
                        try {
                            ResultSet rs = (ResultSet)autoCloseable3;
                            boolean bl6 = false;
                            result2 = ResultSetUtils.copyResultSet$default((ResultSetUtils)ResultSetUtils.INSTANCE, (ResultSet)rs, (int)0, (int)2, null);
                            sqlTask.setStatusCode(200);
                            Unit unit2 = Unit.INSTANCE;
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable3, (Throwable)throwable2);
                        }
                        unit = Unit.INSTANCE;
                    }
                    resultSet = unit;
                }
                catch (JdbcSQLException e) {
                    String string = e.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"e.toString()");
                    String message = string;
                    if (StringsKt.contains$default((CharSequence)message, (CharSequence)"Syntax error in SQL statement", (boolean)false, (int)2, null)) {
                        sqlTask.setStatusCode(400);
                        this.logger.warn("Syntax error in SQL statement #" + this.getTask().getId() + "\n{}", (Object)ExceptionsKt.stringify$default((Throwable)e, null, null, (int)3, null));
                    } else {
                        sqlTask.setStatusCode(417);
                        this.logger.warn("Failed to execute scrape task #" + this.getTask().getId() + "\n{}", (Object)ExceptionsKt.stringify$default((Throwable)e, null, null, (int)3, null));
                    }
                    resultSet = Unit.INSTANCE;
                }
                ResultSet resultSet2 = resultSet;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable);
            }
        }
        statement = result2;
        if (statement == null) {
            autoCloseable2 = ResultSets.newResultSet();
            Intrinsics.checkNotNullExpressionValue((Object)autoCloseable2, (String)"newResultSet()");
            autoCloseable = autoCloseable2;
        } else {
            autoCloseable = statement;
        }
        return autoCloseable;
    }

    protected final void executeCallback(@NotNull ScrapeTaskStatusV2 task, @NotNull ScrapeResponseV2 response, @NotNull Function2<? super ScrapeTaskStatusV2, ? super SinkResponse, Unit> thenAction) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter(thenAction, (String)"thenAction");
        String string = task.getCallbackUrl();
        if (string == null) {
            return;
        }
        String callbackUrl = string;
        this.metrics.getCommits().mark();
        try {
            String responseBody = ExtensionsKt.scentObjectMapper().writeValueAsString((Object)response);
            this.logger.info("Writing " + responseBody);
            Intrinsics.checkNotNullExpressionValue((Object)responseBody, (String)"responseBody");
            this.sinkCommitter.commit(responseBody, callbackUrl, (Function1<? super SinkResponse, Unit>)((Function1)new Function1<SinkResponse, Unit>(thenAction, task){
                final /* synthetic */ Function2<ScrapeTaskStatusV2, SinkResponse, Unit> $thenAction;
                final /* synthetic */ ScrapeTaskStatusV2 $task;
                {
                    this.$thenAction = $thenAction;
                    this.$task = $task;
                    super(1);
                }

                public final void invoke(@NotNull SinkResponse commitResponse) {
                    Intrinsics.checkNotNullParameter((Object)commitResponse, (String)"commitResponse");
                    this.$thenAction.invoke((Object)this.$task, (Object)commitResponse);
                }
            }));
        }
        catch (Exception e) {
            this.metrics.getFailedCommits().mark();
            task.setSyncError(e.getMessage());
        }
    }

    protected final void handleSyncResponse(@NotNull ScrapeTaskStatusV2 task, @NotNull SinkResponse response) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        this.metrics.getSyncResponses().mark();
        task.setSyncStatusCode(response.getStatusCode());
        if (response.getStatusCode() != 0 && response.getStatusCode() != 200) {
            this.metrics.getFailedSyncResponses().mark();
        }
        task.setSyncResponseHeaders(StringUtils.abbreviateMiddle((String)new Gson().toJson(response.getHeaders()), (String)"...", (int)256));
        task.setSyncResponseBody(StringUtils.abbreviateMiddle((String)response.getBody(), (String)"...", (int)1024));
        this.update(task);
    }

    private final void statAfterExtract(WebPage page) {
        ScrapeExceptionHandler.INSTANCE.trackIfInconsistent(this.task, this.response, page);
        if (this.response.getStatusCode() == 200) {
            List<ScrapeResultSet> rs = this.response.getResultSets();
            if (rs == null) {
                this.metrics.getNullResults().mark();
                PageLoadStatusFormatter pageLoadStatusFormatter = new PageLoadStatusFormatter(page, "Null result", false, false, false, false, 60, null);
                boolean bl = false;
                boolean bl2 = false;
                PageLoadStatusFormatter it = pageLoadStatusFormatter;
                boolean bl3 = false;
                this.logger.info(String.valueOf(it));
            } else if (rs.isEmpty()) {
                this.metrics.getEmptyResults().mark();
                PageLoadStatusFormatter pageLoadStatusFormatter = new PageLoadStatusFormatter(page, "Empty result", false, false, false, false, 60, null);
                boolean bl = false;
                boolean bl4 = false;
                PageLoadStatusFormatter it = pageLoadStatusFormatter;
                boolean bl5 = false;
                this.logger.info(String.valueOf(it));
            }
        }
    }

    private final void update(ScrapeTaskStatusV2 task) {
        block2: {
            boolean bl;
            boolean bl2;
            Object object;
            this.metrics.getPersists().mark();
            boolean bl3 = false;
            try {
                object = Result.Companion;
                boolean bl4 = false;
                this.taskUpdater.invoke((Object)task);
                Unit unit = Unit.INSTANCE;
                bl2 = false;
                object = Result.constructor-impl((Object)unit);
            }
            catch (Throwable throwable) {
                Result.Companion companion = Result.Companion;
                bl = false;
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            Object object2 = object;
            boolean bl5 = false;
            boolean bl6 = false;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block2;
            Throwable throwable2 = throwable;
            bl2 = false;
            bl = false;
            Throwable throwable3 = throwable2;
            boolean bl7 = false;
            Throwable it = throwable3;
            boolean bl8 = false;
            this.logger.warn("Failed to update task <" + task.getId() + ">", it);
        }
    }

    private final String buildArgs() {
        String string;
        if (this.task.getId() == null) {
            throw new IllegalArgumentException("task.id should not be null");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("-parse -taskId " + this.task.getId() + " -taskTime " + this.taskTime);
        String string2 = this.normUrl.getArgs();
        boolean bl = false;
        boolean bl2 = false;
        String it = string2;
        boolean bl3 = false;
        CharSequence charSequence = it;
        boolean bl4 = false;
        String string3 = string = !StringsKt.isBlank((CharSequence)charSequence) ? string2 : null;
        if (string != null) {
            string2 = string;
            bl = false;
            bl2 = false;
            it = string2;
            boolean bl5 = false;
            sb.append(" ").append(it);
        }
        if (this.getAuthToken() != null) {
            sb.append(" -authToken ").append(this.getAuthToken());
        }
        string2 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sb.toString()");
        String finalArgs = string2;
        this.task.setArgs(finalArgs);
        return finalArgs;
    }
}

