/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.io;

import ai.platon.pulsar.common.AppPaths;
import ai.platon.pulsar.crawl.common.URLUtil;
import ai.platon.pulsar.persist.WebPage;
import java.nio.file.Path;
import java.time.Month;
import java.time.MonthDay;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006\u00a8\u0006\n"}, d2={"Lai/platon/scent/io/ExportUtils;", "", "()V", "buildExportPath", "Ljava/nio/file/Path;", "label", "", "page", "Lai/platon/pulsar/persist/WebPage;", "extension", "scent-engine"})
public final class ExportUtils {
    @NotNull
    public static final ExportUtils INSTANCE = new ExportUtils();

    private ExportUtils() {
    }

    @NotNull
    public final Path buildExportPath(@NotNull String label, @NotNull WebPage page, @NotNull String extension) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        String string = page.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"page.url");
        String url = string;
        Month month = MonthDay.now().getMonth();
        int dayOfMonth = MonthDay.now().getDayOfMonth();
        String string2 = URLUtil.INSTANCE.getDomainName(url);
        String domain = string2 == null ? "unknown" : string2;
        String string3 = page.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"page.url");
        String filename = AppPaths.INSTANCE.fromUri(string3, "", "." + extension);
        Path path = AppPaths.INSTANCE.getDOC_EXPORT_DIR().resolve(domain).resolve(extension).resolve(label).resolve(String.valueOf(month)).resolve(String.valueOf(dayOfMonth)).resolve(filename);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
        return path;
    }
}

