/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.io;

import ai.platon.pulsar.common.AppFiles;
import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.context.PulsarContexts;
import ai.platon.pulsar.context.support.AbstractPulsarContext;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.persist.gora.generated.GWebPage;
import ai.platon.pulsar.persist.model.FieldGroup;
import ai.platon.pulsar.persist.model.PageModel;
import ai.platon.pulsar.session.PulsarSession;
import ai.platon.scent.io.ExportUtils;
import com.google.gson.GsonBuilder;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0003R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0017"}, d2={"Lai/platon/scent/io/PageEntity2JSONExporter;", "", "label", "", "session", "Lai/platon/pulsar/session/PulsarSession;", "(Ljava/lang/String;Lai/platon/pulsar/session/PulsarSession;)V", "context", "Lai/platon/pulsar/context/support/AbstractPulsarContext;", "getLabel", "()Ljava/lang/String;", "logger", "Lorg/slf4j/Logger;", "pageFields", "", "Lai/platon/pulsar/persist/gora/generated/GWebPage$Field;", "getSession", "()Lai/platon/pulsar/session/PulsarSession;", "export", "", "page", "Lai/platon/pulsar/persist/WebPage;", "url", "scent-engine"})
public final class PageEntity2JSONExporter {
    @NotNull
    private final String label;
    @NotNull
    private final PulsarSession session;
    @NotNull
    private final Logger logger;
    @NotNull
    private final AbstractPulsarContext context;
    @NotNull
    private final List<GWebPage.Field> pageFields;

    public PageEntity2JSONExporter(@NotNull String label, @NotNull PulsarSession session) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.label = label;
        this.session = session;
        this.logger = LogsKt.getLogger((Object)this);
        this.context = (AbstractPulsarContext)this.session.getContext();
        Object[] objectArray = new GWebPage.Field[]{GWebPage.Field.CONTENT_LENGTH, GWebPage.Field.PAGE_MODEL, GWebPage.Field.CREATE_TIME};
        this.pageFields = CollectionsKt.listOf((Object[])objectArray);
    }

    public /* synthetic */ PageEntity2JSONExporter(String string, PulsarSession pulsarSession, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            pulsarSession = PulsarContexts.createSession();
        }
        this(string, pulsarSession);
    }

    @NotNull
    public final String getLabel() {
        return this.label;
    }

    @NotNull
    public final PulsarSession getSession() {
        return this.session;
    }

    public final void export() {
        String urlPrefix = "https://www.amazon.com/";
        Sequence pages2 = SequencesKt.filter((Sequence)SequencesKt.asSequence((Iterator)this.context.scan(urlPrefix, (Iterable)this.pageFields)), (Function1)((Function1)new Function1<WebPage, Boolean>(urlPrefix){
            final /* synthetic */ String $urlPrefix;
            {
                this.$urlPrefix = $urlPrefix;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull WebPage it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string = it.getUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.url");
                return StringsKt.startsWith$default((String)string, (String)this.$urlPrefix, (boolean)false, (int)2, null);
            }
        }));
        int i = 0;
        Sequence $this$forEach$iv = pages2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WebPage page = (WebPage)element$iv;
            boolean bl = false;
            String string = ++i + ".\t" + page.getUrl() + "\t" + page.getCreateTime() + "\t" + page.getContentLength();
            boolean bl2 = false;
            System.out.println((Object)string);
            this.export(page);
        }
    }

    public final void export(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        WebPage page = this.context.getWebDb().get(url, (Iterable)this.pageFields);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"page");
        this.export(page);
    }

    public final void export(@NotNull WebPage page) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        PageModel pageModel = page.getPageModel();
        if (pageModel != null) {
            int numFields = pageModel.getNumFields();
            this.logger.info("There are {} extracted fields in page | {}", (Object)numFields, (Object)page.getUrl());
            FieldGroup fieldGroup = pageModel.findById(1);
            if (fieldGroup != null) {
                List entities = CollectionsKt.listOf((Object)fieldGroup.getFieldsCopy());
                String json = new GsonBuilder().serializeNulls().setPrettyPrinting().create().toJson((Object)entities);
                Path path = ExportUtils.INSTANCE.buildExportPath(this.label, page, "json");
                Intrinsics.checkNotNullExpressionValue((Object)json, (String)"json");
                AppFiles.INSTANCE.saveTo(json, path, true);
            }
        }
    }
}

