/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.ql.h2;

import ai.platon.pulsar.ql.SQLSession;
import ai.platon.pulsar.ql.SessionDelegate;
import ai.platon.pulsar.ql.context.SQLContext;
import ai.platon.pulsar.ql.context.SQLContexts;
import ai.platon.pulsar.ql.h2.H2SessionDelegate;
import ai.platon.scent.ql.h2.ScentSQLSession;
import java.sql.Connection;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.h2.engine.ConnectionInfo;
import org.h2.engine.Engine;
import org.h2.engine.Session;
import org.h2.engine.SessionFactory;
import org.h2.engine.SessionInterface;
import org.h2.engine.SysProperties;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.DbException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0015\u001a\u00020\u0000H\u0007J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0014R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001d"}, d2={"Lai/platon/scent/ql/h2/H2SessionFactory;", "Lorg/h2/engine/SessionFactory;", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "scentSqlContext", "Lai/platon/pulsar/ql/context/SQLContext;", "getScentSqlContext", "()Lai/platon/pulsar/ql/context/SQLContext;", "closeSession", "", "serialId", "", "createSession", "Lorg/h2/engine/Session;", "ci", "Lorg/h2/engine/ConnectionInfo;", "getH2Session", "connection", "Ljava/sql/Connection;", "getInstance", "getSession", "Lai/platon/scent/ql/h2/ScentSQLSession;", "sessionInterface", "Lorg/h2/engine/SessionInterface;", "isColumnRetrieval", "", "conn", "scent-engine"})
public final class H2SessionFactory
implements SessionFactory {
    @NotNull
    public static final H2SessionFactory INSTANCE = new H2SessionFactory();
    private static final Logger log;

    private H2SessionFactory() {
    }

    private final SQLContext getScentSqlContext() {
        return SQLContexts.INSTANCE.create();
    }

    @JvmStatic
    @NotNull
    public static final H2SessionFactory getInstance() {
        return INSTANCE;
    }

    public final boolean isColumnRetrieval(@NotNull Connection conn) {
        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
        String string = conn.getMetaData().getURL();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"conn.metaData.url");
        return StringsKt.contains$default((CharSequence)string, (CharSequence)"jdbc:columnlist:connection", (boolean)false, (int)2, null);
    }

    @NotNull
    public Session createSession(@NotNull ConnectionInfo ci) {
        Intrinsics.checkNotNullParameter((Object)ci, (String)"ci");
        if (!this.getScentSqlContext().isActive()) {
            DbException dbException = DbException.get((int)90098, (String)"Scent sql context is closed");
            Intrinsics.checkNotNullExpressionValue((Object)dbException, (String)"get(ErrorCode.DATABASE_I\u2026t sql context is closed\")");
            throw (Throwable)dbException;
        }
        log.debug("Creating scent session for h2 connection | {}", (Object)ci.getURL());
        Session h2session = Engine.getInstance().createSession(ci);
        SysProperties.serializeJavaObject = ci.isPersistent();
        Logger h2Log = LoggerFactory.getLogger((String)"org.h2");
        if (h2Log.isTraceEnabled()) {
            h2session.getTrace().setLevel(4);
        }
        SQLContext sQLContext = this.getScentSqlContext();
        int n = h2session.getSerialId();
        Intrinsics.checkNotNullExpressionValue((Object)h2session, (String)"h2session");
        SQLSession scentSQLSession = sQLContext.createSession((SessionDelegate)new H2SessionDelegate(n, h2session));
        boolean bl = scentSQLSession.getId() == h2session.getSerialId();
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Object[] objectArray = new Object[]{scentSQLSession, h2session, ci.getURL()};
        log.info("ScentSQLSession {} is created for h2session <{}>, connection: <{}>", objectArray);
        return h2session;
    }

    public void closeSession(int serialId) {
        this.getScentSqlContext().closeSession(serialId);
    }

    @NotNull
    public final ScentSQLSession getSession(@NotNull Connection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        JdbcConnection conn = (JdbcConnection)connection;
        SessionInterface sessionInterface = conn.getSession();
        Intrinsics.checkNotNullExpressionValue((Object)sessionInterface, (String)"conn.session");
        return this.getSession(sessionInterface);
    }

    @NotNull
    public final Session getH2Session(@NotNull Connection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        return (Session)this.getSession(connection).getSessionDelegate().getImplementation();
    }

    @NotNull
    public final ScentSQLSession getSession(@NotNull SessionInterface sessionInterface) {
        Intrinsics.checkNotNullParameter((Object)sessionInterface, (String)"sessionInterface");
        return (ScentSQLSession)this.getScentSqlContext().getSession(((Session)sessionInterface).getSerialId());
    }

    static {
        boolean bl = Intrinsics.areEqual((Object)System.getProperty("h2.sessionFactory"), (Object)"ai.platon.scent.ql.h2.H2SessionFactory");
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        log = LoggerFactory.getLogger(H2SessionFactory.class);
    }
}

