/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.ql.h2.context;

import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.context.PulsarContext;
import ai.platon.pulsar.context.PulsarContexts;
import ai.platon.scent.BasicScentSession;
import ai.platon.scent.context.ScentContexts;
import ai.platon.scent.ql.h2.context.ScentSQLContext;
import ai.platon.scent.ql.h2.context.support.ClassPathXmlScentH2Context;
import ai.platon.scent.ql.h2.context.support.DefaultClassPathXmlScentH2Context;
import ai.platon.scent.ql.h2.context.support.ScentH2Context;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lai/platon/scent/ql/h2/context/ScentSQLContexts;", "", "()V", "logger", "Lorg/slf4j/Logger;", "create", "Lai/platon/scent/ql/h2/context/ScentSQLContext;", "context", "contextLocation", "", "Lorg/springframework/context/ApplicationContext;", "createSession", "Lai/platon/scent/BasicScentSession;", "shutdown", "", "scent-engine"})
public final class ScentSQLContexts {
    @NotNull
    public static final ScentSQLContexts INSTANCE = new ScentSQLContexts();
    @NotNull
    private static final Logger logger = LogsKt.getLogger((Object)INSTANCE);

    private ScentSQLContexts() {
    }

    @NotNull
    public final synchronized ScentSQLContext create() {
        PulsarContext pulsarContext = PulsarContexts.INSTANCE.getActiveContext();
        ScentSQLContext scentSQLContext = pulsarContext instanceof ScentSQLContext ? (ScentSQLContext)pulsarContext : null;
        return scentSQLContext == null ? this.create(new DefaultClassPathXmlScentH2Context()) : scentSQLContext;
    }

    @NotNull
    public final synchronized ScentSQLContext create(@NotNull ScentSQLContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ScentSQLContext scentSQLContext = context;
        boolean bl = false;
        boolean bl2 = false;
        ScentSQLContext it = scentSQLContext;
        boolean bl3 = false;
        ScentContexts.INSTANCE.create(it);
        return scentSQLContext;
    }

    @NotNull
    public final synchronized ScentSQLContext create(@NotNull ApplicationContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PulsarContext activated = PulsarContexts.INSTANCE.getActiveContext();
        if (activated != null && activated instanceof ScentH2Context && Intrinsics.areEqual((Object)((ScentH2Context)activated).getApplicationContext(), (Object)context)) {
            logger.debug("Context is already active | {}#{}", (Object)Reflection.getOrCreateKotlinClass(activated.getClass()), (Object)((ScentH2Context)activated).getId());
            return (ScentSQLContext)activated;
        }
        return this.create(new ScentH2Context((AbstractApplicationContext)context));
    }

    @NotNull
    public final synchronized ScentSQLContext create(@NotNull String contextLocation) {
        Intrinsics.checkNotNullParameter((Object)contextLocation, (String)"contextLocation");
        PulsarContext activated = PulsarContexts.INSTANCE.getActiveContext();
        if (activated != null && activated instanceof ClassPathXmlScentH2Context) {
            logger.debug("Context is already active | {}#{}", (Object)Reflection.getOrCreateKotlinClass(activated.getClass()), (Object)((ClassPathXmlScentH2Context)activated).getId());
            return (ScentSQLContext)activated;
        }
        return this.create(new ClassPathXmlScentH2Context(contextLocation));
    }

    @NotNull
    public final synchronized BasicScentSession createSession() {
        return this.create().createSession();
    }

    public final synchronized void shutdown() {
        ScentContexts.INSTANCE.shutdown();
    }
}

