/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.ql.h2.context.support;

import ai.platon.pulsar.common.ExceptionsKt;
import ai.platon.pulsar.common.Systems;
import ai.platon.pulsar.common.options.LoadOptions;
import ai.platon.pulsar.common.sql.SQLUtils;
import ai.platon.pulsar.common.urls.NormUrl;
import ai.platon.pulsar.ql.SessionDelegate;
import ai.platon.scent.AbstractScentSession;
import ai.platon.scent.context.support.AbstractScentContext;
import ai.platon.scent.ql.h2.AbstractScentSQLSession;
import ai.platon.scent.ql.h2.context.ScentSQLContext;
import ai.platon.scent.ql.h2.context.support.AbstractScentSQLContext;
import java.sql.Connection;
import java.sql.ResultSet;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.h2.engine.Session;
import org.h2.engine.SessionInterface;
import org.h2.message.DbException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.AbstractApplicationContext;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 ?2\u00020\u00012\u00020\u0002:\u0002?@B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020\u0016H\u0016J\u0010\u0010'\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020)H&J\b\u0010*\u001a\u00020$H\u0002J\u0010\u0010+\u001a\u00020$2\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020/2\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u00100\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020\u0016H\u0016J\u0010\u00100\u001a\u00020\u001a2\u0006\u00101\u001a\u000202H\u0016J \u00103\u001a\u0002042\u0006\u00105\u001a\u00020-2\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u000209H\u0016J\u001c\u0010:\u001a\u00020$2\u0012\u0010;\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020$0<H\u0016J\u001c\u0010=\u001a\u00020/2\u0012\u0010;\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020/0<H\u0016J\b\u0010>\u001a\u00020\u0016H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0082D\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u001a0\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"\u00a8\u0006A"}, d2={"Lai/platon/scent/ql/h2/context/support/AbstractScentSQLContext;", "Lai/platon/scent/context/support/AbstractScentContext;", "Lai/platon/scent/ql/h2/context/ScentSQLContext;", "applicationContext", "Lorg/springframework/context/support/AbstractApplicationContext;", "(Lorg/springframework/context/support/AbstractApplicationContext;)V", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "connectionPool", "Ljava/util/concurrent/ArrayBlockingQueue;", "Ljava/sql/Connection;", "getConnectionPool", "()Ljava/util/concurrent/ArrayBlockingQueue;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "randomConnection", "getRandomConnection", "()Ljava/sql/Connection;", "randomConnectionOrNull", "getRandomConnectionOrNull", "resultSetConcurrency", "", "resultSetType", "sqlSessions", "Ljava/util/concurrent/ConcurrentHashMap;", "Lai/platon/scent/ql/h2/AbstractScentSQLSession;", "getSqlSessions", "()Ljava/util/concurrent/ConcurrentHashMap;", "status", "Lai/platon/scent/ql/h2/context/support/AbstractScentSQLContext$Status;", "getStatus", "()Lai/platon/scent/ql/h2/context/support/AbstractScentSQLContext$Status;", "setStatus", "(Lai/platon/scent/ql/h2/context/support/AbstractScentSQLContext$Status;)V", "close", "", "closeSession", "sessionId", "createSession", "sessionDelegate", "Lai/platon/pulsar/ql/SessionDelegate;", "ensureRunning", "execute", "sql", "", "executeQuery", "Ljava/sql/ResultSet;", "getSession", "sessionInterface", "Lorg/h2/engine/SessionInterface;", "normalize", "Lai/platon/pulsar/common/urls/NormUrl;", "url", "options", "Lai/platon/pulsar/common/options/LoadOptions;", "toItemOption", "", "run", "block", "Lkotlin/Function1;", "runQuery", "sessionCount", "Companion", "Status", "scent-engine"})
public abstract class AbstractScentSQLContext
extends AbstractScentContext
implements ScentSQLContext {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Logger logger;
    @NotNull
    private Status status;
    @NotNull
    private final ArrayBlockingQueue<Connection> connectionPool;
    private final int resultSetType;
    private final int resultSetConcurrency;
    @NotNull
    private final ConcurrentHashMap<Integer, AbstractScentSQLSession> sqlSessions;
    @NotNull
    private final AtomicBoolean closed;
    public static final int ID_START = 0x200B20;
    public static final int ID_END = 2099999;

    public AbstractScentSQLContext(@NotNull AbstractApplicationContext applicationContext) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        super(applicationContext, null, 2, null);
        this.logger = LoggerFactory.getLogger(AbstractScentSQLContext.class);
        this.status = Status.NOT_READY;
        this.connectionPool = new ArrayBlockingQueue(1000);
        this.resultSetType = 1005;
        this.resultSetConcurrency = 1007;
        this.sqlSessions = new ConcurrentHashMap();
        this.closed = new AtomicBoolean();
        Systems.INSTANCE.setPropertyIfAbsent("scent.extract.tabulate.cell.type", "DATABASE");
        this.status = Status.INITIALIZING;
        Object[] objectArray = new Object[]{this.getId(), this.getSessions().size(), this.getClass().getSimpleName()};
        this.logger.info("SQLContext is created | {}/{} | {}", objectArray);
        this.status = Status.RUNNING;
    }

    @NotNull
    public final Status getStatus() {
        return this.status;
    }

    public final void setStatus(@NotNull Status status) {
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"<set-?>");
        this.status = status;
    }

    @NotNull
    public abstract Connection getRandomConnection();

    @Nullable
    public final Connection getRandomConnectionOrNull() {
        boolean bl;
        boolean bl2;
        Object object;
        boolean bl3 = false;
        try {
            object = Result.Companion;
            boolean bl4 = false;
            Connection connection = this.getRandomConnection();
            bl2 = false;
            object = Result.constructor-impl((Object)connection);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            bl = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Result.Companion companion = object;
        boolean bl5 = false;
        boolean bl6 = false;
        Throwable throwable = Result.exceptionOrNull-impl((Object)companion);
        if (throwable != null) {
            Throwable throwable2 = throwable;
            bl2 = false;
            bl = false;
            Throwable throwable3 = throwable2;
            boolean bl7 = false;
            Throwable it = throwable3;
            boolean bl8 = false;
            this.logger.warn(ExceptionsKt.stringify$default((Throwable)it, null, null, (int)3, null));
        }
        bl5 = false;
        return (Connection)(Result.isFailure-impl((Object)companion) ? null : companion);
    }

    @NotNull
    public final ArrayBlockingQueue<Connection> getConnectionPool() {
        return this.connectionPool;
    }

    @NotNull
    public final ConcurrentHashMap<Integer, AbstractScentSQLSession> getSqlSessions() {
        return this.sqlSessions;
    }

    @NotNull
    public NormUrl normalize(@NotNull String url, @NotNull LoadOptions options, boolean toItemOption) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        NormUrl normUrl = super.normalize(url, options, toItemOption);
        return new NormUrl(SQLUtils.INSTANCE.unsanitizeUrl(normUrl.getSpec()), normUrl.getOptions(), normUrl.getHrefSpec(), null, 8, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(@NotNull String sql2) {
        Connection it;
        boolean bl;
        boolean bl2;
        Connection connection;
        Intrinsics.checkNotNullParameter((Object)sql2, (String)"sql");
        Connection connection2 = this.connectionPool.poll();
        Connection conn = connection2 == null ? this.getRandomConnection() : connection2;
        try {
            conn.createStatement(this.resultSetType, this.resultSetConcurrency).execute(sql2);
            connection = conn;
            bl2 = false;
            bl = false;
            it = connection;
            boolean bl3 = false;
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                Connection connection3;
                Connection connection4 = conn;
                boolean bl4 = false;
                boolean bl5 = false;
                Connection it2 = connection4;
                boolean bl6 = false;
                Connection connection5 = connection3 = !it2.isClosed() ? connection4 : null;
                if (connection3 != null) {
                    connection4 = connection3;
                    bl4 = false;
                    bl5 = false;
                    it2 = connection4;
                    boolean bl7 = false;
                    this.getConnectionPool().add(conn);
                }
                throw throwable;
            }
        }
        Connection connection6 = connection2 = !it.isClosed() ? connection : null;
        if (connection2 != null) {
            connection = connection2;
            bl2 = false;
            bl = false;
            it = connection;
            boolean bl8 = false;
            this.getConnectionPool().add(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ResultSet executeQuery(@NotNull String sql2) throws Exception {
        Connection connection;
        Connection it;
        boolean bl;
        boolean bl2;
        Connection connection2;
        Intrinsics.checkNotNullParameter((Object)sql2, (String)"sql");
        AutoCloseable autoCloseable = this.connectionPool.poll();
        Connection conn = autoCloseable == null ? this.getRandomConnection() : autoCloseable;
        try {
            autoCloseable = conn.createStatement(this.resultSetType, this.resultSetConcurrency).executeQuery(sql2);
            Intrinsics.checkNotNullExpressionValue((Object)autoCloseable, (String)"{\n            conn.creat\u2026ecuteQuery(sql)\n        }");
            connection2 = conn;
            bl2 = false;
            bl = false;
            it = connection2;
            boolean bl3 = false;
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                Connection connection3;
                Connection connection4 = conn;
                boolean bl4 = false;
                boolean bl5 = false;
                Connection it2 = connection4;
                boolean bl6 = false;
                Connection connection5 = connection3 = !it2.isClosed() ? connection4 : null;
                if (connection3 != null) {
                    connection4 = connection3;
                    bl4 = false;
                    bl5 = false;
                    it2 = connection4;
                    boolean bl7 = false;
                    this.getConnectionPool().add(conn);
                }
                throw throwable;
            }
        }
        Connection connection6 = connection = !it.isClosed() ? connection2 : null;
        if (connection != null) {
            connection2 = connection;
            bl2 = false;
            bl = false;
            it = connection2;
            boolean bl8 = false;
            this.getConnectionPool().add(conn);
        }
        return autoCloseable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(@NotNull Function1<? super Connection, Unit> block) {
        Connection it;
        boolean bl;
        boolean bl2;
        Connection connection;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Connection connection2 = this.connectionPool.poll();
        Connection conn = connection2 == null ? this.getRandomConnection() : connection2;
        try {
            block.invoke((Object)conn);
            connection = conn;
            bl2 = false;
            bl = false;
            it = connection;
            boolean bl3 = false;
        }
        catch (Throwable t) {
            Connection connection3;
            Connection it2;
            boolean bl4;
            boolean bl5;
            Connection connection4;
            try {
                this.logger.warn(ExceptionsKt.stringify$default((Throwable)t, (String)"Unexpected exception\n", null, (int)2, null));
                connection4 = conn;
                bl5 = false;
                bl4 = false;
                it2 = connection4;
                boolean bl6 = false;
            }
            catch (Throwable throwable) {
                Connection connection5;
                Connection connection6 = conn;
                boolean bl7 = false;
                boolean bl8 = false;
                Connection it3 = connection6;
                boolean bl9 = false;
                Connection connection7 = connection5 = !it3.isClosed() ? connection6 : null;
                if (connection5 != null) {
                    connection6 = connection5;
                    bl7 = false;
                    bl8 = false;
                    it3 = connection6;
                    boolean bl10 = false;
                    this.getConnectionPool().add(conn);
                }
                throw throwable;
            }
            Connection connection8 = connection3 = !it2.isClosed() ? connection4 : null;
            if (connection3 != null) {
                connection4 = connection3;
                bl5 = false;
                bl4 = false;
                it2 = connection4;
                boolean bl11 = false;
                this.getConnectionPool().add(conn);
            }
        }
        Connection connection9 = connection2 = !it.isClosed() ? connection : null;
        if (connection2 != null) {
            connection = connection2;
            bl2 = false;
            bl = false;
            it = connection;
            boolean bl12 = false;
            this.getConnectionPool().add(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ResultSet runQuery(@NotNull Function1<? super Connection, ? extends ResultSet> block) throws Exception {
        Connection connection;
        Connection it;
        boolean bl;
        boolean bl2;
        Connection connection2;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        AutoCloseable autoCloseable = this.connectionPool.poll();
        Connection conn = autoCloseable == null ? this.getRandomConnection() : autoCloseable;
        try {
            autoCloseable = (ResultSet)block.invoke((Object)conn);
            connection2 = conn;
            bl2 = false;
            bl = false;
            it = connection2;
            boolean bl3 = false;
        }
        catch (Throwable throwable) {
            Connection connection3;
            Connection connection4 = conn;
            boolean bl4 = false;
            boolean bl5 = false;
            Connection it2 = connection4;
            boolean bl6 = false;
            Connection connection5 = connection3 = !it2.isClosed() ? connection4 : null;
            if (connection3 != null) {
                connection4 = connection3;
                bl4 = false;
                bl5 = false;
                it2 = connection4;
                boolean bl7 = false;
                this.getConnectionPool().add(conn);
            }
            throw throwable;
        }
        Connection connection6 = connection = !it.isClosed() ? connection2 : null;
        if (connection != null) {
            connection2 = connection;
            bl2 = false;
            bl = false;
            it = connection2;
            boolean bl8 = false;
            this.getConnectionPool().add(conn);
        }
        return autoCloseable;
    }

    @Override
    @NotNull
    public abstract AbstractScentSQLSession createSession(@NotNull SessionDelegate var1);

    @Override
    public int sessionCount() {
        this.ensureRunning();
        return this.sqlSessions.size();
    }

    @NotNull
    public AbstractScentSQLSession getSession(@NotNull SessionInterface sessionInterface) {
        Intrinsics.checkNotNullParameter((Object)sessionInterface, (String)"sessionInterface");
        Session h2session = (Session)sessionInterface;
        return this.getSession(h2session.getSerialId());
    }

    @Override
    @NotNull
    public AbstractScentSQLSession getSession(int sessionId) {
        this.ensureRunning();
        AbstractScentSQLSession session = this.sqlSessions.get(sessionId);
        if (session == null) {
            Object[] objectArray = new Object[]{sessionId, this.getId()};
            String message = MessageFormat.format("Session is already closed | #{0}/{1}", objectArray);
            this.logger.warn(message);
            objectArray = DbException.get((int)90007, (String)message);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"get(ErrorCode.OBJECT_CLOSED, message)");
            throw (Throwable)objectArray;
        }
        return session;
    }

    @Override
    public void closeSession(int sessionId) {
        this.ensureRunning();
        Object[] objectArray = this.sqlSessions.remove(sessionId);
        if (objectArray != null) {
            objectArray.close();
        }
        objectArray = new Object[]{this.getId(), sessionId, this.sqlSessions.size()};
        this.logger.info("SQLSession is closed | #{}/{}/{}", objectArray);
    }

    public void close() {
        Integer n = this.getId();
        Collection<Object> collection = this.sqlSessions.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"sqlSessions.keys");
        this.logger.info("Closing SQLContext #{}, sql sessions: {}", (Object)n, (Object)CollectionsKt.joinToString$default((Iterable)collection, null, null, null, (int)0, null, (Function1)close.1.INSTANCE, (int)31, null));
        if (this.closed.compareAndSet(false, true)) {
            Object it;
            this.status = Status.CLOSING;
            collection = this.sqlSessions.values();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"sqlSessions.values");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (AbstractScentSQLSession)element$iv;
                boolean bl = false;
                ((AbstractScentSession)it).close();
            }
            this.sqlSessions.clear();
            $this$forEach$iv = this.connectionPool;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Connection)element$iv;
                boolean bl = false;
                it.close();
            }
            this.connectionPool.clear();
            this.status = Status.CLOSED;
        }
        super.close();
    }

    private final void ensureRunning() {
        if (!this.isActive()) {
            throw new IllegalStateException("SQLContext is closed | #" + this.getId());
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lai/platon/scent/ql/h2/context/support/AbstractScentSQLContext$Companion;", "", "()V", "ID_END", "", "ID_START", "scent-engine"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lai/platon/scent/ql/h2/context/support/AbstractScentSQLContext$Status;", "", "(Ljava/lang/String;I)V", "NOT_READY", "INITIALIZING", "RUNNING", "CLOSING", "CLOSED", "scent-engine"})
    public static final class Status
    extends Enum<Status> {
        public static final /* enum */ Status NOT_READY = new Status();
        public static final /* enum */ Status INITIALIZING = new Status();
        public static final /* enum */ Status RUNNING = new Status();
        public static final /* enum */ Status CLOSING = new Status();
        public static final /* enum */ Status CLOSED = new Status();
        private static final /* synthetic */ Status[] $VALUES;

        public static Status[] values() {
            return (Status[])$VALUES.clone();
        }

        public static Status valueOf(String value) {
            return Enum.valueOf(Status.class, value);
        }

        static {
            $VALUES = statusArray = new Status[]{Status.NOT_READY, Status.INITIALIZING, Status.RUNNING, Status.CLOSING, Status.CLOSED};
        }
    }
}

