/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.crawl;

import ai.platon.pulsar.common.DateTimes;
import ai.platon.pulsar.common.config.VolatileConfig;
import ai.platon.pulsar.skeleton.common.options.LoadOptionDefaults;
import ai.platon.pulsar.skeleton.common.options.LoadOptions;
import ai.platon.pulsar.skeleton.session.PulsarSession;
import ai.platon.scent.common.ClusterTools;
import ai.platon.scent.crawl.ResidentTask;
import ai.platon.scent.dom.HarvestOptions;
import ai.platon.scent.persist.mongo.v1.NaiveResidentTask;
import ai.platon.scent.skeleton.ScentSession;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001a\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u001a\u0010\u0007\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a&\u0010\u0007\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\u0010\b\u001a\u00060\tj\u0002`\n\u001a\n\u0010\u000b\u001a\u00020\u0006*\u00020\f\u001a\n\u0010\r\u001a\u00020\u0006*\u00020\f\u001a\n\u0010\u000e\u001a\u00020\u0006*\u00020\u0002\u001a\n\u0010\u000e\u001a\u00020\u0006*\u00020\f\u001a\"\u0010\u000f\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\n\u0010\u0011\u001a\u00020\u0012*\u00020\u0002\u001a\n\u0010\u0011\u001a\u00020\u0012*\u00020\f\u001a\n\u0010\u0013\u001a\u00020\u0012*\u00020\u0002\u001a\n\u0010\u0013\u001a\u00020\u0012*\u00020\f\u001a\n\u0010\u0014\u001a\u00020\u0012*\u00020\u0002\u001a\n\u0010\u0015\u001a\u00020\u0016*\u00020\u0002\u001a\n\u0010\u0015\u001a\u00020\u0016*\u00020\f\u001a\n\u0010\u0017\u001a\u00020\u0006*\u00020\f\u00a8\u0006\u0018"}, d2={"createArgs", "Lai/platon/pulsar/skeleton/common/options/LoadOptions;", "Lai/platon/scent/crawl/ResidentTask;", "taskId", "", "taskTime", "Ljava/time/Instant;", "createOptions", "session", "Lai/platon/scent/skeleton/ScentSession;", "Lai/platon/scent/ScentSession;", "deadTime", "Lai/platon/scent/persist/mongo/v1/NaiveResidentTask;", "endTime", "expireAt", "initOptions", "options", "isDead", "", "isRunTime", "isSupervised", "localStartTime", "Ljava/time/LocalDateTime;", "startTime", "scent-engine"})
@SourceDebugExtension(value={"SMAP\nResidentTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResidentTask.kt\nai/platon/scent/crawl/ResidentTaskKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,181:1\n1#2:182\n*E\n"})
public final class ResidentTaskKt {
    @NotNull
    public static final Instant expireAt(@NotNull ResidentTask $this$expireAt) {
        Instant instant;
        Intrinsics.checkNotNullParameter((Object)$this$expireAt, (String)"<this>");
        if ($this$expireAt.getTaskPeriod().toHours() == 1L) {
            Instant instant2 = Instant.now().truncatedTo(ChronoUnit.HOURS);
            instant = instant2;
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"truncatedTo(...)");
        } else if ($this$expireAt.getTaskPeriod().toDays() == 1L) {
            instant = (Instant)$this$expireAt.getStartTime().invoke();
        } else {
            Instant instant3 = LoadOptionDefaults.INSTANCE.getExpireAt();
            instant = instant3;
            Intrinsics.checkNotNullExpressionValue((Object)instant3, (String)"<get-expireAt>(...)");
        }
        return instant;
    }

    public static final boolean isDead(@NotNull ResidentTask $this$isDead) {
        Intrinsics.checkNotNullParameter((Object)$this$isDead, (String)"<this>");
        if ($this$isDead.getIgnoreTTL()) {
            return false;
        }
        return Instant.now().compareTo((Instant)$this$isDead.getDeadTime().invoke()) > 0;
    }

    public static final boolean isRunTime(@NotNull ResidentTask $this$isRunTime) {
        Intrinsics.checkNotNullParameter((Object)$this$isRunTime, (String)"<this>");
        if ($this$isRunTime.getIgnoreTTL()) {
            return true;
        }
        Instant now = Instant.now();
        return now.compareTo((Instant)$this$isRunTime.getStartTime().invoke()) >= 0 && now.compareTo((Instant)$this$isRunTime.getEndTime().invoke()) < 0;
    }

    @NotNull
    public static final LocalDateTime localStartTime(@NotNull ResidentTask $this$localStartTime) {
        Intrinsics.checkNotNullParameter((Object)$this$localStartTime, (String)"<this>");
        LocalDateTime localDateTime = ((Instant)$this$localStartTime.getStartTime().invoke()).atOffset(DateTimes.INSTANCE.getZoneOffset()).toLocalDateTime();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"toLocalDateTime(...)");
        return localDateTime;
    }

    @NotNull
    public static final LoadOptions createArgs(@NotNull ResidentTask $this$createArgs, @NotNull String taskId, @NotNull Instant taskTime) {
        LoadOptions loadOptions;
        Intrinsics.checkNotNullParameter((Object)$this$createArgs, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
        Intrinsics.checkNotNullParameter((Object)taskTime, (String)"taskTime");
        LoadOptions it = loadOptions = LoadOptions.Companion.create(VolatileConfig.Companion.getUNSAFE());
        boolean bl = false;
        it.setParse(true);
        it.setExpires($this$createArgs.getExpires());
        it.setExpireAt(ResidentTaskKt.expireAt($this$createArgs));
        it.setTaskId(taskId);
        it.setTaskTime(taskTime);
        it.setLabel($this$createArgs.getLabel());
        it.setIgnoreFailure(true);
        it.setStoreContent($this$createArgs.getStoreContent());
        return loadOptions;
    }

    @NotNull
    public static final LoadOptions createOptions(@NotNull ResidentTask $this$createOptions, @NotNull String taskId, @NotNull Instant taskTime, @NotNull ScentSession session2) {
        Intrinsics.checkNotNullParameter((Object)$this$createOptions, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
        Intrinsics.checkNotNullParameter((Object)taskTime, (String)"taskTime");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        LoadOptions loadOptions = PulsarSession.DefaultImpls.options$default((PulsarSession)session2, null, (int)1, null);
        HarvestOptions it = (HarvestOptions)loadOptions;
        boolean bl = false;
        ResidentTaskKt.initOptions($this$createOptions, (LoadOptions)it, taskId, taskTime);
        return loadOptions;
    }

    @NotNull
    public static final LoadOptions createOptions(@NotNull ResidentTask $this$createOptions, @NotNull String taskId, @NotNull Instant taskTime) {
        LoadOptions loadOptions;
        Intrinsics.checkNotNullParameter((Object)$this$createOptions, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
        Intrinsics.checkNotNullParameter((Object)taskTime, (String)"taskTime");
        LoadOptions it = loadOptions = LoadOptions.Companion.create(VolatileConfig.Companion.getUNSAFE());
        boolean bl = false;
        ResidentTaskKt.initOptions($this$createOptions, it, taskId, taskTime);
        return loadOptions;
    }

    @NotNull
    public static final LoadOptions initOptions(@NotNull ResidentTask $this$initOptions, @NotNull LoadOptions options, @NotNull String taskId, @NotNull Instant taskTime) {
        Intrinsics.checkNotNullParameter((Object)$this$initOptions, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
        Intrinsics.checkNotNullParameter((Object)taskTime, (String)"taskTime");
        options.setParse(true);
        options.setExpires($this$initOptions.getExpires());
        options.setExpireAt(ResidentTaskKt.expireAt($this$initOptions));
        options.setTaskId(taskId);
        options.setTaskTime(taskTime);
        options.setLabel($this$initOptions.getLabel());
        options.setIgnoreFailure(true);
        options.setRefresh($this$initOptions.getRefresh());
        options.setStoreContent($this$initOptions.getStoreContent());
        return options;
    }

    public static final boolean isSupervised(@NotNull ResidentTask $this$isSupervised) {
        Intrinsics.checkNotNullParameter((Object)$this$isSupervised, (String)"<this>");
        int mod = $this$isSupervised.getId() % ClusterTools.INSTANCE.getCrawlerCount();
        return ClusterTools.INSTANCE.getInstancePartition() == mod;
    }

    @NotNull
    public static final Instant startTime(@NotNull NaiveResidentTask $this$startTime) {
        Instant instant;
        Intrinsics.checkNotNullParameter((Object)$this$startTime, (String)"<this>");
        switch ($this$startTime.getStartTimePolicy()) {
            case "START_OF_DAY": {
                instant = DateTimes.INSTANCE.startOfDay();
                break;
            }
            case "START_OF_HOUR": {
                instant = DateTimes.INSTANCE.startOfHour();
                break;
            }
            case "AT_9AM": {
                instant = DateTimes.timePointOfDay$default((DateTimes)DateTimes.INSTANCE, (int)9, (int)0, (int)0, (int)6, null);
                break;
            }
            default: {
                Instant instant2 = Instant.now();
                instant = instant2;
                Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now(...)");
            }
        }
        return instant;
    }

    @NotNull
    public static final Instant endTime(@NotNull NaiveResidentTask $this$endTime) {
        Instant instant;
        Intrinsics.checkNotNullParameter((Object)$this$endTime, (String)"<this>");
        String string = $this$endTime.getEndTimePolicy();
        if (Intrinsics.areEqual((Object)string, (Object)"END_OF_DAY")) {
            instant = DateTimes.INSTANCE.endOfDay();
        } else if (Intrinsics.areEqual((Object)string, (Object)"END_OF_HOUR")) {
            instant = DateTimes.INSTANCE.endOfHour();
        } else {
            Instant instant2 = Instant.now();
            instant = instant2;
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now(...)");
        }
        return instant;
    }

    @NotNull
    public static final Instant deadTime(@NotNull NaiveResidentTask $this$deadTime) {
        Instant instant;
        Intrinsics.checkNotNullParameter((Object)$this$deadTime, (String)"<this>");
        String string = $this$deadTime.getEndTimePolicy();
        if (Intrinsics.areEqual((Object)string, (Object)"END_OF_DAY")) {
            instant = DateTimes.INSTANCE.endOfDay();
        } else if (Intrinsics.areEqual((Object)string, (Object)"END_OF_HOUR")) {
            instant = DateTimes.INSTANCE.endOfHour();
        } else {
            Instant instant2 = DateTimes.INSTANCE.getDoomsday();
            instant = instant2;
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"<get-doomsday>(...)");
        }
        return instant;
    }

    @NotNull
    public static final Instant expireAt(@NotNull NaiveResidentTask $this$expireAt) {
        Instant instant;
        Intrinsics.checkNotNullParameter((Object)$this$expireAt, (String)"<this>");
        if ($this$expireAt.getTaskPeriod().toHours() == 1L) {
            Instant instant2 = Instant.now().truncatedTo(ChronoUnit.HOURS);
            instant = instant2;
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"truncatedTo(...)");
        } else if ($this$expireAt.getTaskPeriod().toDays() == 1L) {
            instant = ResidentTaskKt.startTime($this$expireAt);
        } else {
            Instant instant3 = LoadOptionDefaults.INSTANCE.getExpireAt();
            instant = instant3;
            Intrinsics.checkNotNullExpressionValue((Object)instant3, (String)"<get-expireAt>(...)");
        }
        return instant;
    }

    public static final boolean isDead(@NotNull NaiveResidentTask $this$isDead) {
        Intrinsics.checkNotNullParameter((Object)$this$isDead, (String)"<this>");
        if ($this$isDead.getIgnoreTTL()) {
            return false;
        }
        return Instant.now().compareTo(ResidentTaskKt.deadTime($this$isDead)) > 0;
    }

    public static final boolean isRunTime(@NotNull NaiveResidentTask $this$isRunTime) {
        Intrinsics.checkNotNullParameter((Object)$this$isRunTime, (String)"<this>");
        if ($this$isRunTime.getIgnoreTTL()) {
            return true;
        }
        Instant now = Instant.now();
        return now.compareTo(ResidentTaskKt.startTime($this$isRunTime)) >= 0 && now.compareTo(ResidentTaskKt.endTime($this$isRunTime)) < 0;
    }

    @NotNull
    public static final LocalDateTime localStartTime(@NotNull NaiveResidentTask $this$localStartTime) {
        Intrinsics.checkNotNullParameter((Object)$this$localStartTime, (String)"<this>");
        LocalDateTime localDateTime = ResidentTaskKt.startTime($this$localStartTime).atOffset(DateTimes.INSTANCE.getZoneOffset()).toLocalDateTime();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"toLocalDateTime(...)");
        return localDateTime;
    }
}

