/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.crawl.urls;

import ai.platon.pulsar.common.AppContext;
import ai.platon.pulsar.common.ExceptionsKt;
import ai.platon.pulsar.common.HtmlIntegrity;
import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.serialize.json.JacksonKt;
import ai.platon.pulsar.dom.FeaturedDocument;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.ql.h2.utils.ResultSetUtils;
import ai.platon.pulsar.skeleton.common.message.PageLoadStatusFormatter;
import ai.platon.pulsar.skeleton.context.PulsarContext;
import ai.platon.pulsar.skeleton.crawl.PageEventHandlers;
import ai.platon.pulsar.skeleton.crawl.common.GlobalCache;
import ai.platon.pulsar.skeleton.crawl.common.GlobalCacheFactory;
import ai.platon.pulsar.skeleton.crawl.common.url.CompletableListenableHyperlink;
import ai.platon.scent.common.sql.NormXSQL;
import ai.platon.scent.crawl.scrape.ScrapeExceptionHandler;
import ai.platon.scent.crawl.serialize.ScrapeResponse;
import ai.platon.scent.crawl.sql.ScrapeAPIUtils;
import ai.platon.scent.crawl.urls.SinkAwareHyperlinkMetrics;
import ai.platon.scent.crawl.urls.SinkAwareLoadEventHandler;
import ai.platon.scent.executors.SinkCommitter;
import ai.platon.scent.executors.SinkResponse;
import ai.platon.scent.persist.mongo.v1.ScrapeTask;
import ai.platon.scent.persist.mongo.v1.ScrapeTaskDetail;
import ai.platon.scent.ql.h2.context.support.AbstractScentSQLContext;
import ai.platon.scent.skeleton.ScentSession;
import com.google.gson.Gson;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.h2.engine.SysProperties;
import org.h2.jdbc.JdbcSQLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 _2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001_BA\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r0\f\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\b\u0010F\u001a\u00020\u0004H\u0002J\u0010\u0010G\u001a\u00020\r2\u0006\u0010/\u001a\u00020\u0002H\u0014J\b\u0010H\u001a\u00020\rH\u0014J\u0012\u0010I\u001a\u00020\r2\b\u0010J\u001a\u0004\u0018\u00010KH\u0016J\u0018\u0010L\u001a\u00020\r2\u0006\u0010M\u001a\u00020\u00042\u0006\u0010N\u001a\u00020\u0004H\u0004J\n\u0010O\u001a\u0004\u0018\u00010PH\u0016J\u0012\u0010O\u001a\u0004\u0018\u00010P2\u0006\u0010Q\u001a\u00020\u0004H\u0004J\u001a\u0010R\u001a\u0004\u0018\u00010P2\u0006\u0010Q\u001a\u00020\u00042\u0006\u0010S\u001a\u00020\u001bH\u0004J\u0012\u0010T\u001a\u0004\u0018\u00010P2\u0006\u0010U\u001a\u00020VH\u0014J\u0018\u0010W\u001a\u00020\r2\u0006\u0010J\u001a\u00020K2\u0006\u0010X\u001a\u00020YH\u0016J\u001a\u0010Z\u001a\u0004\u0018\u00010P2\u0006\u0010J\u001a\u00020K2\u0006\u0010X\u001a\u00020YH\u0014J\u0010\u0010[\u001a\u00020\r2\u0006\u0010/\u001a\u00020\\H\u0004J\b\u0010]\u001a\u00020\rH\u0004J\u0010\u0010^\u001a\u00020\r2\u0006\u0010J\u001a\u00020KH\u0002R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0015R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u001fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020%8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0014\u0010\u000e\u001a\u00020\u000fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010,\u001a\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u0014\u0010/\u001a\u00020\u0002X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u000e\u00102\u001a\u000203X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u000203X\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108R\u0014\u00109\u001a\u00020:8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u0010<R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010>R\u001c\u0010?\u001a\n A*\u0004\u0018\u00010@0@X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010CR \u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r0\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010E\u00a8\u0006`"}, d2={"Lai/platon/scent/crawl/urls/ScrapeHyperlinkVS;", "Lai/platon/pulsar/skeleton/crawl/common/url/CompletableListenableHyperlink;", "Lai/platon/scent/crawl/serialize/ScrapeResponse;", "fetchUrl", "", "task", "Lai/platon/scent/persist/mongo/v1/ScrapeTask;", "session", "Lai/platon/scent/skeleton/ScentSession;", "sinkCommitter", "Lai/platon/scent/executors/SinkCommitter;", "taskUpdater", "Lkotlin/Function1;", "", "globalCacheFactory", "Lai/platon/pulsar/skeleton/crawl/common/GlobalCacheFactory;", "(Ljava/lang/String;Lai/platon/scent/persist/mongo/v1/ScrapeTask;Lai/platon/scent/skeleton/ScentSession;Lai/platon/scent/executors/SinkCommitter;Lkotlin/jvm/functions/Function1;Lai/platon/pulsar/skeleton/crawl/common/GlobalCacheFactory;)V", "args", "getArgs", "()Ljava/lang/String;", "setArgs", "(Ljava/lang/String;)V", "authToken", "getAuthToken", "setAuthToken", "connectionPool", "Ljava/util/concurrent/ArrayBlockingQueue;", "Ljava/sql/Connection;", "getConnectionPool", "()Ljava/util/concurrent/ArrayBlockingQueue;", "eventHandlers", "Lai/platon/pulsar/skeleton/crawl/PageEventHandlers;", "getEventHandlers", "()Lai/platon/pulsar/skeleton/crawl/PageEventHandlers;", "setEventHandlers", "(Lai/platon/pulsar/skeleton/crawl/PageEventHandlers;)V", "globalCache", "Lai/platon/pulsar/skeleton/crawl/common/GlobalCache;", "getGlobalCache", "()Lai/platon/pulsar/skeleton/crawl/common/GlobalCache;", "getGlobalCacheFactory", "()Lai/platon/pulsar/skeleton/crawl/common/GlobalCacheFactory;", "logger", "Lorg/slf4j/Logger;", "randomConnection", "getRandomConnection", "()Ljava/sql/Connection;", "response", "getResponse", "()Lai/platon/scent/crawl/serialize/ScrapeResponse;", "resultSetConcurrency", "", "resultSetType", "getSession", "()Lai/platon/scent/skeleton/ScentSession;", "getSinkCommitter", "()Lai/platon/scent/executors/SinkCommitter;", "sqlContext", "Lai/platon/scent/ql/h2/context/support/AbstractScentSQLContext;", "getSqlContext", "()Lai/platon/scent/ql/h2/context/support/AbstractScentSQLContext;", "getTask", "()Lai/platon/scent/persist/mongo/v1/ScrapeTask;", "taskTime", "Ljava/time/Instant;", "kotlin.jvm.PlatformType", "getTaskTime", "()Ljava/time/Instant;", "getTaskUpdater", "()Lkotlin/jvm/functions/Function1;", "buildArgs", "commit", "commitNoExcept", "complete", "page", "Lai/platon/pulsar/persist/WebPage;", "executeCallback", "requestBody", "callbackUrl", "executeQuery", "Ljava/sql/ResultSet;", "sql", "executeQueryWithConnection", "conn", "executeXSQL", "normSQL", "Lai/platon/scent/common/sql/NormXSQL;", "extract", "document", "Lai/platon/pulsar/dom/FeaturedDocument;", "extractWithCache", "handleSyncResponse", "Lai/platon/scent/executors/SinkResponse;", "persistNoExcept", "statAfterExtract", "Companion", "scent-engine"})
@SourceDebugExtension(value={"SMAP\nScrapeHyperlinkVS.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScrapeHyperlinkVS.kt\nai/platon/scent/crawl/urls/ScrapeHyperlinkVS\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,332:1\n1#2:333\n17#3,6:334\n*S KotlinDebug\n*F\n+ 1 ScrapeHyperlinkVS.kt\nai/platon/scent/crawl/urls/ScrapeHyperlinkVS\n*L\n224#1:334,6\n*E\n"})
public class ScrapeHyperlinkVS
extends CompletableListenableHyperlink<ScrapeResponse> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ScrapeTask task;
    @NotNull
    private final ScentSession session;
    @NotNull
    private final SinkCommitter sinkCommitter;
    @NotNull
    private final Function1<ScrapeTask, Unit> taskUpdater;
    @NotNull
    private final GlobalCacheFactory globalCacheFactory;
    @NotNull
    private final Logger logger;
    private final Instant taskTime;
    private final int resultSetType;
    private final int resultSetConcurrency;
    @NotNull
    private final ScrapeResponse response;
    @Nullable
    private String authToken;
    @Nullable
    private String args;
    @NotNull
    private PageEventHandlers eventHandlers;
    @NotNull
    private static final SinkAwareHyperlinkMetrics metrics = new SinkAwareHyperlinkMetrics("v1");

    public ScrapeHyperlinkVS(@NotNull String fetchUrl, @NotNull ScrapeTask task, @NotNull ScentSession session2, @NotNull SinkCommitter sinkCommitter, @NotNull Function1<? super ScrapeTask, Unit> taskUpdater, @NotNull GlobalCacheFactory globalCacheFactory) {
        Intrinsics.checkNotNullParameter((Object)fetchUrl, (String)"fetchUrl");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)sinkCommitter, (String)"sinkCommitter");
        Intrinsics.checkNotNullParameter(taskUpdater, (String)"taskUpdater");
        Intrinsics.checkNotNullParameter((Object)globalCacheFactory, (String)"globalCacheFactory");
        super(fetchUrl, null, 0, null, null, null, 0, null, null, null, 0, 0, null, 8190, null);
        this.task = task;
        this.session = session2;
        this.sinkCommitter = sinkCommitter;
        this.taskUpdater = taskUpdater;
        this.globalCacheFactory = globalCacheFactory;
        this.logger = LogsKt.getLogger((KClass)Reflection.getOrCreateKotlinClass(ScrapeHyperlinkVS.class));
        this.taskTime = this.task.getCreatedAt().truncatedTo(ChronoUnit.SECONDS);
        this.resultSetType = 1005;
        this.resultSetConcurrency = 1007;
        this.response = new ScrapeResponse(this.task);
        this.authToken = this.task.getAuthToken();
        this.args = this.buildArgs();
        this.eventHandlers = (PageEventHandlers)new SinkAwareLoadEventHandler(this, this.task);
        metrics.getLinks().mark();
    }

    @NotNull
    public final ScrapeTask getTask() {
        return this.task;
    }

    @NotNull
    public final ScentSession getSession() {
        return this.session;
    }

    @NotNull
    protected final SinkCommitter getSinkCommitter() {
        return this.sinkCommitter;
    }

    @NotNull
    protected final Function1<ScrapeTask, Unit> getTaskUpdater() {
        return this.taskUpdater;
    }

    @NotNull
    protected final GlobalCacheFactory getGlobalCacheFactory() {
        return this.globalCacheFactory;
    }

    @NotNull
    protected final GlobalCache getGlobalCache() {
        return this.globalCacheFactory.getGlobalCache();
    }

    protected final Instant getTaskTime() {
        return this.taskTime;
    }

    private final AbstractScentSQLContext getSqlContext() {
        PulsarContext pulsarContext = this.session.getContext();
        Intrinsics.checkNotNull((Object)pulsarContext, (String)"null cannot be cast to non-null type ai.platon.scent.ql.h2.context.support.AbstractScentSQLContext");
        return (AbstractScentSQLContext)pulsarContext;
    }

    private final ArrayBlockingQueue<Connection> getConnectionPool() {
        return this.getSqlContext().getConnectionPool();
    }

    private final Connection getRandomConnection() {
        return this.getSqlContext().getRandomConnection();
    }

    @NotNull
    protected final ScrapeResponse getResponse() {
        return this.response;
    }

    @Nullable
    public String getAuthToken() {
        return this.authToken;
    }

    public void setAuthToken(@Nullable String string) {
        this.authToken = string;
    }

    @Nullable
    public String getArgs() {
        return this.args;
    }

    public void setArgs(@Nullable String string) {
        this.args = string;
    }

    @NotNull
    public PageEventHandlers getEventHandlers() {
        return this.eventHandlers;
    }

    public void setEventHandlers(@NotNull PageEventHandlers pageEventHandlers) {
        Intrinsics.checkNotNullParameter((Object)pageEventHandlers, (String)"<set-?>");
        this.eventHandlers = pageEventHandlers;
    }

    @Nullable
    public ResultSet executeQuery() {
        NormXSQL normSQL = ScrapeAPIUtils.normalizeSQL$default(ScrapeAPIUtils.INSTANCE, this.task.getSql(), "-parse", "-readonly", false, 8, null);
        return this.executeXSQL(normSQL);
    }

    public void extract(@NotNull WebPage page, @NotNull FeaturedDocument document) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        try {
            int statusCode;
            int n = page.getHtmlIntegrity() == HtmlIntegrity.WRONG_DISTRICT ? 412 : (!page.getProtocolStatus().isSuccess() ? 417 : (statusCode = page.getContentLength() == 0L || page.getContent() == null ? 204 : 102));
            if (statusCode == 102) {
                this.extractWithCache(page, document);
            } else {
                this.task.setStatusCode(statusCode);
            }
        }
        catch (Throwable t) {
            this.task.setStatusCode(417);
            LogsKt.warnInterruptible((Object)((Object)this), (Throwable)t, (String)ExceptionsKt.stringify$default((Throwable)t, null, null, (int)3, null), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete(@Nullable WebPage page) {
        try {
            WebPage webPage = page;
            int contentLength = webPage != null ? (int)webPage.getContentLength() : 0;
            int pageStatusCode = page == null ? 204 : (page.getHtmlIntegrity() == HtmlIntegrity.WRONG_DISTRICT ? 412 : (page.getProtocolStatus().isRetry() && page.getFetchRetries() > page.getMaxRetries() ? 410 : page.getProtocolStatus().getMinorCode()));
            this.task.setContentLength(contentLength);
            this.task.setPageStatusCode(pageStatusCode);
            this.task.setDone(true);
            this.task.appendMessage("done(" + contentLength + ")");
            this.response.setEstimatedWaitTime(0L);
            this.response.updateBy(this.task);
            if (page != null) {
                this.statAfterExtract(page);
            }
            this.commitNoExcept();
        }
        finally {
            this.persistNoExcept();
            super.complete((Object)this.response);
        }
    }

    @Nullable
    protected ResultSet extractWithCache(@NotNull WebPage page, @NotNull FeaturedDocument document) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        this.getGlobalCache().putPDCache(page, document);
        NormXSQL normSQL = ScrapeAPIUtils.normalizeSQL$default(ScrapeAPIUtils.INSTANCE, this.task.getSql(), "-parse", "-readonly", false, 8, null);
        ResultSet rs = this.executeXSQL(normSQL);
        return rs;
    }

    @Nullable
    protected ResultSet executeXSQL(@NotNull NormXSQL normSQL) {
        Intrinsics.checkNotNullParameter((Object)normSQL, (String)"normSQL");
        ResultSet rs = null;
        try {
            this.task.setStatusCode(102);
            rs = this.executeQuery(normSQL.getSql());
            if (rs != null) {
                ScrapeTaskDetail scrapeTaskDetail = this.task.getDetail();
                if (scrapeTaskDetail != null) {
                    scrapeTaskDetail.setResultSet(ResultSetUtils.INSTANCE.getEntitiesFromResultSetTo(rs, (List)new ArrayList()));
                }
            }
            this.task.setStatusCode(200);
        }
        catch (JdbcSQLException e) {
            this.task.setStatusCode(417);
            this.logger.warn("Failed to execute sql #" + this.task.getId() + "{}", (Object)ExceptionsKt.brief$default((Throwable)e, null, null, (int)3, null));
        }
        catch (Throwable e) {
            this.task.setStatusCode(417);
            LogsKt.warnInterruptible((Object)((Object)this), (Throwable)e, (String)ExceptionsKt.stringify$default((Throwable)e, (String)("Failed to execute sql #" + this.task.getId() + " - "), null, (int)2, null), (Object[])new Object[0]);
        }
        return rs;
    }

    protected void commitNoExcept() {
        try {
            this.commit(this.response);
        }
        catch (Exception e) {
            LogsKt.warnInterruptible((Object)((Object)this), (Throwable)e, (String)ExceptionsKt.stringify$default((Throwable)e, (String)("Failed to commit scrape task <" + this.task.getId() + "> - "), null, (int)2, null), (Object[])new Object[0]);
        }
    }

    protected void commit(@NotNull ScrapeResponse response) {
        String callbackUrl;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        ScrapeTaskDetail scrapeTaskDetail = this.task.getDetail();
        String string = callbackUrl = scrapeTaskDetail != null ? scrapeTaskDetail.getCallbackUrl() : null;
        if (callbackUrl != null) {
            String responseBody = JacksonKt.pulsarObjectMapper().writeValueAsString((Object)response);
            Intrinsics.checkNotNull((Object)responseBody);
            this.executeCallback(responseBody, callbackUrl);
        }
    }

    @Nullable
    protected final ResultSet executeQuery(@NotNull String sql2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)sql2, (String)"sql");
        ScrapeHyperlinkVS it = object = this;
        boolean bl = false;
        if ((AppContext.INSTANCE.isActive() ? object : null) == null) {
            return null;
        }
        Connection connection = this.getConnectionPool().poll();
        if (connection == null) {
            connection = this.getRandomConnection();
        }
        Connection connection2 = connection;
        it = object = this.executeQueryWithConnection(sql2, connection2);
        boolean bl2 = false;
        this.getConnectionPool().offer(connection2);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected final ResultSet executeQueryWithConnection(@NotNull String sql2, @NotNull Connection conn) {
        Statement statement;
        Intrinsics.checkNotNullParameter((Object)sql2, (String)"sql");
        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
        ResultSet result2 = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        if (this.isCancelled()) {
            return null;
        }
        SysProperties.serializeJavaObject = false;
        Statement statement2 = statement = conn.createStatement(this.resultSetType, this.resultSetConcurrency);
        if (statement2 != null) {
            Intrinsics.checkNotNull((Object)statement2);
            AutoCloseable autoCloseable = statement;
            Throwable throwable = null;
            try {
                block20: {
                    Statement st;
                    block19: {
                        st = (Statement)autoCloseable;
                        boolean bl2 = false;
                        if (!this.isCancelled()) break block19;
                        ResultSet resultSet = null;
                        return resultSet;
                    }
                    try {
                        ResultSet resultSet;
                        String string;
                        if (StringsKt.contains$default((CharSequence)sql2, (CharSequence)"refresh", (boolean)false, (int)2, null)) {
                            this.logger.debug("Unexpected refresh option in sql");
                            string = StringsKt.replace$default((String)sql2, (String)"-refresh", (String)"-erased", (boolean)false, (int)4, null);
                        } else {
                            string = sql2;
                        }
                        String sql0 = string;
                        ResultSet resultSet2 = resultSet = st.executeQuery(sql0);
                        if (resultSet2 == null) break block20;
                        Intrinsics.checkNotNull((Object)resultSet2);
                        AutoCloseable autoCloseable2 = resultSet;
                        Throwable throwable2 = null;
                        try {
                            ResultSet rs = (ResultSet)autoCloseable2;
                            boolean bl3 = false;
                            result2 = ResultSetUtils.copyResultSet$default((ResultSetUtils)ResultSetUtils.INSTANCE, (ResultSet)rs, (int)0, (int)2, null);
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
                        }
                    }
                    catch (JdbcSQLException e) {
                        String string = e.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                        String message = string;
                        if (StringsKt.contains$default((CharSequence)message, (CharSequence)"Syntax error in SQL statement", (boolean)false, (int)2, null)) {
                            this.task.setStatusCode(400);
                            this.logger.warn("Syntax error in SQL statement #" + this.task.getId() + ">>>\n{}\n<<<", (Object)e.getSQL());
                            break block20;
                        }
                        this.task.setStatusCode(417);
                        this.logger.warn("Failed to execute scrape task #" + this.task.getId() + "\n{}", (Object)ExceptionsKt.stringify$default((Throwable)e, null, null, (int)3, null));
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        long millis = System.currentTimeMillis() - start$iv;
        return result2;
    }

    protected final void executeCallback(@NotNull String requestBody, @NotNull String callbackUrl) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)requestBody, (String)"requestBody");
            Intrinsics.checkNotNullParameter((Object)callbackUrl, (String)"callbackUrl");
            try {
                metrics.getCommits().mark();
                this.sinkCommitter.commit(requestBody, callbackUrl, (Function1<? super SinkResponse, Unit>)((Function1)new Function1<SinkResponse, Unit>(this){
                    final /* synthetic */ ScrapeHyperlinkVS this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull SinkResponse sinkResponse) {
                        Intrinsics.checkNotNullParameter((Object)sinkResponse, (String)"sinkResponse");
                        this.this$0.handleSyncResponse(sinkResponse);
                    }
                }));
            }
            catch (Exception e) {
                metrics.getFailedCommits().mark();
                ScrapeTaskDetail scrapeTaskDetail = this.task.getDetail();
                if (scrapeTaskDetail == null) break block2;
                scrapeTaskDetail.setSyncError(e.getMessage());
            }
        }
    }

    protected final void handleSyncResponse(@NotNull SinkResponse response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        metrics.getSyncResponses().mark();
        this.task.setSyncStatusCode(response.getStatusCode());
        if (response.getStatusCode() != 0 && response.getStatusCode() != 200) {
            metrics.getFailedSyncResponses().mark();
        }
        ScrapeTaskDetail scrapeTaskDetail = this.task.getDetail();
        if (scrapeTaskDetail != null) {
            scrapeTaskDetail.setSyncResponseHeaders(StringUtils.abbreviateMiddle((String)new Gson().toJson(response.getHeaders()), (String)"...", (int)256));
        }
        ScrapeTaskDetail scrapeTaskDetail2 = this.task.getDetail();
        if (scrapeTaskDetail2 != null) {
            scrapeTaskDetail2.setSyncResponseBody(StringUtils.abbreviateMiddle((String)response.getBody(), (String)"...", (int)1024));
        }
        this.persistNoExcept();
    }

    protected final void persistNoExcept() {
        try {
            metrics.getPersists().mark();
            this.taskUpdater.invoke((Object)this.task);
        }
        catch (Exception e) {
            LogsKt.warnInterruptible((Object)((Object)this), (Throwable)e, (String)ExceptionsKt.stringify$default((Throwable)e, (String)("Failed to update scrape task status <" + this.task.getId() + "> -"), null, (int)2, null), (Object[])new Object[0]);
        }
    }

    private final String buildArgs() {
        StringBuilder sb = new StringBuilder();
        sb.append("-parse -taskId " + this.task.getIdOrUnknown() + " -taskTime " + this.taskTime);
        if (!StringsKt.contains$default((CharSequence)AppContext.INSTANCE.getHOST_NAME(), (CharSequence)"crawl", (boolean)false, (int)2, null)) {
            sb.append(" -requireSize 1");
            sb.append(" -storeContent true");
        }
        if (this.getAuthToken() != null) {
            sb.append(" -authToken ").append(this.getAuthToken());
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final void statAfterExtract(WebPage page) {
        ScrapeExceptionHandler.INSTANCE.trackIfInconsistent(this.task, this.response, page);
        if (this.response.getStatusCode() == 200) {
            List<Map<String, Object>> rs = this.response.getResultSet();
            if (rs == null) {
                PageLoadStatusFormatter pageLoadStatusFormatter;
                metrics.getNullResults().mark();
                PageLoadStatusFormatter it = pageLoadStatusFormatter = new PageLoadStatusFormatter(page, "Null result", false, false, false, false, 60, null);
                boolean bl = false;
                this.logger.info(String.valueOf(it));
            } else if (rs.isEmpty()) {
                PageLoadStatusFormatter pageLoadStatusFormatter;
                metrics.getEmptyResults().mark();
                PageLoadStatusFormatter it = pageLoadStatusFormatter = new PageLoadStatusFormatter(page, "Empty result", false, false, false, false, 60, null);
                boolean bl = false;
                this.logger.info(String.valueOf(it));
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lai/platon/scent/crawl/urls/ScrapeHyperlinkVS$Companion;", "", "()V", "metrics", "Lai/platon/scent/crawl/urls/SinkAwareHyperlinkMetrics;", "getMetrics", "()Lai/platon/scent/crawl/urls/SinkAwareHyperlinkMetrics;", "scent-engine"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        protected final SinkAwareHyperlinkMetrics getMetrics() {
            return metrics;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

