/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.executors;

import ai.platon.pulsar.common.urls.URLUtils;
import ai.platon.scent.executors.SinkCommitter;
import ai.platon.scent.executors.SinkResponse;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListSet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J;\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052!\u0010\u000f\u001a\u001d\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\u00150\u0010H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lai/platon/scent/executors/AsyncApiSinkCommitter;", "Lai/platon/scent/executors/SinkCommitter;", "()V", "badSinkDescriptor", "Ljava/util/concurrent/ConcurrentSkipListSet;", "", "client", "Ljava/net/http/HttpClient;", "kotlin.jvm.PlatformType", "log", "Lorg/slf4j/Logger;", "commit", "", "requestBody", "sinkDescriptor", "thenAction", "Lkotlin/Function1;", "Lai/platon/scent/executors/SinkResponse;", "Lkotlin/ParameterName;", "name", "response", "", "scent-engine"})
public final class AsyncApiSinkCommitter
extends SinkCommitter {
    private final Logger log = LoggerFactory.getLogger(AsyncApiSinkCommitter.class);
    private final HttpClient client = HttpClient.newHttpClient();
    @NotNull
    private final ConcurrentSkipListSet<String> badSinkDescriptor = new ConcurrentSkipListSet();

    @Override
    public int commit(@NotNull String requestBody, @NotNull String sinkDescriptor, @NotNull Function1<? super SinkResponse, Unit> thenAction) {
        Intrinsics.checkNotNullParameter((Object)requestBody, (String)"requestBody");
        Intrinsics.checkNotNullParameter((Object)sinkDescriptor, (String)"sinkDescriptor");
        Intrinsics.checkNotNullParameter(thenAction, (String)"thenAction");
        if (!URLUtils.isStandard((String)sinkDescriptor)) {
            if (!this.badSinkDescriptor.contains(sinkDescriptor)) {
                this.log.warn("Bad sink descriptor | {}", (Object)sinkDescriptor);
                this.badSinkDescriptor.add(sinkDescriptor);
            }
            return -1;
        }
        HttpRequest request = HttpRequest.newBuilder(URI.create(sinkDescriptor)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(requestBody)).build();
        this.client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApplyAsync(arg_0 -> AsyncApiSinkCommitter.commit$lambda$0((Function1)new Function1<HttpResponse<String>, Unit>(thenAction){
            final /* synthetic */ Function1<SinkResponse, Unit> $thenAction;
            {
                this.$thenAction = $thenAction;
                super(1);
            }

            public final void invoke(HttpResponse<String> it) {
                int n = it.statusCode();
                Map<String, List<String>> map2 = it.headers().map();
                Intrinsics.checkNotNullExpressionValue(map2, (String)"map(...)");
                String string = it.body();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"body(...)");
                this.$thenAction.invoke((Object)new SinkResponse(n, map2, string));
            }
        }, arg_0));
        return 0;
    }

    private static final Unit commit$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Unit)$tmp0.invoke(p0);
    }
}

