/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.ql.h2;

import ai.platon.pulsar.ql.SQLSession;
import ai.platon.pulsar.ql.SessionDelegate;
import ai.platon.pulsar.ql.context.SQLContext;
import ai.platon.pulsar.ql.context.SQLContexts;
import ai.platon.pulsar.ql.h2.H2SessionDelegate;
import ai.platon.scent.ql.h2.ScentSQLSession;
import java.sql.Connection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.h2.engine.ConnectionInfo;
import org.h2.engine.Engine;
import org.h2.engine.Session;
import org.h2.engine.SessionFactory;
import org.h2.engine.SessionInterface;
import org.h2.engine.SysProperties;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.DbException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u000e\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017J\b\u0010\u0018\u001a\u00020\u0000H\u0007J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006 "}, d2={"Lai/platon/scent/ql/h2/H2SessionFactory;", "Lorg/h2/engine/SessionFactory;", "()V", "h2sessionLifeCycleMonitor", "", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "scentSqlContext", "Lai/platon/pulsar/ql/context/SQLContext;", "getScentSqlContext", "()Lai/platon/pulsar/ql/context/SQLContext;", "closeSession", "", "serialId", "", "createSession", "Lorg/h2/engine/Session;", "ci", "Lorg/h2/engine/ConnectionInfo;", "createSession0", "getH2Session", "connection", "Ljava/sql/Connection;", "getInstance", "getSession", "Lai/platon/scent/ql/h2/ScentSQLSession;", "sessionInterface", "Lorg/h2/engine/SessionInterface;", "isColumnRetrieval", "", "conn", "scent-engine"})
public final class H2SessionFactory
implements SessionFactory {
    @NotNull
    public static final H2SessionFactory INSTANCE = new H2SessionFactory();
    private static final Logger logger;
    @NotNull
    private static final Object h2sessionLifeCycleMonitor;

    private H2SessionFactory() {
    }

    private final SQLContext getScentSqlContext() {
        return SQLContexts.INSTANCE.create();
    }

    @JvmStatic
    @NotNull
    public static final H2SessionFactory getInstance() {
        return INSTANCE;
    }

    public final boolean isColumnRetrieval(@NotNull Connection conn) {
        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
        String string = conn.getMetaData().getURL();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getURL(...)");
        return StringsKt.contains$default((CharSequence)string, (CharSequence)"jdbc:columnlist:connection", (boolean)false, (int)2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Session createSession(@NotNull ConnectionInfo ci) throws Exception {
        Intrinsics.checkNotNullParameter((Object)ci, (String)"ci");
        Object object = h2sessionLifeCycleMonitor;
        synchronized (object) {
            boolean bl = false;
            Session session2 = INSTANCE.createSession0(ci);
            return session2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSession(int serialId) {
        Object object = h2sessionLifeCycleMonitor;
        synchronized (object) {
            boolean bl = false;
            INSTANCE.getScentSqlContext().closeSession(serialId);
            Unit unit = Unit.INSTANCE;
        }
    }

    @NotNull
    public final ScentSQLSession getSession(@NotNull Connection connection) throws Exception {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        JdbcConnection conn = (JdbcConnection)connection;
        SessionInterface sessionInterface = conn.getSession();
        Intrinsics.checkNotNullExpressionValue((Object)sessionInterface, (String)"getSession(...)");
        return this.getSession(sessionInterface);
    }

    @NotNull
    public final Session getH2Session(@NotNull Connection connection) throws Exception {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Object object = this.getSession(connection).getSessionDelegate().getImplementation();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.h2.engine.Session");
        return (Session)object;
    }

    @NotNull
    public final ScentSQLSession getSession(@NotNull SessionInterface sessionInterface) throws Exception {
        Intrinsics.checkNotNullParameter((Object)sessionInterface, (String)"sessionInterface");
        SQLSession sQLSession = this.getScentSqlContext().getSession(((Session)sessionInterface).getSerialId());
        Intrinsics.checkNotNull((Object)sQLSession, (String)"null cannot be cast to non-null type ai.platon.scent.ql.h2.ScentSQLSession");
        return (ScentSQLSession)sQLSession;
    }

    private final Session createSession0(ConnectionInfo ci) throws Exception {
        if (!this.getScentSqlContext().isActive()) {
            DbException dbException = DbException.get((int)90098, (String)"Scent sql context is closed");
            Intrinsics.checkNotNullExpressionValue((Object)dbException, (String)"get(...)");
            throw (Throwable)dbException;
        }
        logger.debug("Creating scent session for h2 connection | {}", (Object)ci.getURL());
        Session h2session = Engine.getInstance().createSession(ci);
        SysProperties.serializeJavaObject = ci.isPersistent();
        Logger h2Log = LoggerFactory.getLogger((String)"org.h2");
        if (h2Log.isTraceEnabled()) {
            h2session.getTrace().setLevel(4);
        }
        SQLContext sQLContext = this.getScentSqlContext();
        int n = h2session.getSerialId();
        Intrinsics.checkNotNull((Object)h2session);
        SQLSession scentSQLSession = sQLContext.createSession((SessionDelegate)new H2SessionDelegate(n, h2session));
        if (!(scentSQLSession.getId() == h2session.getSerialId())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Object[] objectArray = new Object[]{scentSQLSession, h2session, ci.getURL()};
        logger.info("ScentSQLSession {} is created for h2session <{}>, connection: <{}>", objectArray);
        return h2session;
    }

    static {
        if (!Intrinsics.areEqual((Object)System.getProperty("h2.sessionFactory"), (Object)"ai.platon.scent.ql.h2.H2SessionFactory")) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        logger = LoggerFactory.getLogger(H2SessionFactory.class);
        h2sessionLifeCycleMonitor = new Object();
    }
}

