/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.ql.h2.udfs;

import ai.platon.pulsar.common.ExceptionsKt;
import ai.platon.pulsar.common.LangKt;
import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.OpenMapTable;
import ai.platon.pulsar.common.config.VolatileConfig;
import ai.platon.pulsar.common.urls.URLUtils;
import ai.platon.pulsar.dom.FeaturedDocument;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.ql.common.annotation.H2Context;
import ai.platon.pulsar.ql.common.annotation.UDFGroup;
import ai.platon.pulsar.ql.common.annotation.UDFunction;
import ai.platon.pulsar.ql.h2.H2ExtKt;
import ai.platon.pulsar.skeleton.common.options.LoadOptions;
import ai.platon.scent.common.options.CellType;
import ai.platon.scent.dom.HNormUrl;
import ai.platon.scent.dom.HarvestOptions;
import ai.platon.scent.dom.nodes.AnchorGroup;
import ai.platon.scent.entities.DataTypeStatistics;
import ai.platon.scent.entities.HarvestResult;
import ai.platon.scent.entities.PageTableKt;
import ai.platon.scent.ql.h2.H2SessionFactory;
import ai.platon.scent.ql.h2.ScentSQLSession;
import ai.platon.scent.ql.h2.udfs.ExtractFunctionTables;
import ai.platon.scent.skeleton.ScentSession;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.h2.command.CommandInterface;
import org.h2.engine.Session;
import org.h2.jdbc.JdbcConnection;
import org.h2.tools.SimpleResultSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UDFGroup(namespace="DOM")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010#\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0012H\u0002J\u0010\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J \u0010 \u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010!\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\"\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J \u0010#\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020$2\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010%\u001a\u00020&H\u0002J\u0012\u0010'\u001a\u00020\u00122\b\b\u0001\u0010\u001b\u001a\u00020\u001cH\u0007J\u001a\u0010(\u001a\u00020\u00122\b\b\u0001\u0010\u001b\u001a\u00020$2\u0006\u0010)\u001a\u00020\u0005H\u0007J\u0010\u0010*\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J$\u0010+\u001a\u00020,2\b\b\u0001\u0010\u001b\u001a\u00020$2\u0006\u0010)\u001a\u00020\u00052\b\b\u0002\u0010-\u001a\u00020\u0012H\u0007J\u001a\u0010.\u001a\u00020,2\b\b\u0001\u0010\u001b\u001a\u00020$2\u0006\u0010)\u001a\u00020\u0005H\u0007J$\u0010/\u001a\u00020,2\b\b\u0001\u0010\u001b\u001a\u00020$2\u0006\u0010)\u001a\u00020\u00052\b\b\u0002\u0010-\u001a\u00020\u0012H\u0007JD\u00100\u001a\u00020,2\b\b\u0001\u0010\u001b\u001a\u00020$2\u0006\u0010)\u001a\u00020\u00052\b\b\u0002\u0010-\u001a\u00020\u00122\u001e\u00101\u001a\u001a\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020\u001a02H\u0002J(\u00103\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u001a\u00104\u001a\u00020,2\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u00105\u001a\u00020\u0012H\u0002J\u001a\u00106\u001a\u00020,2\b\b\u0001\u0010\u001b\u001a\u00020$2\u0006\u0010)\u001a\u00020\u0005H\u0007J\u0019\u00107\u001a\u0004\u0018\u0001082\b\u00109\u001a\u0004\u0018\u00010:H\u0002\u00a2\u0006\u0002\u0010;J\u0019\u0010<\u001a\u0004\u0018\u00010\u00122\b\u00109\u001a\u0004\u0018\u00010:H\u0002\u00a2\u0006\u0002\u0010=J\u0018\u0010>\u001a\u00020,2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J\"\u0010?\u001a\u00020,2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00052\b\b\u0002\u00105\u001a\u00020\u0012H\u0002J\u0018\u0010@\u001a\u00020A2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0005H\u0002J\u0010\u0010B\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR \u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lai/platon/scent/ql/h2/udfs/ExtractFunctionTables;", "", "()V", "harvestTaskTableFieldDefines", "", "", "harvestTaskTableFields", "", "harvestTaskTableFieldsPlaceholds", "integerFieldDefine", "joinedHarvestTaskTableFields", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "sessionTracker", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "", "buildTableName", "url", "tid", "buildTaskId", "createHarvestResultMetaTable", "", "conn", "Ljava/sql/Connection;", "tableName", "table", "Lai/platon/pulsar/common/OpenMapTable;", "createHarvestResultTable", "createHarvestTaskTableIfAbsent", "deleteHarvestTask", "doHarvest", "Lorg/h2/jdbc/JdbcConnection;", "options", "Lai/platon/scent/dom/HarvestOptions;", "dropAllHarvestTasks", "dropHarvest", "portalUrl", "dropHarvestTaskTable", "harvest", "Ljava/sql/ResultSet;", "nthTable", "harvestMetadata", "harvestNthTable", "harvestNthTable0", "harvestFun", "Lkotlin/Function3;", "insertHarvestTask", "listHarvestTasks", "limit", "loadAndGetAnchorGroups", "parseDouble", "", "cell", "Lai/platon/pulsar/common/OpenMapTable$Cell;", "(Lai/platon/pulsar/common/OpenMapTable$Cell;)Ljava/lang/Double;", "parseInt", "(Lai/platon/pulsar/common/OpenMapTable$Cell;)Ljava/lang/Integer;", "queryHarvestTaskTable", "queryTable", "tableExists", "", "truncateHarvestTaskTable", "scent-engine"})
@SourceDebugExtension(value={"SMAP\nExtractFunctionTables.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtractFunctionTables.kt\nai/platon/scent/ql/h2/udfs/ExtractFunctionTables\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,520:1\n13309#2,2:521\n11155#2:532\n11266#2,4:533\n13374#2,3:539\n10394#2,5:543\n12634#2,3:561\n1855#3,2:523\n766#3:526\n857#3,2:527\n1864#3,3:529\n1864#3,2:537\n1866#3:542\n1549#3:548\n1620#3,3:549\n1864#3,2:552\n1864#3,3:554\n1866#3:557\n2976#3,3:558\n2980#3:564\n1#4:525\n*S KotlinDebug\n*F\n+ 1 ExtractFunctionTables.kt\nai/platon/scent/ql/h2/udfs/ExtractFunctionTables\n*L\n78#1:521,2\n312#1:532\n312#1:533,4\n335#1:539,3\n378#1:543,5\n443#1:561,3\n93#1:523,2\n282#1:526\n282#1:527,2\n283#1:529,3\n330#1:537,2\n330#1:542\n385#1:548\n385#1:549,3\n386#1:552,2\n390#1:554,3\n386#1:557\n443#1:558,3\n443#1:564\n*E\n"})
public final class ExtractFunctionTables {
    @NotNull
    public static final ExtractFunctionTables INSTANCE = new ExtractFunctionTables();
    private static final Logger log = LoggerFactory.getLogger(ExtractFunctionTables.class);
    @NotNull
    private static final String integerFieldDefine = "INTEGER NOT NULL DEFAULT 0";
    @NotNull
    private static final ConcurrentHashMap<Integer, Set<Long>> sessionTracker = new ConcurrentHashMap();
    @NotNull
    private static final Map<String, String> harvestTaskTableFieldDefines;
    @NotNull
    private static final Set<String> harvestTaskTableFields;
    @NotNull
    private static final String joinedHarvestTaskTableFields;
    @NotNull
    private static final String harvestTaskTableFieldsPlaceholds;

    private ExtractFunctionTables() {
    }

    public final Logger getLog() {
        return log;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @UDFunction(hasShortcut=true, description="Load and find out all anchor groups, each anchor group is a recoverable page set")
    @NotNull
    public static final ResultSet loadAndGetAnchorGroups(@H2Context @NotNull JdbcConnection conn, @NotNull String portalUrl) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
        Intrinsics.checkNotNullParameter((Object)portalUrl, (String)"portalUrl");
        SimpleResultSet rs = new SimpleResultSet();
        String[] stringArray = new String[]{"PATH", "DISTORT", "SCORE", "NUM_LINKS", "LINKS"};
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv;
            void it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            H2ExtKt.addColumn((SimpleResultSet)rs, (String)it);
        }
        if (H2SessionFactory.INSTANCE.isColumnRetrieval((Connection)conn)) {
            return (ResultSet)rs;
        }
        ScentSQLSession scentSession = H2SessionFactory.INSTANCE.getSession((Connection)conn);
        VolatileConfig conf = scentSession.getSessionConfig().toVolatileConfig();
        HNormUrl normUrl = HNormUrl.Companion.parse(portalUrl, conf);
        HarvestOptions options = normUrl.getHOptions();
        WebPage page = scentSession.load(normUrl);
        FeaturedDocument doc = ScentSession.DefaultImpls.parse$default(scentSession, page, options, false, 4, null);
        SortedSet anchorGroups = scentSession.arrangeLinks(normUrl, doc);
        Iterable $this$forEach$iv2 = anchorGroups;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            String distort;
            AnchorGroup it = (AnchorGroup)element$iv;
            boolean bl = false;
            Object[] objectArray = "%.4f";
            Object[] objectArray2 = new Object[]{it.getDistortion()};
            Intrinsics.checkNotNullExpressionValue((Object)String.format((String)objectArray, Arrays.copyOf(objectArray2, objectArray2.length)), (String)"format(...)");
            objectArray = new Object[5];
            objectArray[0] = it.getPath();
            objectArray[1] = distort;
            Intrinsics.checkNotNullExpressionValue((Object)it.getScore().toString(), (String)"toString(...)");
            objectArray[3] = it.getUrlStrings().size();
            objectArray[4] = CollectionsKt.joinToString$default((Iterable)it.getUrlStrings(), null, null, null, (int)0, null, null, (int)63, null);
            Object[] values = objectArray;
            rs.addRow(Arrays.copyOf(values, values.length));
        }
        return (ResultSet)rs;
    }

    @JvmStatic
    @UDFunction(hasShortcut=true)
    @JvmOverloads
    @NotNull
    public static final ResultSet harvest(@H2Context @NotNull JdbcConnection conn, @NotNull String portalUrl, int nthTable) {
        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
        Intrinsics.checkNotNullParameter((Object)portalUrl, (String)"portalUrl");
        return ExtractFunctionTables.harvestNthTable(conn, portalUrl, nthTable);
    }

    public static /* synthetic */ ResultSet harvest$default(JdbcConnection jdbcConnection, String string, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 1;
        }
        return ExtractFunctionTables.harvest(jdbcConnection, string, n);
    }

    @JvmStatic
    @UDFunction(hasShortcut=true)
    @JvmOverloads
    @NotNull
    public static final ResultSet harvestNthTable(@H2Context @NotNull JdbcConnection conn, @NotNull String portalUrl, int nthTable) {
        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
        Intrinsics.checkNotNullParameter((Object)portalUrl, (String)"portalUrl");
        return INSTANCE.harvestNthTable0(conn, portalUrl, nthTable, (Function3<? super JdbcConnection, ? super String, ? super HarvestOptions, Unit>)((Function3)new Function3<JdbcConnection, String, HarvestOptions, Unit>((Object)INSTANCE){

            public final void invoke(@NotNull JdbcConnection p0, @NotNull String p1, @NotNull HarvestOptions p2) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                ExtractFunctionTables.access$doHarvest((ExtractFunctionTables)this.receiver, p0, p1, p2);
            }
        }));
    }

    public static /* synthetic */ ResultSet harvestNthTable$default(JdbcConnection jdbcConnection, String string, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 1;
        }
        return ExtractFunctionTables.harvestNthTable(jdbcConnection, string, n);
    }

    private final ResultSet harvestNthTable0(@H2Context JdbcConnection conn, String portalUrl, int nthTable, Function3<? super JdbcConnection, ? super String, ? super HarvestOptions, Unit> harvestFun) {
        boolean columnRetrieval = H2SessionFactory.INSTANCE.isColumnRetrieval((Connection)conn);
        if (columnRetrieval) {
            this.createHarvestTaskTableIfAbsent((Connection)conn);
        }
        ScentSQLSession scentSession = H2SessionFactory.INSTANCE.getSession((Connection)conn);
        Pair pair = URLUtils.splitUrlArgs((String)portalUrl);
        String url = (String)pair.component1();
        String args = (String)pair.component2();
        LoadOptions loadOptions = scentSession.options(args);
        HarvestOptions $this$harvestNthTable0_u24lambda_u242 = (HarvestOptions)loadOptions;
        boolean bl2 = false;
        $this$harvestNthTable0_u24lambda_u242.setNoSubTable(true);
        HarvestOptions options = (HarvestOptions)loadOptions;
        ResultSet result2 = this.queryHarvestTaskTable((Connection)conn, url);
        if (!result2.next()) {
            Object $i$a$-runCatching-ExtractFunctionTables$harvestNthTable0$22;
            try {
                boolean $i$a$-runCatching-ExtractFunctionTables$harvestNthTable0$22 = false;
                harvestFun.invoke((Object)conn, (Object)url, (Object)options);
                $i$a$-runCatching-ExtractFunctionTables$harvestNthTable0$22 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl2) {
                $i$a$-runCatching-ExtractFunctionTables$harvestNthTable0$22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
            }
            Throwable throwable = Result.exceptionOrNull-impl((Object)$i$a$-runCatching-ExtractFunctionTables$harvestNthTable0$22);
            if (throwable != null) {
                Throwable it = bl2 = throwable;
                boolean bl3 = false;
                LogsKt.warnInterruptible((Object)this, (Throwable)it, (String)ExceptionsKt.brief$default((Throwable)it, (String)"Failed to do harvest - ", null, (int)2, null), (Object[])new Object[0]);
            }
            result2 = this.queryHarvestTaskTable((Connection)conn, url);
        }
        result2.beforeFirst();
        int i = 0;
        while (result2.next() && i++ < nthTable) {
            ResultSet resultSet;
            if (i != nthTable) continue;
            String tableName = result2.getString("TABLE_NAME");
            if (columnRetrieval) {
                Connection connection = (Connection)conn;
                Intrinsics.checkNotNull((Object)tableName);
                resultSet = this.queryTable(connection, tableName, 0);
            } else {
                Connection connection = (Connection)conn;
                Intrinsics.checkNotNull((Object)tableName);
                resultSet = ExtractFunctionTables.queryTable$default(this, connection, tableName, 0, 4, null);
            }
            return resultSet;
        }
        return (ResultSet)new SimpleResultSet();
    }

    static /* synthetic */ ResultSet harvestNthTable0$default(ExtractFunctionTables extractFunctionTables, JdbcConnection jdbcConnection, String string, int n, Function3 function3, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 1;
        }
        return extractFunctionTables.harvestNthTable0(jdbcConnection, string, n, (Function3<? super JdbcConnection, ? super String, ? super HarvestOptions, Unit>)function3);
    }

    @JvmStatic
    @UDFunction(hasShortcut=true)
    @NotNull
    public static final ResultSet harvestMetadata(@H2Context @NotNull JdbcConnection conn, @NotNull String portalUrl) {
        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
        Intrinsics.checkNotNullParameter((Object)portalUrl, (String)"portalUrl");
        if (H2SessionFactory.INSTANCE.isColumnRetrieval((Connection)conn)) {
            INSTANCE.createHarvestTaskTableIfAbsent((Connection)conn);
            return INSTANCE.listHarvestTasks((Connection)conn, 0);
        }
        ScentSQLSession scentSession = H2SessionFactory.INSTANCE.getSession((Connection)conn);
        Pair pair = URLUtils.splitUrlArgs((String)portalUrl);
        String url = (String)pair.component1();
        String args = (String)pair.component2();
        ResultSet rs = INSTANCE.queryHarvestTaskTable((Connection)conn, url);
        if (!rs.isBeforeFirst()) {
            Object object;
            HarvestOptions options = (HarvestOptions)scentSession.options(args);
            try {
                boolean bl = false;
                INSTANCE.doHarvest(conn, url, options);
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable != null) {
                Throwable throwable2;
                Throwable it = throwable2 = throwable;
                boolean bl = false;
                LogsKt.warnInterruptible((Object)INSTANCE, (Throwable)it, (String)ExceptionsKt.brief$default((Throwable)it, (String)"Failed to do harvest - ", null, (int)2, null), (Object[])new Object[0]);
            }
            rs = INSTANCE.queryHarvestTaskTable((Connection)conn, url);
        }
        return rs;
    }

    @JvmStatic
    @UDFunction(hasShortcut=true)
    public static final int dropHarvest(@H2Context @NotNull JdbcConnection conn, @NotNull String portalUrl) {
        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
        Intrinsics.checkNotNullParameter((Object)portalUrl, (String)"portalUrl");
        String url = (String)URLUtils.splitUrlArgs((String)portalUrl).component1();
        INSTANCE.createHarvestTaskTableIfAbsent((Connection)conn);
        ResultSet rs = INSTANCE.queryHarvestTaskTable((Connection)conn, url);
        while (rs.next()) {
            String tableName = rs.getString("TABLE_NAME");
            String sql2 = "DROP TABLE IF EXISTS " + tableName;
            CommandInterface command = conn.getSession().prepareCommand(sql2, 1000);
            command.executeUpdate(null);
            if (!LangKt.alwaysFalse()) continue;
            tableName = rs.getString("META_TABLE_NAME");
            sql2 = "DROP TABLE IF EXISTS " + tableName;
            command = conn.getSession().prepareCommand(sql2, 1000);
            command.executeUpdate(null);
        }
        return INSTANCE.deleteHarvestTask((Connection)conn, url);
    }

    @JvmStatic
    @UDFunction(hasShortcut=true)
    public static final int dropAllHarvestTasks(@H2Context @NotNull Connection conn) {
        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
        log.warn("All harvest tasks will be dropped!");
        INSTANCE.createHarvestTaskTableIfAbsent(conn);
        Session h2session = H2SessionFactory.INSTANCE.getH2Session(conn);
        ResultSet rs = ExtractFunctionTables.listHarvestTasks$default(INSTANCE, conn, 0, 2, null);
        while (rs.next()) {
            String tableName = rs.getString("TABLE_NAME");
            String sql2 = "DROP TABLE IF EXISTS " + tableName;
            CommandInterface command = h2session.prepareCommand(sql2, Integer.MAX_VALUE);
            command.executeUpdate(null);
        }
        return INSTANCE.truncateHarvestTaskTable(conn);
    }

    /*
     * WARNING - void declaration
     */
    private final void doHarvest(JdbcConnection conn, String url, HarvestOptions options) {
        block4: {
            void $this$filterTo$iv$iv;
            ScentSQLSession scentSession = H2SessionFactory.INSTANCE.getSession((Connection)conn);
            Object object = scentSession.getSessionDelegate().getImplementation();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.h2.engine.Session");
            Session h2session = (Session)object;
            options.setDisableHarvestCache(true);
            long threadId = Thread.currentThread().getId();
            sessionTracker.computeIfAbsent(scentSession.getId(), arg_0 -> ExtractFunctionTables.doHarvest$lambda$7(doHarvest.1.INSTANCE, arg_0)).add(threadId);
            Set<Long> set = sessionTracker.get(scentSession.getId());
            String threadIds2 = set != null ? CollectionsKt.joinToString$default((Iterable)set, null, null, null, (int)0, null, (Function1)doHarvest.threadIds.1.INSTANCE, (int)31, null) : null;
            Object[] objectArray = new Object[]{h2session, scentSession, threadIds2, url};
            log.info("Starting harvest task in session [{}], scent session: {}, threadIds: [{}] | {} ", objectArray);
            if (options.getCellType() == CellType.AUTO) {
                options.setCellType(CellType.DATABASE);
            }
            HarvestResult result2 = (HarvestResult)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super HarvestResult>, Object>(scentSession, url, options, null){
                int label;
                final /* synthetic */ ScentSQLSession $scentSession;
                final /* synthetic */ String $url;
                final /* synthetic */ HarvestOptions $options;
                {
                    this.$scentSession = $scentSession;
                    this.$url = $url;
                    this.$options = $options;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = this.$scentSession.harvest(this.$url, this.$options, (Continuation)this);
                            if (object3 != object2) return object3;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return object3;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super HarvestResult> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
            scentSession.buildAll(result2.getTableGroup(), options);
            List tableNames = new ArrayList();
            Iterable $this$filter$iv = result2.getTableGroup().getTables();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                OpenMapTable it = (OpenMapTable)element$iv$iv;
                boolean bl = false;
                boolean bl2 = !it.getRows().isEmpty();
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List tables = (List)destination$iv$iv;
            Iterable $this$forEachIndexed$iv = tables;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void table;
                int n;
                Object element$iv$iv;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                element$iv$iv = (OpenMapTable)item$iv;
                int tid = n;
                boolean bl = false;
                String tableName = INSTANCE.buildTableName(url, tid);
                INSTANCE.createHarvestResultTable((Connection)conn, tableName, (OpenMapTable)table);
                INSTANCE.insertHarvestTask((Connection)conn, url, tableName, (OpenMapTable)table);
                tableNames.add(tableName);
            }
            conn.commit();
            log.debug("Tables are created | {}", (Object)CollectionsKt.joinToString$default((Iterable)tableNames, null, null, null, (int)0, null, null, (int)63, null));
            Set<Long> set2 = sessionTracker.get(scentSession.getId());
            if (set2 == null) break block4;
            set2.remove(threadId);
        }
    }

    private final String buildTaskId(String url) {
        String string = Integer.toString(Math.abs(url.hashCode()), CharsKt.checkRadix((int)36));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String hash = string;
        String string2 = new URL(url).getHost();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getHost(...)");
        String taskId = StringsKt.substringBeforeLast$default((String)StringsKt.removePrefix((String)string2, (CharSequence)"www."), (String)".", null, (int)2, null) + "-" + hash;
        return StringsKt.replace$default((String)taskId, (String)".", (String)"-", (boolean)false, (int)4, null);
    }

    private final String buildTableName(String url, int tid) {
        String taskId = this.buildTaskId(url);
        String string = StringsKt.replace$default((String)(taskId + "-" + (1 + tid)), (char)'-', (char)'_', (boolean)false, (int)4, null);
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string2 = string.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        String ident = string2;
        return "PG_" + ident;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void createHarvestResultTable(Connection conn, String tableName, OpenMapTable table) {
        AutoCloseable $this$mapIndexedTo$iv$iv;
        log.debug("Creating harvest task table {}", (Object)tableName);
        OpenMapTable.Column[] $this$mapIndexed$iv = table.getColumns();
        boolean $i$f$mapIndexed = false;
        OpenMapTable.Column[] columnArray = $this$mapIndexed$iv;
        Object destination$iv$iv = new ArrayList($this$mapIndexed$iv.length);
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (OpenMapTable.Row item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void col;
            int n = index$iv$iv++;
            void var14_22 = item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String it = PageTableKt.getData((OpenMapTable.Column)col).isInt() ? "INT" : (PageTableKt.getData((OpenMapTable.Column)col).isFloat() ? "DOUBLE" : "VARCHAR");
            boolean bl2 = false;
            collection.add(col.getName() + " " + it);
        }
        String fieldDefines2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), null, null, null, (int)0, null, (Function1)createHarvestResultTable.fieldDefines.2.INSTANCE, (int)31, null);
        String fieldNames2 = ArraysKt.joinToString$default((Object[])table.getColumns(), null, null, null, (int)0, null, (Function1)createHarvestResultTable.fieldNames.1.INSTANCE, (int)31, null);
        String createSql = "CREATE TABLE IF NOT EXISTS " + tableName + "( ID IDENTITY, " + fieldDefines2 + ", CREATED TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP);";
        $this$mapIndexedTo$iv$iv = conn.prepareStatement(createSql);
        destination$iv$iv = null;
        try {
            PreparedStatement it22 = (PreparedStatement)$this$mapIndexedTo$iv$iv;
            boolean bl = false;
            int it22 = it22.executeUpdate();
        }
        catch (Throwable it22) {
            destination$iv$iv = it22;
            throw it22;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)$this$mapIndexedTo$iv$iv, (Throwable)destination$iv$iv);
        }
        conn.commit();
        Iterable $this$forEachIndexed$iv = table.getRows();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void row;
            int n;
            OpenMapTable.Row item$iv$iv;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            item$iv$iv = (OpenMapTable.Row)item$iv;
            int i = n;
            boolean bl = false;
            String prefix = "INSERT INTO " + tableName + "(" + fieldNames2 + ") VALUES(";
            String sql2 = CollectionsKt.joinToString$default((Iterable)((Iterable)new IntRange(1, row.getCells().length)), (CharSequence)", ", (CharSequence)prefix, (CharSequence)")", (int)0, null, (Function1)createHarvestResultTable.2.sql.1.INSTANCE, (int)24, null);
            AutoCloseable autoCloseable = conn.prepareStatement(sql2);
            Throwable throwable = null;
            try {
                PreparedStatement stat = (PreparedStatement)autoCloseable;
                boolean bl3 = false;
                if (!(row.getCells().length == table.getNumColumns())) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                OpenMapTable.Cell[] $this$forEachIndexed$iv2 = row.getCells();
                boolean $i$f$forEachIndexed2 = false;
                int index$iv2 = 0;
                for (OpenMapTable.Cell item$iv2 : $this$forEachIndexed$iv2) {
                    void datum;
                    int n3 = index$iv2++;
                    OpenMapTable.Cell cell = item$iv2;
                    int j = n3;
                    boolean bl4 = false;
                    OpenMapTable.Column col = table.getColumns()[j];
                    int parameterIndex = j + 1;
                    if (PageTableKt.getData((OpenMapTable.Column)col).isInt()) {
                        Unit unit;
                        Integer n4 = INSTANCE.parseInt((OpenMapTable.Cell)datum);
                        if (n4 != null) {
                            int it = ((Number)n4).intValue();
                            boolean bl5 = false;
                            stat.setInt(parameterIndex, it);
                            unit = Unit.INSTANCE;
                        } else {
                            unit = null;
                        }
                        if (unit != null) continue;
                        stat.setNull(parameterIndex, 4);
                        continue;
                    }
                    if (PageTableKt.getData((OpenMapTable.Column)col).isFloat()) {
                        Unit unit;
                        Double d = INSTANCE.parseDouble((OpenMapTable.Cell)datum);
                        if (d != null) {
                            double it = ((Number)d).doubleValue();
                            boolean bl6 = false;
                            stat.setDouble(parameterIndex, it);
                            unit = Unit.INSTANCE;
                        } else {
                            unit = null;
                        }
                        if (unit != null) continue;
                        stat.setNull(parameterIndex, 8);
                        continue;
                    }
                    String string = datum;
                    if (string == null || (string = string.toString()) == null) {
                        string = "";
                    }
                    stat.setString(parameterIndex, string);
                }
                stat.executeUpdate();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        conn.commit();
    }

    private final Integer parseInt(OpenMapTable.Cell cell) {
        if (cell == null) {
            return null;
        }
        Object v = cell.getValue();
        if (v instanceof Integer) {
            return (Integer)v;
        }
        return StringsKt.toIntOrNull((String)String.valueOf(v));
    }

    private final Double parseDouble(OpenMapTable.Cell cell) {
        if (cell == null) {
            return null;
        }
        Object v = cell.getValue();
        if (v instanceof Double || v instanceof Float) {
            return (Double)v;
        }
        return StringsKt.toDoubleOrNull((String)String.valueOf(v));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void createHarvestResultMetaTable(Connection conn, String tableName, OpenMapTable table) {
        void $this$mapTo$iv$iv;
        Iterable list$iv;
        void $this$flatMapTo$iv;
        OpenMapTable.Column[] columnArray = table.getColumns();
        Collection destination$iv = new HashSet();
        boolean $i$f$flatMapTo22 = false;
        int n = ((void)$this$flatMapTo$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv;
            void it = element$iv = $this$flatMapTo$iv[i];
            boolean bl = false;
            list$iv = it.getAttributes().keySet();
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        HashSet attrNames = (HashSet)destination$iv;
        String fieldDefines2 = ArraysKt.joinToString$default((Object[])table.getColumns(), null, null, null, (int)0, null, (Function1)createHarvestResultMetaTable.fieldDefines.1.INSTANCE, (int)31, null);
        String createSql = "CREATE TEMPORARY TABLE IF NOT EXISTS " + tableName + "(ID IDENTITY, NAME VARCHAR, " + fieldDefines2 + ");";
        AutoCloseable $i$f$flatMapTo22 = conn.prepareStatement(createSql);
        Throwable throwable = null;
        try {
            PreparedStatement it22 = (PreparedStatement)$i$f$flatMapTo22;
            boolean bl = false;
            int it22 = it22.executeUpdate();
        }
        catch (Throwable it22) {
            throwable = it22;
            throw it22;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)$i$f$flatMapTo22, (Throwable)throwable);
        }
        String fields2 = ArraysKt.joinToString$default((Object[])table.getColumns(), null, null, null, (int)0, null, (Function1)createHarvestResultMetaTable.fields.1.INSTANCE, (int)31, null);
        Iterable $this$map$iv = attrNames;
        boolean $i$f$map = false;
        list$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)it), (Iterable)table.getMetadata().attributeRow((String)it)));
        }
        List rows = (List)destination$iv$iv;
        Iterable $this$forEachIndexed$iv = rows;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void row;
            int n2;
            Object item$iv$iv;
            if ((n2 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            item$iv$iv = (List)item$iv;
            int i = n2;
            boolean bl = false;
            String prefix = "INSERT INTO " + tableName + "(NAME, " + fields2 + ") VALUES(";
            String sql2 = CollectionsKt.joinToString$default((Iterable)((Iterable)new IntRange(1, row.size())), (CharSequence)", ", (CharSequence)prefix, (CharSequence)")", (int)0, null, (Function1)createHarvestResultMetaTable.2.sql.1.INSTANCE, (int)24, null);
            AutoCloseable autoCloseable = conn.prepareStatement(sql2);
            Throwable throwable2 = null;
            try {
                PreparedStatement it = (PreparedStatement)autoCloseable;
                boolean bl2 = false;
                Iterable $this$forEachIndexed$iv2 = (Iterable)row;
                boolean $i$f$forEachIndexed2 = false;
                int index$iv2 = 0;
                for (Object item$iv2 : $this$forEachIndexed$iv2) {
                    void datum;
                    int n3;
                    if ((n3 = index$iv2++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    Object t = item$iv2;
                    int j = n3;
                    boolean bl3 = false;
                    String string = datum;
                    if (string == null || (string = string.toString()) == null) {
                        string = "";
                    }
                    it.setString(j + 1, string);
                }
                it.executeUpdate();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable2);
            }
        }
    }

    private final ResultSet queryTable(Connection conn, String tableName, int limit) {
        String sql2 = "SELECT * FROM " + tableName + " limit " + limit;
        Statement stat = conn.createStatement();
        ResultSet resultSet = stat.executeQuery(sql2);
        Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"executeQuery(...)");
        return resultSet;
    }

    static /* synthetic */ ResultSet queryTable$default(ExtractFunctionTables extractFunctionTables, Connection connection, String string, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 1000;
        }
        return extractFunctionTables.queryTable(connection, string, n);
    }

    private final boolean tableExists(Connection conn, String tableName) {
        ResultSet rs = conn.getMetaData().getTables(null, null, tableName, null);
        return rs.next();
    }

    private final ResultSet listHarvestTasks(Connection conn, int limit) {
        String sql2 = "SELECT * FROM WEB_HARVEST_TASKS LIMIT " + limit;
        PreparedStatement stat = conn.prepareStatement(sql2, 1004, 1007, 2);
        ResultSet resultSet = stat.executeQuery();
        Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"executeQuery(...)");
        return resultSet;
    }

    static /* synthetic */ ResultSet listHarvestTasks$default(ExtractFunctionTables extractFunctionTables, Connection connection, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 1000;
        }
        return extractFunctionTables.listHarvestTasks(connection, n);
    }

    private final ResultSet queryHarvestTaskTable(Connection conn, String url) {
        String sql2 = "SELECT * FROM WEB_HARVEST_TASKS WHERE PORTAL_URL=?";
        PreparedStatement stat = conn.prepareStatement(sql2, 1004, 1007, 2);
        stat.setString(1, url);
        ResultSet resultSet = stat.executeQuery();
        Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"executeQuery(...)");
        return resultSet;
    }

    private final int truncateHarvestTaskTable(Connection conn) {
        String sql2 = "TRUNCATE TABLE WEB_HARVEST_TASKS";
        Statement stat = conn.createStatement();
        return stat.executeUpdate(sql2);
    }

    private final void dropHarvestTaskTable(Connection conn) {
        String sql2 = "DROP TABLE IF EXISTS WEB_HARVEST_TASKS";
        conn.prepareStatement(sql2).executeUpdate();
    }

    /*
     * WARNING - void declaration
     */
    private final void insertHarvestTask(Connection conn, String portalUrl, String tableName, OpenMapTable table) {
        log.debug("Creating harvest task record for " + portalUrl + " with table name " + tableName);
        String score = PageTableKt.getData((OpenMapTable)table).getScore();
        int numColumns = table.getNumColumns();
        int numRows = table.getNumRows();
        Iterable $this$sumBy$iv = table.getRows();
        boolean $i$f$sumBy = false;
        int sum$iv = 0;
        for (Object element$iv : $this$sumBy$iv) {
            void it;
            OpenMapTable.Row row = (OpenMapTable.Row)element$iv;
            int n = sum$iv;
            boolean bl = false;
            OpenMapTable.Cell[] $this$count$iv = it.getCells();
            boolean $i$f$count = false;
            int count$iv = 0;
            int n2 = $this$count$iv.length;
            for (int i = 0; i < n2; ++i) {
                OpenMapTable.Cell element$iv2;
                OpenMapTable.Cell it2 = element$iv2 = $this$count$iv[i];
                boolean bl2 = false;
                if (!(it2 == null)) continue;
                ++count$iv;
            }
            int n3 = count$iv;
            sum$iv = n + n3;
        }
        int numNulls = sum$iv;
        DataTypeStatistics ds = PageTableKt.getData((OpenMapTable)table).getDataTypeStatistics();
        String showSql = "SELECT * FROM " + tableName + ";";
        String sql2 = "INSERT INTO WEB_HARVEST_TASKS(" + joinedHarvestTaskTableFields + ") VALUES(" + harvestTaskTableFieldsPlaceholds + ");";
        PreparedStatement stat = conn.prepareStatement(sql2);
        int parameterIndex = 0;
        stat.setString(++parameterIndex, portalUrl);
        stat.setString(++parameterIndex, tableName);
        stat.setString(++parameterIndex, score.toString());
        stat.setInt(++parameterIndex, numColumns);
        stat.setInt(++parameterIndex, numRows);
        stat.setInt(++parameterIndex, numNulls);
        stat.setInt(++parameterIndex, ds.getNumLocallyConstants());
        stat.setInt(++parameterIndex, ds.getNumShortTexts());
        stat.setInt(++parameterIndex, ds.getNumMediumTexts());
        stat.setInt(++parameterIndex, ds.getNumTexts());
        stat.setInt(++parameterIndex, ds.getNumImages());
        stat.setInt(++parameterIndex, ds.getNumVariables());
        stat.setInt(++parameterIndex, ds.getNumInts());
        stat.setInt(++parameterIndex, ds.getNumFloats());
        stat.setInt(++parameterIndex, ds.getNumNumbers());
        stat.setInt(++parameterIndex, ds.getNumNumberLikes());
        stat.setInt(++parameterIndex, ds.getNumMoneyLikes());
        stat.setString(++parameterIndex, showSql);
        stat.executeUpdate();
        conn.commit();
    }

    private final int deleteHarvestTask(Connection conn, String url) {
        String sql2 = "DELETE TOP 1000 FROM `WEB_HARVEST_TASKS` WHERE `PORTAL_URL`=?";
        PreparedStatement stat = conn.prepareStatement(sql2);
        stat.setString(1, url);
        int affectedRows = stat.executeUpdate();
        conn.commit();
        return affectedRows;
    }

    private final void createHarvestTaskTableIfAbsent(Connection conn) {
        if (this.tableExists(conn, "WEB_HARVEST_TASKS")) {
            return;
        }
        String fieldDefines2 = CollectionsKt.joinToString$default((Iterable)harvestTaskTableFieldDefines.entrySet(), null, null, null, (int)0, null, (Function1)createHarvestTaskTableIfAbsent.fieldDefines.1.INSTANCE, (int)31, null);
        Object sql2 = "CREATE TABLE IF NOT EXISTS WEB_HARVEST_TASKS(ID IDENTITY, " + fieldDefines2 + ", CREATED TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP);";
        int result2 = conn.prepareStatement((String)sql2).executeUpdate();
        conn.commit();
        if (result2 > 0) {
            sql2 = "CREATE INDEX IF NOT EXISTS ON WEB_HARVEST_TASKS(PORTAL_URL);";
            conn.prepareStatement((String)sql2).executeUpdate();
            sql2 = "CREATE INDEX IF NOT EXISTS ON WEB_HARVEST_TASKS(TABLE_NAME);";
            conn.prepareStatement((String)sql2).executeUpdate();
            conn.commit();
        }
        for (int i = 1; i < 11 && !this.tableExists(conn, "WEB_HARVEST_TASKS"); ++i) {
            LangKt.sleepSeconds((long)1L);
        }
    }

    @JvmStatic
    @UDFunction(hasShortcut=true)
    @JvmOverloads
    @NotNull
    public static final ResultSet harvest(@H2Context @NotNull JdbcConnection conn, @NotNull String portalUrl) {
        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
        Intrinsics.checkNotNullParameter((Object)portalUrl, (String)"portalUrl");
        return ExtractFunctionTables.harvest$default(conn, portalUrl, 0, 4, null);
    }

    @JvmStatic
    @UDFunction(hasShortcut=true)
    @JvmOverloads
    @NotNull
    public static final ResultSet harvestNthTable(@H2Context @NotNull JdbcConnection conn, @NotNull String portalUrl) {
        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
        Intrinsics.checkNotNullParameter((Object)portalUrl, (String)"portalUrl");
        return ExtractFunctionTables.harvestNthTable$default(conn, portalUrl, 0, 4, null);
    }

    private static final Set doHarvest$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Set)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$doHarvest(ExtractFunctionTables $this, JdbcConnection conn, String url, HarvestOptions options) {
        $this.doHarvest(conn, url, options);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"PORTAL_URL", (Object)"VARCHAR(2046) NOT NULL"), TuplesKt.to((Object)"TABLE_NAME", (Object)"VARCHAR(256) NOT NULL"), TuplesKt.to((Object)"SCORE", (Object)"VARCHAR(256) NOT NULL"), TuplesKt.to((Object)"NUM_COLUMNS", (Object)integerFieldDefine), TuplesKt.to((Object)"NUM_ROWS", (Object)integerFieldDefine), TuplesKt.to((Object)"NUM_NULLS", (Object)integerFieldDefine), TuplesKt.to((Object)"NUM_LOCALLY_CONSTANTS", (Object)integerFieldDefine), TuplesKt.to((Object)"NUM_SHORT_TEXTS", (Object)integerFieldDefine), TuplesKt.to((Object)"NUM_MEDIUM_TEXTS", (Object)integerFieldDefine), TuplesKt.to((Object)"NUM_TEXTS", (Object)integerFieldDefine), TuplesKt.to((Object)"NUM_IMAGES", (Object)integerFieldDefine), TuplesKt.to((Object)"NUM_VARIABLES", (Object)integerFieldDefine), TuplesKt.to((Object)"NUM_INTS", (Object)integerFieldDefine), TuplesKt.to((Object)"NUM_FLOATS", (Object)integerFieldDefine), TuplesKt.to((Object)"NUM_NUMBERS", (Object)integerFieldDefine), TuplesKt.to((Object)"NUM_NUMBER_LIKES", (Object)integerFieldDefine), TuplesKt.to((Object)"NUM_MONEY_LIKES", (Object)integerFieldDefine), TuplesKt.to((Object)"NUM_TEXTS", (Object)integerFieldDefine), TuplesKt.to((Object)"NUM_IMAGES", (Object)integerFieldDefine), TuplesKt.to((Object)"SHOW_SQL", (Object)"VARCHAR(256)")};
        harvestTaskTableFieldDefines = MapsKt.mapOf((Pair[])pairArray);
        harvestTaskTableFields = harvestTaskTableFieldDefines.keySet();
        joinedHarvestTaskTableFields = CollectionsKt.joinToString$default((Iterable)harvestTaskTableFields, null, null, null, (int)0, null, (Function1)joinedHarvestTaskTableFields.1.INSTANCE, (int)31, null);
        harvestTaskTableFieldsPlaceholds = CollectionsKt.joinToString$default((Iterable)((Iterable)new IntRange(1, harvestTaskTableFields.size())), null, null, null, (int)0, null, (Function1)harvestTaskTableFieldsPlaceholds.1.INSTANCE, (int)31, null);
    }
}

