/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.context.privacy;

import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.browser.BrowserFiles;
import ai.platon.pulsar.common.browser.Fingerprint;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.serialize.json.JacksonKt;
import ai.platon.pulsar.skeleton.crawl.fetch.privacy.PrivacyAgent;
import ai.platon.pulsar.skeleton.crawl.fetch.privacy.PrivacyAgentGenerator;
import com.google.common.collect.Iterators;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010)\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u0011\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0096\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0002R\u001a\u0010\u0005\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\u0003 \u000e*\b\u0012\u0004\u0012\u00020\u00030\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0004R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lai/platon/scent/context/privacy/ConfiguredPrivacyAgentGenerator;", "Lai/platon/pulsar/skeleton/crawl/fetch/privacy/PrivacyAgentGenerator;", "group", "", "(Ljava/lang/String;)V", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "getConf", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "setConf", "(Lai/platon/pulsar/common/config/ImmutableConfig;)V", "contextDirIterator", "", "", "kotlin.jvm.PlatformType", "contextDirs", "", "getGroup", "()Ljava/lang/String;", "setGroup", "logger", "Lorg/slf4j/Logger;", "computeMaxAgentCount", "", "invoke", "Lai/platon/pulsar/skeleton/crawl/fetch/privacy/PrivacyAgent;", "fingerprint", "Lai/platon/pulsar/common/browser/Fingerprint;", "loadContextDirs", "", "scent-engine"})
public class ConfiguredPrivacyAgentGenerator
implements PrivacyAgentGenerator {
    @NotNull
    private String group;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Set<String> contextDirs;
    @NotNull
    private final Iterator<String> contextDirIterator;
    @NotNull
    private ImmutableConfig conf;

    public ConfiguredPrivacyAgentGenerator(@NotNull String group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        this.group = group;
        this.logger = LogsKt.getLogger((Object)this);
        this.contextDirs = new LinkedHashSet();
        Iterator iterator = Iterators.cycle((Iterable)this.contextDirs);
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"cycle(...)");
        this.contextDirIterator = iterator;
        this.conf = new ImmutableConfig();
    }

    public /* synthetic */ ConfiguredPrivacyAgentGenerator(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "default";
        }
        this(string);
    }

    @NotNull
    public final String getGroup() {
        return this.group;
    }

    public final void setGroup(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.group = string;
    }

    @NotNull
    public ImmutableConfig getConf() {
        return this.conf;
    }

    public void setConf(@NotNull ImmutableConfig immutableConfig) {
        Intrinsics.checkNotNullParameter((Object)immutableConfig, (String)"<set-?>");
        this.conf = immutableConfig;
    }

    @NotNull
    public PrivacyAgent invoke(@NotNull Fingerprint fingerprint) throws IllegalStateException {
        Intrinsics.checkNotNullParameter((Object)fingerprint, (String)"fingerprint");
        if (this.contextDirs.isEmpty()) {
            this.loadContextDirs();
        }
        if (this.contextDirs.isEmpty()) {
            throw new IllegalStateException("No context dirs found");
        }
        Path contextDir = Paths.get(this.contextDirIterator.next(), new String[0]);
        Path fingerprintConfigFile = contextDir.resolve("fingerprint.json");
        Intrinsics.checkNotNull((Object)fingerprintConfigFile);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.notExists(fingerprintConfigFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            throw new IllegalStateException("The fingerprint config file does not exist: " + fingerprintConfigFile);
        }
        Fingerprint finalFingerprint = (Fingerprint)JacksonKt.pulsarObjectMapper().readValue(fingerprintConfigFile.toFile(), Fingerprint.class);
        Intrinsics.checkNotNull((Object)contextDir);
        Intrinsics.checkNotNull((Object)finalFingerprint);
        return new PrivacyAgent(contextDir, finalFingerprint);
    }

    private final void loadContextDirs() {
        if (!((Collection)this.contextDirs).isEmpty()) {
            return;
        }
        int maxAgents = this.computeMaxAgentCount();
        for (int i = 0; i < maxAgents; ++i) {
            int it = i;
            boolean bl = false;
            Path contextDir = BrowserFiles.INSTANCE.computeNextSequentialContextDir(this.group, Fingerprint.Companion.getDEFAULT(), maxAgents);
            Path fingerprintConfigFile = contextDir.resolve("fingerprint.json");
            Intrinsics.checkNotNull((Object)fingerprintConfigFile);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(fingerprintConfigFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
            this.contextDirs.add(((Object)contextDir).toString());
        }
        this.logger.info("Loaded " + this.contextDirs.size() + " context dirs");
    }

    private final int computeMaxAgentCount() {
        int privacyContextNumber = this.getConf().getInt("privacy.context.number", 2);
        int minAgents = this.getConf().getInt("min.sequential.privacy.agent.number", 10);
        int maxAgents = this.getConf().getInt("max.sequential.privacy.agent.number", minAgents);
        maxAgents = RangesKt.coerceAtLeast((int)RangesKt.coerceAtLeast((int)maxAgents, (int)privacyContextNumber), (int)minAgents);
        return maxAgents;
    }

    public ConfiguredPrivacyAgentGenerator() {
        this(null, 1, null);
    }
}

