/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.crawl.sql;

import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.urls.URLUtils;
import ai.platon.pulsar.ql.h2.utils.ResultSetUtils;
import ai.platon.pulsar.skeleton.common.options.LoadOptions;
import ai.platon.scent.common.XSQLUtils;
import ai.platon.scent.common.sql.NormXSQL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nibor.autolink.LinkExtractor;
import org.nibor.autolink.LinkSpan;
import org.nibor.autolink.LinkType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005J\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u0005J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0005J2\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0016\u001a\u00020\u0010J\u0010\u0010\u0017\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u0005R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\u0018"}, d2={"Lai/platon/scent/crawl/sql/ScrapeAPIUtils;", "", "()V", "allowedArgs", "", "", "allowedScrapeUDFs", "", "[Ljava/lang/String;", "checkArgs", "", "args", "eraseExpireOptions", "extractConfiguredUrl", "sql", "isScrapeUDF", "", "normalizeSQL", "Lai/platon/scent/common/sql/NormXSQL;", "rawSql", "eraseArgs", "addArgs", "noExpire", "sanitizeSQL", "scent-engine"})
@SourceDebugExtension(value={"SMAP\nScrapeAPIUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScrapeAPIUtils.kt\nai/platon/scent/crawl/sql/ScrapeAPIUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,117:1\n1549#2:118\n1620#2,3:119\n766#2:124\n857#2,2:125\n1855#2,2:127\n37#3,2:122\n12474#4,2:129\n*S KotlinDebug\n*F\n+ 1 ScrapeAPIUtils.kt\nai/platon/scent/crawl/sql/ScrapeAPIUtils\n*L\n38#1:118\n38#1:119,3\n58#1:124\n58#1:125,2\n58#1:127,2\n38#1:122,2\n67#1:129,2\n*E\n"})
public final class ScrapeAPIUtils {
    @NotNull
    public static final ScrapeAPIUtils INSTANCE = new ScrapeAPIUtils();
    @NotNull
    private static final List<String> allowedArgs = LoadOptions.Companion.getApiPublicOptionNames();
    @NotNull
    private static final String[] allowedScrapeUDFs;

    private ScrapeAPIUtils() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final NormXSQL normalizeSQL(@Nullable String rawSql, @Nullable String eraseArgs, @Nullable String addArgs, boolean noExpire) throws IllegalArgumentException {
        Object newArgs;
        String[] eraseArgList;
        if (rawSql == null) {
            throw new IllegalArgumentException("SQL is required");
        }
        String string = this.extractConfiguredUrl(rawSql);
        if (string == null) {
            throw new IllegalArgumentException("Illegal sql, no url found>>>\n" + rawSql + "\n<<<");
        }
        String configuredUrl = string;
        Pair pair = URLUtils.splitUrlArgs((String)configuredUrl);
        String url = (String)pair.component1();
        String args = (String)pair.component2();
        if (!URLUtils.isStandard((String)url)) {
            throw new IllegalArgumentException("Malformed url: <" + url + ">");
        }
        CharSequence charSequence = eraseArgs;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            void $this$toTypedArray$iv;
            void $this$mapTo$iv$iv;
            String[] stringArray = new String[]{" "};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)eraseArgs, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                char[] cArray = new char[]{'-'};
                collection.add(StringsKt.trim((String)it, (char[])cArray));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            eraseArgList = thisCollection$iv.toArray(new String[0]);
            v1 = LoadOptions.Companion.eraseOptions(args, Arrays.copyOf(eraseArgList, eraseArgList.length));
        } else {
            v1 = newArgs = args;
        }
        if (noExpire) {
            newArgs = this.eraseExpireOptions((String)newArgs);
        }
        if (!((eraseArgList = (String[])addArgs) == null || StringsKt.isBlank((CharSequence)eraseArgList))) {
            newArgs = (String)newArgs + " " + addArgs;
        }
        newArgs = ((Object)StringsKt.trim((CharSequence)((CharSequence)newArgs))).toString();
        String newConfiguredUrl = ((Object)StringsKt.trim((CharSequence)(url + " " + (String)newArgs))).toString();
        String newSQL = StringsKt.replace$default((String)rawSql, (String)configuredUrl, (String)newConfiguredUrl, (boolean)false, (int)4, null);
        return new NormXSQL(url, args, newSQL);
    }

    public static /* synthetic */ NormXSQL normalizeSQL$default(ScrapeAPIUtils scrapeAPIUtils, String string, String string2, String string3, boolean bl, int n, Object object) throws IllegalArgumentException {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            string3 = null;
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        return scrapeAPIUtils.normalizeSQL(string, string2, string3, bl);
    }

    /*
     * WARNING - void declaration
     */
    public final void checkArgs(@Nullable String args) throws IllegalArgumentException {
        block2: {
            void $this$filterTo$iv$iv;
            int n;
            CharSequence charSequence;
            Regex regex;
            Object object = args;
            if (object == null || (object = (regex = new Regex("\\s+")).split(charSequence = (CharSequence)object, n = 0)) == null) break block2;
            Iterable $this$filter$iv = (Iterable)object;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)it, (String)"-", (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String arg = (String)element$iv;
                boolean bl = false;
                if (allowedArgs.contains(arg)) continue;
                throw new IllegalArgumentException("Argument is not allowed: <" + arg + ">");
            }
        }
    }

    public final boolean isScrapeUDF(@NotNull String sql2) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)sql2, (String)"sql");
            String string = StringsKt.replace$default((String)sql2, (String)"_", (String)"", (boolean)false, (int)4, null);
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            String s = string2;
            String[] $this$any$iv = allowedScrapeUDFs;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String it = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                if (!StringsKt.contains$default((CharSequence)s, (CharSequence)it, (boolean)false, (int)2, null)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @NotNull
    public final String sanitizeSQL(@Nullable String sql2) throws IllegalArgumentException {
        String string;
        if (sql2 == null) {
            throw new IllegalArgumentException("Sql is required");
        }
        try {
            string = XSQLUtils.INSTANCE.sanitize(sql2);
        }
        catch (Exception e) {
            LogsKt.getLogger((Object)this).warn(sql2);
            throw new IllegalArgumentException(e.getMessage());
        }
        return string;
    }

    @NotNull
    public final String eraseExpireOptions(@NotNull String args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        String[] stringArray = new String[]{"refresh", "expires", "expireAt", "itemExpires", "itemExpireAt"};
        String[] optionsToRemove = stringArray;
        return LoadOptions.Companion.eraseOptions(args, Arrays.copyOf(optionsToRemove, optionsToRemove.length));
    }

    @Nullable
    public final String extractConfiguredUrl(@Nullable String sql2) {
        String string;
        String string2;
        if (sql2 == null) {
            return null;
        }
        Regex regex = new Regex("\\s+");
        CharSequence charSequence = this.sanitizeSQL(sql2);
        String sql0 = regex.replace(charSequence, string2 = " ");
        if (StringsKt.contains((CharSequence)sql0, (CharSequence)" from ", (boolean)true)) {
            string = ResultSetUtils.INSTANCE.extractUrlFromFromClause(sql0);
        } else {
            String input = sql0;
            LinkExtractor linkExtractor = LinkExtractor.builder().linkTypes((Set)EnumSet.of((Enum)LinkType.URL)).build();
            Iterator links2 = linkExtractor.extractLinks((CharSequence)input).iterator();
            if (links2.hasNext()) {
                LinkSpan link = (LinkSpan)links2.next();
                String string3 = input.substring(link.getBeginIndex(), link.getEndIndex());
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            } else {
                string = null;
            }
        }
        return string;
    }

    static {
        String[] stringArray = new String[]{"loadandselect", "loadoutpages", "newsloadandextract"};
        allowedScrapeUDFs = stringArray;
    }
}

