/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.io;

import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.ql.h2.utils.ResultSetUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lai/platon/scent/io/ResultSet2ExcelExporter;", "", "name", "", "(Ljava/lang/String;)V", "logger", "Lorg/slf4j/Logger;", "getName", "()Ljava/lang/String;", "export", "", "rs", "Ljava/sql/ResultSet;", "scent-engine"})
@SourceDebugExtension(value={"SMAP\nResultSet2ExcelExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResultSet2ExcelExporter.kt\nai/platon/scent/io/ResultSet2ExcelExporter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,63:1\n1864#2,3:64\n*S KotlinDebug\n*F\n+ 1 ResultSet2ExcelExporter.kt\nai/platon/scent/io/ResultSet2ExcelExporter\n*L\n28#1:64,3\n*E\n"})
public final class ResultSet2ExcelExporter {
    @NotNull
    private final String name;
    @NotNull
    private final Logger logger;

    public ResultSet2ExcelExporter(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.logger = LogsKt.getLogger((KClass)Reflection.getOrCreateKotlinClass(ResultSet2ExcelExporter.class));
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    /*
     * WARNING - void declaration
     */
    public final void export(@NotNull ResultSet rs) {
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet(this.name);
        List entities = ResultSetUtils.INSTANCE.getEntitiesFromResultSet(rs);
        Map data = new TreeMap();
        data.put("0", ResultSetUtils.INSTANCE.getColumnNames(rs));
        Iterable $this$forEachIndexed$iv = entities;
        boolean $i$f$forEachIndexed22 = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void record;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Map map2 = (Map)item$iv;
            int i = n;
            boolean bl = false;
            data.put(String.valueOf(i + 1), record.values());
        }
        Set keySet = data.keySet();
        Iterator $i$f$forEachIndexed22 = keySet.iterator();
        index$iv = 0;
        while ($i$f$forEachIndexed22.hasNext()) {
            int rowNum = index$iv++;
            String key = (String)$i$f$forEachIndexed22.next();
            XSSFRow row = sheet.createRow(rowNum);
            Object v = data.get(key);
            Intrinsics.checkNotNull(v);
            Collection objArr = (Collection)v;
            Iterator iterator = objArr.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                int cellNum = n++;
                Object obj = iterator.next();
                XSSFCell cell = row.createCell(cellNum);
                Object e = obj;
                if (e instanceof String) {
                    cell.setCellValue((String)obj);
                    continue;
                }
                if (!(e instanceof Integer)) continue;
                cell.setCellValue((double)((Number)obj).intValue());
            }
        }
        try {
            String filename = this.name + ".xlsx";
            FileOutputStream out = new FileOutputStream(new File(filename));
            workbook.write((OutputStream)out);
            out.close();
            this.logger.info(filename + " written successfully on disk");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

