/**
 * A utility class for handling scent-related tasks.
 * */
"use strict";

let __scent_utils__ = function () {

};

/**
 * Return a + b.
 *
 * This simple function is used for a smoke test.
 *
 * @param a {Number}
 * @param b {Number}
 * @return {Number}
 * */
__scent_utils__.add = function(a, b) {
    return a + b
};

/**
 * Select an element with the given color and size and click it.
 *
 * @param  {String} restrictSelector
 * @param  {String} color
 * @param  {String} size
 * @return
 */
__scent_utils__.click = function(restrictSelector, color, size) {
    let ele = document.querySelector(restrictSelector)
    ele = ele.querySelector(`[data-color="${color}"][data-size="${size}"]`)
    if (ele instanceof HTMLElement) {
        ele.click()
    }
};
