/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.parse.html;

import ai.platon.pulsar.common.ExceptionsKt;
import ai.platon.pulsar.common.LogsKt;
import ai.platon.scent.parse.html.SinkAwarePendingResult;
import ai.platon.scent.parse.html.SinkAwareResultSet;
import java.sql.ResultSet;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"J&\u0010\u001f\u001a\u00020 2\u0006\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u00102\u0006\u0010!\u001a\u00020%2\u0006\u0010&\u001a\u00020\tJ\u0016\u0010'\u001a\u00020 2\u0006\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u0010J\u0016\u0010(\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u0010J\u0016\u0010)\u001a\u00020\u00112\u0006\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u0010J\u0016\u0010*\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u0010J\u0006\u0010+\u001a\u00020\u0004J\u0006\u0010,\u001a\u00020\u0004J\u0006\u0010-\u001a\u00020\u0016J\u0018\u0010.\u001a\u00020\u00112\u0006\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u0010H\u0002J\u0016\u0010/\u001a\u00020 2\u0006\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u0010J*\u00100\u001a\u00020 2\u0006\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u00102\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020 02R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\u000b\u001a\n \n*\u0004\u0018\u00010\t0\t2\u000e\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR-\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fj\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011`\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0019\u0010\u001b\u001a\n \n*\u0004\u0018\u00010\u001c0\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u00063"}, d2={"Lai/platon/scent/parse/html/SinkAwareResultManager;", "", "()V", "isExpired", "", "()Z", "logger", "Lorg/slf4j/Logger;", "<set-?>", "Ljava/time/Instant;", "kotlin.jvm.PlatformType", "nextSyncTime", "getNextSyncTime", "()Ljava/time/Instant;", "results", "Ljava/util/LinkedHashMap;", "", "Lai/platon/scent/parse/html/SinkAwarePendingResult;", "Lkotlin/collections/LinkedHashMap;", "getResults", "()Ljava/util/LinkedHashMap;", "syncBatchSize", "", "getSyncBatchSize", "()I", "setSyncBatchSize", "(I)V", "syncInterval", "Ljava/time/Duration;", "getSyncInterval", "()Ljava/time/Duration;", "add", "", "resultSet", "Lai/platon/scent/parse/html/SinkAwareResultSet;", "collection", "name", "Ljava/sql/ResultSet;", "deadTime", "clear", "count", "get", "hasBatches", "isEmpty", "isNotEmpty", "size", "take", "takeAndClear", "takeAndCommit", "committer", "Lkotlin/Function1;", "scent-parse"})
@SourceDebugExtension(value={"SMAP\nSinkAwareResultManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SinkAwareResultManager.kt\nai/platon/scent/parse/html/SinkAwareResultManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,158:1\n1774#2,4:159\n1855#2:163\n1856#2:165\n1726#2,3:166\n1#3:164\n*S KotlinDebug\n*F\n+ 1 SinkAwareResultManager.kt\nai/platon/scent/parse/html/SinkAwareResultManager\n*L\n116#1:159,4\n130#1:163\n130#1:165\n140#1:166,3\n*E\n"})
public class SinkAwareResultManager {
    @NotNull
    private final Logger logger = LogsKt.getLogger((KClass)Reflection.getOrCreateKotlinClass(SinkAwareResultManager.class));
    @NotNull
    private final LinkedHashMap<String, SinkAwarePendingResult> results = new LinkedHashMap();
    private final Duration syncInterval = Duration.ofMinutes(10L);
    private int syncBatchSize = 60;
    private volatile Instant nextSyncTime = Instant.now().plus(this.syncInterval);

    @NotNull
    public final LinkedHashMap<String, SinkAwarePendingResult> getResults() {
        return this.results;
    }

    public final Duration getSyncInterval() {
        return this.syncInterval;
    }

    public final int getSyncBatchSize() {
        return this.syncBatchSize;
    }

    public final void setSyncBatchSize(int n) {
        this.syncBatchSize = n;
    }

    public final Instant getNextSyncTime() {
        return this.nextSyncTime;
    }

    public final boolean isExpired() {
        return this.nextSyncTime.compareTo(Instant.now()) < 0;
    }

    public final boolean hasBatches(@NotNull String collection, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)collection, (String)"collection");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.count(collection, name) >= this.syncBatchSize;
    }

    public final void add(@NotNull SinkAwareResultSet resultSet) {
        Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
        SinkAwarePendingResult sinkAwarePendingResult = this.results.computeIfAbsent(resultSet.getKey(), arg_0 -> SinkAwareResultManager.add$lambda$0((Function1)new Function1<String, SinkAwarePendingResult>(resultSet){
            final /* synthetic */ SinkAwareResultSet $resultSet;
            {
                this.$resultSet = $resultSet;
                super(1);
            }

            @NotNull
            public final SinkAwarePendingResult invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return new SinkAwarePendingResult(this.$resultSet.getCollection(), this.$resultSet.getName());
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)sinkAwarePendingResult, (String)"computeIfAbsent(...)");
        SinkAwarePendingResult batch2 = sinkAwarePendingResult;
        batch2.getResultSets().add(resultSet);
    }

    public final void add(@NotNull String collection, @NotNull String name, @NotNull ResultSet resultSet, @NotNull Instant deadTime) {
        Intrinsics.checkNotNullParameter((Object)collection, (String)"collection");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
        Intrinsics.checkNotNullParameter((Object)deadTime, (String)"deadTime");
        this.add(new SinkAwareResultSet(collection, name, resultSet, deadTime));
    }

    @NotNull
    public final SinkAwarePendingResult get(@NotNull String collection, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)collection, (String)"collection");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String key = SinkAwareResultSet.Companion.toKey(collection, name);
        SinkAwarePendingResult sinkAwarePendingResult = this.results.computeIfAbsent(key, arg_0 -> SinkAwareResultManager.get$lambda$1((Function1)new Function1<String, SinkAwarePendingResult>(collection, name){
            final /* synthetic */ String $collection;
            final /* synthetic */ String $name;
            {
                this.$collection = $collection;
                this.$name = $name;
                super(1);
            }

            @NotNull
            public final SinkAwarePendingResult invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return new SinkAwarePendingResult(this.$collection, this.$name);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)sinkAwarePendingResult, (String)"computeIfAbsent(...)");
        return sinkAwarePendingResult;
    }

    public final int count(@NotNull String collection, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)collection, (String)"collection");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String key = SinkAwareResultSet.Companion.toKey(collection, name);
        SinkAwarePendingResult sinkAwarePendingResult = this.results.get(key);
        return sinkAwarePendingResult != null ? sinkAwarePendingResult.getSize() : 0;
    }

    public final void clear(@NotNull String collection, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)collection, (String)"collection");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.takeAndClear(collection, name);
    }

    public final void takeAndClear(@NotNull String collection, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)collection, (String)"collection");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        SinkAwarePendingResult pendingResult = this.take(collection, name);
        if (pendingResult.isEmpty()) {
            return;
        }
        pendingResult.clear();
    }

    public final void takeAndCommit(@NotNull String collection, @NotNull String name, @NotNull Function1<? super SinkAwarePendingResult, Unit> committer) {
        int deadCount;
        Intrinsics.checkNotNullParameter((Object)collection, (String)"collection");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(committer, (String)"committer");
        SinkAwarePendingResult pendingResult = this.take(collection, name);
        if (pendingResult.isEmpty()) {
            return;
        }
        Instant now = Instant.now();
        this.nextSyncTime = now.plus(this.syncInterval);
        Iterable $this$count$iv = pendingResult.getResultSets();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            v0 = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                SinkAwareResultSet it = (SinkAwareResultSet)element$iv;
                boolean bl = false;
                if (!(it.getDeadTime().compareTo(now) < 0) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            v0 = deadCount = count$iv;
        }
        if (deadCount > 0) {
            this.logger.info("There are {} dead result sets", (Object)deadCount);
        }
        pendingResult.getResultSets().removeIf(arg_0 -> SinkAwareResultManager.takeAndCommit$lambda$3((Function1)new Function1<SinkAwareResultSet, Boolean>(now){
            final /* synthetic */ Instant $now;
            {
                this.$now = $now;
                super(1);
            }

            @NotNull
            public final Boolean invoke(SinkAwareResultSet it) {
                return it.getDeadTime().compareTo(this.$now) < 0;
            }
        }, arg_0));
        try {
            committer.invoke((Object)pendingResult);
        }
        catch (Throwable t) {
            LogsKt.warnInterruptible((Object)this, (Throwable)t);
        }
        Iterable $this$forEach$iv = pendingResult.getResultSets();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            SinkAwareResultSet it = (SinkAwareResultSet)element$iv;
            boolean bl = false;
            Object object2 = it.getResultSet();
            try {
                ResultSet $this$takeAndCommit_u24lambda_u246_u24lambda_u244 = object2;
                boolean bl2 = false;
                $this$takeAndCommit_u24lambda_u246_u24lambda_u244.close();
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl2) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) continue;
            Object it2 = object = throwable;
            boolean bl3 = false;
            LogsKt.warnForClose((Object)this, (Throwable)it2, (String)ExceptionsKt.brief$default((Throwable)it2, (String)"Failed to close result set - ", null, (int)2, null), (Object[])new Object[0]);
        }
        pendingResult.getResultSets().clear();
    }

    public final boolean isEmpty() {
        boolean bl;
        block3: {
            Collection<SinkAwarePendingResult> collection = this.results.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable $this$all$iv = collection;
            boolean $i$f$all = false;
            if (((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    SinkAwarePendingResult it = (SinkAwarePendingResult)element$iv;
                    boolean bl2 = false;
                    if (it.getResultSets().isEmpty()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public final boolean isNotEmpty() {
        return !this.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public final int size() {
        Collection<SinkAwarePendingResult> collection = this.results.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable iterable = collection;
        int n = 0;
        for (Object t : iterable) {
            void it;
            SinkAwarePendingResult sinkAwarePendingResult = (SinkAwarePendingResult)t;
            int n2 = n;
            boolean bl = false;
            int n3 = it.getResultSets().size();
            n = n2 + n3;
        }
        return n;
    }

    private final synchronized SinkAwarePendingResult take(String collection, String name) {
        String key = SinkAwareResultSet.Companion.toKey(collection, name);
        SinkAwarePendingResult oldBatch = this.results.get(key);
        SinkAwarePendingResult newBatch = new SinkAwarePendingResult(collection, name);
        ((Map)this.results).put(key, newBatch);
        SinkAwarePendingResult sinkAwarePendingResult = oldBatch;
        if (sinkAwarePendingResult == null) {
            sinkAwarePendingResult = newBatch;
        }
        return sinkAwarePendingResult;
    }

    private static final SinkAwarePendingResult add$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (SinkAwarePendingResult)$tmp0.invoke(p0);
    }

    private static final SinkAwarePendingResult get$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (SinkAwarePendingResult)$tmp0.invoke(p0);
    }

    private static final boolean takeAndCommit$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

