/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.parse.html;

import ai.platon.pulsar.common.AppContext;
import ai.platon.pulsar.common.CheckState;
import ai.platon.pulsar.common.DateTimesKt;
import ai.platon.pulsar.common.ExceptionsKt;
import ai.platon.pulsar.common.IllegalApplicationStateException;
import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.sql.ResultSetFormatter;
import ai.platon.pulsar.common.sql.SQLInstance;
import ai.platon.pulsar.common.sql.SQLTemplate;
import ai.platon.pulsar.dom.FeaturedDocument;
import ai.platon.pulsar.dom.nodes.NodesKt;
import ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt;
import ai.platon.pulsar.persist.AbstractWebPage;
import ai.platon.pulsar.persist.HyperlinkPersistable;
import ai.platon.pulsar.persist.ProtocolStatus;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.persist.model.PageModel;
import ai.platon.pulsar.ql.h2.utils.ResultSetUtils;
import ai.platon.pulsar.skeleton.common.metrics.AppMetricRegistry;
import ai.platon.pulsar.skeleton.common.metrics.MetricsSystem;
import ai.platon.pulsar.skeleton.common.metrics.MultiMetric;
import ai.platon.pulsar.skeleton.common.persist.ext.WebPageExKt;
import ai.platon.pulsar.skeleton.crawl.common.GlobalCache;
import ai.platon.pulsar.skeleton.crawl.common.GlobalCacheFactory;
import ai.platon.pulsar.skeleton.crawl.parse.AbstractParseFilter;
import ai.platon.pulsar.skeleton.crawl.parse.FilterResult;
import ai.platon.pulsar.skeleton.crawl.parse.ParseResult;
import ai.platon.pulsar.skeleton.crawl.parse.html.OpenMapFields;
import ai.platon.pulsar.skeleton.crawl.parse.html.ParseContext;
import ai.platon.scent.common.ScentStatusTracker;
import ai.platon.scent.common.message.ScentMiscMessageWriter;
import ai.platon.scent.common.sql.NormXSQL;
import ai.platon.scent.crawl.sql.ScrapeAPIUtils;
import ai.platon.scent.parse.html.ExtractCounter;
import ai.platon.scent.ql.h2.context.support.AbstractScentSQLContext;
import ai.platon.scent.skeleton.ScentContext;
import ai.platon.scent.skeleton.ScentSession;
import com.codahale.metrics.Meter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Wrapper;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.reflect.KClass;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.h2.jdbc.JdbcSQLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00fc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0004\b&\u0018\u0000 \u00af\u00012\u00020\u0001:\u0004\u00af\u0001\u00b0\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ&\u0010\u0083\u0001\u001a\u00030\u0084\u00012\u0007\u0010\u0085\u0001\u001a\u00020S2\b\u0010\u0086\u0001\u001a\u00030\u0087\u00012\u0007\u0010\u0088\u0001\u001a\u000203H\u0014J\n\u0010\u0089\u0001\u001a\u00030\u0084\u0001H\u0016J\n\u0010\u008a\u0001\u001a\u00030\u0084\u0001H\u0004J\u0019\u0010\u008b\u0001\u001a\t\u0012\u0004\u0012\u00020S0\u008c\u00012\u0007\u0010\u0088\u0001\u001a\u000203H\u0004J\u001d\u0010\u008d\u0001\u001a\u0004\u0018\u0001032\u0007\u0010\u008e\u0001\u001a\u0002092\u0007\u0010\u008f\u0001\u001a\u000203H\u0014J\u0013\u0010\u0090\u0001\u001a\u00030\u0091\u00012\u0007\u0010\u0085\u0001\u001a\u00020SH\u0016J\u0014\u0010\u0092\u0001\u001a\u00030\u0093\u00012\b\u0010\u0094\u0001\u001a\u00030\u0095\u0001H\u0014J\u001d\u0010\u0096\u0001\u001a\u0004\u0018\u0001032\u0007\u0010\u008e\u0001\u001a\u0002092\u0007\u0010\u0097\u0001\u001a\u00020\u0011H\u0002J\"\u0010\u0098\u0001\u001a\u00030\u0084\u00012\u0007\u0010\u0099\u0001\u001a\u0002032\r\u0010\u009a\u0001\u001a\b0\u009b\u0001j\u0003`\u009c\u0001H\u0014J\u001f\u0010\u009d\u0001\u001a\u0004\u0018\u0001032\b\u0010\u0086\u0001\u001a\u00030\u0087\u00012\b\u0010\u009e\u0001\u001a\u00030\u009f\u0001H\u0014J(\u0010\u00a0\u0001\u001a\u0004\u0018\u0001032\b\u0010\u0086\u0001\u001a\u00030\u0087\u00012\b\u0010\u009e\u0001\u001a\u00030\u009f\u00012\u0007\u0010\u0097\u0001\u001a\u00020\u0011H\u0014J\u001d\u0010\u00a0\u0001\u001a\u0004\u0018\u0001032\u0007\u0010\u008e\u0001\u001a\u0002092\u0007\u0010\u0097\u0001\u001a\u00020\u0011H\u0014J\u001d\u0010\u00a1\u0001\u001a\u0004\u0018\u0001032\u0007\u0010\u008e\u0001\u001a\u0002092\u0007\u0010\u008f\u0001\u001a\u000203H\u0014J\u0013\u0010\u00a2\u0001\u001a\u00020-2\b\u0010\u0094\u0001\u001a\u00030\u0095\u0001H\u0016J*\u0010\u00a3\u0001\u001a\u0004\u0018\u0001032\b\u0010\u0086\u0001\u001a\u00030\u0087\u00012\b\u0010\u009e\u0001\u001a\u00030\u009f\u00012\t\u0010\u0099\u0001\u001a\u0004\u0018\u000103H\u0016J(\u0010\u00a4\u0001\u001a\u00030\u0084\u00012\b\u0010\u0086\u0001\u001a\u00030\u0087\u00012\b\u0010\u009e\u0001\u001a\u00030\u009f\u00012\b\u0010\u00a5\u0001\u001a\u00030\u00a6\u0001H\u0016J\u001e\u0010\u00a7\u0001\u001a\u00030\u0084\u00012\b\u0010\u0086\u0001\u001a\u00030\u0087\u00012\b\u0010\u009e\u0001\u001a\u00030\u009f\u0001H\u0016J\u001e\u0010\u00a8\u0001\u001a\u00030\u0084\u00012\b\u0010\u0086\u0001\u001a\u00030\u0087\u00012\b\u0010\u009e\u0001\u001a\u00030\u009f\u0001H\u0016J\u001d\u0010\u00a9\u0001\u001a\u00030\u0084\u00012\u0007\u0010\u0099\u0001\u001a\u0002032\b\u0010\u0086\u0001\u001a\u00030\u0087\u0001H\u0014J\u001c\u0010\u00aa\u0001\u001a\u00030\u0084\u00012\u0007\u0010\u008f\u0001\u001a\u0002032\u0007\u0010\u008e\u0001\u001a\u000209H\u0002J\u001e\u0010\u00ab\u0001\u001a\u00030\u0084\u00012\b\u0010\u00ac\u0001\u001a\u00030\u00ad\u00012\b\u0010\u0086\u0001\u001a\u00030\u0087\u0001H\u0002J\u001b\u0010\u00ae\u0001\u001a\u0002032\u0007\u0010\u0085\u0001\u001a\u00020S2\u0007\u0010\u0099\u0001\u001a\u000203H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010 R\u001c\u0010!\u001a\n #*\u0004\u0018\u00010\"0\"X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R(\u0010(\u001a\u0004\u0018\u00010'2\b\u0010&\u001a\u0004\u0018\u00010'@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R(\u0010.\u001a\u0004\u0018\u00010-2\b\u0010&\u001a\u0004\u0018\u00010-@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R(\u00104\u001a\u0004\u0018\u0001032\b\u0010&\u001a\u0004\u0018\u000103@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u00106\"\u0004\b7\u00108R(\u0010:\u001a\u0004\u0018\u0001092\b\u0010&\u001a\u0004\u0018\u000109@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>R\u000e\u0010?\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010@\u001a\u00020A\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010CR\u0011\u0010D\u001a\u00020A\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010CR\u0011\u0010F\u001a\u00020A\u00a2\u0006\b\n\u0000\u001a\u0004\bG\u0010CR\u0011\u0010H\u001a\u00020A\u00a2\u0006\b\n\u0000\u001a\u0004\bI\u0010CR\u001a\u0010J\u001a\u00020KX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bL\u0010M\"\u0004\bN\u0010OR\u0014\u0010P\u001a\u00020KX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\bQ\u0010MR\u001a\u0010R\u001a\u00020SX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bT\u0010U\"\u0004\bV\u0010WR\u001a\u0010X\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bY\u0010 \"\u0004\bZ\u0010[R\u0011\u0010\\\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b]\u0010 R\u0016\u0010^\u001a\u0004\u0018\u00010\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b_\u0010`R\u0019\u0010a\u001a\b\u0012\u0004\u0012\u00020c0b\u00a2\u0006\n\n\u0002\u0010f\u001a\u0004\bd\u0010eR\u000e\u0010g\u001a\u00020KX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010h\u001a\u00020KX\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\bi\u0010jR\u000e\u0010k\u001a\u00020SX\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010l\u001a\u00020m8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bn\u0010oR\u0011\u0010p\u001a\u00020S8F\u00a2\u0006\u0006\u001a\u0004\bq\u0010UR\u001a\u0010r\u001a\u00020sX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bt\u0010u\"\u0004\bv\u0010wR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bx\u0010yR\u0010\u0010z\u001a\u0004\u0018\u00010\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010{\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b|\u0010 \"\u0004\b}\u0010[R\u001d\u0010~\u001a\u00020cX\u0086\u000e\u00a2\u0006\u0011\n\u0000\u001a\u0005\b\u007f\u0010\u0080\u0001\"\u0006\b\u0081\u0001\u0010\u0082\u0001\u00a8\u0006\u00b1\u0001"}, d2={"Lai/platon/scent/parse/html/AbstractSQLExtractorParseFilter;", "Lai/platon/pulsar/skeleton/crawl/parse/AbstractParseFilter;", "session", "Lai/platon/scent/skeleton/ScentSession;", "statusTracker", "Lai/platon/scent/common/ScentStatusTracker;", "globalCacheFactory", "Lai/platon/pulsar/skeleton/crawl/common/GlobalCacheFactory;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/scent/skeleton/ScentSession;Lai/platon/scent/common/ScentStatusTracker;Lai/platon/pulsar/skeleton/crawl/common/GlobalCacheFactory;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getConf", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "connectionPool", "Ljava/util/concurrent/ArrayBlockingQueue;", "Ljava/sql/Connection;", "getConnectionPool", "()Ljava/util/concurrent/ArrayBlockingQueue;", "globalCache", "Lai/platon/pulsar/skeleton/crawl/common/GlobalCache;", "getGlobalCache", "()Lai/platon/pulsar/skeleton/crawl/common/GlobalCache;", "getGlobalCacheFactory", "()Lai/platon/pulsar/skeleton/crawl/common/GlobalCacheFactory;", "irrLogger", "Lorg/slf4j/Logger;", "getIrrLogger", "()Lorg/slf4j/Logger;", "isActive", "", "()Z", "jdbcTimeout", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "getJdbcTimeout", "()Ljava/time/Duration;", "<set-?>", "Lai/platon/pulsar/persist/model/PageModel;", "lastPageModel", "getLastPageModel", "()Lai/platon/pulsar/persist/model/PageModel;", "setLastPageModel", "(Lai/platon/pulsar/persist/model/PageModel;)V", "Lai/platon/pulsar/common/CheckState;", "lastRelevantState", "getLastRelevantState", "()Lai/platon/pulsar/common/CheckState;", "setLastRelevantState", "(Lai/platon/pulsar/common/CheckState;)V", "Ljava/sql/ResultSet;", "lastResultSet", "getLastResultSet", "()Ljava/sql/ResultSet;", "setLastResultSet", "(Ljava/sql/ResultSet;)V", "Lai/platon/scent/parse/html/AbstractSQLExtractorParseFilter$Task;", "lastTask", "getLastTask", "()Lai/platon/scent/parse/html/AbstractSQLExtractorParseFilter$Task;", "setLastTask", "(Lai/platon/scent/parse/html/AbstractSQLExtractorParseFilter$Task;)V", "logger", "meterChecks", "Lcom/codahale/metrics/Meter;", "getMeterChecks", "()Lcom/codahale/metrics/Meter;", "meterFitRecords", "getMeterFitRecords", "meterRelevantTasks", "getMeterRelevantTasks", "meterResults", "getMeterResults", "minContentSize", "", "getMinContentSize", "()I", "setMinContentSize", "(I)V", "minNumNonBlankFields", "getMinNumNonBlankFields", "name", "", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "onlyFetched", "getOnlyFetched", "setOnlyFetched", "(Z)V", "persistPageModel", "getPersistPageModel", "randomConnectionOrNull", "getRandomConnectionOrNull", "()Ljava/sql/Connection;", "regexLinkFilters", "", "Lkotlin/text/Regex;", "getRegexLinkFilters", "()[Lkotlin/text/Regex;", "[Lkotlin/text/Regex;", "resultSetConcurrency", "resultSetType", "getSession", "()Lai/platon/scent/skeleton/ScentSession;", "sms", "sqlContext", "Lai/platon/scent/ql/h2/context/support/AbstractScentSQLContext;", "getSqlContext", "()Lai/platon/scent/ql/h2/context/support/AbstractScentSQLContext;", "sqlName", "getSqlName", "sqlTemplate", "Lai/platon/pulsar/common/sql/SQLTemplate;", "getSqlTemplate", "()Lai/platon/pulsar/common/sql/SQLTemplate;", "setSqlTemplate", "(Lai/platon/pulsar/common/sql/SQLTemplate;)V", "getStatusTracker", "()Lai/platon/scent/common/ScentStatusTracker;", "tracer", "transpose", "getTranspose", "setTranspose", "urlFilter", "getUrlFilter", "()Lkotlin/text/Regex;", "setUrlFilter", "(Lkotlin/text/Regex;)V", "checkFieldRequirement", "", "url", "page", "Lai/platon/pulsar/persist/WebPage;", "onlyRecordRs", "close", "closeConnections", "collectNullFields", "", "copyResultSetIfQualified", "task", "sourceRs", "createSQLInstance", "Lai/platon/pulsar/common/sql/SQLInstance;", "doFilter", "Lai/platon/pulsar/skeleton/crawl/parse/FilterResult;", "parseContext", "Lai/platon/pulsar/skeleton/crawl/parse/html/ParseContext;", "executeQuery0", "conn", "exportToCsv", "rs", "buffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "extract", "document", "Lai/platon/pulsar/dom/FeaturedDocument;", "extractWithConnection", "handleResultSet", "isRelevant", "onAfterExtract", "onAfterFilter", "parseResult", "Lai/platon/pulsar/skeleton/crawl/parse/ParseResult;", "onBeforeExtract", "onBeforeFilter", "resultSet2PageModel", "stat", "traceExtractResult", "millis", "", "transposeRsIfNecessary", "Companion", "Task", "scent-parse"})
@SourceDebugExtension(value={"SMAP\nAbstractSQLExtractorParseFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractSQLExtractorParseFilter.kt\nai/platon/scent/parse/html/AbstractSQLExtractorParseFilter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Timing.kt\nkotlin/system/TimingKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,472:1\n1#2:473\n1#2:496\n17#3,6:474\n1855#4,2:480\n1855#4,2:482\n1855#4,2:484\n1603#4,9:486\n1855#4:495\n1856#4:497\n1612#4:498\n*S KotlinDebug\n*F\n+ 1 AbstractSQLExtractorParseFilter.kt\nai/platon/scent/parse/html/AbstractSQLExtractorParseFilter\n*L\n465#1:496\n266#1:474,6\n362#1:480,2\n385#1:482,2\n427#1:484,2\n465#1:486,9\n465#1:495\n465#1:497\n465#1:498\n*E\n"})
public abstract class AbstractSQLExtractorParseFilter
extends AbstractParseFilter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ScentSession session;
    @NotNull
    private final ScentStatusTracker statusTracker;
    @NotNull
    private final GlobalCacheFactory globalCacheFactory;
    @NotNull
    private final ImmutableConfig conf;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Logger irrLogger;
    @Nullable
    private final Logger tracer;
    private final Duration jdbcTimeout;
    private final int resultSetType;
    private final int resultSetConcurrency;
    @NotNull
    private String name;
    @NotNull
    private SQLTemplate sqlTemplate;
    @NotNull
    private Regex urlFilter;
    private boolean onlyFetched;
    private int minContentSize;
    private final int minNumNonBlankFields;
    private boolean transpose;
    @Nullable
    private Task lastTask;
    @Nullable
    private ResultSet lastResultSet;
    @Nullable
    private PageModel lastPageModel;
    @Nullable
    private CheckState lastRelevantState;
    @NotNull
    private final String sms;
    @NotNull
    private final Meter meterChecks;
    @NotNull
    private final Meter meterRelevantTasks;
    @NotNull
    private final Meter meterFitRecords;
    @NotNull
    private final Meter meterResults;
    @NotNull
    private final Regex[] regexLinkFilters;
    @NotNull
    private final AtomicBoolean closed;
    @NotNull
    private static final AppMetricRegistry registry = MetricsSystem.Companion.getDefaultMetricRegistry();
    @NotNull
    private static final MultiMetric metricGlobalTasks = registry.multiMetric((Object)Companion, "tasks");
    @NotNull
    private static final MultiMetric metricGlobalFitRecords = registry.multiMetric((Object)Companion, "fitRecords");

    /*
     * WARNING - void declaration
     */
    public AbstractSQLExtractorParseFilter(@NotNull ScentSession session, @NotNull ScentStatusTracker statusTracker, @NotNull GlobalCacheFactory globalCacheFactory, @NotNull ImmutableConfig conf) {
        void it;
        Logger logger;
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)statusTracker, (String)"statusTracker");
        Intrinsics.checkNotNullParameter((Object)globalCacheFactory, (String)"globalCacheFactory");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        super(0, null, 3, null);
        this.session = session;
        this.statusTracker = statusTracker;
        this.globalCacheFactory = globalCacheFactory;
        this.conf = conf;
        this.logger = LogsKt.getLogger((KClass)Reflection.getOrCreateKotlinClass(AbstractSQLExtractorParseFilter.class));
        this.irrLogger = LogsKt.getLogger((KClass)Reflection.getOrCreateKotlinClass(AbstractSQLExtractorParseFilter.class), (String)".Irr");
        Logger logger2 = logger = this.logger;
        AbstractSQLExtractorParseFilter abstractSQLExtractorParseFilter = this;
        boolean bl = false;
        boolean bl2 = it.isTraceEnabled();
        abstractSQLExtractorParseFilter.tracer = bl2 ? logger : null;
        this.jdbcTimeout = Duration.ofMinutes(1L);
        this.resultSetType = 1005;
        this.resultSetConcurrency = 1007;
        this.name = "X" + this.getId();
        this.sqlTemplate = new SQLTemplate("", null, 2, null);
        this.urlFilter = new Regex(".+");
        this.minContentSize = 100000;
        this.minNumNonBlankFields = 10;
        this.sms = "._.";
        this.meterChecks = MetricsSystem.Companion.getReg().meter((Object)this, this.getId() + this.sms, "checks");
        this.meterRelevantTasks = MetricsSystem.Companion.getReg().meter((Object)this, this.getId() + this.sms, "relevantTasks");
        this.meterFitRecords = MetricsSystem.Companion.getReg().meter((Object)this, this.getId() + this.sms, "fitRecords");
        this.meterResults = MetricsSystem.Companion.getReg().meter((Object)this, this.getId() + this.sms, "results");
        this.regexLinkFilters = new Regex[0];
        this.closed = new AtomicBoolean();
    }

    @NotNull
    public final ScentSession getSession() {
        return this.session;
    }

    @NotNull
    public final ScentStatusTracker getStatusTracker() {
        return this.statusTracker;
    }

    @NotNull
    public final GlobalCacheFactory getGlobalCacheFactory() {
        return this.globalCacheFactory;
    }

    @NotNull
    public final ImmutableConfig getConf() {
        return this.conf;
    }

    @NotNull
    protected final Logger getIrrLogger() {
        return this.irrLogger;
    }

    protected final Duration getJdbcTimeout() {
        return this.jdbcTimeout;
    }

    @NotNull
    protected final GlobalCache getGlobalCache() {
        return this.globalCacheFactory.getGlobalCache();
    }

    private final AbstractScentSQLContext getSqlContext() {
        ScentContext scentContext = this.session.getScentContext();
        Intrinsics.checkNotNull((Object)scentContext, (String)"null cannot be cast to non-null type ai.platon.scent.ql.h2.context.support.AbstractScentSQLContext");
        return (AbstractScentSQLContext)scentContext;
    }

    private final ArrayBlockingQueue<Connection> getConnectionPool() {
        return this.getSqlContext().getConnectionPool();
    }

    private final Connection getRandomConnectionOrNull() {
        Object object;
        block2: {
            Throwable throwable;
            try {
                boolean bl = false;
                object = Result.constructor-impl((Object)this.getSqlContext().getRandomConnection());
            }
            catch (Throwable throwable2) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
            }
            Throwable throwable3 = Result.exceptionOrNull-impl((Object)object);
            if (throwable3 == null) break block2;
            Throwable it = throwable = throwable3;
            boolean bl = false;
            LogsKt.warnInterruptible((Object)((Object)this), (Throwable)it, (String)ExceptionsKt.brief$default((Throwable)it, null, null, (int)3, null), (Object[])new Object[0]);
        }
        return (Connection)(Result.isFailure-impl((Object)object) ? null : object);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final void setName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.name = string;
    }

    @NotNull
    public final SQLTemplate getSqlTemplate() {
        return this.sqlTemplate;
    }

    public final void setSqlTemplate(@NotNull SQLTemplate sQLTemplate) {
        Intrinsics.checkNotNullParameter((Object)sQLTemplate, (String)"<set-?>");
        this.sqlTemplate = sQLTemplate;
    }

    @NotNull
    public final Regex getUrlFilter() {
        return this.urlFilter;
    }

    public final void setUrlFilter(@NotNull Regex regex) {
        Intrinsics.checkNotNullParameter((Object)regex, (String)"<set-?>");
        this.urlFilter = regex;
    }

    public final boolean getOnlyFetched() {
        return this.onlyFetched;
    }

    public final void setOnlyFetched(boolean bl) {
        this.onlyFetched = bl;
    }

    public int getMinContentSize() {
        return this.minContentSize;
    }

    public void setMinContentSize(int n) {
        this.minContentSize = n;
    }

    public int getMinNumNonBlankFields() {
        return this.minNumNonBlankFields;
    }

    public final boolean getTranspose() {
        return this.transpose;
    }

    public final void setTranspose(boolean bl) {
        this.transpose = bl;
    }

    @NotNull
    public final String getSqlName() {
        return this.sqlTemplate.getDisplay();
    }

    public final boolean getPersistPageModel() {
        return this.conf.getBoolean("persist.enable.page.model", true);
    }

    @Nullable
    public final Task getLastTask() {
        return this.lastTask;
    }

    protected final void setLastTask(@Nullable Task task) {
        this.lastTask = task;
    }

    @Nullable
    public final ResultSet getLastResultSet() {
        return this.lastResultSet;
    }

    protected final void setLastResultSet(@Nullable ResultSet resultSet) {
        this.lastResultSet = resultSet;
    }

    @Nullable
    public final PageModel getLastPageModel() {
        return this.lastPageModel;
    }

    protected final void setLastPageModel(@Nullable PageModel pageModel) {
        this.lastPageModel = pageModel;
    }

    @Nullable
    public final CheckState getLastRelevantState() {
        return this.lastRelevantState;
    }

    protected final void setLastRelevantState(@Nullable CheckState checkState) {
        this.lastRelevantState = checkState;
    }

    @NotNull
    public final Meter getMeterChecks() {
        return this.meterChecks;
    }

    @NotNull
    public final Meter getMeterRelevantTasks() {
        return this.meterRelevantTasks;
    }

    @NotNull
    public final Meter getMeterFitRecords() {
        return this.meterFitRecords;
    }

    @NotNull
    public final Meter getMeterResults() {
        return this.meterResults;
    }

    @NotNull
    public final Regex[] getRegexLinkFilters() {
        return this.regexLinkFilters;
    }

    public final boolean isActive() {
        return !this.closed.get() && AppContext.INSTANCE.isActive();
    }

    @NotNull
    public SQLInstance createSQLInstance(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return this.sqlTemplate.createInstance(url);
    }

    @NotNull
    public CheckState isRelevant(@NotNull ParseContext parseContext) {
        CheckState checkState;
        Intrinsics.checkNotNullParameter((Object)parseContext, (String)"parseContext");
        MetricsSystem metrics = this.statusTracker.getMetrics();
        Enum[] enumArray = new Enum[]{ExtractCounter.xCheck};
        metrics.inc(enumArray);
        this.meterChecks.mark();
        ScentMiscMessageWriter messageWriter = this.statusTracker.getMessageWriter();
        WebPage page = parseContext.getPage();
        if (!(page instanceof AbstractWebPage)) {
            boolean $i$a$-require-AbstractSQLExtractorParseFilter$isRelevant$22 = false;
            String $i$a$-require-AbstractSQLExtractorParseFilter$isRelevant$22 = "page is not AbstractWebPage";
            throw new IllegalArgumentException($i$a$-require-AbstractSQLExtractorParseFilter$isRelevant$22.toString());
        }
        ProtocolStatus protocolStatus = page.getProtocolStatus();
        if (!this.isActive()) {
            checkState = new CheckState(10, "system down", null, 4, null);
        } else if (page.isInternal()) {
            checkState = new CheckState(20, "internal page", null, 4, null);
        } else if (!this.urlFilter.matches((CharSequence)page.getUrl())) {
            checkState = new CheckState(30, "url not match", null, 4, null);
        } else if (((AbstractWebPage)page).hasVar("IS_SCRAPE")) {
            checkState = new CheckState(40, "scraping", null, 4, null);
        } else if (protocolStatus.isNotFound()) {
            checkState = new CheckState(protocolStatus.getMinorCode(), "not found", null, 4, null);
        } else if (page.isCanceled()) {
            checkState = new CheckState(1602, "canceled", null, 4, null);
        } else if (!protocolStatus.isSuccess()) {
            checkState = new CheckState(protocolStatus.getMinorCode(), protocolStatus.getMinorName(), null, 4, null);
        } else if (this.onlyFetched && !page.isFetched()) {
            var7_9 = new Enum[]{ExtractCounter.xLoaded};
            metrics.inc(var7_9);
            messageWriter.reportLoadedIrrelevantPages(page);
            checkState = new CheckState(60, "loaded", null, 4, null);
        } else if (page.getContent() == null) {
            var7_9 = new Enum[]{ExtractCounter.xNullContent};
            metrics.inc(var7_9);
            checkState = new CheckState(65, "null content", null, 4, null);
        } else if (page.getContentLength() < (long)this.getMinContentSize()) {
            messageWriter.reportTooSmallPages(page);
            var7_9 = new Enum[]{ExtractCounter.xSmall};
            metrics.inc(var7_9);
            checkState = new CheckState(70, "small content", null, 4, null);
        } else if (WebPageExKt.getOptions((WebPage)page).isDead()) {
            checkState = new CheckState(80, "dead", null, 4, null);
        } else if (!parseContext.getParseResult().isParsed()) {
            this.logger.warn("Page is be parsed | {}", (Object)page.getUrl());
            checkState = new CheckState(90, "not parsed", null, 4, null);
        } else if (!parseContext.getParseResult().isSuccess()) {
            this.logger.warn("Page is not parsed correctly | {}", (Object)page.getUrl());
            checkState = new CheckState(92, "parse failure", null, 4, null);
        } else if (parseContext.getDocument() == null) {
            this.logger.warn("Document is null | {}", (Object)page.getUrl());
            checkState = new CheckState(93, "null document", null, 4, null);
        } else {
            checkState = new CheckState(0, null, null, 7, null);
        }
        CheckState state = checkState;
        return state;
    }

    @NotNull
    protected FilterResult doFilter(@NotNull ParseContext parseContext) {
        Intrinsics.checkNotNullParameter((Object)parseContext, (String)"parseContext");
        this.meterRelevantTasks.mark();
        metricGlobalTasks.mark();
        WebPage page = parseContext.getPage();
        if (!parseContext.getParseResult().isParsed()) {
            this.logger.warn("Page is be parsed | {}", (Object)page.getUrl());
            return FilterResult.Companion.failed(200, "Not parsed");
        }
        try {
            FeaturedDocument document = parseContext.getParseResult().getDocument();
            if (document == null) {
                this.logger.warn("Document is null, page might not be parsed | {}", (Object)page.getUrl());
                return FilterResult.Companion.failed(200, "Not parsed");
            }
            parseContext.getParseResult().setDocument(document);
            parseContext.getParseResult().setMajorCode((short)1);
            this.onBeforeFilter(page, document);
            this.extract(page, document);
            this.onAfterFilter(page, document, parseContext.getParseResult());
            return new FilterResult(1, 0, null, 6, null);
        }
        catch (IllegalApplicationStateException e) {
            AppContext.INSTANCE.terminate();
            this.logger.warn("Illegal context state | {}", (Object)e.getMessage());
            return FilterResult.Companion.failed((Throwable)e);
        }
    }

    public void onBeforeFilter(@NotNull WebPage page, @NotNull FeaturedDocument document) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
    }

    public void onAfterFilter(@NotNull WebPage page, @NotNull FeaturedDocument document, @NotNull ParseResult parseResult) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)parseResult, (String)"parseResult");
        Ref.IntRef order = new Ref.IntRef();
        NodesKt.forEachElement$default((Node)((Node)document.getDocument()), (boolean)false, (Function1)((Function1)new Function1<Element, Unit>(this, order, parseResult){
            final /* synthetic */ AbstractSQLExtractorParseFilter this$0;
            final /* synthetic */ Ref.IntRef $order;
            final /* synthetic */ ParseResult $parseResult;
            {
                this.this$0 = $receiver;
                this.$order = $order;
                this.$parseResult = $parseResult;
                super(1);
            }

            public final void invoke(@NotNull Element it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (NodeExtKt.isAnchor((Node)((Node)it))) {
                    boolean bl;
                    String href;
                    block3: {
                        String string = it.attr("abs:href");
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"attr(...)");
                        href = string;
                        Regex[] $this$any$iv = this.this$0.getRegexLinkFilters();
                        boolean $i$f$any = false;
                        int n = $this$any$iv.length;
                        for (int i = 0; i < n; ++i) {
                            Regex element$iv;
                            Regex it2 = element$iv = $this$any$iv[i];
                            boolean bl2 = false;
                            if (!it2.matches((CharSequence)href)) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                    if (bl) {
                        ++this.$order.element;
                        int cfr_ignored_0 = this.$order.element;
                        HyperlinkPersistable hyperLink = new HyperlinkPersistable(href, it.getExtension().getImmutableText(), this.$order.element);
                        this.$parseResult.getHypeLinks().add(hyperLink);
                    }
                }
            }
        }), (int)1, null);
    }

    public void onBeforeExtract(@NotNull WebPage page, @NotNull FeaturedDocument document) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
    }

    @Nullable
    public ResultSet onAfterExtract(@NotNull WebPage page, @NotNull FeaturedDocument document, @Nullable ResultSet rs) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        return rs;
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.closeConnections();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected ResultSet extract(@NotNull WebPage page, @NotNull FeaturedDocument document) {
        ResultSet result;
        block12: {
            AbstractSQLExtractorParseFilter abstractSQLExtractorParseFilter;
            AbstractSQLExtractorParseFilter abstractSQLExtractorParseFilter2;
            Intrinsics.checkNotNullParameter((Object)page, (String)"page");
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            if (!this.isActive()) {
                return null;
            }
            result = null;
            boolean $i$f$measureTimeMillis = false;
            long start$iv = System.currentTimeMillis();
            boolean bl = false;
            AbstractSQLExtractorParseFilter it = abstractSQLExtractorParseFilter2 = this;
            boolean bl2 = false;
            if ((AppContext.INSTANCE.isActive() ? abstractSQLExtractorParseFilter2 : null) == null) {
                return null;
            }
            Connection connection = this.getConnectionPool().poll();
            if (connection == null && (connection = this.getRandomConnectionOrNull()) == null) {
                return null;
            }
            Connection conn = connection;
            try {
                this.onBeforeExtract(page, document);
                result = this.extractWithConnection(page, document, conn);
                this.onAfterExtract(page, document, result);
            }
            catch (JdbcSQLException e) {
                this.logger.warn("JDBC exception", (Throwable)e);
            }
            catch (SQLException e) {
                this.logger.error("Extract failed", (Throwable)e);
            }
            finally {
                if (!conn.isClosed()) {
                    this.getConnectionPool().add(conn);
                }
            }
            long millis = System.currentTimeMillis() - start$iv;
            AbstractSQLExtractorParseFilter it2 = abstractSQLExtractorParseFilter = this;
            boolean bl3 = false;
            AbstractSQLExtractorParseFilter abstractSQLExtractorParseFilter3 = this.logger.isTraceEnabled() ? abstractSQLExtractorParseFilter : null;
            if (abstractSQLExtractorParseFilter3 == null) break block12;
            abstractSQLExtractorParseFilter3.traceExtractResult(millis, page);
        }
        return result;
    }

    @Nullable
    protected ResultSet extractWithConnection(@NotNull WebPage page, @NotNull FeaturedDocument document, @NotNull Connection conn) {
        Task task;
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
        SQLInstance sql = this.createSQLInstance(page.getUrl());
        if (!StringsKt.contains((CharSequence)sql.getSql(), (CharSequence)"select", (boolean)true)) {
            this.logger.warn("Illegal sql format: >>>{}<<<", (Object)sql);
            return null;
        }
        this.lastTask = task = new Task(page, document, sql.getSql());
        return this.extractWithConnection(task, conn);
    }

    @Nullable
    protected ResultSet extractWithConnection(@NotNull Task task, @NotNull Connection conn) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
        try {
            long startTime = System.currentTimeMillis();
            ResultSet rs = this.executeQuery0(task, conn);
            task.setMillis(System.currentTimeMillis() - startTime);
            if (rs != null) {
                this.meterResults.mark();
            }
            return rs;
        }
        catch (JdbcSQLException e) {
            this.logger.warn("Unexpected jdbc sql exception", (Throwable)e);
            return null;
        }
    }

    @Nullable
    protected ResultSet handleResultSet(@NotNull Task task, @NotNull ResultSet sourceRs) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)sourceRs, (String)"sourceRs");
        ResultSet resultSet = this.copyResultSetIfQualified(task, sourceRs);
        if (resultSet == null) {
            return null;
        }
        ResultSet simpleRs = resultSet;
        return simpleRs;
    }

    @Nullable
    protected ResultSet copyResultSetIfQualified(@NotNull Task task, @NotNull ResultSet sourceRs) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)sourceRs, (String)"sourceRs");
        this.stat(sourceRs, task);
        if (task.getNumFitRecords() == 0) {
            return null;
        }
        sourceRs.beforeFirst();
        ResultSet simpleRs = ResultSetUtils.copyResultSet$default((ResultSetUtils)ResultSetUtils.INSTANCE, (ResultSet)sourceRs, (int)0, (int)2, null);
        if (this.getPersistPageModel()) {
            this.resultSet2PageModel(simpleRs, task.getPage());
        }
        if (this.logger.isDebugEnabled()) {
            sourceRs.beforeFirst();
            String formattedString = new ResultSetFormatter(sourceRs, true, false, 0, null, 28, null).toString();
            this.statusTracker.getMessageWriter().reportExtractListResult(formattedString);
        }
        return simpleRs;
    }

    protected void checkFieldRequirement(@NotNull String url, @NotNull WebPage page, @NotNull ResultSet onlyRecordRs) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter((Object)onlyRecordRs, (String)"onlyRecordRs");
    }

    protected void resultSet2PageModel(@NotNull ResultSet rs, @NotNull WebPage page) {
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        OpenMapFields fields = new OpenMapFields();
        int columnCount = rs.getMetaData().getColumnCount();
        rs.beforeFirst();
        while (rs.next()) {
            Iterable $this$forEach$iv = (Iterable)new IntRange(1, columnCount);
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                int element$iv;
                int j = element$iv = ((IntIterator)iterator).nextInt();
                boolean bl = false;
                String name = rs.getMetaData().getColumnName(j);
                String value = rs.getString(j);
                Intrinsics.checkNotNull((Object)name);
                fields.set(name, value);
            }
        }
        rs.beforeFirst();
        page.setPageModelUpdateTime(Instant.now());
        page.ensurePageModel().emplace(1, 0, "sql", (Map)fields.getMap());
        this.lastPageModel = page.ensurePageModel().deepCopy();
    }

    protected void exportToCsv(@NotNull ResultSet rs, @NotNull StringBuilder buffer) {
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        rs.beforeFirst();
        buffer.setLength(0);
        new ResultSetFormatter(rs, false, false, 0, buffer, 10, null);
        Character c = StringsKt.lastOrNull((CharSequence)buffer);
        char c2 = '\n';
        if (c != null && c.charValue() == c2) {
            buffer.deleteCharAt(buffer.length() - 1);
        }
        ScentMiscMessageWriter scentMiscMessageWriter = this.statusTracker.getMessageWriter();
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        scentMiscMessageWriter.reportExtractCsvResult(string);
    }

    protected final void closeConnections() {
        Iterable $this$forEach$iv = this.getConnectionPool();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            Connection it = (Connection)element$iv;
            boolean bl = false;
            Object object2 = it;
            try {
                Connection $this$closeConnections_u24lambda_u2410_u24lambda_u248 = object2;
                boolean bl2 = false;
                it.close();
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl2) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) continue;
            Object it2 = object = throwable;
            boolean bl3 = false;
            LogsKt.warnForClose((Object)((Object)this), (Throwable)it2, (String)ExceptionsKt.brief$default((Throwable)it2, null, null, (int)3, null), (Object[])new Object[0]);
        }
        this.getConnectionPool().clear();
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ResultSet executeQuery0(Task task, Connection conn) {
        ResultSet resultSet;
        String url = task.getUrl();
        ResultSet result = null;
        if (conn.isClosed()) {
            return null;
        }
        Statement $this$executeQuery0_u24lambda_u2412 = conn.createStatement(this.resultSetType, this.resultSetConcurrency);
        boolean bl = false;
        this.getGlobalCache().putPDCache(task.getPage(), task.getDocument());
        NormXSQL normSql = ScrapeAPIUtils.normalizeSQL$default((ScrapeAPIUtils)ScrapeAPIUtils.INSTANCE, (String)task.getSql(), (String)"-parse", (String)"-readonly", (boolean)false, (int)8, null);
        ResultSet resultSet2 = resultSet = $this$executeQuery0_u24lambda_u2412.executeQuery(normSql.getSql());
        if (resultSet2 != null) {
            Intrinsics.checkNotNull((Object)resultSet2);
            AutoCloseable autoCloseable = resultSet;
            Throwable throwable = null;
            try {
                ResultSet rs = (ResultSet)autoCloseable;
                boolean bl2 = false;
                result = this.handleResultSet(task, this.transposeRsIfNecessary(url, rs));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        this.lastResultSet = result;
        return result;
    }

    private final ResultSet transposeRsIfNecessary(String url, ResultSet rs) {
        Object object;
        block7: {
            block6: {
                Object object2;
                AbstractSQLExtractorParseFilter abstractSQLExtractorParseFilter;
                AbstractSQLExtractorParseFilter it = abstractSQLExtractorParseFilter = this;
                boolean bl = false;
                object = this.transpose ? abstractSQLExtractorParseFilter : null;
                if (object == null) break block6;
                Object object3 = object;
                try {
                    AbstractSQLExtractorParseFilter $this$transposeRsIfNecessary_u24lambda_u2414 = object3;
                    boolean bl2 = false;
                    object2 = Result.constructor-impl((Object)ResultSetUtils.INSTANCE.transpose(rs));
                }
                catch (Throwable throwable) {
                    object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
                if (throwable != null) {
                    Throwable throwable2;
                    Throwable it2 = throwable2 = throwable;
                    boolean bl3 = false;
                    Object[] objectArray = new Object[]{this.getSqlName(), url, it2.getMessage()};
                    this.logger.warn("Failed to transpose result set. Sql: {} | {} {}", objectArray);
                }
                object3 = object2;
                object = (ResultSet)(Result.isFailure-impl((Object)object3) ? null : object3);
                if (object != null) break block7;
            }
            object = rs;
        }
        return object;
    }

    private final void stat(ResultSet sourceRs, Task task) {
        int columnCount = sourceRs.getMetaData().getColumnCount();
        sourceRs.beforeFirst();
        while (sourceRs.next()) {
            task.setNumRecords(task.getNumRecords() + 1);
            task.getNumRecords();
            int numNonBlankFields = 0;
            Iterable $this$forEach$iv = (Iterable)new IntRange(1, columnCount);
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                CharSequence charSequence;
                int element$iv;
                int k = element$iv = ((IntIterator)iterator).nextInt();
                boolean bl = false;
                String value = sourceRs.getString(k);
                task.setNumFields(task.getNumFields() + 1);
                task.getNumFields();
                if (value != null) {
                    task.setNumNonNullFields(task.getNumNonNullFields() + 1);
                    task.getNumNonNullFields();
                }
                if ((charSequence = (CharSequence)value) == null || StringsKt.isBlank((CharSequence)charSequence) || Intrinsics.areEqual((Object)value, (Object)"()")) continue;
                ++numNonBlankFields;
                task.setNumNonBlankFields(task.getNumNonBlankFields() + 1);
                task.getNumNonBlankFields();
            }
            if (numNonBlankFields < this.getMinNumNonBlankFields()) {
                Enum[] enumArray = new Enum[]{ExtractCounter.xFewFields};
                this.statusTracker.getMetrics().inc(enumArray);
                this.checkFieldRequirement(task.getUrl(), task.getPage(), sourceRs);
                continue;
            }
            task.setNumFitRecords(task.getNumFitRecords() + 1);
            task.getNumFitRecords();
            this.meterFitRecords.mark();
            metricGlobalFitRecords.mark();
        }
    }

    private final void traceExtractResult(long millis, WebPage page) {
        block2: {
            if (!this.logger.isTraceEnabled() || millis <= 10000L) break block2;
            PageModel pageModel = page.getPageModel();
            if (pageModel == null) {
                return;
            }
            PageModel m = pageModel;
            Logger logger = this.tracer;
            if (logger != null) {
                Object[] objectArray = new Object[5];
                Duration duration = Duration.ofMillis(millis);
                Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(...)");
                objectArray[0] = DateTimesKt.readable((Duration)duration);
                objectArray[1] = m.getNumNonBlankFields();
                objectArray[2] = m.getNumNonNullFields();
                objectArray[3] = m.getNumFields();
                objectArray[4] = page.getUrl();
                logger.trace("It takes {} to parse {}/{}/{} fields | {}", objectArray);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final List<String> collectNullFields(@NotNull ResultSet onlyRecordRs) {
        List list;
        Intrinsics.checkNotNullParameter((Object)onlyRecordRs, (String)"onlyRecordRs");
        int numColumns = onlyRecordRs.getMetaData().getColumnCount();
        onlyRecordRs.beforeFirst();
        if (onlyRecordRs.next()) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = (Iterable)new IntRange(1, numColumns);
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String it$iv$iv;
                ResultSet resultSet;
                int element$iv$iv$iv;
                int element$iv$iv = element$iv$iv$iv = ((IntIterator)iterator).nextInt();
                boolean bl = false;
                int col = element$iv$iv;
                boolean bl2 = false;
                onlyRecordRs.getObject(col);
                ResultSet it = resultSet = onlyRecordRs;
                boolean bl3 = false;
                Wrapper wrapper = it.wasNull() ? resultSet : null;
                if ((wrapper != null && (wrapper = wrapper.getMetaData()) != null ? wrapper.getColumnName(col) : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lai/platon/scent/parse/html/AbstractSQLExtractorParseFilter$Companion;", "", "()V", "metricGlobalFitRecords", "Lai/platon/pulsar/skeleton/common/metrics/MultiMetric;", "getMetricGlobalFitRecords", "()Lai/platon/pulsar/skeleton/common/metrics/MultiMetric;", "metricGlobalTasks", "getMetricGlobalTasks", "registry", "Lai/platon/pulsar/skeleton/common/metrics/AppMetricRegistry;", "scent-parse"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MultiMetric getMetricGlobalTasks() {
            return metricGlobalTasks;
        }

        @NotNull
        public final MultiMetric getMetricGlobalFitRecords() {
            return metricGlobalFitRecords;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0017\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016R\u001a\u0010\u001a\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0014\"\u0004\b\u001c\u0010\u0016R\u001a\u0010\u001d\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0014\"\u0004\b\u001f\u0010\u0016R\u001a\u0010 \u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0014\"\u0004\b\"\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010'\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010&\u00a8\u0006)"}, d2={"Lai/platon/scent/parse/html/AbstractSQLExtractorParseFilter$Task;", "", "page", "Lai/platon/pulsar/persist/WebPage;", "document", "Lai/platon/pulsar/dom/FeaturedDocument;", "sql", "", "(Lai/platon/pulsar/persist/WebPage;Lai/platon/pulsar/dom/FeaturedDocument;Ljava/lang/String;)V", "getDocument", "()Lai/platon/pulsar/dom/FeaturedDocument;", "millis", "", "getMillis", "()J", "setMillis", "(J)V", "numFields", "", "getNumFields", "()I", "setNumFields", "(I)V", "numFitRecords", "getNumFitRecords", "setNumFitRecords", "numNonBlankFields", "getNumNonBlankFields", "setNumNonBlankFields", "numNonNullFields", "getNumNonNullFields", "setNumNonNullFields", "numRecords", "getNumRecords", "setNumRecords", "getPage", "()Lai/platon/pulsar/persist/WebPage;", "getSql", "()Ljava/lang/String;", "url", "getUrl", "scent-parse"})
    public static final class Task {
        @NotNull
        private final WebPage page;
        @NotNull
        private final FeaturedDocument document;
        @NotNull
        private final String sql;
        @NotNull
        private final String url;
        private int numRecords;
        private int numFitRecords;
        private int numNonBlankFields;
        private int numNonNullFields;
        private int numFields;
        private long millis;

        public Task(@NotNull WebPage page, @NotNull FeaturedDocument document, @NotNull String sql) {
            Intrinsics.checkNotNullParameter((Object)page, (String)"page");
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
            this.page = page;
            this.document = document;
            this.sql = sql;
            this.url = this.page.getUrl();
        }

        @NotNull
        public final WebPage getPage() {
            return this.page;
        }

        @NotNull
        public final FeaturedDocument getDocument() {
            return this.document;
        }

        @NotNull
        public final String getSql() {
            return this.sql;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        public final int getNumRecords() {
            return this.numRecords;
        }

        public final void setNumRecords(int n) {
            this.numRecords = n;
        }

        public final int getNumFitRecords() {
            return this.numFitRecords;
        }

        public final void setNumFitRecords(int n) {
            this.numFitRecords = n;
        }

        public final int getNumNonBlankFields() {
            return this.numNonBlankFields;
        }

        public final void setNumNonBlankFields(int n) {
            this.numNonBlankFields = n;
        }

        public final int getNumNonNullFields() {
            return this.numNonNullFields;
        }

        public final void setNumNonNullFields(int n) {
            this.numNonNullFields = n;
        }

        public final int getNumFields() {
            return this.numFields;
        }

        public final void setNumFields(int n) {
            this.numFields = n;
        }

        public final long getMillis() {
            return this.millis;
        }

        public final void setMillis(long l) {
            this.millis = l;
        }
    }
}

